/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.exprtree;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableTable;
import com.google.errorprone.annotations.Immutable;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.OperatorNodes;
import com.google.template.soy.exprtree.SoyPrecedence;
import java.util.List;
import javax.annotation.Nullable;

public enum Operator {
    ASSERT_NON_NULL(ImmutableList.of((Object)Constants.OPERAND_0, (Object)new Token("!")), SoyPrecedence.P13, SoyPrecedence.Associativity.NA, "! (non-null assertion)"){

        @Override
        public ExprNode.OperatorNode createNode(SourceLocation location, SourceLocation operatorLocation) {
            return new OperatorNodes.AssertNonNullOpNode(location, operatorLocation);
        }
    }
    ,
    NEGATIVE(ImmutableList.of((Object)new Token("-"), (Object)Constants.OPERAND_0), SoyPrecedence.P12, SoyPrecedence.Associativity.NA, "- (unary)"){

        @Override
        public ExprNode.OperatorNode createNode(SourceLocation location, SourceLocation operatorLocation) {
            return new OperatorNodes.NegativeOpNode(location, operatorLocation);
        }
    }
    ,
    NOT_LEGACY(ImmutableList.of((Object)new Token("not"), (Object)Constants.SP, (Object)Constants.OPERAND_0), SoyPrecedence.P12, SoyPrecedence.Associativity.NA){

        @Override
        public ExprNode.OperatorNode createNode(SourceLocation location, SourceLocation operatorLocation) {
            return new OperatorNodes.NotOpNode(location, operatorLocation, this);
        }
    }
    ,
    NOT(ImmutableList.of((Object)new Token("!"), (Object)Constants.OPERAND_0), SoyPrecedence.P12, SoyPrecedence.Associativity.NA, "! (not)"){

        @Override
        public ExprNode.OperatorNode createNode(SourceLocation location, SourceLocation operatorLocation) {
            return new OperatorNodes.NotOpNode(location, operatorLocation, this);
        }
    }
    ,
    TIMES(ImmutableList.of((Object)Constants.OPERAND_0, (Object)Constants.SP, (Object)new Token("*"), (Object)Constants.SP, (Object)Constants.OPERAND_1), SoyPrecedence.P11, SoyPrecedence.Associativity.LEFT){

        @Override
        public ExprNode.OperatorNode createNode(SourceLocation location, SourceLocation operatorLocation) {
            return new OperatorNodes.TimesOpNode(location, operatorLocation);
        }
    }
    ,
    DIVIDE_BY(ImmutableList.of((Object)Constants.OPERAND_0, (Object)Constants.SP, (Object)new Token("/"), (Object)Constants.SP, (Object)Constants.OPERAND_1), SoyPrecedence.P11, SoyPrecedence.Associativity.LEFT){

        @Override
        public ExprNode.OperatorNode createNode(SourceLocation location, SourceLocation operatorLocation) {
            return new OperatorNodes.DivideByOpNode(location, operatorLocation);
        }
    }
    ,
    MOD(ImmutableList.of((Object)Constants.OPERAND_0, (Object)Constants.SP, (Object)new Token("%"), (Object)Constants.SP, (Object)Constants.OPERAND_1), SoyPrecedence.P11, SoyPrecedence.Associativity.LEFT){

        @Override
        public ExprNode.OperatorNode createNode(SourceLocation location, SourceLocation operatorLocation) {
            return new OperatorNodes.ModOpNode(location, operatorLocation);
        }
    }
    ,
    PLUS(ImmutableList.of((Object)Constants.OPERAND_0, (Object)Constants.SP, (Object)new Token("+"), (Object)Constants.SP, (Object)Constants.OPERAND_1), SoyPrecedence.P10, SoyPrecedence.Associativity.LEFT){

        @Override
        public ExprNode.OperatorNode createNode(SourceLocation location, SourceLocation operatorLocation) {
            return new OperatorNodes.PlusOpNode(location, operatorLocation);
        }
    }
    ,
    MINUS(ImmutableList.of((Object)Constants.OPERAND_0, (Object)Constants.SP, (Object)new Token("-"), (Object)Constants.SP, (Object)Constants.OPERAND_1), SoyPrecedence.P10, SoyPrecedence.Associativity.LEFT, "- (binary)"){

        @Override
        public ExprNode.OperatorNode createNode(SourceLocation location, SourceLocation operatorLocation) {
            return new OperatorNodes.MinusOpNode(location, operatorLocation);
        }
    }
    ,
    SHIFT_RIGHT(ImmutableList.of((Object)Constants.OPERAND_0, (Object)Constants.SP, (Object)new Token(">>"), (Object)Constants.SP, (Object)Constants.OPERAND_1), SoyPrecedence.P9, SoyPrecedence.Associativity.LEFT){

        @Override
        public ExprNode.OperatorNode createNode(SourceLocation location, SourceLocation operatorLocation) {
            return new OperatorNodes.ShiftRightOpNode(location, operatorLocation);
        }
    }
    ,
    SHIFT_LEFT(ImmutableList.of((Object)Constants.OPERAND_0, (Object)Constants.SP, (Object)new Token("<<"), (Object)Constants.SP, (Object)Constants.OPERAND_1), SoyPrecedence.P9, SoyPrecedence.Associativity.LEFT){

        @Override
        public ExprNode.OperatorNode createNode(SourceLocation location, SourceLocation operatorLocation) {
            return new OperatorNodes.ShiftLeftOpNode(location, operatorLocation);
        }
    }
    ,
    LESS_THAN(ImmutableList.of((Object)Constants.OPERAND_0, (Object)Constants.SP, (Object)new Token("<"), (Object)Constants.SP, (Object)Constants.OPERAND_1), SoyPrecedence.P8, SoyPrecedence.Associativity.LEFT){

        @Override
        public ExprNode.OperatorNode createNode(SourceLocation location, SourceLocation operatorLocation) {
            return new OperatorNodes.LessThanOpNode(location, operatorLocation);
        }
    }
    ,
    GREATER_THAN(ImmutableList.of((Object)Constants.OPERAND_0, (Object)Constants.SP, (Object)new Token(">"), (Object)Constants.SP, (Object)Constants.OPERAND_1), SoyPrecedence.P8, SoyPrecedence.Associativity.LEFT){

        @Override
        public ExprNode.OperatorNode createNode(SourceLocation location, SourceLocation operatorLocation) {
            return new OperatorNodes.GreaterThanOpNode(location, operatorLocation);
        }
    }
    ,
    LESS_THAN_OR_EQUAL(ImmutableList.of((Object)Constants.OPERAND_0, (Object)Constants.SP, (Object)new Token("<="), (Object)Constants.SP, (Object)Constants.OPERAND_1), SoyPrecedence.P8, SoyPrecedence.Associativity.LEFT){

        @Override
        public ExprNode.OperatorNode createNode(SourceLocation location, SourceLocation operatorLocation) {
            return new OperatorNodes.LessThanOrEqualOpNode(location, operatorLocation);
        }
    }
    ,
    GREATER_THAN_OR_EQUAL(ImmutableList.of((Object)Constants.OPERAND_0, (Object)Constants.SP, (Object)new Token(">="), (Object)Constants.SP, (Object)Constants.OPERAND_1), SoyPrecedence.P8, SoyPrecedence.Associativity.LEFT){

        @Override
        public ExprNode.OperatorNode createNode(SourceLocation location, SourceLocation operatorLocation) {
            return new OperatorNodes.GreaterThanOrEqualOpNode(location, operatorLocation);
        }
    }
    ,
    EQUAL(ImmutableList.of((Object)Constants.OPERAND_0, (Object)Constants.SP, (Object)new Token("=="), (Object)Constants.SP, (Object)Constants.OPERAND_1), SoyPrecedence.P7, SoyPrecedence.Associativity.LEFT){

        @Override
        public ExprNode.OperatorNode createNode(SourceLocation location, SourceLocation operatorLocation) {
            return new OperatorNodes.EqualOpNode(location, operatorLocation);
        }
    }
    ,
    NOT_EQUAL(ImmutableList.of((Object)Constants.OPERAND_0, (Object)Constants.SP, (Object)new Token("!="), (Object)Constants.SP, (Object)Constants.OPERAND_1), SoyPrecedence.P7, SoyPrecedence.Associativity.LEFT){

        @Override
        public ExprNode.OperatorNode createNode(SourceLocation location, SourceLocation operatorLocation) {
            return new OperatorNodes.NotEqualOpNode(location, operatorLocation);
        }
    }
    ,
    TRIPLE_EQUAL(ImmutableList.of((Object)Constants.OPERAND_0, (Object)Constants.SP, (Object)new Token("==="), (Object)Constants.SP, (Object)Constants.OPERAND_1), SoyPrecedence.P7, SoyPrecedence.Associativity.LEFT){

        @Override
        public ExprNode.OperatorNode createNode(SourceLocation location, SourceLocation operatorLocation) {
            return new OperatorNodes.TripleEqualOpNode(location, operatorLocation);
        }
    }
    ,
    TRIPLE_NOT_EQUAL(ImmutableList.of((Object)Constants.OPERAND_0, (Object)Constants.SP, (Object)new Token("!=="), (Object)Constants.SP, (Object)Constants.OPERAND_1), SoyPrecedence.P7, SoyPrecedence.Associativity.LEFT){

        @Override
        public ExprNode.OperatorNode createNode(SourceLocation location, SourceLocation operatorLocation) {
            return new OperatorNodes.TripleNotEqualOpNode(location, operatorLocation);
        }
    }
    ,
    BITWISE_AND(ImmutableList.of((Object)Constants.OPERAND_0, (Object)Constants.SP, (Object)new Token("&"), (Object)Constants.SP, (Object)Constants.OPERAND_1), SoyPrecedence.P6, SoyPrecedence.Associativity.LEFT){

        @Override
        public ExprNode.OperatorNode createNode(SourceLocation location, SourceLocation operatorLocation) {
            return new OperatorNodes.BitwiseAndOpNode(location, operatorLocation);
        }
    }
    ,
    BITWISE_XOR(ImmutableList.of((Object)Constants.OPERAND_0, (Object)Constants.SP, (Object)new Token("^"), (Object)Constants.SP, (Object)Constants.OPERAND_1), SoyPrecedence.P5, SoyPrecedence.Associativity.LEFT){

        @Override
        public ExprNode.OperatorNode createNode(SourceLocation location, SourceLocation operatorLocation) {
            return new OperatorNodes.BitwiseXorOpNode(location, operatorLocation);
        }
    }
    ,
    BITWISE_OR(ImmutableList.of((Object)Constants.OPERAND_0, (Object)Constants.SP, (Object)new Token("|"), (Object)Constants.SP, (Object)Constants.OPERAND_1), SoyPrecedence.P4, SoyPrecedence.Associativity.LEFT){

        @Override
        public ExprNode.OperatorNode createNode(SourceLocation location, SourceLocation operatorLocation) {
            return new OperatorNodes.BitwiseOrOpNode(location, operatorLocation);
        }
    }
    ,
    AND(ImmutableList.of((Object)Constants.OPERAND_0, (Object)Constants.SP, (Object)new Token("and"), (Object)Constants.SP, (Object)Constants.OPERAND_1), SoyPrecedence.P3, SoyPrecedence.Associativity.LEFT){

        @Override
        public ExprNode.OperatorNode createNode(SourceLocation location, SourceLocation operatorLocation) {
            return new OperatorNodes.AndOpNode(location, operatorLocation);
        }
    }
    ,
    AMP_AMP(ImmutableList.of((Object)Constants.OPERAND_0, (Object)Constants.SP, (Object)new Token("&&"), (Object)Constants.SP, (Object)Constants.OPERAND_1), SoyPrecedence.P3, SoyPrecedence.Associativity.LEFT){

        @Override
        public ExprNode.OperatorNode createNode(SourceLocation location, SourceLocation operatorLocation) {
            return new OperatorNodes.AmpAmpOpNode(location, operatorLocation);
        }
    }
    ,
    OR(ImmutableList.of((Object)Constants.OPERAND_0, (Object)Constants.SP, (Object)new Token("or"), (Object)Constants.SP, (Object)Constants.OPERAND_1), SoyPrecedence.P2, SoyPrecedence.Associativity.LEFT){

        @Override
        public ExprNode.OperatorNode createNode(SourceLocation location, SourceLocation operatorLocation) {
            return new OperatorNodes.OrOpNode(location, operatorLocation);
        }
    }
    ,
    BAR_BAR(ImmutableList.of((Object)Constants.OPERAND_0, (Object)Constants.SP, (Object)new Token("||"), (Object)Constants.SP, (Object)Constants.OPERAND_1), SoyPrecedence.P2, SoyPrecedence.Associativity.LEFT){

        @Override
        public ExprNode.OperatorNode createNode(SourceLocation location, SourceLocation operatorLocation) {
            return new OperatorNodes.BarBarOpNode(location, operatorLocation);
        }
    }
    ,
    NULL_COALESCING(ImmutableList.of((Object)Constants.OPERAND_0, (Object)Constants.SP, (Object)new Token("??"), (Object)Constants.SP, (Object)Constants.OPERAND_1), SoyPrecedence.P2, SoyPrecedence.Associativity.LEFT){

        @Override
        public ExprNode.OperatorNode createNode(SourceLocation location, SourceLocation operatorLocation) {
            return new OperatorNodes.NullCoalescingOpNode(location, operatorLocation);
        }
    }
    ,
    CONDITIONAL(ImmutableList.of((Object)Constants.OPERAND_0, (Object)Constants.SP, (Object)new Token("?"), (Object)Constants.SP, (Object)Constants.OPERAND_1, (Object)Constants.SP, (Object)new Token(":"), (Object)Constants.SP, (Object)Constants.OPERAND_2), SoyPrecedence.P1, SoyPrecedence.Associativity.RIGHT){

        @Override
        public ExprNode.OperatorNode createNode(SourceLocation location, SourceLocation operatorLocation) {
            return new OperatorNodes.ConditionalOpNode(location, operatorLocation);
        }
    };

    private static final ImmutableTable<String, Integer, Operator> OPERATOR_TABLE;
    private final ImmutableList<SyntaxElement> syntax;
    private final String tokenString;
    private final int numOperands;
    private final SoyPrecedence precedence;
    private final SoyPrecedence.Associativity associativity;
    private final String description;

    public static ExprNode.OperatorNode createOperatorNode(SourceLocation location, String op, SourceLocation operatorLocation, SoyPrecedence prec, ExprNode ... children) {
        Preconditions.checkArgument((boolean)OPERATOR_TABLE.containsRow((Object)op));
        Operator operator = (Operator)((Object)OPERATOR_TABLE.get((Object)op, (Object)children.length));
        if (operator.getPrecedence() != prec) {
            throw new IllegalArgumentException("invalid precedence " + String.valueOf((Object)prec) + " for operator " + op);
        }
        return operator.createNode(location, operatorLocation, children);
    }

    private Operator(ImmutableList<SyntaxElement> syntax, SoyPrecedence precedence, SoyPrecedence.Associativity associativity) {
        this(syntax, precedence, associativity, null);
    }

    private Operator(ImmutableList<SyntaxElement> syntax, @Nullable SoyPrecedence precedence, SoyPrecedence.Associativity associativity, String description) {
        this.syntax = syntax;
        Object tokenString = null;
        int numOperands = 0;
        for (SyntaxElement syntaxEl : syntax) {
            if (syntaxEl instanceof Operand) {
                ++numOperands;
                continue;
            }
            if (!(syntaxEl instanceof Token)) continue;
            if (tokenString == null) {
                tokenString = ((Token)syntaxEl).getValue();
                continue;
            }
            tokenString = (String)tokenString + " " + ((Token)syntaxEl).getValue();
        }
        Preconditions.checkArgument((tokenString != null && numOperands > 0 ? 1 : 0) != 0);
        this.tokenString = tokenString;
        this.numOperands = numOperands;
        this.precedence = precedence;
        this.associativity = associativity;
        this.description = description != null ? description : tokenString;
    }

    public List<SyntaxElement> getSyntax() {
        return this.syntax;
    }

    public String getTokenString() {
        return this.tokenString;
    }

    public int getNumOperands() {
        return this.numOperands;
    }

    public boolean isBinary() {
        return this.getNumOperands() == 2;
    }

    public SoyPrecedence getPrecedence() {
        return this.precedence;
    }

    public SoyPrecedence.Associativity getAssociativity() {
        return this.associativity;
    }

    public String getDescription() {
        return this.description;
    }

    public abstract ExprNode.OperatorNode createNode(SourceLocation var1, SourceLocation var2);

    public final ExprNode.OperatorNode createNode(SourceLocation location, SourceLocation operatorLocation, ExprNode ... children) {
        Preconditions.checkArgument((children.length == this.getNumOperands() ? 1 : 0) != 0, (String)"expected %s operands, got %s", (int)this.getNumOperands(), (int)children.length);
        ExprNode.OperatorNode node = this.createNode(location, operatorLocation);
        for (ExprNode child : children) {
            node.addChild(child);
        }
        return node;
    }

    static {
        ImmutableTable.Builder builder = ImmutableTable.builder();
        for (Operator op : Operator.values()) {
            if (op == ASSERT_NON_NULL) continue;
            builder.put((Object)op.getTokenString(), (Object)op.getNumOperands(), (Object)op);
        }
        OPERATOR_TABLE = builder.buildOrThrow();
    }

    @Immutable
    public static class Spacer
    implements SyntaxElement {
        private Spacer() {
        }
    }

    @Immutable
    public static class Token
    implements SyntaxElement {
        private final String value;

        private Token(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    @Immutable
    public static class Operand
    implements SyntaxElement {
        private final int index;

        private Operand(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }
    }

    @Immutable
    public static interface SyntaxElement {
    }

    static class Constants {
        static final Spacer SP = new Spacer();
        static final Operand OPERAND_0 = new Operand(0);
        static final Operand OPERAND_1 = new Operand(1);
        static final Operand OPERAND_2 = new Operand(2);

        Constants() {
        }
    }
}

