/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.exprtree;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.exprtree.AbstractLocalVarDefn;
import com.google.template.soy.exprtree.AbstractParentExprNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.VarDefn;
import com.google.template.soy.types.SoyType;
import javax.annotation.Nullable;

public final class ListComprehensionNode
extends AbstractParentExprNode {
    private final ComprehensionVarDefn listIterVar;
    @Nullable
    private final ComprehensionVarDefn indexVar;
    private final boolean hasFilter;
    private int nodeId;

    public ListComprehensionNode(ExprNode listExpr, String listIterVarName, SourceLocation listIterVarNameLocation, String indexVarName, SourceLocation indexVarNameLocation, ExprNode itemMapExpr, ExprNode filterExpr, SourceLocation sourceLocation, int nodeId) {
        super(sourceLocation);
        this.listIterVar = new ComprehensionVarDefn(listIterVarName, listIterVarNameLocation, this);
        this.indexVar = indexVarName == null ? null : new ComprehensionVarDefn(indexVarName, indexVarNameLocation, this);
        this.nodeId = nodeId;
        this.addChild(listExpr);
        this.addChild(itemMapExpr);
        if (filterExpr != null) {
            this.hasFilter = true;
            this.addChild(filterExpr);
        } else {
            this.hasFilter = false;
        }
    }

    private ListComprehensionNode(ListComprehensionNode orig, CopyState copyState) {
        super(orig, copyState);
        this.listIterVar = new ComprehensionVarDefn(orig.listIterVar, this);
        this.indexVar = orig.indexVar == null ? null : new ComprehensionVarDefn(orig.indexVar, this);
        this.hasFilter = orig.hasFilter;
        this.nodeId = orig.nodeId;
        copyState.updateRefs(orig.listIterVar, this.listIterVar);
        if (orig.indexVar != null) {
            copyState.updateRefs(orig.indexVar, this.indexVar);
        }
    }

    public ImmutableList<? extends AbstractLocalVarDefn<?>> getVars() {
        return this.indexVar == null ? ImmutableList.of((Object)this.listIterVar) : ImmutableList.of((Object)this.listIterVar, (Object)this.indexVar);
    }

    @Override
    public ExprNode.Kind getKind() {
        return ExprNode.Kind.LIST_COMPREHENSION_NODE;
    }

    public ComprehensionVarDefn getListIterVar() {
        return this.listIterVar;
    }

    @Nullable
    public ComprehensionVarDefn getIndexVar() {
        return this.indexVar;
    }

    public ExprNode getListExpr() {
        return (ExprNode)Preconditions.checkNotNull((Object)this.getChild(0));
    }

    public ExprNode getListItemTransformExpr() {
        return (ExprNode)Preconditions.checkNotNull((Object)this.getChild(1));
    }

    @Nullable
    public ExprNode getFilterExpr() {
        if (this.hasFilter) {
            return (ExprNode)Preconditions.checkNotNull((Object)this.getChild(2));
        }
        return null;
    }

    public void setNodeId(int nodeId) {
        this.nodeId = nodeId;
    }

    public int getNodeId() {
        return this.nodeId;
    }

    @Override
    public String toSourceString() {
        if (this.indexVar != null) {
            if (this.hasFilter) {
                return String.format("[%s for %s, %s in %s if %s]", this.getListItemTransformExpr().toSourceString(), this.listIterVar.refName(), this.indexVar.refName(), this.getListExpr().toSourceString(), this.getFilterExpr().toSourceString());
            }
            return String.format("[%s for %s, %s in %s]", this.getListItemTransformExpr().toSourceString(), this.listIterVar.refName(), this.indexVar.refName(), this.getListExpr().toSourceString());
        }
        if (this.hasFilter) {
            return String.format("[%s for %s in %s if %s]", this.getListItemTransformExpr().toSourceString(), this.listIterVar.refName(), this.getListExpr().toSourceString(), this.getFilterExpr().toSourceString());
        }
        return String.format("[%s for %s in %s]", this.getListItemTransformExpr().toSourceString(), this.listIterVar.refName(), this.getListExpr().toSourceString());
    }

    @Override
    public ListComprehensionNode copy(CopyState copyState) {
        return new ListComprehensionNode(this, copyState);
    }

    public static final class ComprehensionVarDefn
    extends AbstractLocalVarDefn<ListComprehensionNode> {
        ComprehensionVarDefn(String name, SourceLocation nameLocation, ListComprehensionNode declaringNode) {
            this(name, nameLocation, declaringNode, (SoyType)null);
        }

        ComprehensionVarDefn(String name, SourceLocation nameLocation, ListComprehensionNode declaringNode, SoyType type) {
            super(name, nameLocation, declaringNode, type);
        }

        ComprehensionVarDefn(ComprehensionVarDefn var, ListComprehensionNode declaringNode) {
            super(var, declaringNode);
        }

        @Override
        public VarDefn.Kind kind() {
            return VarDefn.Kind.COMPREHENSION_VAR;
        }
    }
}

