/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.exprtree;

import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.exprtree.AbstractExprNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.UnknownType;

public final class GlobalNode
extends AbstractExprNode {
    private Identifier identifier;
    private boolean isErrorPlaceholder;

    private static GlobalNode error(SourceLocation location) {
        return new GlobalNode(Identifier.create("error", "error", location));
    }

    public static void replaceExprWithError(ExprNode expr) {
        GlobalNode errorNode = GlobalNode.error(expr.getSourceLocation());
        errorNode.isErrorPlaceholder = true;
        expr.getParent().replaceChild(expr, errorNode);
    }

    public GlobalNode(Identifier identifier) {
        super(identifier.location());
        this.identifier = identifier;
    }

    private GlobalNode(GlobalNode orig, CopyState copyState) {
        super(orig, copyState);
        this.identifier = orig.identifier;
    }

    @Override
    public ExprNode.Kind getKind() {
        return ExprNode.Kind.GLOBAL_NODE;
    }

    @Override
    public SoyType getType() {
        return UnknownType.getInstance();
    }

    public String getName() {
        return this.identifier.identifier();
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public void resolve(String name) {
        this.identifier = Identifier.create(name, this.identifier.originalName(), this.identifier.location());
    }

    public boolean alreadyReportedError() {
        return this.isErrorPlaceholder;
    }

    @Override
    public String toSourceString() {
        return this.identifier.originalName();
    }

    @Override
    public GlobalNode copy(CopyState copyState) {
        return new GlobalNode(this, copyState);
    }
}

