/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.exprtree;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.basetree.Node;
import com.google.template.soy.basetree.ParentNode;
import com.google.template.soy.exprtree.Operator;
import com.google.template.soy.exprtree.SoyPrecedence;
import com.google.template.soy.types.SoyType;
import java.util.List;
import java.util.Optional;

public interface ExprNode
extends Node {
    public Kind getKind();

    public SoyType getType();

    public ParentExprNode getParent();

    @Override
    public ExprNode copy(CopyState var1);

    default public SoyPrecedence getPrecedence() {
        return SoyPrecedence.PRIMARY;
    }

    default public SoyPrecedence.Associativity getAssociativity() {
        return SoyPrecedence.Associativity.LEFT;
    }

    public boolean isDesugaredGroup();

    public void setDesugaredGroup(boolean var1);

    public static interface CallableExpr
    extends ExprNode {
        public Optional<ImmutableList<SourceLocation.Point>> getCommaLocations();

        public List<ExprNode> getParams();

        default public ExprNode getParam(int index) {
            return this.getParams().get(index);
        }

        public int numParams();

        public ParamsStyle getParamsStyle();

        public Identifier getIdentifier();

        public ImmutableList<Identifier> getParamNames();

        default public Identifier getParamName(int i) {
            return (Identifier)this.getParamNames().get(i);
        }

        public static enum ParamsStyle {
            NONE,
            POSITIONAL,
            NAMED;

        }
    }

    public static interface AccessChainComponentNode
    extends ParentExprNode {
    }

    public static interface PrimitiveNode
    extends ExprNode {
        @Override
        public PrimitiveNode copy(CopyState var1);
    }

    public static interface OperatorNode
    extends ParentExprNode {
        public Operator getOperator();

        @Override
        public OperatorNode copy(CopyState var1);

        @Override
        default public SoyPrecedence getPrecedence() {
            return this.getOperator().getPrecedence();
        }

        @Override
        default public SoyPrecedence.Associativity getAssociativity() {
            return this.getOperator().getAssociativity();
        }
    }

    public static interface ParentExprNode
    extends ExprNode,
    ParentNode<ExprNode> {
    }

    public static enum Kind {
        EXPR_ROOT_NODE,
        NULL_NODE,
        UNDEFINED_NODE,
        BOOLEAN_NODE,
        INTEGER_NODE,
        FLOAT_NODE,
        STRING_NODE,
        PROTO_ENUM_VALUE_NODE,
        LIST_LITERAL_NODE,
        LIST_COMPREHENSION_NODE,
        MAP_LITERAL_NODE,
        MAP_LITERAL_FROM_LIST_NODE,
        RECORD_LITERAL_NODE,
        VAR_REF_NODE,
        FIELD_ACCESS_NODE,
        ITEM_ACCESS_NODE,
        METHOD_CALL_NODE,
        NULL_SAFE_ACCESS_NODE,
        GLOBAL_NODE,
        GROUP_NODE,
        NEGATIVE_OP_NODE,
        NOT_OP_NODE,
        TIMES_OP_NODE,
        DIVIDE_BY_OP_NODE,
        MOD_OP_NODE,
        PLUS_OP_NODE,
        MINUS_OP_NODE,
        LESS_THAN_OP_NODE,
        GREATER_THAN_OP_NODE,
        LESS_THAN_OR_EQUAL_OP_NODE,
        GREATER_THAN_OR_EQUAL_OP_NODE,
        EQUAL_OP_NODE,
        NOT_EQUAL_OP_NODE,
        TRIPLE_EQUAL_OP_NODE,
        TRIPLE_NOT_EQUAL_OP_NODE,
        AND_OP_NODE,
        AMP_AMP_OP_NODE,
        OR_OP_NODE,
        BAR_BAR_OP_NODE,
        NULL_COALESCING_OP_NODE,
        CONDITIONAL_OP_NODE,
        ASSERT_NON_NULL_OP_NODE,
        SHIFT_LEFT_OP_NODE,
        SHIFT_RIGHT_OP_NODE,
        BITWISE_OR_OP_NODE,
        BITWISE_XOR_OP_NODE,
        BITWISE_AND_OP_NODE,
        FUNCTION_NODE,
        TEMPLATE_LITERAL_NODE;

    }
}

