/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.error;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.error.SoyError;
import com.google.template.soy.error.SoyErrors;

public final class SoyCompilationException
extends RuntimeException {
    private final ImmutableList<SoyError> errors;

    public SoyCompilationException(Iterable<SoyError> errors) {
        this.errors = ImmutableList.sortedCopyOf(errors);
        Preconditions.checkArgument((!this.errors.isEmpty() ? 1 : 0) != 0);
    }

    public ImmutableList<SoyError> getErrors() {
        return this.errors;
    }

    @Override
    public String getMessage() {
        return SoyErrors.formatErrors(this.errors);
    }
}

