/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.data.internalutils;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.html.types.SafeHtmlProto;
import com.google.common.html.types.SafeScriptProto;
import com.google.common.html.types.SafeStyleProto;
import com.google.common.html.types.SafeStyleSheetProto;
import com.google.common.html.types.SafeUrlProto;
import com.google.common.html.types.TrustedResourceUrlProto;
import com.google.protobuf.Descriptors;
import com.google.template.soy.base.internal.SanitizedContentKind;
import java.util.EnumSet;

public final class NodeContentKinds {
    private static final ImmutableMap<SanitizedContentKind, String> KIND_TO_JS_CTOR_NAME = ImmutableMap.builder().put((Object)SanitizedContentKind.HTML, (Object)"goog.soy.data.SanitizedHtml").put((Object)SanitizedContentKind.HTML_ELEMENT, (Object)"goog.soy.data.SanitizedHtml").put((Object)SanitizedContentKind.ATTRIBUTES, (Object)"goog.soy.data.SanitizedHtmlAttribute").put((Object)SanitizedContentKind.JS, (Object)"goog.soy.data.SanitizedJs").put((Object)SanitizedContentKind.URI, (Object)"goog.soy.data.SanitizedUri").put((Object)SanitizedContentKind.CSS, (Object)"goog.soy.data.SanitizedCss").put((Object)SanitizedContentKind.TRUSTED_RESOURCE_URI, (Object)"goog.soy.data.SanitizedTrustedResourceUri").put((Object)SanitizedContentKind.TEXT, (Object)"string").build();
    private static final ImmutableMap<SanitizedContentKind, String> KIND_TO_JS_ORDAINER_NAME = ImmutableMap.builder().put((Object)SanitizedContentKind.HTML, (Object)"soy.VERY_UNSAFE.ordainSanitizedHtml").put((Object)SanitizedContentKind.HTML_ELEMENT, (Object)"soy.VERY_UNSAFE.ordainSanitizedHtml").put((Object)SanitizedContentKind.ATTRIBUTES, (Object)"soy.VERY_UNSAFE.ordainSanitizedHtmlAttribute").put((Object)SanitizedContentKind.JS, (Object)"soy.VERY_UNSAFE.ordainSanitizedJs").put((Object)SanitizedContentKind.URI, (Object)"soy.VERY_UNSAFE.ordainSanitizedUri").put((Object)SanitizedContentKind.CSS, (Object)"soy.VERY_UNSAFE.ordainSanitizedCss").put((Object)SanitizedContentKind.TRUSTED_RESOURCE_URI, (Object)"soy.VERY_UNSAFE.ordainSanitizedTrustedResourceUri").put((Object)SanitizedContentKind.TEXT, (Object)"").build();
    private static final ImmutableMap<String, String> PROTO_TO_JS_UNPACK_FN = ImmutableMap.builder().put((Object)SafeHtmlProto.getDescriptor().getFullName(), (Object)"unpackProtoToSanitizedHtml").put((Object)SafeScriptProto.getDescriptor().getFullName(), (Object)"unpackProtoToSanitizedJs").put((Object)SafeUrlProto.getDescriptor().getFullName(), (Object)"unpackProtoToSanitizedUri").put((Object)SafeStyleProto.getDescriptor().getFullName(), (Object)"unpackProtoToSanitizedCss").put((Object)SafeStyleSheetProto.getDescriptor().getFullName(), (Object)"unpackProtoToSanitizedCss").put((Object)TrustedResourceUrlProto.getDescriptor().getFullName(), (Object)"unpackProtoToSanitizedTrustedResourceUri").build();
    private static final ImmutableMap<SanitizedContentKind, String> KIND_TO_PY_SANITIZED_NAME = ImmutableMap.builder().put((Object)SanitizedContentKind.HTML_ELEMENT, (Object)"sanitize.SanitizedHtml").put((Object)SanitizedContentKind.HTML, (Object)"sanitize.SanitizedHtml").put((Object)SanitizedContentKind.ATTRIBUTES, (Object)"sanitize.SanitizedHtmlAttribute").put((Object)SanitizedContentKind.JS, (Object)"sanitize.SanitizedJs").put((Object)SanitizedContentKind.URI, (Object)"sanitize.SanitizedUri").put((Object)SanitizedContentKind.CSS, (Object)"sanitize.SanitizedCss").put((Object)SanitizedContentKind.TRUSTED_RESOURCE_URI, (Object)"sanitize.SanitizedTrustedResourceUri").put((Object)SanitizedContentKind.TEXT, (Object)"").build();

    public static String toJsSanitizedContentCtorName(SanitizedContentKind contentKind) {
        return (String)Preconditions.checkNotNull((Object)((String)KIND_TO_JS_CTOR_NAME.get((Object)contentKind)));
    }

    public static String toJsSanitizedContentOrdainer(SanitizedContentKind contentKind) {
        return (String)Preconditions.checkNotNull((Object)((String)KIND_TO_JS_ORDAINER_NAME.get((Object)contentKind)));
    }

    public static String getJsImportForOrdainersFunctions(SanitizedContentKind contentKind) {
        return "soy";
    }

    public static String toJsUnpackFunction(Descriptors.Descriptor protoDescriptor) {
        return (String)Preconditions.checkNotNull((Object)((String)PROTO_TO_JS_UNPACK_FN.get((Object)protoDescriptor.getFullName())));
    }

    public static String toPySanitizedContentOrdainer(SanitizedContentKind contentKind) {
        return (String)Preconditions.checkNotNull((Object)((String)KIND_TO_PY_SANITIZED_NAME.get((Object)contentKind)), (String)"expected to have an ordainer for %s", (Object)((Object)contentKind));
    }

    private NodeContentKinds() {
    }

    static {
        EnumSet<SanitizedContentKind> allKinds = EnumSet.allOf(SanitizedContentKind.class);
        if (!KIND_TO_JS_CTOR_NAME.keySet().containsAll(allKinds)) {
            throw new AssertionError((Object)"Not all ContentKind enums have a JS constructor");
        }
        if (!KIND_TO_JS_ORDAINER_NAME.keySet().containsAll(allKinds)) {
            throw new AssertionError((Object)"Not all Soy-accessible ContentKind enums have a JS ordainer");
        }
        if (!KIND_TO_PY_SANITIZED_NAME.keySet().containsAll(allKinds)) {
            throw new AssertionError((Object)"Not all Soy-accessible ContentKind enums have a Python sanitizer");
        }
    }
}

