/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.data.internal;

import com.google.common.collect.ImmutableMap;
import com.google.template.soy.data.LoggingAdvisingAppendable;
import com.google.template.soy.data.RecordProperty;
import com.google.template.soy.data.SoyAbstractValue;
import com.google.template.soy.data.SoyRecord;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.SoyValueProvider;
import com.google.template.soy.data.internal.ParamStore;
import java.io.IOException;
import java.util.function.BiConsumer;

public final class SoyRecordImpl
extends SoyAbstractValue
implements SoyRecord {
    private final ParamStore map;

    public SoyRecordImpl(ParamStore map) {
        this.map = map.freeze();
    }

    @Override
    public ImmutableMap<String, SoyValueProvider> recordAsMap() {
        return this.map.asStringMap();
    }

    @Override
    public void forEach(BiConsumer<RecordProperty, ? super SoyValueProvider> action) {
        this.map.forEach(action);
    }

    @Override
    public int recordSize() {
        return this.map.size();
    }

    @Override
    public boolean coerceToBoolean() {
        return true;
    }

    @Override
    public String coerceToString() {
        LoggingAdvisingAppendable.BufferingAppendable mapStr = LoggingAdvisingAppendable.buffering();
        try {
            this.render(mapStr);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        return ((Object)mapStr).toString();
    }

    @Override
    public void render(LoggingAdvisingAppendable appendable) throws IOException {
        appendable.append('{');
        boolean isFirst = true;
        for (RecordProperty property : this.map.properties()) {
            if (isFirst) {
                isFirst = false;
            } else {
                appendable.append(", ");
            }
            appendable.append(property.getName()).append(": ");
            this.map.getFieldProvider(property).resolve().render(appendable);
        }
        appendable.append('}');
    }

    @Override
    public boolean equals(Object other) {
        return this == other;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public boolean hasField(RecordProperty name) {
        return this.map.containsKey(name);
    }

    @Override
    public SoyValueProvider getFieldProvider(RecordProperty name) {
        return this.map.getFieldProvider(name);
    }

    @Override
    public SoyValue getField(RecordProperty name) {
        SoyValueProvider svp = this.map.getFieldProvider(name);
        if (svp == null) {
            return null;
        }
        return svp.resolve();
    }

    ParamStore getParamStore() {
        return this.map;
    }
}

