/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.data.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.DoNotCall;
import com.google.template.soy.data.RecordProperty;
import com.google.template.soy.data.SoyRecord;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.SoyValueProvider;
import com.google.template.soy.data.internal.SoyRecordImpl;
import com.google.template.soy.data.restricted.UndefinedData;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

public final class ParamStore
extends IdentityHashMap<RecordProperty, SoyValueProvider> {
    private boolean frozen;
    public static final ParamStore EMPTY_INSTANCE = new ParamStore(0).freeze();

    public static ParamStore merge(ParamStore store1, ParamStore store2) {
        ParamStore newStore = new ParamStore(store1.size() + store2.size());
        store1.forEach(newStore::setFieldCritical);
        store2.forEach(newStore::setFieldCritical);
        return newStore.freeze();
    }

    public static ParamStore fromRecord(SoyRecord record) {
        if (record instanceof SoyRecordImpl) {
            return ((SoyRecordImpl)record).getParamStore();
        }
        ParamStore newStore = new ParamStore(record.recordSize());
        record.forEach(newStore::setFieldCritical);
        return newStore.freeze();
    }

    public ParamStore(ParamStore backingStore, int size) {
        super(backingStore.size() + size);
        backingStore.forEach((x$0, x$1) -> {
            SoyValueProvider cfr_ignored_0 = (SoyValueProvider)super.put(x$0, x$1);
        });
    }

    public ParamStore(int size) {
        super(size);
    }

    public ParamStore() {
    }

    @CanIgnoreReturnValue
    public ParamStore freeze() {
        this.frozen = true;
        return this;
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    @CanIgnoreReturnValue
    public ParamStore setField(RecordProperty name, @Nonnull SoyValueProvider valueProvider) {
        Preconditions.checkState((!this.frozen ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)valueProvider);
        super.put(name, valueProvider);
        return this;
    }

    @CanIgnoreReturnValue
    public ParamStore setFieldCritical(RecordProperty name, @Nonnull SoyValueProvider valueProvider) {
        Preconditions.checkState((!this.frozen ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)valueProvider);
        SoyValueProvider previous = super.put(name, valueProvider);
        Preconditions.checkState((previous == null ? 1 : 0) != 0, (String)"value already set for param %s", (Object)name);
        return this;
    }

    public boolean hasField(RecordProperty name) {
        return super.containsKey(name);
    }

    public SoyValueProvider getFieldProvider(RecordProperty name) {
        return (SoyValueProvider)super.get(name);
    }

    public SoyValueProvider getParameter(RecordProperty name) {
        SoyValueProvider provider = (SoyValueProvider)super.get(name);
        return provider != null ? provider : UndefinedData.INSTANCE;
    }

    public SoyValueProvider getParameter(RecordProperty name, SoyValue defaultValue) {
        SoyValueProvider provider = (SoyValueProvider)super.get(name);
        return provider != null ? provider : defaultValue;
    }

    public ImmutableMap<String, SoyValueProvider> asStringMap() {
        ImmutableMap.Builder builder = ImmutableMap.builderWithExpectedSize((int)this.size());
        this.forEach((k, v) -> builder.put((Object)k.getName(), v));
        return builder.buildOrThrow();
    }

    @Override
    public String toString() {
        return this.getClass().toString();
    }

    @Override
    public boolean equals(Object o) {
        Preconditions.checkState((boolean)this.frozen);
        if (!(o instanceof ParamStore)) {
            return false;
        }
        ParamStore otherStore = (ParamStore)o;
        if (this.size() != otherStore.size()) {
            return false;
        }
        for (RecordProperty key : super.keySet()) {
            if (this.getFieldProvider(key).equals(otherStore.getFieldProvider(key))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        Preconditions.checkState((boolean)this.frozen);
        int result = 0;
        for (RecordProperty key : super.keySet()) {
            result += System.identityHashCode(key) ^ this.getFieldProvider(key).hashCode();
        }
        return result;
    }

    public Set<RecordProperty> properties() {
        return super.keySet();
    }

    @Override
    @DoNotCall
    public SoyValueProvider put(RecordProperty property, SoyValueProvider value) {
        throw new UnsupportedOperationException();
    }

    @Override
    @DoNotCall
    public void putAll(Map<? extends RecordProperty, ? extends SoyValueProvider> map) {
        throw new UnsupportedOperationException();
    }

    @Override
    @DoNotCall
    public SoyValueProvider remove(Object property) {
        throw new UnsupportedOperationException();
    }

    @Override
    @DoNotCall
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    @DoNotCall
    public Set<Map.Entry<RecordProperty, SoyValueProvider>> entrySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    @DoNotCall
    public Set<RecordProperty> keySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    @DoNotCall
    public Collection<SoyValueProvider> values() {
        throw new UnsupportedOperationException();
    }

    @Override
    @DoNotCall
    public SoyValueProvider get(Object key) {
        throw new UnsupportedOperationException();
    }
}

