/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.data.internal;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.template.soy.data.ProtoFieldInterpreter;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.internal.AbstractSoyMap;
import com.google.template.soy.data.restricted.NullData;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;

public final class LazyProtoToSoyValueMap<K, V>
extends AbstractSoyMap {
    private final ImmutableMap<K, V> rawMap;
    private final Map<SoyValue, SoyValue> wrappedValues;
    private final Map<SoyValue, K> rawKeys;
    private final Map<K, SoyValue> wrappedKeys;
    private final ProtoFieldInterpreter keyFieldInterpreter;
    private final ProtoFieldInterpreter valueFieldInterpreter;
    private final Class<K> keyClass;

    @Nonnull
    public static <K, V> LazyProtoToSoyValueMap<K, V> forMap(Map<K, V> map, ProtoFieldInterpreter keyFieldInterpreter, ProtoFieldInterpreter valueFieldInterpreter, Class<K> keyClass) {
        return new LazyProtoToSoyValueMap<K, V>(map, keyFieldInterpreter, valueFieldInterpreter, keyClass);
    }

    private LazyProtoToSoyValueMap(Map<K, V> map, ProtoFieldInterpreter keyFieldInterpreter, ProtoFieldInterpreter valueFieldInterpreter, Class<K> keyClass) {
        BiMap keys;
        this.rawMap = ImmutableMap.copyOf(map);
        this.wrappedValues = new HashMap<SoyValue, SoyValue>();
        this.rawKeys = keys = Maps.synchronizedBiMap((BiMap)HashBiMap.create());
        this.wrappedKeys = keys.inverse();
        this.keyFieldInterpreter = keyFieldInterpreter;
        this.valueFieldInterpreter = valueFieldInterpreter;
        this.keyClass = keyClass;
    }

    @Override
    public int size() {
        return this.rawMap.size();
    }

    public ImmutableSet<SoyValue> keys() {
        ImmutableSet.Builder keys = ImmutableSet.builder();
        for (Object key : this.rawMap.keySet()) {
            SoyValue wrappedKey = this.wrappedKeys.computeIfAbsent(key, this.keyFieldInterpreter::soyFromProto);
            keys.add((Object)wrappedKey);
        }
        return keys.build();
    }

    @Override
    public boolean containsKey(SoyValue key) {
        if (this.rawKeys.containsKey(key)) {
            return true;
        }
        return this.rawMap.containsKey(this.soyValueToKey(key));
    }

    @Override
    public SoyValue get(SoyValue key) {
        return this.wrappedValues.computeIfAbsent(key, k -> {
            Object value = this.rawMap.get(this.soyValueToKey((SoyValue)k));
            if (value == null) {
                return null;
            }
            return this.valueFieldInterpreter.soyFromProto(value);
        });
    }

    @Override
    public SoyValue getProvider(SoyValue key) {
        return this.get(key);
    }

    @Nonnull
    public ImmutableMap<SoyValue, SoyValue> asJavaMap() {
        ImmutableMap.Builder map = ImmutableMap.builder();
        for (SoyValue key : this.keys()) {
            map.put((Object)key, (Object)this.get(key));
        }
        return map.build();
    }

    private K soyValueToKey(SoyValue soyValue) {
        if (NullData.INSTANCE.equals(soyValue)) {
            return null;
        }
        return (K)this.rawKeys.computeIfAbsent(soyValue, k -> this.keyClass.cast(this.keyFieldInterpreter.protoFromSoy((SoyValue)k)));
    }
}

