/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.data.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.template.soy.data.LoggingAdvisingAppendable;
import com.google.template.soy.data.RecordProperty;
import com.google.template.soy.data.SoyAbstractValue;
import com.google.template.soy.data.SoyDataException;
import com.google.template.soy.data.SoyDict;
import com.google.template.soy.data.SoyMap;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.SoyValueProvider;
import com.google.template.soy.data.internal.RuntimeMapTypeTracker;
import com.google.template.soy.data.restricted.StringData;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class DictImpl
extends SoyAbstractValue
implements SoyDict,
SoyMap {
    private final Map<String, ? extends SoyValueProvider> providerMap;
    private final RuntimeMapTypeTracker typeTracker;

    @Nonnull
    public static DictImpl forProviderMap(Map<String, ? extends SoyValueProvider> providerMap, RuntimeMapTypeTracker.Type mapType) {
        return new DictImpl(providerMap, mapType);
    }

    private DictImpl(Map<String, ? extends SoyValueProvider> providerMap, RuntimeMapTypeTracker.Type typeTracker) {
        this.providerMap = (Map)Preconditions.checkNotNull(providerMap);
        this.typeTracker = new RuntimeMapTypeTracker((RuntimeMapTypeTracker.Type)((Object)Preconditions.checkNotNull((Object)((Object)typeTracker))));
    }

    @Override
    public boolean hasField(RecordProperty symbol) {
        this.typeTracker.maybeSetLegacyObjectMapOrRecordType();
        return this.providerMap.containsKey(symbol.getName());
    }

    @Override
    public SoyValue getField(RecordProperty symbol) {
        this.typeTracker.maybeSetLegacyObjectMapOrRecordType();
        return this.getFieldInternal(symbol);
    }

    private SoyValue getFieldInternal(RecordProperty symbol) {
        return this.getFieldInternal(symbol.getName());
    }

    private SoyValue getFieldInternal(String key) {
        SoyValueProvider provider = this.providerMap.get(key);
        return provider != null ? provider.resolve() : null;
    }

    @Override
    public SoyValueProvider getFieldProvider(RecordProperty symbol) {
        this.typeTracker.maybeSetLegacyObjectMapOrRecordType();
        return this.providerMap.get(symbol.getName());
    }

    @Override
    public ImmutableMap<String, SoyValueProvider> recordAsMap() {
        this.typeTracker.maybeSetLegacyObjectMapOrRecordType();
        return ImmutableMap.copyOf(this.providerMap);
    }

    @Override
    public void forEach(BiConsumer<RecordProperty, ? super SoyValueProvider> action) {
        this.typeTracker.maybeSetLegacyObjectMapOrRecordType();
        this.providerMap.forEach((? super K key, ? super V value) -> action.accept(RecordProperty.get(key), (SoyValueProvider)value));
    }

    @Override
    public int recordSize() {
        this.typeTracker.maybeSetLegacyObjectMapOrRecordType();
        return this.providerMap.size();
    }

    @Override
    public int getItemCnt() {
        this.typeTracker.maybeSetLegacyObjectMapOrRecordType();
        return this.providerMap.size();
    }

    @Override
    public int size() {
        this.typeTracker.maybeSetMapType();
        return this.providerMap.size();
    }

    @Override
    @Nonnull
    public Iterable<? extends SoyValue> getItemKeys() {
        this.typeTracker.maybeSetLegacyObjectMapOrRecordType();
        return Iterables.transform(this.providerMap.keySet(), StringData::forValue);
    }

    @Override
    @Nonnull
    public Iterable<? extends SoyValue> keys() {
        this.typeTracker.maybeSetMapType();
        return Iterables.transform(this.providerMap.keySet(), StringData::forValue);
    }

    @Override
    public boolean hasItem(SoyValue key) {
        this.typeTracker.maybeSetLegacyObjectMapOrRecordType();
        return this.providerMap.containsKey(this.getStringKey(key));
    }

    @Override
    public boolean containsKey(SoyValue key) {
        this.typeTracker.maybeSetMapType();
        return this.providerMap.containsKey(this.getStringKey(key));
    }

    @Override
    public SoyValue getItem(SoyValue key) {
        this.typeTracker.maybeSetLegacyObjectMapOrRecordType();
        return this.getFieldInternal(this.getStringKey(key));
    }

    @Override
    public SoyValue get(SoyValue key) {
        this.typeTracker.maybeSetMapType();
        return this.getFieldInternal(this.getStringKey(key));
    }

    @Override
    public SoyValueProvider getItemProvider(SoyValue key) {
        this.typeTracker.maybeSetLegacyObjectMapOrRecordType();
        return this.providerMap.get(this.getStringKey(key));
    }

    @Override
    public SoyValueProvider getProvider(SoyValue key) {
        this.typeTracker.maybeSetMapType();
        return this.providerMap.get(this.getStringKey(key));
    }

    @Override
    @Nonnull
    public Map<String, ? extends SoyValueProvider> asJavaStringMap() {
        return Collections.unmodifiableMap(this.providerMap);
    }

    @Override
    @Nonnull
    public Map<String, ? extends SoyValue> asResolvedJavaStringMap() {
        return Maps.transformValues(this.asJavaStringMap(), SoyValueProvider::resolve);
    }

    @Override
    @Nonnull
    public Map<? extends SoyValue, ? extends SoyValueProvider> asJavaMap() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<String, ? extends SoyValueProvider> entry : this.providerMap.entrySet()) {
            builder.put((Object)StringData.forValue(entry.getKey()), (Object)entry.getValue());
        }
        return builder.build();
    }

    private String getStringKey(SoyValue key) {
        try {
            return key.stringValue();
        }
        catch (SoyDataException e) {
            throw new SoyDataException("SoyDict accessed with non-string key (got key type " + key.getClass().getName() + ").", e);
        }
    }

    @Override
    public boolean coerceToBoolean() {
        return true;
    }

    @Override
    public String coerceToString() {
        LoggingAdvisingAppendable.BufferingAppendable mapStr = LoggingAdvisingAppendable.buffering();
        try {
            this.render(mapStr);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        return ((Object)mapStr).toString();
    }

    @Override
    public void render(LoggingAdvisingAppendable appendable) throws IOException {
        appendable.append('{');
        boolean isFirst = true;
        boolean useNewSoyMap = this.typeTracker.type() == RuntimeMapTypeTracker.Type.MAP;
        for (SoyValue soyValue : useNewSoyMap ? this.keys() : this.getItemKeys()) {
            SoyValue value;
            SoyValue soyValue2 = value = useNewSoyMap ? this.get(soyValue) : this.getItem(soyValue);
            if (isFirst) {
                isFirst = false;
            } else {
                appendable.append(", ");
            }
            soyValue.render(appendable);
            appendable.append(": ");
            if (value == null) {
                appendable.append("null");
                continue;
            }
            value.render(appendable);
        }
        appendable.append('}');
    }

    @Override
    public boolean equals(Object other) {
        return this == other;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    public String toString() {
        return this.coerceToString();
    }

    public RuntimeMapTypeTracker.Type getMapType() {
        return this.typeTracker.type();
    }
}

