/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.data.internal;

import com.google.common.base.Converter;
import com.google.template.soy.base.internal.SanitizedContentKind;
import com.google.template.soy.data.SanitizedContent;

public final class Converters {
    static final Converter<SanitizedContentKind, SanitizedContent.ContentKind> CONTENT_KIND_CONVERTER = new Converter<SanitizedContentKind, SanitizedContent.ContentKind>(){

        protected SanitizedContent.ContentKind doForward(SanitizedContentKind sanitizedContentKind) {
            if (sanitizedContentKind == SanitizedContentKind.HTML_ELEMENT) {
                return SanitizedContent.ContentKind.HTML;
            }
            return SanitizedContent.ContentKind.valueOf(sanitizedContentKind.name());
        }

        protected SanitizedContentKind doBackward(SanitizedContent.ContentKind contentKind) {
            return SanitizedContentKind.valueOf(contentKind.name());
        }
    };

    public static SanitizedContent.ContentKind toContentKind(SanitizedContentKind sanitizedContentKind) {
        return (SanitizedContent.ContentKind)((Object)CONTENT_KIND_CONVERTER.convert((Object)sanitizedContentKind));
    }

    public static SanitizedContentKind toSanitizedContentKind(SanitizedContent.ContentKind contentKind) {
        return (SanitizedContentKind)((Object)CONTENT_KIND_CONVERTER.reverse().convert((Object)contentKind));
    }

    private Converters() {
    }
}

