/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.data;

import com.google.auto.value.AutoValue;
import com.google.template.soy.data.AutoValue_TemplateValue;
import com.google.template.soy.data.LoggingAdvisingAppendable;
import com.google.template.soy.data.SoyAbstractValue;
import com.google.template.soy.data.TemplateInterface;
import com.google.template.soy.data.internal.ParamStore;
import java.util.Optional;
import javax.annotation.Nonnull;

@AutoValue
public abstract class TemplateValue
extends SoyAbstractValue {
    @Nonnull
    public static TemplateValue create(String templateName) {
        return new AutoValue_TemplateValue(templateName, Optional.empty(), Optional.empty());
    }

    @Nonnull
    public static TemplateValue create(String templateName, Object compiledTemplate) {
        return new AutoValue_TemplateValue(templateName, Optional.empty(), Optional.of(compiledTemplate));
    }

    @Nonnull
    public static TemplateValue createWithBoundParameters(String templateName, ParamStore boundParameters) {
        return new AutoValue_TemplateValue(templateName, Optional.of(boundParameters), Optional.empty());
    }

    @Nonnull
    public static TemplateValue createWithBoundParameters(String templateName, ParamStore boundParameters, Object compiledTemplate) {
        return new AutoValue_TemplateValue(templateName, Optional.of(boundParameters), Optional.of(compiledTemplate));
    }

    @Nonnull
    public static TemplateValue createFromTemplate(TemplateInterface template, Object compiledTemplate) {
        ParamStore record = (ParamStore)template.getParamsAsRecord();
        return new AutoValue_TemplateValue(template.getTemplateName(), Optional.of(record), Optional.of(compiledTemplate));
    }

    public abstract String getTemplateName();

    public abstract Optional<ParamStore> getBoundParameters();

    public abstract Optional<Object> compiledTemplate();

    @Nonnull
    public Object getCompiledTemplate() {
        return this.compiledTemplate().get();
    }

    @Override
    public final boolean coerceToBoolean() {
        return true;
    }

    @Override
    public final String coerceToString() {
        return String.format("** FOR DEBUGGING ONLY: %s **", this.getTemplateName());
    }

    @Override
    public final void render(LoggingAdvisingAppendable appendable) {
        throw new IllegalStateException("Cannot print template types; this should have been caught during parsing.");
    }
}

