/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.data;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.template.soy.data.SoyTemplateParam;
import com.google.template.soy.data.SoyValueConverter;
import com.google.template.soy.data.SoyValueUnconverter;
import com.google.template.soy.data.internal.ParamStore;
import java.util.Map;

public final class SoyTemplateData {
    public static final SoyTemplateData EMPTY = SoyTemplateData.builder().build();
    private final ParamStore data;

    public static Builder builder() {
        return new Builder();
    }

    private SoyTemplateData(ParamStore data) {
        this.data = data;
    }

    public Map<String, ?> getParamsAsMap() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        this.data.forEach((k, v) -> params.put((Object)k.getName(), v));
        return params.buildOrThrow();
    }

    public Map<String, Object> getRawParamsAsMap() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        this.data.forEach((k, v) -> params.put((Object)k.getName(), SoyValueUnconverter.unconvert(v)));
        return params.buildOrThrow();
    }

    public Object getParamsAsRecord() {
        return this.data;
    }

    public boolean equals(Object o) {
        return o instanceof SoyTemplateData && this.data.equals(((SoyTemplateData)o).data);
    }

    public int hashCode() {
        return this.data.hashCode();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("data", this.getParamsAsMap()).toString();
    }

    public static final class Builder {
        private ParamStore data = new ParamStore();

        private Builder() {
        }

        private Builder setParamInternal(SoyTemplateParam<?> param, Object value) {
            if (this.data.isFrozen()) {
                this.data = new ParamStore(this.data, 1);
            }
            this.data.setField(param.getSymbol(), SoyValueConverter.INSTANCE.convert(value));
            return this;
        }

        @CanIgnoreReturnValue
        public <T> Builder setParam(SoyTemplateParam<? super T> param, T value) {
            return this.setParamInternal(param, value);
        }

        @CanIgnoreReturnValue
        public <T> Builder setParamFuture(SoyTemplateParam<? super T> param, ListenableFuture<T> value) {
            return this.setParamInternal(param, value);
        }

        public SoyTemplateData build() {
            return new SoyTemplateData(this.data.freeze());
        }
    }
}

