/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.data;

import com.google.template.soy.data.RecordProperty;
import com.google.template.soy.data.SoyRecord;
import com.google.template.soy.data.SoyValueConverter;
import com.google.template.soy.data.SoyValueProvider;
import com.google.template.soy.data.internal.ParamStore;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.annotation.Nullable;

@FunctionalInterface
public interface SoyInjector {
    public static final SoyInjector EMPTY = key -> null;

    public static SoyInjector fromStringMap(Map<String, ?> params) {
        IdentityHashMap<RecordProperty, SoyValueProvider> ihm = new IdentityHashMap<RecordProperty, SoyValueProvider>(params.size());
        for (Map.Entry<String, ?> entry : params.entrySet()) {
            SoyValueProvider value;
            String key = entry.getKey();
            try {
                value = SoyValueConverter.INSTANCE.convert(entry.getValue());
            }
            catch (RuntimeException e) {
                throw new IllegalArgumentException("Unable to convert param " + key + " to a SoyValue", e);
            }
            ihm.put(RecordProperty.get(key), value);
        }
        return ihm::get;
    }

    public static SoyInjector fromParamStore(ParamStore params) {
        return params::getFieldProvider;
    }

    public static SoyInjector fromRecord(SoyRecord params) {
        return params::getFieldProvider;
    }

    @Nullable
    public SoyValueProvider get(RecordProperty var1);
}

