/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.data;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import com.google.common.html.types.SafeHtml;
import com.google.common.html.types.SafeScript;
import com.google.common.html.types.SafeUrl;
import com.google.common.html.types.TrustedResourceUrl;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.errorprone.annotations.ForOverride;
import com.google.protobuf.Message;
import com.google.protobuf.ProtocolMessageEnum;
import com.google.template.soy.data.CssParam;
import com.google.template.soy.data.LoggingAdvisingAppendable;
import com.google.template.soy.data.PartialSoyTemplate;
import com.google.template.soy.data.RecordProperty;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SanitizedContents;
import com.google.template.soy.data.SoyFutureValueProvider;
import com.google.template.soy.data.SoyLegacyObjectMap;
import com.google.template.soy.data.SoyList;
import com.google.template.soy.data.SoyMap;
import com.google.template.soy.data.SoyProtoValue;
import com.google.template.soy.data.SoyRecord;
import com.google.template.soy.data.SoyTemplate;
import com.google.template.soy.data.SoyTemplateParam;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.SoyValueConverter;
import com.google.template.soy.data.SoyValueProvider;
import com.google.template.soy.data.SoyValueUnconverter;
import com.google.template.soy.data.TemplateInterface;
import com.google.template.soy.data.TemplateValue;
import com.google.template.soy.data.internal.ListImpl;
import com.google.template.soy.data.internal.ParamStore;
import com.google.template.soy.data.internal.SoyLegacyObjectMapImpl;
import com.google.template.soy.data.internal.SoyMapImpl;
import com.google.template.soy.data.internal.SoyRecordImpl;
import com.google.template.soy.data.restricted.BooleanData;
import com.google.template.soy.data.restricted.FloatData;
import com.google.template.soy.data.restricted.IntegerData;
import com.google.template.soy.data.restricted.NullData;
import com.google.template.soy.data.restricted.NumberData;
import com.google.template.soy.data.restricted.StringData;
import com.google.template.soy.jbcsrc.api.RenderResult;
import com.google.template.soy.jbcsrc.shared.CompiledTemplate;
import com.google.template.soy.jbcsrc.shared.RenderContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.function.Function;
import javax.annotation.Nullable;

public abstract class BaseSoyTemplateImpl
implements SoyTemplate {
    protected final ParamStore data;

    protected BaseSoyTemplateImpl(AbstractBuilder<?, ?> builder) {
        this.data = builder.data.freeze();
    }

    public final ImmutableMap<String, ?> getParamsAsMap() {
        return this.data.asStringMap();
    }

    @Override
    public final Object getParamsAsRecord() {
        return this.data;
    }

    public final ImmutableMap<String, Object> getRawParamsAsMap() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        this.data.forEach((key, value) -> builder.put((Object)key.getName(), SoyValueUnconverter.unconvert(value)));
        return builder.buildOrThrow();
    }

    public boolean equals(Object o) {
        return o != null && this.getClass().equals(o.getClass()) && this.data.equals(((BaseSoyTemplateImpl)o).data);
    }

    public int hashCode() {
        return this.getClass().hashCode() * 31 + this.data.hashCode();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("name", (Object)this.getTemplateName()).add("data", this.getParamsAsMap()).toString();
    }

    public static abstract class AbstractBuilderWithAccumulatorParameters<B extends AbstractBuilderWithAccumulatorParameters<?, T>, T extends SoyTemplate>
    extends AbstractBuilder<B, T> {
        private final IdentityHashMap<SoyTemplateParam<?>, List<SoyValueProvider>> accummulatorData = new IdentityHashMap();

        protected AbstractBuilderWithAccumulatorParameters(int numParams) {
            super(numParams);
        }

        @Override
        void prepareDataForBuild() {
            this.accummulatorData.forEach((k, v) -> this.setParamInternal((SoyTemplateParam<?>)k, ListImpl.forProviderList(v)));
        }

        @CanIgnoreReturnValue
        protected final B addToListParam(SoyTemplateParam<?> name, SoyValueProvider soyValue) {
            Preconditions.checkNotNull(name);
            this.accummulatorData.computeIfAbsent(name, s -> new ArrayList()).add(soyValue);
            return (B)this;
        }

        @CanIgnoreReturnValue
        protected final B initListParam(SoyTemplateParam<?> name) {
            Preconditions.checkNotNull(name);
            this.accummulatorData.computeIfAbsent(name, s -> new ArrayList());
            return (B)this;
        }
    }

    public static abstract class AbstractBuilder<B extends AbstractBuilder<?, T>, T extends SoyTemplate>
    implements SoyTemplate.Builder<T> {
        private ParamStore data;

        protected AbstractBuilder(int numParams) {
            this.data = new ParamStore(numParams);
        }

        @Override
        @CheckReturnValue
        public final T build() {
            this.prepareData(true);
            return this.buildInternal();
        }

        @Override
        public final PartialSoyTemplate buildPartial() {
            this.prepareData(false);
            return new PartialSoyTemplateImpl<T>(this.buildInternal());
        }

        @ForOverride
        protected abstract ImmutableSet<SoyTemplateParam<?>> allParams();

        @ForOverride
        protected abstract T buildInternal();

        @CanIgnoreReturnValue
        protected final B setParamInternal(SoyTemplateParam<?> name, SoyValueProvider soyValue) {
            Preconditions.checkNotNull(name);
            Preconditions.checkNotNull((Object)soyValue);
            if (this.data.isFrozen()) {
                this.data = new ParamStore(this.data, 1);
            }
            this.data.setField(name.getSymbol(), soyValue);
            return (B)this;
        }

        @CanIgnoreReturnValue
        public final <V> B setParam(SoyTemplateParam<? super V> param, V value) {
            if (!this.allParams().contains(param)) {
                throw new IllegalArgumentException("No param in " + this.getClass().getName() + " like " + String.valueOf(param));
            }
            return this.setParamInternal(param, SoyValueConverter.INSTANCE.convert(value));
        }

        @CanIgnoreReturnValue
        public final <V> B setParamFuture(SoyTemplateParam<? super V> param, ListenableFuture<V> value) {
            if (!this.allParams().contains(param)) {
                throw new IllegalArgumentException("No param in " + this.getClass().getName() + " like " + String.valueOf(param));
            }
            return this.setParamInternal(param, SoyValueConverter.INSTANCE.convert(value));
        }

        @Override
        public final boolean hasParam(SoyTemplateParam<?> param) {
            return this.allParams().contains(param);
        }

        protected static <T> SoyList asList(Iterable<T> iterable, Function<? super T, ? extends SoyValueProvider> mapper) {
            return ListImpl.forProviderList((ImmutableList<? extends SoyValueProvider>)((ImmutableList)Streams.stream(iterable).map(mapper).collect(ImmutableList.toImmutableList())));
        }

        protected static <T> SoyValue asNullableList(@Nullable Iterable<T> iterable, Function<? super T, ? extends SoyValueProvider> mapper) {
            return iterable == null ? NullData.INSTANCE : AbstractBuilder.asList(iterable, mapper);
        }

        protected static SoyProtoValue asProto(Message proto) {
            return SoyProtoValue.create(proto);
        }

        protected static SoyValue asNullableProto(@Nullable Message proto) {
            return proto == null ? NullData.INSTANCE : SoyProtoValue.create(proto);
        }

        protected static BooleanData asBool(boolean b) {
            return b ? BooleanData.TRUE : BooleanData.FALSE;
        }

        protected static SoyValue asNullableBool(@Nullable Boolean b) {
            return b == null ? NullData.INSTANCE : AbstractBuilder.asBool(b);
        }

        protected static StringData asString(String s) {
            return StringData.forValue(s);
        }

        protected static SoyValue asNullableString(@Nullable String s) {
            return s == null ? NullData.INSTANCE : AbstractBuilder.asString(s);
        }

        protected static SoyRecord asRecord(String firstKey, SoyValueProvider firstValue, Object ... more) {
            Preconditions.checkArgument((more.length % 2 == 0 ? 1 : 0) != 0);
            ParamStore map = new ParamStore(1 + more.length / 2);
            map.setField(RecordProperty.get(firstKey), firstValue);
            for (int i = 0; i < more.length; i += 2) {
                map.setField(RecordProperty.get((String)more[i]), (SoyValueProvider)more[i + 1]);
            }
            return new SoyRecordImpl(map);
        }

        protected static NumberData asNumber(Number n) {
            return n instanceof Float || n instanceof Double ? FloatData.forValue(n.doubleValue()) : IntegerData.forValue(n.longValue());
        }

        protected static SoyValue asNullableNumber(@Nullable Number n) {
            return n == null ? NullData.INSTANCE : AbstractBuilder.asNumber(n);
        }

        protected static IntegerData asInt(long n) {
            return IntegerData.forValue(n);
        }

        protected static IntegerData asBoxedInt(Number n) {
            return AbstractBuilder.asInt(n.longValue());
        }

        protected static SoyValue asNullableInt(@Nullable Number n) {
            return n == null ? NullData.INSTANCE : AbstractBuilder.asInt(n.longValue());
        }

        protected static FloatData asFloat(double n) {
            return FloatData.forValue(n);
        }

        protected static FloatData asBoxedFloat(Number n) {
            return AbstractBuilder.asFloat(n.doubleValue());
        }

        protected static SoyValue asNullableFloat(@Nullable Number n) {
            return n == null ? NullData.INSTANCE : AbstractBuilder.asFloat(n.doubleValue());
        }

        protected static IntegerData asProtoEnum(ProtocolMessageEnum protoEnum) {
            return IntegerData.forValue(protoEnum.getNumber());
        }

        protected static SoyValue asNullableProtoEnum(@Nullable ProtocolMessageEnum protoEnum) {
            return protoEnum == null ? NullData.INSTANCE : AbstractBuilder.asProtoEnum(protoEnum);
        }

        protected static <T> SoyFutureValueProvider asFuture(Future<? extends T> future, Function<? super T, SoyValueProvider> mapper) {
            return new SoyFutureValueProvider(future, mapper);
        }

        protected static SanitizedContent asHtml(SafeHtml html) {
            return SanitizedContents.fromSafeHtml(html);
        }

        protected static SoyValue asNullableHtml(@Nullable SafeHtml html) {
            return html == null ? NullData.INSTANCE : AbstractBuilder.asHtml(html);
        }

        protected static SanitizedContent asUri(SafeUrl url) {
            return SanitizedContents.fromSafeUrl(url);
        }

        protected static SoyValue asNullableUri(@Nullable SafeUrl url) {
            return url == null ? NullData.INSTANCE : AbstractBuilder.asUri(url);
        }

        protected static SanitizedContent asJs(SafeScript script) {
            return SanitizedContents.fromSafeScript(script);
        }

        protected static SoyValue asNullableJs(@Nullable SafeScript script) {
            return script == null ? NullData.INSTANCE : AbstractBuilder.asJs(script);
        }

        protected static SanitizedContent asTrustedResourceUri(TrustedResourceUrl url) {
            return SanitizedContents.fromTrustedResourceUrl(url);
        }

        protected static SoyValue asNullableTrustedResourceUri(@Nullable TrustedResourceUrl url) {
            return url == null ? NullData.INSTANCE : AbstractBuilder.asTrustedResourceUri(url);
        }

        protected static SanitizedContent asAttributes(SanitizedContent content) {
            Preconditions.checkArgument((content.getContentKind() == SanitizedContent.ContentKind.ATTRIBUTES ? 1 : 0) != 0, (String)"expected %s but got %s", (Object)((Object)SanitizedContent.ContentKind.ATTRIBUTES), (Object)((Object)content.getContentKind()));
            return content;
        }

        protected static SoyValue asNullableAttributes(@Nullable SanitizedContent content) {
            return content == null ? NullData.INSTANCE : AbstractBuilder.asAttributes(content);
        }

        protected static SanitizedContent asCss(CssParam css) {
            switch (css.type()) {
                case SAFE_STYLE: {
                    return SanitizedContents.fromSafeStyle(css.safeStyle());
                }
                case SAFE_STYLE_SHEET: {
                    return SanitizedContents.fromSafeStyleSheet(css.safeStyleSheet());
                }
            }
            throw new AssertionError();
        }

        protected static SoyValue asNullableCss(@Nullable CssParam css) {
            return css == null ? NullData.INSTANCE : AbstractBuilder.asCss(css);
        }

        protected static <K, V> SoyMap asMap(Map<K, V> map, Function<? super K, ? extends SoyValue> keyMapper, Function<? super V, ? extends SoyValueProvider> valueMapper) {
            ImmutableMap.Builder builder = ImmutableMap.builderWithExpectedSize((int)map.size());
            map.forEach((k, v) -> builder.put((Object)((SoyValue)keyMapper.apply((Object)k)), (Object)((SoyValueProvider)valueMapper.apply((Object)v))));
            return SoyMapImpl.forProviderMap((Map<? extends SoyValue, ? extends SoyValueProvider>)builder.buildOrThrow());
        }

        protected static <K, V> SoyValue asNullableMap(@Nullable Map<K, V> map, Function<? super K, ? extends SoyValue> keyMapper, Function<? super V, ? extends SoyValueProvider> valueMapper) {
            return map == null ? NullData.INSTANCE : AbstractBuilder.asMap(map, keyMapper, valueMapper);
        }

        protected static <V> SoyLegacyObjectMap asLegacyObjectMap(Map<?, V> map, Function<? super V, ? extends SoyValueProvider> valueMapper) {
            ImmutableMap.Builder builder = ImmutableMap.builderWithExpectedSize((int)map.size());
            for (Map.Entry<?, V> entry : map.entrySet()) {
                builder.put((Object)entry.getKey().toString(), (Object)valueMapper.apply(entry.getValue()));
            }
            return new SoyLegacyObjectMapImpl((ImmutableMap<String, SoyValueProvider>)builder.buildOrThrow());
        }

        protected static <V> SoyValue asNullableLegacyObjectMap(@Nullable Map<?, V> map, Function<? super V, ? extends SoyValueProvider> valueMapper) {
            return map == null ? NullData.INSTANCE : AbstractBuilder.asLegacyObjectMap(map, valueMapper);
        }

        protected static SoyValueProvider asSoyValue(@Nullable Object object) {
            return SoyValueConverter.INSTANCE.convert(object);
        }

        protected static SoyValueProvider asTemplateValue(final TemplateInterface template) {
            return TemplateValue.createFromTemplate(template, new CompiledTemplate(){

                @Override
                public RenderResult render(ParamStore params, LoggingAdvisingAppendable appendable, RenderContext context) throws IOException {
                    return context.getTemplate(template.getTemplateName()).render(ParamStore.merge(params, (ParamStore)template.getParamsAsRecord()), appendable, context);
                }
            });
        }

        @ForOverride
        void prepareDataForBuild() {
        }

        private void prepareData(boolean checkRequired) {
            List<String> missingParams;
            this.prepareDataForBuild();
            if (checkRequired && !(missingParams = this.getMissingParamNames()).isEmpty()) {
                throw new IllegalStateException("Missing required params: " + Joiner.on((String)", ").join(missingParams));
            }
        }

        private List<String> getMissingParamNames() {
            Object missing = ImmutableList.of();
            ImmutableList params = this.allParams().asList();
            for (int i = 0; i < params.size(); ++i) {
                SoyTemplateParam param = (SoyTemplateParam)params.get(i);
                if (!param.isRequired() || param.isIndirect() || this.data.containsKey(param.getSymbol())) continue;
                if (missing.isEmpty()) {
                    missing = new ArrayList();
                }
                missing.add(param.getName());
            }
            return missing;
        }

        private static class PartialSoyTemplateImpl<T extends SoyTemplate>
        implements PartialSoyTemplate {
            private final T soyTemplate;

            PartialSoyTemplateImpl(T soyTemplate) {
                this.soyTemplate = soyTemplate;
            }

            @Override
            public String getTemplateName() {
                return this.soyTemplate.getTemplateName();
            }

            public Map<String, SoyValueProvider> getParamsAsMap() {
                return this.soyTemplate.getParamsAsMap();
            }

            @Override
            public Object getParamsAsRecord() {
                return this.soyTemplate.getParamsAsRecord();
            }
        }
    }
}

