/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.css;

import com.google.common.base.CaseFormat;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.TemplateNode;
import javax.annotation.Nullable;

public class CssPrefixUtil {
    private CssPrefixUtil() {
    }

    @Nullable
    public static String getNamespacePrefix(SoyFileNode file) {
        if (file.getCssPrefix() != null) {
            return file.getCssPrefix();
        }
        if (file.getCssBaseNamespace() != null) {
            return CssPrefixUtil.toCamelCase(file.getCssBaseNamespace());
        }
        if (!file.getRequiredCssNamespaces().isEmpty()) {
            return CssPrefixUtil.toCamelCase((String)file.getRequiredCssNamespaces().get(0));
        }
        return null;
    }

    @Nullable
    public static String getTemplatePrefix(TemplateNode template, @Nullable String namespacePrefix) {
        if (template.getCssBaseNamespace() != null) {
            return CssPrefixUtil.toCamelCase(template.getCssBaseNamespace());
        }
        return namespacePrefix;
    }

    private static String toCamelCase(String packageName) {
        String packageNameWithDashes = packageName.replace('.', '-');
        return CaseFormat.LOWER_HYPHEN.to(CaseFormat.LOWER_CAMEL, packageNameWithDashes);
    }
}

