/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.conformance;

import com.google.common.collect.ImmutableSet;
import com.google.template.soy.conformance.Rule;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.soytree.HtmlAttributeNode;
import com.google.template.soy.soytree.HtmlAttributeValueNode;
import com.google.template.soy.soytree.HtmlCommentNode;
import com.google.template.soy.soytree.RawTextNode;

final class BannedRawText
extends Rule<RawTextNode> {
    private final ImmutableSet<String> bannedTexts;
    private final ImmutableSet<String> ignoredHtmlAttributes;

    BannedRawText(ImmutableSet<String> bannedRawText, ImmutableSet<String> ignoredHtmlAttributes, SoyErrorKind error) {
        super(error);
        this.bannedTexts = bannedRawText;
        this.ignoredHtmlAttributes = ignoredHtmlAttributes;
    }

    @Override
    protected void doCheckConformance(RawTextNode node, ErrorReporter errorReporter) {
        if (node.getParent() instanceof HtmlCommentNode) {
            return;
        }
        String rawText = node.getRawText();
        for (String bannedText : this.bannedTexts) {
            int indexOf = rawText.indexOf(bannedText);
            if (indexOf <= -1 || this.isIgnoredHtmlAttribute(node)) continue;
            errorReporter.report(node.substringLocation(indexOf, indexOf + bannedText.length()), this.error, new Object[0]);
        }
    }

    private boolean isIgnoredHtmlAttribute(RawTextNode node) {
        if (!(node.getParent() instanceof HtmlAttributeValueNode) || !(node.getParent().getParent() instanceof HtmlAttributeNode)) {
            return false;
        }
        HtmlAttributeNode htmlAttributeNode = (HtmlAttributeNode)node.getParent().getParent();
        for (String ignoredAttribute : this.ignoredHtmlAttributes) {
            if (!htmlAttributeNode.definitelyMatchesAttributeName(ignoredAttribute)) continue;
            return true;
        }
        return false;
    }
}

