/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.bididirectives;

import com.google.common.collect.ImmutableSet;
import com.google.template.soy.bididirectives.BidiDirectivesRuntime;
import com.google.template.soy.data.LoggingAdvisingAppendable;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.internal.i18n.BidiGlobalDir;
import com.google.template.soy.jbcsrc.restricted.Expression;
import com.google.template.soy.jbcsrc.restricted.JbcSrcPluginContext;
import com.google.template.soy.jbcsrc.restricted.MethodRef;
import com.google.template.soy.jbcsrc.restricted.SoyExpression;
import com.google.template.soy.jbcsrc.restricted.SoyJbcSrcPrintDirective;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.jssrc.restricted.SoyLibraryAssistedJsSrcPrintDirective;
import com.google.template.soy.pysrc.restricted.PyExpr;
import com.google.template.soy.pysrc.restricted.SoyPySrcPrintDirective;
import com.google.template.soy.shared.restricted.SoyJavaPrintDirective;
import com.google.template.soy.types.SanitizedType;
import com.google.template.soy.types.StringType;
import com.google.template.soy.types.UnionType;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;

final class BidiUnicodeWrapDirective
implements SoyJavaPrintDirective,
SoyLibraryAssistedJsSrcPrintDirective,
SoyPySrcPrintDirective,
SoyJbcSrcPrintDirective.Streamable {
    private final Supplier<BidiGlobalDir> bidiGlobalDirProvider;

    BidiUnicodeWrapDirective(Supplier<BidiGlobalDir> bidiGlobalDirProvider) {
        this.bidiGlobalDirProvider = bidiGlobalDirProvider;
    }

    @Override
    public String getName() {
        return "|bidiUnicodeWrap";
    }

    @Override
    public Set<Integer> getValidArgsSizes() {
        return ImmutableSet.of((Object)0);
    }

    @Override
    public SoyValue applyForJava(SoyValue value, List<SoyValue> args) {
        return BidiDirectivesRuntime.bidiUnicodeWrap(this.bidiGlobalDirProvider.get(), value);
    }

    @Override
    public SoyExpression applyForJbcSrc(JbcSrcPluginContext context, SoyExpression value, List<SoyExpression> args) {
        return SoyExpression.forSoyValue(UnionType.of(StringType.getInstance(), SanitizedType.HtmlType.getInstance()), JbcSrcMethods.BIDI_UNICODE_WRAP.invoke(context.getBidiGlobalDir(), value.box()));
    }

    @Override
    public SoyJbcSrcPrintDirective.Streamable.AppendableAndOptions applyForJbcSrcStreaming(JbcSrcPluginContext context, Expression delegateAppendable, List<SoyExpression> args) {
        return SoyJbcSrcPrintDirective.Streamable.AppendableAndOptions.createCloseable(JbcSrcMethods.BIDI_UNICODE_WRAP_STREAMING.invoke(delegateAppendable, context.getBidiGlobalDir()));
    }

    @Override
    public JsExpr applyForJsSrc(JsExpr value, List<JsExpr> args) {
        String codeSnippet = this.bidiGlobalDirProvider.get().getCodeSnippet();
        return new JsExpr("soy.$$bidiUnicodeWrap(" + codeSnippet + ", " + value.getText() + ")", Integer.MAX_VALUE);
    }

    @Override
    public ImmutableSet<String> getRequiredJsLibNames() {
        return ImmutableSet.of((Object)"soy");
    }

    @Override
    public PyExpr applyForPySrc(PyExpr value, List<PyExpr> args) {
        String codeSnippet = this.bidiGlobalDirProvider.get().getCodeSnippet();
        return new PyExpr("bidi.unicode_wrap(" + codeSnippet + ", " + value.getText() + ")", Integer.MAX_VALUE);
    }

    private static final class JbcSrcMethods {
        static final MethodRef BIDI_UNICODE_WRAP = MethodRef.createPure(BidiDirectivesRuntime.class, "bidiUnicodeWrap", BidiGlobalDir.class, SoyValue.class);
        static final MethodRef BIDI_UNICODE_WRAP_STREAMING = MethodRef.createNonPure(BidiDirectivesRuntime.class, "bidiUnicodeWrapStreaming", LoggingAdvisingAppendable.class, BidiGlobalDir.class);

        private JbcSrcMethods() {
        }
    }
}

