/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.basicfunctions;

import com.google.template.soy.basicfunctions.BasicFunctionsRuntime;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.restricted.NumberData;
import com.google.template.soy.plugin.java.restricted.JavaPluginContext;
import com.google.template.soy.plugin.java.restricted.JavaValue;
import com.google.template.soy.plugin.java.restricted.JavaValueFactory;
import com.google.template.soy.plugin.java.restricted.SoyJavaSourceFunction;
import com.google.template.soy.plugin.javascript.restricted.JavaScriptPluginContext;
import com.google.template.soy.plugin.javascript.restricted.JavaScriptValue;
import com.google.template.soy.plugin.javascript.restricted.JavaScriptValueFactory;
import com.google.template.soy.plugin.javascript.restricted.SoyJavaScriptSourceFunction;
import com.google.template.soy.plugin.python.restricted.PythonPluginContext;
import com.google.template.soy.plugin.python.restricted.PythonValue;
import com.google.template.soy.plugin.python.restricted.PythonValueFactory;
import com.google.template.soy.plugin.python.restricted.SoyPythonSourceFunction;
import com.google.template.soy.shared.restricted.Signature;
import com.google.template.soy.shared.restricted.SoyMethodSignature;
import com.google.template.soy.shared.restricted.SoyPureFunction;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

@SoyMethodSignature(name="indexOf", baseType="string", value={@Signature(parameterTypes={"string"}, returnType="int"), @Signature(parameterTypes={"string", "number"}, returnType="int")})
@SoyPureFunction
public final class StrIndexOfFunction
implements SoyJavaSourceFunction,
SoyJavaScriptSourceFunction,
SoyPythonSourceFunction {
    @Override
    public JavaScriptValue applyForJavaScriptSource(JavaScriptValueFactory factory, List<JavaScriptValue> args, JavaScriptPluginContext context) {
        ArrayList<JavaScriptValue> transformedArgs = new ArrayList<JavaScriptValue>();
        transformedArgs.add(args.get(1));
        if (args.size() == 3) {
            transformedArgs.add(args.get(2));
        }
        return args.get(0).invokeMethod("indexOf", transformedArgs);
    }

    @Override
    public PythonValue applyForPythonSource(PythonValueFactory factory, List<PythonValue> args, PythonPluginContext context) {
        ArrayList<PythonValue> transformedArgs = new ArrayList<PythonValue>();
        transformedArgs.add(args.get(0).coerceToString());
        transformedArgs.add(args.get(1).coerceToString());
        if (args.size() == 3) {
            transformedArgs.add(args.get(2));
        }
        return factory.global("runtime.str_indexof").call(transformedArgs);
    }

    @Override
    public JavaValue applyForJavaSource(JavaValueFactory factory, List<JavaValue> args, JavaPluginContext context) {
        return factory.callStaticMethod(Methods.INDEX_OF, args.get(0), args.get(1), args.size() == 3 ? args.get(2) : factory.constant(0L));
    }

    private static final class Methods {
        static final Method INDEX_OF = JavaValueFactory.createMethod(BasicFunctionsRuntime.class, "strIndexOf", SoyValue.class, SoyValue.class, NumberData.class);

        private Methods() {
        }
    }
}

