/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.basicfunctions;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Longs;
import com.google.protobuf.Message;
import com.google.template.soy.data.RecordProperty;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SoyDict;
import com.google.template.soy.data.SoyLegacyObjectMap;
import com.google.template.soy.data.SoyList;
import com.google.template.soy.data.SoyMap;
import com.google.template.soy.data.SoyMaps;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.SoyValueProvider;
import com.google.template.soy.data.SoyVisualElement;
import com.google.template.soy.data.UnsafeSanitizedContentOrdainer;
import com.google.template.soy.data.internal.DictImpl;
import com.google.template.soy.data.internal.ParamStore;
import com.google.template.soy.data.internal.RuntimeMapTypeTracker;
import com.google.template.soy.data.internal.SoyMapImpl;
import com.google.template.soy.data.internal.SoyRecordImpl;
import com.google.template.soy.data.restricted.FloatData;
import com.google.template.soy.data.restricted.IntegerData;
import com.google.template.soy.data.restricted.NumberData;
import com.google.template.soy.data.restricted.StringData;
import com.google.template.soy.shared.internal.Sanitizers;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class BasicFunctionsRuntime {
    private static final Pattern CSS_NAME_REGEX = Pattern.compile("^\\s*[\\w-]+\\s*$");

    private BasicFunctionsRuntime() {
    }

    public static boolean veHasSameId(SoyVisualElement ve1, SoyVisualElement ve2) {
        return ve1.hasSameId(ve2);
    }

    public static long ceil(SoyValue arg) {
        if (arg instanceof IntegerData) {
            return arg.longValue();
        }
        return (long)Math.ceil(arg.floatValue());
    }

    @Nonnull
    public static ImmutableList<SoyValueProvider> concatLists(List<SoyList> args) {
        ImmutableList.Builder flattened = ImmutableList.builder();
        for (SoyList soyList : args) {
            flattened.addAll(soyList.asJavaList());
        }
        return flattened.build();
    }

    @Nonnull
    public static SoyMap concatMaps(SoyMap map, SoyMap mapTwo) {
        LinkedHashMap<SoyValue, SoyValueProvider> mapBuilder = new LinkedHashMap<SoyValue, SoyValueProvider>();
        mapBuilder.putAll(map.asJavaMap());
        mapBuilder.putAll(mapTwo.asJavaMap());
        return SoyMapImpl.forProviderMap(mapBuilder);
    }

    public static boolean listContains(List<? extends SoyValueProvider> list, SoyValue value) {
        for (SoyValueProvider soyValueProvider : list) {
            if (!soyValueProvider.resolve().equals(value)) continue;
            return true;
        }
        return false;
    }

    public static int listIndexOf(List<? extends SoyValueProvider> list, SoyValue value, NumberData startIndex) {
        int clampedStartIndex = BasicFunctionsRuntime.clampListIndex(list, startIndex);
        if (clampedStartIndex >= list.size()) {
            return -1;
        }
        int indexInSubList = list.subList(clampedStartIndex, list.size()).indexOf(value);
        return indexInSubList == -1 ? -1 : indexInSubList + clampedStartIndex;
    }

    @Nonnull
    public static String join(List<? extends SoyValueProvider> list, String separator) {
        return list.stream().map(v -> v.resolve().coerceToString()).collect(Collectors.joining(separator));
    }

    @Nonnull
    public static String concatAttributeValues(SoyValue l, SoyValue r, String delimiter) {
        boolean rnull;
        boolean lnull = l == null || l.isNullish();
        boolean bl = rnull = r == null || r.isNullish();
        if (lnull && rnull) {
            return "";
        }
        if (lnull) {
            return r.coerceToString();
        }
        if (rnull) {
            return l.coerceToString();
        }
        String lValue = l.stringValue();
        String rValue = r.stringValue();
        if (lValue.isEmpty()) {
            return rValue;
        }
        if (rValue.isEmpty()) {
            return lValue;
        }
        return lValue + delimiter + rValue;
    }

    @Nonnull
    public static SanitizedContent concatCssValues(SoyValue l, SoyValue r) {
        return UnsafeSanitizedContentOrdainer.ordainAsSafe(BasicFunctionsRuntime.concatAttributeValues(l, r, ";"), SanitizedContent.ContentKind.CSS);
    }

    @Nonnull
    public static ImmutableList<? extends SoyValueProvider> listSlice(List<? extends SoyValueProvider> list, NumberData from, NumberData optionalTo) {
        int length = list.size();
        int intFrom = BasicFunctionsRuntime.clampListIndex(list, from);
        if (optionalTo == null) {
            return ImmutableList.copyOf(list.subList(intFrom, length));
        }
        int to = BasicFunctionsRuntime.clampListIndex(list, optionalTo);
        if (to < intFrom) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf(list.subList(intFrom, to));
    }

    @Nonnull
    public static ImmutableList<? extends SoyValueProvider> listReverse(List<? extends SoyValueProvider> list) {
        return ImmutableList.copyOf(list).reverse();
    }

    @Nonnull
    public static ImmutableList<? extends SoyValueProvider> listUniq(List<? extends SoyValueProvider> list) {
        return (ImmutableList)list.stream().distinct().collect(ImmutableList.toImmutableList());
    }

    @Nonnull
    public static ImmutableList<? extends SoyValueProvider> listFlat(List<? extends SoyValueProvider> list) {
        return BasicFunctionsRuntime.listFlatImpl(list, 1);
    }

    @Nonnull
    public static ImmutableList<? extends SoyValueProvider> listFlat(List<? extends SoyValueProvider> list, IntegerData data) {
        return BasicFunctionsRuntime.listFlatImpl(list, (int)data.getValue());
    }

    @Nonnull
    private static ImmutableList<? extends SoyValueProvider> listFlatImpl(List<? extends SoyValueProvider> list, int maxDepth) {
        ImmutableList.Builder builder = ImmutableList.builder();
        BasicFunctionsRuntime.listFlatImpl(list, (ImmutableList.Builder<SoyValueProvider>)builder, maxDepth);
        return builder.build();
    }

    private static void listFlatImpl(List<? extends SoyValueProvider> list, ImmutableList.Builder<SoyValueProvider> builder, int maxDepth) {
        for (SoyValueProvider soyValueProvider : list) {
            if (maxDepth > 0 && soyValueProvider.resolve() instanceof SoyList) {
                BasicFunctionsRuntime.listFlatImpl(((SoyList)soyValueProvider.resolve()).asResolvedJavaList(), builder, maxDepth - 1);
                continue;
            }
            builder.add((Object)soyValueProvider);
        }
    }

    @Nonnull
    public static ImmutableList<SoyValueProvider> numberListSort(List<? extends SoyValueProvider> list) {
        return ImmutableList.sortedCopyOf(Comparator.comparingDouble(arg -> arg.resolve().numberValue()), list);
    }

    @Nonnull
    public static ImmutableList<SoyValueProvider> stringListSort(List<? extends SoyValueProvider> list) {
        return ImmutableList.sortedCopyOf(Comparator.comparing(arg -> arg.resolve().stringValue()), list);
    }

    public static long floor(SoyValue arg) {
        if (arg instanceof IntegerData) {
            return arg.longValue();
        }
        return (long)Math.floor(arg.floatValue());
    }

    @Nonnull
    public static List<SoyValue> keys(SoyValue sv) {
        SoyLegacyObjectMap map = (SoyLegacyObjectMap)sv;
        ArrayList<SoyValue> list = new ArrayList<SoyValue>(map.getItemCnt());
        Iterables.addAll(list, map.getItemKeys());
        return list;
    }

    @Nonnull
    public static ImmutableList<SoyValue> mapKeys(SoyMap map) {
        return ImmutableList.copyOf(map.keys());
    }

    @Nonnull
    public static ImmutableList<SoyValueProvider> mapValues(SoyMap map) {
        return ImmutableList.copyOf(map.values());
    }

    @Nonnull
    public static ImmutableList<SoyValueProvider> mapEntries(SoyMap map) {
        return (ImmutableList)map.entrySet().stream().map(e -> new SoyRecordImpl(new ParamStore(2).setField(RecordProperty.KEY, (SoyValueProvider)e.getKey()).setField(RecordProperty.VALUE, (SoyValueProvider)e.getValue()))).collect(ImmutableList.toImmutableList());
    }

    public static int mapSize(SoyMap map) {
        return map.size();
    }

    @Nonnull
    public static SoyDict mapToLegacyObjectMap(SoyMap map) {
        HashMap<String, SoyValueProvider> keysCoercedToStrings = new HashMap<String, SoyValueProvider>();
        for (Map.Entry<? extends SoyValue, ? extends SoyValueProvider> entry : map.asJavaMap().entrySet()) {
            keysCoercedToStrings.put(entry.getKey().coerceToString(), entry.getValue());
        }
        return DictImpl.forProviderMap(keysCoercedToStrings, RuntimeMapTypeTracker.Type.LEGACY_OBJECT_MAP_OR_RECORD);
    }

    public static NumberData max(SoyValue arg0, SoyValue arg1) {
        if (arg0 instanceof IntegerData && arg1 instanceof IntegerData) {
            return IntegerData.forValue(Math.max(arg0.longValue(), arg1.longValue()));
        }
        return FloatData.forValue(Math.max(arg0.numberValue(), arg1.numberValue()));
    }

    public static NumberData min(SoyValue arg0, SoyValue arg1) {
        if (arg0 instanceof IntegerData && arg1 instanceof IntegerData) {
            return IntegerData.forValue(Math.min(arg0.longValue(), arg1.longValue()));
        }
        return FloatData.forValue(Math.min(arg0.numberValue(), arg1.numberValue()));
    }

    @Nullable
    public static FloatData parseFloat(String str) {
        Double d = Doubles.tryParse((String)str);
        return d == null || d.isNaN() ? null : FloatData.forValue(d);
    }

    @Nullable
    public static IntegerData parseInt(String str, int radix) {
        if (radix < 2 || radix > 36) {
            return null;
        }
        Long l = Longs.tryParse((String)str, (int)radix);
        return l == null ? null : IntegerData.forValue(l);
    }

    public static long randomInt(double number) {
        return (long)Math.floor(Math.random() * number);
    }

    @Nonnull
    public static NumberData round(SoyValue value, int numDigitsAfterPoint) {
        if (numDigitsAfterPoint == 0) {
            return IntegerData.forValue(BasicFunctionsRuntime.round(value));
        }
        if (numDigitsAfterPoint > 0) {
            double valueDouble = value.numberValue();
            double shift = Math.pow(10.0, numDigitsAfterPoint);
            return FloatData.forValue((double)Math.round(valueDouble * shift) / shift);
        }
        double valueDouble = value.numberValue();
        double shift = Math.pow(10.0, -numDigitsAfterPoint);
        return IntegerData.forValue((int)((double)Math.round(valueDouble / shift) * shift));
    }

    public static long round(SoyValue value) {
        if (value instanceof IntegerData) {
            return value.longValue();
        }
        return Math.round(value.numberValue());
    }

    @Nonnull
    public static ImmutableList<IntegerData> range(int start, int end, int step) {
        if (step == 0) {
            throw new IllegalArgumentException(String.format("step must be non-zero: %d", step));
        }
        int length = end - start;
        if ((length ^ step) < 0) {
            return ImmutableList.of();
        }
        int size = length / step + (length % step == 0 ? 0 : 1);
        ImmutableList.Builder list = ImmutableList.builderWithExpectedSize((int)size);
        if (step > 0) {
            for (int i = start; i < end; i += step) {
                list.add((Object)IntegerData.forValue(i));
            }
        } else {
            for (int i = start; i > end; i += step) {
                list.add((Object)IntegerData.forValue(i));
            }
        }
        return list.build();
    }

    public static boolean strContainsFromIndex(String left, String right, NumberData index) {
        int clampedStart = BasicFunctionsRuntime.clampStrIndex(left, index);
        return left.substring(clampedStart).contains(right);
    }

    public static boolean strContains(SoyValue left, String right) {
        return left.stringValue().contains(right);
    }

    public static int strIndexOf(SoyValue str, SoyValue searchStr, NumberData start) {
        String strValue = str.stringValue();
        int clampedStart = BasicFunctionsRuntime.clampStrIndex(strValue, start);
        return strValue.indexOf(searchStr.stringValue(), clampedStart);
    }

    public static int strLen(SoyValue str) {
        return str.stringValue().length();
    }

    public static String strSub(SoyValue str, NumberData start) {
        String string = str.stringValue();
        return string.substring(BasicFunctionsRuntime.clampStrIndex(string, start));
    }

    public static String strSub(SoyValue str, NumberData start, NumberData end) {
        if (start.numberValue() > end.numberValue()) {
            return BasicFunctionsRuntime.strSub(str, end, start);
        }
        String string = str.stringValue();
        return string.substring(BasicFunctionsRuntime.clampStrIndex(string, start), BasicFunctionsRuntime.clampStrIndex(string, end));
    }

    public static boolean strStartsWith(String str, String arg, NumberData start) {
        int clampedStart = BasicFunctionsRuntime.clampStrIndex(str, start);
        if (clampedStart + arg.length() > str.length()) {
            return false;
        }
        return str.substring(clampedStart).startsWith(arg);
    }

    public static boolean strEndsWith(String str, String arg, NumberData length) {
        if (length == null) {
            return str.endsWith(arg);
        }
        int clampedLength = BasicFunctionsRuntime.clampStrIndex(str, length);
        if (clampedLength - arg.length() < 0) {
            return false;
        }
        return str.substring(0, clampedLength).endsWith(arg);
    }

    @Nonnull
    public static ImmutableList<StringData> strSplit(String str, String sep, NumberData limit) {
        ImmutableList.Builder builder = ImmutableList.builder();
        int truncLimit = -1;
        if (limit != null) {
            truncLimit = (int)limit.numberValue();
        }
        if (truncLimit == 0) {
            return builder.build();
        }
        int count = 0;
        for (String string : (sep.isEmpty() ? Splitter.fixedLength((int)1) : Splitter.on((String)sep)).split((CharSequence)str)) {
            if (count == truncLimit) {
                return builder.build();
            }
            builder.add((Object)StringData.forValue(string));
            ++count;
        }
        return builder.build();
    }

    @Nonnull
    public static String strReplaceAll(String str, String match, String token) {
        return str.replace(match, token);
    }

    @Nonnull
    public static String strTrim(String str) {
        return str.trim();
    }

    public static int length(List<?> list) {
        return list.size();
    }

    @Nonnull
    public static SoyMap legacyObjectMapToMap(SoyValue value) {
        return SoyMaps.legacyObjectMapToMap((SoyLegacyObjectMap)value);
    }

    public static boolean isDefault(Message proto) {
        return proto.equals((Object)proto.getDefaultInstanceForType());
    }

    public static boolean protoEquals(Message proto1, Message proto2) {
        return proto1.equals((Object)proto2);
    }

    private static int clampListIndex(List<?> list, NumberData index) {
        int truncIndex = (int)index.numberValue();
        int size = list.size();
        int clampLowerBound = Math.max(0, truncIndex >= 0 ? truncIndex : size + truncIndex);
        return Math.min(size, clampLowerBound);
    }

    private static int clampStrIndex(String str, NumberData position) {
        int clampLowerBound = Math.max(0, (int)position.numberValue());
        return Math.min(str.length(), clampLowerBound);
    }

    public static boolean isFinite(SoyValue arg) {
        return arg instanceof NumberData && Double.isFinite(arg.numberValue());
    }

    private static String joinHelper(List<SoyValue> values, String delimiter) {
        return values.stream().filter(v -> v != null).filter(SoyValue::coerceToBoolean).map(SoyValue::coerceToString).collect(Collectors.joining(delimiter));
    }

    @Nonnull
    public static String buildAttrValue(List<SoyValue> values) {
        return BasicFunctionsRuntime.joinHelper(values, ";");
    }

    @Nonnull
    public static String buildClassValue(List<SoyValue> values) {
        return BasicFunctionsRuntime.joinHelper(values, " ");
    }

    @Nonnull
    public static SanitizedContent buildStyleValue(List<SoyValue> values) {
        return UnsafeSanitizedContentOrdainer.ordainAsSafe(values.stream().filter(v -> v != null).filter(SoyValue::coerceToBoolean).map(v -> {
            String name;
            String str;
            if (v instanceof StringData && (str = v.coerceToString()).indexOf(58) != -1 && CSS_NAME_REGEX.matcher(name = str.substring(0, str.indexOf(58))).matches()) {
                String value = str.substring(str.indexOf(58) + 1);
                return String.format("%s:%s", name.trim(), Sanitizers.filterCssValue(value.trim().replaceAll(";$", "")));
            }
            return Sanitizers.filterCssValue(v);
        }).collect(Collectors.joining(";")), SanitizedContent.ContentKind.CSS);
    }

    @Nonnull
    public static SanitizedContent buildAttr(String attrName, List<SoyValue> values) {
        String attrValue = attrName.equals("class") ? BasicFunctionsRuntime.buildClassValue(values) : BasicFunctionsRuntime.buildAttrValue(values);
        return UnsafeSanitizedContentOrdainer.ordainAsSafe(attrValue.isEmpty() ? "" : String.format("%s=\"%s\"", attrName, attrValue), SanitizedContent.ContentKind.ATTRIBUTES);
    }
}

