/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.basetree;

import com.google.common.base.Preconditions;
import com.google.template.soy.basetree.Copyable;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.annotation.Nullable;

public final class CopyState {
    private final IdentityHashMap<Object, Object> mappings = new IdentityHashMap();

    public <T> void updateRefs(T oldObject, T newObject) {
        Preconditions.checkNotNull(oldObject);
        Preconditions.checkNotNull(newObject);
        Preconditions.checkArgument((!(newObject instanceof Listener) ? 1 : 0) != 0);
        Object previousMapping = this.mappings.put(oldObject, newObject);
        if (previousMapping != null) {
            if (previousMapping instanceof Listener) {
                Listener listener = (Listener)previousMapping;
                listener.newVersion(newObject);
            } else {
                throw new IllegalStateException("found multiple remappings for " + String.valueOf(oldObject));
            }
        }
    }

    public <T> void registerRefListener(T oldObject, Listener<T> listener) {
        Preconditions.checkNotNull(oldObject);
        Preconditions.checkNotNull(listener);
        Object oldMapping = this.mappings.get(oldObject);
        if (oldMapping == null) {
            this.mappings.put(oldObject, listener);
        } else if (oldMapping instanceof Listener) {
            Listener oldListener = (Listener)oldMapping;
            this.mappings.put(oldObject, CopyState.chainListeners(listener, oldListener));
        } else {
            Object typedValue = oldMapping;
            listener.newVersion(typedValue);
        }
    }

    public void checkAllListenersFired() {
        boolean any = false;
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Object, Object> entry : this.mappings.entrySet()) {
            if (!(entry.getValue() instanceof Listener)) continue;
            if (any) {
                sb.append("\n");
            }
            sb.append("Listener for ").append(entry.getKey()).append(" never fired: ").append(entry.getValue());
            any = true;
        }
        if (any) {
            throw new IllegalStateException(sb.toString());
        }
    }

    private static <T> Listener<T> chainListeners(Listener<T> listener, Listener<T> oldListener) {
        return newObject -> {
            listener.newVersion(newObject);
            oldListener.newVersion(newObject);
        };
    }

    @Nullable
    public <T extends Copyable<?>> T copyNullable(@Nullable T node) {
        if (node == null) {
            return null;
        }
        Copyable copy = (Copyable)node.copy(this);
        return (T)copy;
    }

    public static interface Listener<T> {
        public void newVersion(T var1);
    }
}

