/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.base.internal;

import com.google.auto.value.AutoValue;
import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.template.soy.base.internal.AutoValue_UniqueNameGenerator_Pair;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public final class UniqueNameGenerator {
    private static final Pattern ENDING_DIGITS = Pattern.compile("\\D([1-9]\\d{0,3})$");
    private final ImmutableSet<String> reserved;
    private final Set<String> used;
    private final Map<String, Integer> baseToMaxIndex;
    private final CharMatcher bannedCharacters;
    private final String collisionSeparator;

    public UniqueNameGenerator(CharMatcher bannedCharacters, String collisionSeparator) {
        this(bannedCharacters, collisionSeparator, (Set<String>)ImmutableSet.of());
    }

    public UniqueNameGenerator(CharMatcher bannedCharacters, String collisionSeparator, Set<String> reserved) {
        Preconditions.checkArgument((boolean)bannedCharacters.matchesNoneOf((CharSequence)collisionSeparator), (String)"separator %s contains banned characters", (Object)collisionSeparator);
        this.reserved = ImmutableSet.copyOf(reserved);
        this.used = new HashSet<String>();
        this.baseToMaxIndex = new HashMap<String, Integer>();
        this.bannedCharacters = bannedCharacters;
        this.collisionSeparator = collisionSeparator;
    }

    public UniqueNameGenerator branch() {
        UniqueNameGenerator copy = new UniqueNameGenerator(this.bannedCharacters, this.collisionSeparator, (Set<String>)this.reserved);
        this.used.forEach(copy::exact);
        return copy;
    }

    public void exact(String name) {
        String unused = this.generate(name, true, false);
    }

    public void exactLenient(String name) {
        String unused = this.generate(name, true, true);
    }

    public String generate(String name) {
        return this.generate(name, false, false);
    }

    private String generate(String name, boolean exact, boolean lenient) {
        boolean isReserved;
        this.checkName((String)name);
        Pair parts = this.split((String)name);
        boolean isUsed = this.used.contains(name);
        boolean bl = isReserved = !isUsed && this.reserved.contains(name);
        if (isUsed || isReserved) {
            if (exact) {
                if (lenient) {
                    return name;
                }
                if (isReserved) {
                    throw new IllegalArgumentException("Tried to claim a reserved name: " + (String)name);
                }
                throw new IllegalArgumentException("Name: " + (String)name + " was already claimed!");
            }
            int index = this.baseToMaxIndex.compute(parts.base(), (key, oldValue) -> oldValue == null ? 1 : oldValue + 1);
            name = parts.base() + this.collisionSeparator + index;
        } else if (parts.index() != null) {
            this.baseToMaxIndex.compute(parts.base(), (key, oldValue) -> Math.max(oldValue != null ? oldValue : 0, parts.index()));
        }
        Preconditions.checkArgument((boolean)this.used.add((String)name));
        return name;
    }

    public boolean has(String name) {
        return this.used.contains(name);
    }

    private void checkName(String name) {
        Preconditions.checkArgument((!name.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkArgument((!this.bannedCharacters.matchesAnyOf((CharSequence)name) ? 1 : 0) != 0, (String)"%s contains dangerous characters!", (Object)name);
    }

    private Pair split(String name) {
        Matcher m = ENDING_DIGITS.matcher(name);
        if (m.find()) {
            String intString = m.group(1);
            String rest = name.substring(0, name.length() - intString.length());
            if (!rest.isEmpty() && rest.endsWith(this.collisionSeparator)) {
                return Pair.of(rest.substring(0, rest.length() - this.collisionSeparator.length()), Integer.parseInt(intString));
            }
        }
        return Pair.of(name, null);
    }

    @AutoValue
    static abstract class Pair {
        Pair() {
        }

        static Pair of(String base, Integer index) {
            return new AutoValue_UniqueNameGenerator_Pair(base, index);
        }

        abstract String base();

        @Nullable
        abstract Integer index();
    }
}

