/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.base.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.template.soy.base.internal.SanitizedContentKind;
import com.google.template.soy.error.SoyErrorKind;
import java.util.Optional;

public abstract class TemplateContentKind {
    public static final SoyErrorKind INVALID_ATTRIBUTE_VALUE = SoyErrorKind.of("Invalid value for template attribute ''kind'', expected one of " + String.valueOf(ImmutableSortedSet.naturalOrder().addAll((Iterable)BasicTemplateContentKind.KINDS_BY_ATTR_VALUE.keySet()).add((Object)"html<...>").build()) + ".", new SoyErrorKind.StyleAllowance[0]);
    public static final TemplateContentKind DEFAULT = (TemplateContentKind)BasicTemplateContentKind.KINDS_BY_ATTR_VALUE.get((Object)SanitizedContentKind.HTML.asAttributeValue());

    public static Optional<TemplateContentKind> fromAttributeValue(String attrValue) {
        Preconditions.checkNotNull((Object)attrValue);
        if (attrValue.startsWith("html<") && attrValue.endsWith(">")) {
            return Optional.of(ElementContentKind.valueOf(attrValue.substring(5, attrValue.length() - 1)));
        }
        if (BasicTemplateContentKind.KINDS_BY_ATTR_VALUE.containsKey((Object)attrValue)) {
            return Optional.of((TemplateContentKind)BasicTemplateContentKind.KINDS_BY_ATTR_VALUE.get((Object)attrValue));
        }
        return Optional.empty();
    }

    public static TemplateContentKind fromSanitizedContentKind(SanitizedContentKind sanitizedContentKind) {
        Preconditions.checkNotNull((Object)((Object)sanitizedContentKind));
        return (TemplateContentKind)BasicTemplateContentKind.KINDS_BY_KIND.get((Object)sanitizedContentKind);
    }

    public boolean isAssignableFrom(TemplateContentKind src) {
        return this.getSanitizedContentKind().isAssignableFrom(src.getSanitizedContentKind());
    }

    public abstract String asAttributeValue();

    public abstract SanitizedContentKind getSanitizedContentKind();

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public abstract String toString();

    public static class ElementContentKind
    extends TemplateContentKind {
        private static final String WILDCARD_CHAR = "?";
        public static final ElementContentKind WILDCARD = new ElementContentKind("");
        private final String tagName;

        public static ElementContentKind valueOf(String tag) {
            if (WILDCARD_CHAR.equals(tag) || tag.isEmpty()) {
                return WILDCARD;
            }
            return new ElementContentKind(tag);
        }

        private ElementContentKind(String tagName) {
            this.tagName = tagName;
        }

        public String getTagName() {
            return this.tagName;
        }

        @Override
        public String asAttributeValue() {
            return "html<" + (this.tagName.isEmpty() ? WILDCARD_CHAR : this.tagName) + ">";
        }

        @Override
        public SanitizedContentKind getSanitizedContentKind() {
            return SanitizedContentKind.HTML_ELEMENT;
        }

        @Override
        public boolean isAssignableFrom(TemplateContentKind src) {
            if (!super.isAssignableFrom(src) || !(src instanceof ElementContentKind)) {
                return false;
            }
            return this.tagName.isEmpty() || this.tagName.equals(((ElementContentKind)src).tagName);
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof ElementContentKind)) {
                return false;
            }
            ElementContentKind other = (ElementContentKind)o;
            return this.tagName.equals(other.tagName);
        }

        @Override
        public int hashCode() {
            return this.tagName.hashCode();
        }

        @Override
        public String toString() {
            return this.asAttributeValue();
        }
    }

    public static class BasicTemplateContentKind
    extends TemplateContentKind {
        private static final ImmutableMap<SanitizedContentKind, TemplateContentKind> KINDS_BY_KIND;
        private static final ImmutableMap<String, TemplateContentKind> KINDS_BY_ATTR_VALUE;
        private final SanitizedContentKind sanitizedContentKind;

        private BasicTemplateContentKind(SanitizedContentKind kind) {
            this.sanitizedContentKind = (SanitizedContentKind)((Object)Preconditions.checkNotNull((Object)((Object)kind)));
        }

        @Override
        public String asAttributeValue() {
            return this.sanitizedContentKind.asAttributeValue();
        }

        @Override
        public SanitizedContentKind getSanitizedContentKind() {
            return this.sanitizedContentKind;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof BasicTemplateContentKind)) {
                return false;
            }
            BasicTemplateContentKind other = (BasicTemplateContentKind)o;
            return this.sanitizedContentKind == other.sanitizedContentKind;
        }

        @Override
        public int hashCode() {
            return this.sanitizedContentKind.hashCode();
        }

        @Override
        public String toString() {
            return this.sanitizedContentKind.toString();
        }

        static {
            ImmutableMap.Builder kindsByKind = new ImmutableMap.Builder();
            ImmutableMap.Builder kindsByAttributeValue = new ImmutableMap.Builder();
            for (SanitizedContentKind kind : SanitizedContentKind.values()) {
                if (kind == SanitizedContentKind.HTML_ELEMENT) continue;
                BasicTemplateContentKind contentKind = new BasicTemplateContentKind(kind);
                kindsByKind.put((Object)kind, (Object)contentKind);
                kindsByAttributeValue.put((Object)kind.asAttributeValue(), (Object)contentKind);
            }
            KINDS_BY_KIND = kindsByKind.build();
            KINDS_BY_ATTR_VALUE = kindsByAttributeValue.build();
        }
    }
}

