/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.base.internal;

import com.google.common.io.CharSource;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import com.google.template.soy.base.SourceFilePath;
import com.google.template.soy.base.internal.StableSoyFileSupplier;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public interface SoyFileSupplier {
    default public CharSource asCharSource() {
        return new CharSource(){

            public Reader openStream() throws IOException {
                return SoyFileSupplier.this.open();
            }
        };
    }

    public Reader open() throws IOException;

    public SourceFilePath getFilePath();

    public Version getVersion();

    public static final class Factory {
        public static SoyFileSupplier create(CharSource contentSource, SourceFilePath filePath) {
            return new StableSoyFileSupplier(contentSource, filePath);
        }

        public static SoyFileSupplier create(File inputFile) {
            return Factory.create(Files.asCharSource((File)inputFile, (Charset)StandardCharsets.UTF_8), SourceFilePath.create(inputFile.getPath(), inputFile.getPath()));
        }

        public static SoyFileSupplier create(URL inputFileUrl, SourceFilePath filePath) {
            return Factory.create(Resources.asCharSource((URL)inputFileUrl, (Charset)StandardCharsets.UTF_8), filePath);
        }

        public static SoyFileSupplier create(CharSequence content, SourceFilePath filePath) {
            return Factory.create(CharSource.wrap((CharSequence)content), filePath);
        }

        private Factory() {
        }
    }

    public static interface Version {
        public static final Version STABLE_VERSION = new Version(){};

        public boolean equals(Object var1);
    }
}

