/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.base.internal;

import java.util.Optional;

public final class SetOnce<T> {
    private Optional<T> value = Optional.empty();

    public void set(T newValue) {
        if (!this.value.isEmpty()) {
            throw new IllegalStateException("SetOnce object can be only set once. Existing value: " + String.valueOf(this.value.get()) + ". Attempting to set with: " + String.valueOf(newValue));
        }
        this.value = Optional.of(newValue);
    }

    public SetOnce<T> copy() {
        SetOnce<T> copy = new SetOnce<T>();
        if (this.value.isPresent()) {
            copy.set(this.value.get());
        }
        return copy;
    }

    public T get() {
        return this.value.orElseThrow(() -> new IllegalStateException("SetOnce object has not been set yet."));
    }

    public boolean isPresent() {
        return this.value.isPresent();
    }
}

