/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.base.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Utf8;
import com.google.errorprone.annotations.CanIgnoreReturnValue;

public class IndentedLinesBuilder
implements CharSequence {
    private static final String SPACES = "                        ";
    private static final int MAX_INDENT_LEN = 24;
    private final StringBuilder sb = new StringBuilder();
    private final int indentIncrementLen;
    private int indentLen;
    private String indent;
    private int byteLength = 0;

    public IndentedLinesBuilder(int indentIncrementLen) {
        this.indentIncrementLen = indentIncrementLen;
        this.indentLen = 0;
        this.indent = "";
    }

    public IndentedLinesBuilder(int indentIncrementLen, int initialIndentLen) {
        this.indentIncrementLen = indentIncrementLen;
        this.indentLen = initialIndentLen;
        Preconditions.checkState((0 <= this.indentLen && this.indentLen <= 24 ? 1 : 0) != 0);
        this.indent = SPACES.substring(0, this.indentLen);
    }

    private void appendInternal(String s) {
        this.sb.append(s);
        this.byteLength += Utf8.encodedLength((CharSequence)s);
    }

    public int getByteLength() {
        return this.byteLength;
    }

    public int getIndentIncrementLen() {
        return this.indentIncrementLen;
    }

    public int getCurrIndentLen() {
        return this.indentLen;
    }

    public void increaseIndent() {
        this.increaseIndent(1);
    }

    public void increaseIndent(int numStops) {
        this.indentLen += numStops * this.indentIncrementLen;
        Preconditions.checkState((0 <= this.indentLen && this.indentLen <= 24 ? 1 : 0) != 0);
        this.indent = SPACES.substring(0, this.indentLen);
    }

    public void decreaseIndent() {
        this.decreaseIndent(1);
    }

    public void decreaseIndent(int numStops) {
        this.indentLen -= numStops * this.indentIncrementLen;
        Preconditions.checkState((0 <= this.indentLen && this.indentLen <= 24 ? 1 : 0) != 0);
        this.indent = SPACES.substring(0, this.indentLen);
    }

    public void appendLine(Object ... parts) {
        if (parts.length > 0) {
            this.appendInternal(this.indent);
        }
        this.appendParts(parts);
        this.appendInternal("\n");
    }

    @CanIgnoreReturnValue
    public IndentedLinesBuilder appendParts(Object ... parts) {
        for (Object part : parts) {
            this.appendInternal(part.toString());
        }
        return this;
    }

    @CanIgnoreReturnValue
    public IndentedLinesBuilder appendLineStart(Object ... parts) {
        this.appendInternal(this.indent);
        this.appendParts(parts);
        return this;
    }

    @CanIgnoreReturnValue
    public IndentedLinesBuilder appendLineMiddle(Object ... parts) {
        this.appendParts(parts);
        return this;
    }

    @CanIgnoreReturnValue
    public IndentedLinesBuilder appendLineEnd(Object ... parts) {
        this.appendParts(parts);
        this.appendInternal("\n");
        return this;
    }

    @Override
    public String toString() {
        return this.sb.toString();
    }

    @Override
    public int length() {
        return this.sb.length();
    }

    @Override
    public char charAt(int index) {
        return this.sb.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.sb.subSequence(start, end);
    }
}

