/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.base;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.errorprone.annotations.Immutable;
import com.google.template.soy.base.AutoValue_SourceLocation_Point;
import com.google.template.soy.base.SourceFilePath;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
@Immutable
@CheckReturnValue
public final class SourceLocation
implements Comparable<SourceLocation> {
    @Nonnull
    private final SourceFilePath filePath;
    private final Point begin;
    private final Point end;
    public static final SourceLocation UNKNOWN = new SourceLocation(SourceFilePath.create("unknown", "unknown"));

    public SourceLocation(SourceFilePath filePath, int beginLine, int beginColumn, int endLine, int endColumn) {
        this(filePath, Point.create(beginLine, beginColumn), Point.create(endLine, endColumn));
    }

    public SourceLocation(SourceFilePath filePath) {
        this(filePath, -1, -1, -1, -1);
    }

    public SourceLocation(SourceFilePath filePath, Point begin, Point end) {
        Preconditions.checkNotNull((Object)filePath, (Object)"filePath is null");
        Preconditions.checkNotNull((Object)begin, (Object)"begin is null");
        Preconditions.checkNotNull((Object)end, (Object)"end is null");
        Preconditions.checkArgument((begin.isKnown() == end.isKnown() ? 1 : 0) != 0, (String)"Either both the begin and end locations should be known, or neither should be. Got [%s, %s]", (Object)begin, (Object)end);
        Preconditions.checkArgument((begin.compareTo(end) <= 0 ? 1 : 0) != 0, (String)"begin %s should be before end %s in file %s", (Object)begin, (Object)end, (Object)filePath);
        this.filePath = filePath;
        this.begin = begin;
        this.end = end;
    }

    @Nonnull
    public SourceFilePath getFilePath() {
        return this.filePath;
    }

    @Nullable
    public String getFileName() {
        if (UNKNOWN.equals(this)) {
            return null;
        }
        return this.filePath.fileName();
    }

    public int getBeginLine() {
        return this.begin.line();
    }

    public int getBeginColumn() {
        return this.begin.column();
    }

    public int getEndLine() {
        return this.end.line();
    }

    public int getEndColumn() {
        return this.end.column();
    }

    public boolean isJustBefore(SourceLocation that) {
        if (!this.filePath.equals(that.filePath)) {
            return false;
        }
        return this.getEndLine() == that.getBeginLine() && this.getEndColumn() + 1 == that.getBeginColumn();
    }

    public boolean isBefore(SourceLocation that) {
        if (!this.filePath.equals(that.filePath)) {
            return false;
        }
        return this.getEndPoint().isBefore(that.getBeginPoint());
    }

    public boolean isKnown() {
        return this.begin.isKnown();
    }

    @Override
    public int compareTo(SourceLocation o) {
        return ComparisonChain.start().compare((Comparable)this.filePath, (Comparable)o.filePath).compare((Comparable)this.begin, (Comparable)o.begin).compare((Comparable)this.end, (Comparable)o.end).result();
    }

    public boolean equals(@Nullable Object o) {
        if (!(o instanceof SourceLocation)) {
            return false;
        }
        SourceLocation that = (SourceLocation)o;
        return this.filePath.equals(that.filePath) && this.begin.equals(that.begin) && this.end.equals(that.end);
    }

    public int hashCode() {
        return this.filePath.hashCode() + 31 * this.begin.hashCode() + 961 * this.end.hashCode();
    }

    public String toString() {
        String lineColumnString = this.toLineColumnString();
        return lineColumnString == null ? this.filePath.realPath() : String.format("%s:%s", this.filePath.realPath(), lineColumnString);
    }

    @Nullable
    public String toLineColumnString() {
        return this.begin.line() == -1 ? null : String.format("%s:%s-%s:%s", this.begin.line(), this.begin.column(), this.end.line(), this.end.column());
    }

    public SourceLocation offsetStartCol(int offset) {
        return new SourceLocation(this.filePath, this.begin.offset(0, offset), this.end);
    }

    public SourceLocation offsetEndCol(int offset) {
        return new SourceLocation(this.filePath, this.begin, this.end.offset(0, offset));
    }

    public SourceLocation offsetCols(int beginOffset, int endOffset) {
        return new SourceLocation(this.filePath, this.begin.offset(0, beginOffset), this.end.offset(0, endOffset));
    }

    public boolean isSingleLine() {
        return this.begin.line() == this.end.line();
    }

    public int getLength() {
        Preconditions.checkState((boolean)this.isSingleLine());
        return this.end.column() - this.begin.column() + 1;
    }

    public SourceLocation substring(int beginIndex) {
        return this.substring(beginIndex, this.end.column() - this.begin.column() + 1);
    }

    public SourceLocation substring(int beginIndex, int endIndexExcl) {
        Preconditions.checkState((boolean)this.isSingleLine());
        Point newEnd = endIndexExcl >= 0 ? this.begin.offset(0, endIndexExcl - 1) : this.end.offset(0, endIndexExcl);
        return new SourceLocation(this.filePath, this.begin.offset(0, beginIndex), newEnd);
    }

    public SourceLocation extend(SourceLocation other) {
        if (!this.isKnown() || !other.isKnown()) {
            return UNKNOWN;
        }
        Preconditions.checkState((boolean)this.filePath.equals(other.filePath), (String)"Mismatched files paths: %s and %s", (Object)this.filePath, (Object)other.filePath);
        return new SourceLocation(this.filePath, this.begin, other.end);
    }

    public SourceLocation extend(Point other) {
        if (!this.isKnown() || !other.isKnown()) {
            return UNKNOWN;
        }
        return new SourceLocation(this.filePath, this.begin, other);
    }

    public SourceLocation extend(int lines, int cols) {
        return new SourceLocation(this.filePath, this.begin, this.end.offset(lines, cols));
    }

    public SourceLocation createSuperRangeWith(SourceLocation other) {
        Point begin = this.begin.isBefore(other.begin) ? this.begin : other.begin;
        Point end = this.end.isAfter(other.end) ? this.end : other.end;
        return new SourceLocation(this.filePath, begin, end);
    }

    public SourceLocation unionWith(SourceLocation other) {
        if (!this.isKnown() || !other.isKnown()) {
            return UNKNOWN;
        }
        Preconditions.checkState((boolean)this.filePath.equals(other.filePath), (String)"Mismatched files paths: %s and %s", (Object)this.filePath, (Object)other.filePath);
        Preconditions.checkState((boolean)this.isAdjacentOrOverlappingWith(other), (String)"Cannot compute union of nonadjacent source locations: %s and %s", (Object)this.asLineColumnRange(), (Object)other.asLineColumnRange());
        Point newBegin = this.begin.isBefore(other.getBeginPoint()) ? this.begin : other.getBeginPoint();
        Point newEnd = this.end.isAfter(other.getEndPoint()) ? this.end : other.getEndPoint();
        return new SourceLocation(this.filePath, newBegin, newEnd);
    }

    public boolean isAdjacentOrOverlappingWith(SourceLocation other) {
        Point lowerEndPoint = this.end.isBefore(other.getEndPoint()) ? this.end : other.getEndPoint();
        Point higherBeginPoint = this.begin.isAfter(other.getBeginPoint()) ? this.begin : other.getBeginPoint();
        SourceLocation locWithLowerEndPoint = this.end.isBefore(other.getEndPoint()) ? this : other;
        SourceLocation locWithHigherEndPoint = locWithLowerEndPoint.equals(this) ? other : this;
        return locWithLowerEndPoint.isJustBefore(locWithHigherEndPoint) || lowerEndPoint.equals(higherBeginPoint) || lowerEndPoint.isAfter(higherBeginPoint);
    }

    private String asLineColumnRange() {
        return this.getBeginLine() + ":" + this.getBeginColumn() + " - " + this.getEndLine() + ":" + this.getEndColumn();
    }

    public SourceLocation getBeginLocation() {
        return new SourceLocation(this.filePath, this.begin, this.begin);
    }

    public Point getBeginPoint() {
        return this.begin;
    }

    public boolean fullyContainsRange(SourceLocation range) {
        if (!this.isKnown() || !range.isKnown()) {
            return false;
        }
        boolean rangeStartsAfterOrAtBeginPoint = !this.begin.isAfter(range.begin);
        boolean rangeEndsAfterOrAtEndPoint = !this.end.isBefore(range.end);
        return rangeStartsAfterOrAtBeginPoint && rangeEndsAfterOrAtEndPoint;
    }

    public Optional<SourceLocation> getOverlapWith(SourceLocation other) {
        Point higherBeginPoint;
        Point lowerEndPoint = this.end.isBefore(other.getEndPoint()) ? this.end : other.getEndPoint();
        Point point = higherBeginPoint = this.begin.isAfter(other.getBeginPoint()) ? this.begin : other.getBeginPoint();
        if (!lowerEndPoint.isBefore(higherBeginPoint)) {
            return Optional.of(new SourceLocation(this.filePath, higherBeginPoint, lowerEndPoint));
        }
        return Optional.empty();
    }

    public SourceLocation getEndLocation() {
        return new SourceLocation(this.filePath, this.end, this.end);
    }

    public Point getEndPoint() {
        return this.end;
    }

    public boolean containsPoint(Point point) {
        return this.begin.compareTo(point) <= 0 && this.end.compareTo(point) >= 0;
    }

    public SourceLocation clearRange() {
        return new SourceLocation(this.filePath);
    }

    @Immutable
    @AutoValue
    public static abstract class Point
    implements Comparable<Point> {
        public static final Point UNKNOWN_POINT = new AutoValue_SourceLocation_Point(-1, -1);

        public static Point create(int line, int column) {
            if (line == -1 && column == -1) {
                return UNKNOWN_POINT;
            }
            Preconditions.checkArgument((line > 0 ? 1 : 0) != 0, (String)"line must be positive: %s", (int)line);
            Preconditions.checkArgument((column > 0 ? 1 : 0) != 0, (String)"column must be positive: %s", (int)column);
            return new AutoValue_SourceLocation_Point(line, column);
        }

        public abstract int line();

        public abstract int column();

        public final boolean isKnown() {
            return !this.equals(UNKNOWN_POINT);
        }

        public final Point offset(int byLines, int byColumns) {
            if (!this.isKnown()) {
                return this;
            }
            return Point.create(this.line() + byLines, this.column() + byColumns);
        }

        public final SourceLocation asLocation(SourceFilePath filePath) {
            return new SourceLocation(filePath, this, this);
        }

        @Override
        public final int compareTo(Point o) {
            return ComparisonChain.start().compare(this.line(), o.line()).compare(this.column(), o.column()).result();
        }

        public final boolean isBefore(Point o) {
            return this.compareTo(o) < 0;
        }

        public final boolean isBefore(SourceLocation o) {
            return this.isBefore(o.getBeginPoint());
        }

        public final boolean isAfter(Point o) {
            return this.compareTo(o) > 0;
        }

        public final boolean isAfter(SourceLocation o) {
            return this.isAfter(o.getEndPoint());
        }

        public final boolean equals(Object o) {
            if (!(o instanceof Point)) {
                return false;
            }
            return this.compareTo((Point)o) == 0;
        }

        public final int hashCode() {
            return this.line() * 31 * 31 + this.column() * 31;
        }
    }
}

