/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.errorprone.annotations.ForOverride;
import com.google.inject.Module;
import com.google.template.soy.CommandLineError;
import com.google.template.soy.PluginLoader;
import com.google.template.soy.msgs.SoyMsgPlugin;
import com.google.template.soy.plugin.restricted.SoySourceFunction;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import org.kohsuke.args4j.ClassParser;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.NamedOptionDef;
import org.kohsuke.args4j.OptionDef;
import org.kohsuke.args4j.spi.Getter;
import org.kohsuke.args4j.spi.OptionHandler;
import org.kohsuke.args4j.spi.Parameters;
import org.kohsuke.args4j.spi.Setter;

public final class SoyCmdLineParser
extends CmdLineParser {
    private final PluginLoader pluginLoader;

    SoyCmdLineParser(PluginLoader loader) {
        super(null);
        this.pluginLoader = loader;
    }

    void registerFlagsObject(Object bean) {
        new ClassParser().parse(bean, (CmdLineParser)this);
    }

    private static <T> T instantiateObject(String flagName, String objectType, Class<T> clazz, PluginLoader loader, String instanceClassName) {
        try {
            return loader.loadPlugin(instanceClassName).asSubclass(clazz).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassCastException cce) {
            throw new CommandLineError(String.format("%s \"%s\" is not a subclass of %s.  Classes passed to %s should be %ss. Did you pass it to the wrong flag?", objectType, instanceClassName, clazz.getSimpleName(), flagName, clazz.getSimpleName()), cce);
        }
        catch (ReflectiveOperationException e) {
            throw new CommandLineError(String.format("Cannot instantiate %s \"%s\" registered with flag %s.  Please make sure that the %s exists and is on the compiler classpath and has a public zero arguments constructor.", objectType, instanceClassName, flagName, objectType), e);
        }
        catch (ExceptionInInitializerError e) {
            throw new CommandLineError(String.format("Cannot instantiate %s \"%s\" registered with flag %s. An error was thrown while loading the class.  There is a bug in the implementation.", objectType, instanceClassName, flagName), e);
        }
        catch (SecurityException e) {
            throw new CommandLineError(String.format("Cannot instantiate %s \"%s\" registered with flag %s. A security manager is preventing instantiation.", objectType, instanceClassName, flagName), e);
        }
    }

    static {
        CmdLineParser.registerHandler(Module.class, ModuleOptionHandler.class);
        CmdLineParser.registerHandler(Boolean.class, BooleanOptionHandler.class);
        CmdLineParser.registerHandler(Boolean.TYPE, BooleanOptionHandler.class);
        CmdLineParser.registerHandler(SoyMsgPlugin.class, MsgPluginOptionHandler.class);
        CmdLineParser.registerHandler(Path.class, PathOptionHandler.class);
    }

    static abstract class MapHandler<K, V>
    extends OptionHandler<Map<K, V>> {
        MapHandler(CmdLineParser parser, OptionDef option, Setter<? super Map<K, V>> setter) {
            super(parser, option, setter);
        }

        @ForOverride
        protected abstract K parseKey(String var1);

        @ForOverride
        protected abstract V parseValue(String var1);

        public int parseArguments(Parameters params) throws CmdLineException {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            String parameters = params.getParameter(0);
            for (String parameter : Splitter.on((String)",").split((CharSequence)parameters)) {
                int index = parameter.indexOf("=");
                if (index == -1) {
                    throw new CommandLineError("Invalid map flag entry.  No '=' found: " + parameter);
                }
                K key = this.parseKey(CharMatcher.whitespace().trimFrom((CharSequence)parameter.substring(0, index)));
                V val = this.parseValue(CharMatcher.whitespace().trimFrom((CharSequence)parameter.substring(index + 1)));
                builder.put(key, val);
            }
            this.setter.addValue((Object)builder.buildOrThrow());
            return 1;
        }

        public String getDefaultMetaVariable() {
            return "KEY=VALUE1,KEY2=VALUE3,VALUE4;...";
        }
    }

    public static final class StringStringMapHandler
    extends MapHandler<String, String> {
        public StringStringMapHandler(CmdLineParser parser, OptionDef option, Setter<? super Map<String, String>> setter) {
            super(parser, option, setter);
        }

        @Override
        protected String parseKey(String key) {
            return key;
        }

        @Override
        protected String parseValue(String value) {
            return value;
        }
    }

    static abstract class ListMultimapOptionHandler<K, V>
    extends MultimapOptionHandler<ListMultimap<K, V>, K, V> {
        ListMultimapOptionHandler(CmdLineParser parser, OptionDef option, Setter<? super ListMultimap<K, V>> setter) {
            super(parser, option, setter);
        }

        @Override
        protected ListMultimap<K, V> emptyMultimap() {
            return ArrayListMultimap.create();
        }
    }

    static abstract class MultimapOptionHandler<T extends Multimap<K, V>, K, V>
    extends OptionHandler<T> {
        protected MultimapOptionHandler(CmdLineParser parser, OptionDef option, Setter<? super T> setter) {
            super(parser, option, setter);
        }

        protected abstract T emptyMultimap();

        @ForOverride
        protected abstract K parseKey(String var1);

        @ForOverride
        protected abstract V parseValue(String var1);

        public int parseArguments(Parameters params) throws CmdLineException {
            Getter getter;
            Multimap builder = null;
            if (this.setter instanceof Getter && !(getter = (Getter)this.setter).getValueList().isEmpty()) {
                builder = (Multimap)getter.getValueList().get(0);
            }
            if (builder == null) {
                builder = (Multimap)this.emptyMultimap();
            }
            String parameter = params.getParameter(0);
            Splitter valueSplitter = Splitter.on((String)",").omitEmptyStrings();
            for (String s : Splitter.on((String)";").omitEmptyStrings().split((CharSequence)parameter)) {
                int index = s.indexOf("=");
                if (index == -1) {
                    throw new CommandLineError("Invalid multimap flag entry.  No '=' found: " + s);
                }
                K key = this.parseKey(CharMatcher.whitespace().trimFrom((CharSequence)s.substring(0, index)));
                String allValStr = CharMatcher.whitespace().trimFrom((CharSequence)s.substring(index + 1));
                for (String valStr : valueSplitter.split((CharSequence)allValStr)) {
                    builder.put(key, this.parseValue(valStr));
                }
            }
            this.setter.addValue((Object)builder);
            return 1;
        }

        public String getDefaultMetaVariable() {
            return "KEY=VALUE1,VALUE2;KEY2=VALUE3,VALUE4;...";
        }
    }

    public static final class MsgPluginOptionHandler
    extends OptionHandler<SoyMsgPlugin> {
        public MsgPluginOptionHandler(CmdLineParser parser, OptionDef option, Setter<? super SoyMsgPlugin> setter) {
            super(parser, option, setter);
        }

        public int parseArguments(Parameters params) throws CmdLineException {
            String parameter = params.getParameter(0);
            if (parameter.isEmpty()) {
                this.setter.addValue(null);
            } else {
                this.setter.addValue((Object)SoyCmdLineParser.instantiateObject(((NamedOptionDef)this.option).name(), "msg plugin", SoyMsgPlugin.class, ((SoyCmdLineParser)this.owner).pluginLoader, parameter));
            }
            return 1;
        }

        public String getDefaultMetaVariable() {
            return "com.foo.bar.BazModule";
        }
    }

    public static final class ModuleOptionHandler
    extends OptionHandler<Module> {
        public ModuleOptionHandler(CmdLineParser parser, OptionDef option, Setter<? super Module> setter) {
            super(parser, option, setter);
        }

        public int parseArguments(Parameters params) throws CmdLineException {
            String parameter = params.getParameter(0);
            if (parameter.isEmpty()) {
                this.setter.addValue(null);
            } else {
                this.setter.addValue((Object)SoyCmdLineParser.instantiateObject(((NamedOptionDef)this.option).name(), "plugin module", Module.class, ((SoyCmdLineParser)this.owner).pluginLoader, parameter));
            }
            return 1;
        }

        public String getDefaultMetaVariable() {
            return "com.foo.bar.BazModule";
        }
    }

    public static final class PathOptionHandler
    extends OptionHandler<Path> {
        public PathOptionHandler(CmdLineParser parser, OptionDef option, Setter<? super Path> setter) {
            super(parser, option, setter);
        }

        public int parseArguments(Parameters params) throws CmdLineException {
            String parameter = params.getParameter(0);
            if (parameter.isEmpty()) {
                this.setter.addValue(null);
            } else {
                this.setter.addValue((Object)Paths.get(parameter, new String[0]));
            }
            return 1;
        }

        public String getDefaultMetaVariable() {
            return "foo/bar/baz";
        }
    }

    public static final class PathListOptionHandler
    extends ListOptionHandler<Path> {
        public PathListOptionHandler(CmdLineParser parser, OptionDef option, Setter<? super Path> setter) {
            super(parser, option, setter);
        }

        @Override
        Path parseItem(String item) {
            return Paths.get(item, new String[0]);
        }
    }

    public static final class FileListOptionHandler
    extends ListOptionHandler<File> {
        public FileListOptionHandler(CmdLineParser parser, OptionDef option, Setter<? super File> setter) {
            super(parser, option, setter);
        }

        @Override
        File parseItem(String item) {
            return new File(item);
        }
    }

    public static final class SourceFunctionListOptionHandler
    extends ListMultimapOptionHandler<String, SoySourceFunction> {
        public SourceFunctionListOptionHandler(CmdLineParser parser, OptionDef option, Setter<? super ListMultimap<String, SoySourceFunction>> setter) {
            super(parser, option, setter);
        }

        @Override
        protected String parseKey(String key) {
            return key;
        }

        @Override
        protected SoySourceFunction parseValue(String value) {
            return SoyCmdLineParser.instantiateObject(((NamedOptionDef)this.option).name(), "plugin SoySourceFunction", SoySourceFunction.class, ((SoyCmdLineParser)this.owner).pluginLoader, value);
        }
    }

    public static final class ModuleListOptionHandler
    extends ListOptionHandler<Module> {
        public ModuleListOptionHandler(CmdLineParser parser, OptionDef option, Setter<? super Module> setter) {
            super(parser, option, setter);
        }

        @Override
        Module parseItem(String item) {
            return SoyCmdLineParser.instantiateObject(((NamedOptionDef)this.option).name(), "plugin module", Module.class, ((SoyCmdLineParser)this.owner).pluginLoader, item);
        }
    }

    public static final class StringListOptionHandler
    extends ListOptionHandler<String> {
        public StringListOptionHandler(CmdLineParser parser, OptionDef option, Setter<? super String> setter) {
            super(parser, option, setter);
        }

        @Override
        String parseItem(String item) {
            return item;
        }
    }

    static abstract class ListOptionHandler<T>
    extends OptionHandler<T> {
        ListOptionHandler(CmdLineParser parser, OptionDef option, Setter<? super T> setter) {
            super(parser, option, setter);
        }

        abstract T parseItem(String var1);

        public int parseArguments(Parameters params) throws CmdLineException {
            String parameter = params.getParameter(0);
            if (!parameter.isEmpty()) {
                for (String item : parameter.split(",")) {
                    this.setter.addValue(this.parseItem(item));
                }
            }
            return 1;
        }

        public String getDefaultMetaVariable() {
            return "ITEM,ITEM,...";
        }
    }

    public static final class BooleanOptionHandler
    extends OptionHandler<Boolean> {
        public BooleanOptionHandler(CmdLineParser parser, OptionDef option, Setter<? super Boolean> setter) {
            super(parser, option, setter);
        }

        public int parseArguments(Parameters params) throws CmdLineException {
            boolean hasParam;
            boolean value;
            try {
                String nextArg = params.getParameter(0);
                if (nextArg.equalsIgnoreCase("true") || nextArg.equals("1")) {
                    value = true;
                    hasParam = true;
                } else if (nextArg.equalsIgnoreCase("false") || nextArg.equals("0")) {
                    value = false;
                    hasParam = true;
                } else {
                    value = true;
                    hasParam = false;
                }
            }
            catch (CmdLineException e) {
                value = true;
                hasParam = false;
            }
            this.setter.addValue((Object)value);
            return hasParam ? 1 : 0;
        }

        public String getDefaultMetaVariable() {
            return null;
        }
    }
}

