/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.errorprone.annotations.ForOverride;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.protobuf.Descriptors;
import com.google.template.soy.CacheLoaders;
import com.google.template.soy.CommandLineError;
import com.google.template.soy.FileSystemSoyFileReader;
import com.google.template.soy.PluginLoader;
import com.google.template.soy.SoyCmdLineParser;
import com.google.template.soy.SoyCompilerFileReader;
import com.google.template.soy.SoyFileSet;
import com.google.template.soy.SoyInputCache;
import com.google.template.soy.base.SourceFilePath;
import com.google.template.soy.base.SourceLogicalPath;
import com.google.template.soy.base.internal.SoyFileKind;
import com.google.template.soy.error.SoyCompilationException;
import com.google.template.soy.plugin.java.DelegatingMethodChecker;
import com.google.template.soy.plugin.java.MethodChecker;
import com.google.template.soy.plugin.restricted.SoySourceFunction;
import com.google.template.soy.shared.internal.ImmutableSetMultimapToggleRegistry;
import com.google.template.soy.shared.restricted.SoyFunction;
import com.google.template.soy.shared.restricted.SoyPrintDirective;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringWriter;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.Option;

public abstract class AbstractSoyCompiler {
    private final String usagePrefix = "Usage:\njava " + this.getClass().getName() + " \\\n     [<flag1> <flag2> ...] --java_extern_defn_jars <jarName>  \\\n     --srcs <soyFilePath>,... [--depHeaders <filePath>,...]\n";
    @Option(name="--srcs", usage="The list of source Soy files (if applicable). Extra arguments are treated as srcs. Sources are typically required and read from this flag or as extra arguments.", handler=SoyCmdLineParser.FileListOptionHandler.class)
    List<File> srcs = new ArrayList<File>();
    @Option(name="--generated_files", usage="A map of generated files that map back to their short name", handler=SoyCmdLineParser.StringStringMapHandler.class)
    private Map<String, String> generatedFiles = new HashMap<String, String>();
    @Option(name="--depHeaders", usage="The list of dependency Soy header files (if applicable). The compiler needs deps for analysis/checking..", handler=SoyCmdLineParser.FileListOptionHandler.class)
    private List<File> depHeaders = new ArrayList<File>();
    @Option(name="--indirectDepHeaders", usage="Soy file headers required by deps, but which may not be used by srcs.  Used by the compiler for typechecking and call analysis.", handler=SoyCmdLineParser.FileListOptionHandler.class)
    private List<File> indirectDepHeaders = new ArrayList<File>();
    @Option(name="--pluginModules", usage="Specifies the full class names of Guice modules for function plugins and print directive plugins (comma-delimited list).", handler=SoyCmdLineParser.ModuleListOptionHandler.class)
    private List<Module> pluginModules = new ArrayList<Module>();
    @Option(name="--pluginFunctions", usage="Specifies a multimap of plugin target to class name of SoySourceFunction plugin, in the form //target1=pkg.Class1,pkg.Class2,...;//target2=...", handler=SoyCmdLineParser.SourceFunctionListOptionHandler.class)
    private ListMultimap<String, SoySourceFunction> sourceFunctions = ArrayListMultimap.create();
    @Option(name="--directProtoDeps", usage="Location of protocol buffer definitions in the form of a file descriptor set. These are the 'direct dependencies' of the compilation unit -- any protos imported by Soy files in this compilation unit must be listed here.", handler=SoyCmdLineParser.FileListOptionHandler.class)
    private List<File> protoDescDirectDeps = new ArrayList<File>();
    @Option(name="--indirectProtoDeps", usage="Location of protocol buffer definitions in the form of a file descriptor set. These are the 'indirect dependencies' of the compilation unit and must include all transitive dependencies of the files passed to --directProtoDeps.", handler=SoyCmdLineParser.FileListOptionHandler.class)
    private List<File> protoDescIndirectDeps = new ArrayList<File>();
    @Option(name="--cssMetadata", usage="List of css metadata files used to check strict deps against css dependencies and css() calls.", handler=SoyCmdLineParser.FileListOptionHandler.class)
    private List<File> cssMetadata = new ArrayList<File>();
    @Option(name="--togglesFiles", usage="List of toggles provider files.", handler=SoyCmdLineParser.FileListOptionHandler.class)
    private List<File> togglesFiles = new ArrayList<File>();
    @Option(name="--skip_css_reference_check", usage="Whether to skip the go/css-conformance#css-reference-checks.")
    private boolean skipCssReferenceCheck = false;
    @Option(name="--enableExperimentalFeatures", usage="Enable experimental features that are not generally available. These experimental features may change, break, or disappear at any time. We make absolutely no guarantees about what may happen if you turn one of these experiments on. Please proceed with caution at your own risk.", handler=SoyCmdLineParser.StringListOptionHandler.class)
    private List<String> experimentalFeatures = new ArrayList<String>();
    @Option(name="--java_extern_defn_jars", usage="Java jars that are used to validate that java implementations of externs are valid references.", handler=SoyCmdLineParser.FileListOptionHandler.class)
    private List<File> javaDeps = new ArrayList<File>();
    @Option(name="--disableOptimizerForTestingUseOnly", usage="Disable optimizer in Soy compiler. Optimzer tries to simplify the Soy AST and improves the performance in general. This flag should only be set in integration test environment.")
    private boolean disableOptimizer = false;
    @Option(name="--allow_unblessed_generated_files", usage="Whether to allow generated source files without the blessed comment.")
    private boolean allowUnblessedGeneratedFiles = true;
    @Option(name="--javaPackage", required=false, usage="The Java package name used for generated Java classes associated with these Soy sources. Required by some compilers.")
    protected String javaPackage = "";
    @Argument
    private List<String> arguments = new ArrayList<String>();
    protected final SoyCompilerFileReader soyCompilerFileReader;
    final PluginLoader pluginLoader;
    private final SoyInputCache cache;

    protected AbstractSoyCompiler(PluginLoader pluginLoader, SoyInputCache cache, SoyCompilerFileReader soyCompilerFileReader) {
        this.cache = cache;
        this.pluginLoader = pluginLoader;
        this.soyCompilerFileReader = soyCompilerFileReader;
    }

    protected AbstractSoyCompiler(PluginLoader pluginLoader, SoyCompilerFileReader soyCompilerFileReader) {
        this(pluginLoader, SoyInputCache.DEFAULT, soyCompilerFileReader);
    }

    protected AbstractSoyCompiler(PluginLoader pluginLoader, SoyInputCache cache) {
        this(pluginLoader, cache, FileSystemSoyFileReader.INSTANCE);
    }

    protected AbstractSoyCompiler() {
        this((PluginLoader)new PluginLoader.Default(), SoyInputCache.DEFAULT);
    }

    final void runMain(String ... args) {
        int status = this.run(args, System.err);
        System.exit(status);
    }

    @CheckReturnValue
    public int run(String[] args, PrintStream err) {
        try {
            this.doMain(args, err);
            return 0;
        }
        catch (SoyCompilationException compilationException) {
            err.println(this.formatCompilationException(compilationException));
            return 1;
        }
        catch (CommandLineError e) {
            e.printStackTrace(err);
            return 1;
        }
        catch (Throwable e) {
            err.println("INTERNAL SOY ERROR.\nPlease open an issue at https://github.com/google/closure-templates/issues with this stack trace and repro steps");
            e.printStackTrace(err);
            return 1;
        }
    }

    private void doMain(String[] args, PrintStream err) throws IOException {
        Stopwatch timer = Stopwatch.createStarted();
        Stopwatch guiceTimer = Stopwatch.createUnstarted();
        SoyCmdLineParser cmdLineParser = new SoyCmdLineParser(this.pluginLoader);
        cmdLineParser.registerFlagsObject(this);
        for (Object flagsObject : this.extraFlagsObjects()) {
            cmdLineParser.registerFlagsObject(flagsObject);
        }
        try {
            cmdLineParser.parseArgument(args);
        }
        catch (CmdLineException cle) {
            StringWriter sw = new StringWriter();
            cmdLineParser.setUsageWidth(100);
            cmdLineParser.printUsage(sw, null);
            AbstractSoyCompiler.exitWithError(String.format("%s\n\n%s\n%s", cle.getMessage(), this.usagePrefix, sw));
        }
        this.validateFlags();
        if (!this.arguments.isEmpty()) {
            AbstractSoyCompiler.exitWithError("Found unexpected extra arguments passed on the command line:\n  " + Joiner.on((String)" ").join(this.arguments));
        }
        if (this.requireSources() && this.srcs.isEmpty()) {
            AbstractSoyCompiler.exitWithError("Must provide list of source Soy files (--srcs).");
        }
        SoyFileSet.Builder sfsBuilder = new SoyFileSet.Builder(true);
        if (!this.pluginModules.isEmpty()) {
            Injector injector;
            guiceTimer.start();
            ArrayList<Module> modules = new ArrayList<Module>(this.pluginModules);
            try {
                injector = Guice.createInjector(modules);
            }
            catch (Throwable t) {
                throw new CommandLineError("Failed to create Guice injector.  Is there a bug in one of the modules passed to --pluginModules?", t);
            }
            Optional.ofNullable(injector.getExistingBinding((Key)new Key<Set<SoyFunction>>(this){})).ifPresent(b -> sfsBuilder.addSoyFunctions((Iterable)b.getProvider().get()));
            Optional.ofNullable(injector.getExistingBinding((Key)new Key<Set<SoyPrintDirective>>(this){})).ifPresent(b -> sfsBuilder.addSoyPrintDirectives((Iterable)b.getProvider().get()));
            guiceTimer.stop();
        }
        ImmutableSet uniqueSourceFunctionClasses = (ImmutableSet)this.sourceFunctions.values().stream().map(Object::getClass).collect(ImmutableSet.toImmutableSet());
        HashSet<String> uniqueClasses = new HashSet<String>();
        ImmutableSetMultimap.Builder togglesBuilder = ImmutableSetMultimap.builder();
        for (File file : this.togglesFiles) {
            SourceFilePath toggleFile = this.getFilePath(file);
            ImmutableList<String> toggleNames = this.cache.read(file, CacheLoaders.CACHED_TOGGLE_NAMES, this.soyCompilerFileReader);
            togglesBuilder.putAll((Object)toggleFile, toggleNames);
        }
        sfsBuilder.setToggleRegistry(ImmutableSetMultimapToggleRegistry.create((ImmutableSetMultimap<SourceFilePath, String>)togglesBuilder.build()));
        ImmutableList.Builder builder = ImmutableList.builder();
        for (File dep : this.javaDeps) {
            builder.add((Object)this.cache.read(dep, CacheLoaders.JAVA_DEPS, this.soyCompilerFileReader));
        }
        for (Map.Entry entry : this.sourceFunctions.asMap().entrySet()) {
            for (SoySourceFunction function : (Collection)entry.getValue()) {
                String className = function.getClass().getName();
                if (!uniqueClasses.add(className)) continue;
                sfsBuilder.addSourceFunction((String)entry.getKey(), function);
            }
        }
        sfsBuilder.setWarningSink(err).setJavaPluginValidator(new DelegatingMethodChecker((List<MethodChecker>)builder.build())).setExperimentalFeatures(this.experimentalFeatures).setSoyAstCache(this.cache.astCache());
        ImmutableSet immutableSet = ImmutableSet.copyOf(this.protoDescDirectDeps);
        Sets.SetView allProtoFiles = Sets.union((Set)immutableSet, (Set)ImmutableSet.copyOf(this.protoDescIndirectDeps));
        ImmutableListMultimap<File, Descriptors.FileDescriptor> parsedProtos = AbstractSoyCompiler.parseProtos((Collection<File>)allProtoFiles, this.cache, this.soyCompilerFileReader, err);
        for (Map.Entry entry : parsedProtos.asMap().entrySet()) {
            sfsBuilder.addProtoDescriptors(immutableSet.contains(entry.getKey()) ? SoyFileKind.DEP : SoyFileKind.INDIRECT_DEP, (Iterable)entry.getValue());
        }
        if (!this.allowUnblessedGeneratedFiles) {
            sfsBuilder.setGeneratedPathsToCheck(this.generatedFiles.values().stream().map(SourceLogicalPath::create).collect(Collectors.toSet()));
        }
        for (File src : this.srcs) {
            try {
                SourceFilePath filePath = this.getFilePath(src);
                sfsBuilder.add(this.cache.createFileSupplier(src, filePath, this.soyCompilerFileReader));
            }
            catch (FileNotFoundException fnfe) {
                throw new CommandLineError("File: " + src.getPath() + " passed to --srcs does not exist", fnfe);
            }
        }
        this.addCompilationUnitsToBuilder(sfsBuilder);
        if (this.disableOptimizer) {
            sfsBuilder.disableOptimizer();
        }
        this.compile(sfsBuilder);
        timer.stop();
        if (timer.elapsed().compareTo(Duration.ofSeconds(1L)) > 0 && guiceTimer.elapsed().compareTo(timer.elapsed().dividedBy(2L)) > 0) {
            err.println("WARNING: This compile took " + String.valueOf(timer) + " but more than 50% of that (" + String.valueOf(guiceTimer) + ") was creating a guice injector for plugins.  Please migrate to passing plugins via the --pluginFunctions flag to improve compiler performance.");
        }
    }

    private SourceFilePath getFilePath(File src) {
        String logicalPath = this.generatedFiles.getOrDefault(src.getPath(), src.getPath());
        return SourceFilePath.create(logicalPath, src.getPath());
    }

    @VisibleForTesting
    static ImmutableListMultimap<File, Descriptors.FileDescriptor> parseProtos(Collection<File> protoFileDescriptors, SoyInputCache cache, SoyCompilerFileReader reader, PrintStream err) {
        SetMultimap protoFileToDescriptor = MultimapBuilder.linkedHashKeys().linkedHashSetValues().build();
        LinkedHashMap<File, CacheLoaders.CachedDescriptorSet> cachedDescriptors = new LinkedHashMap<File, CacheLoaders.CachedDescriptorSet>(protoFileDescriptors.size());
        for (File file : protoFileDescriptors) {
            try {
                CacheLoaders.CachedDescriptorSet cachedDescriptor = cache.read(file, CacheLoaders.CACHED_DESCRIPTOR_SET_LOADER, reader);
                for (String protoFileName : cachedDescriptor.getProtoFileNames()) {
                    protoFileToDescriptor.put((Object)protoFileName, (Object)cachedDescriptor);
                }
                cachedDescriptors.put(file, cachedDescriptor);
            }
            catch (IOException ioe) {
                throw new CommandLineError("Error parsing proto file descriptor from " + String.valueOf(file) + ": " + ioe.getMessage());
            }
        }
        for (Map.Entry entry : Multimaps.asMap((SetMultimap)protoFileToDescriptor).entrySet()) {
            if (((Set)entry.getValue()).size() <= 1) continue;
            err.println("WARNING: " + (String)entry.getKey() + " has a descriptor defined in each of these files: " + ((Set)entry.getValue()).stream().map(c -> c.getFile().getPath()).sorted().collect(Collectors.joining(", ")) + ". Do your proto_library rules have overlapping sources?");
        }
        ImmutableListMultimap.Builder descriptors = ImmutableListMultimap.builder();
        for (Map.Entry entry : cachedDescriptors.entrySet()) {
            try {
                descriptors.putAll((Object)((File)entry.getKey()), ((CacheLoaders.CachedDescriptorSet)entry.getValue()).getFileDescriptors((SetMultimap<String, CacheLoaders.CachedDescriptorSet>)protoFileToDescriptor, cache));
            }
            catch (Descriptors.DescriptorValidationException e) {
                throw new CommandLineError("Error parsing proto file descriptor from " + String.valueOf(entry.getKey()) + ": " + e.getMessage());
            }
        }
        return descriptors.build();
    }

    private void addCompilationUnitsToBuilder(SoyFileSet.Builder sfsBuilder) {
        HashSet<File> soFar = new HashSet<File>();
        for (File depHeader : this.depHeaders) {
            this.addCompilationUnitToBuilder(sfsBuilder, depHeader, SoyFileKind.DEP, soFar);
        }
        for (File indirectDep : this.indirectDepHeaders) {
            this.addCompilationUnitToBuilder(sfsBuilder, indirectDep, SoyFileKind.INDIRECT_DEP, soFar);
        }
    }

    private void addCompilationUnitToBuilder(SoyFileSet.Builder sfsBuilder, File depFile, SoyFileKind depKind, Set<File> soFar) {
        if (soFar.add(depFile)) {
            try {
                sfsBuilder.addCompilationUnit(depKind, this.cache.read(depFile, CacheLoaders.COMPILATION_UNIT_LOADER, this.soyCompilerFileReader));
            }
            catch (IOException e) {
                throw new CommandLineError("Unable to read header file: " + String.valueOf(depFile) + ": " + e.getMessage());
            }
        }
    }

    protected Map<String, String> getGeneratedFiles() {
        return this.generatedFiles;
    }

    @ForOverride
    protected void validateFlags() {
    }

    @ForOverride
    boolean requireSources() {
        return true;
    }

    @ForOverride
    Iterable<?> extraFlagsObjects() {
        return ImmutableList.of();
    }

    @ForOverride
    String formatCompilationException(SoyCompilationException sce) {
        return sce.getMessage();
    }

    @ForOverride
    protected abstract void compile(SoyFileSet.Builder var1) throws IOException;

    protected static RuntimeException exitWithError(String errorMsg) {
        throw new CommandLineError(errorMsg);
    }
}

