/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.types;

import com.google.protobuf.Descriptors;
import com.google.template.soy.types.ImportType;
import com.google.template.soy.types.LegacyObjectMapType;
import com.google.template.soy.types.ListType;
import com.google.template.soy.types.MapType;
import com.google.template.soy.types.RecordType;
import com.google.template.soy.types.SanitizedType;
import com.google.template.soy.types.SoyProtoEnumType;
import com.google.template.soy.types.SoyProtoType;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.TemplateType;
import com.google.template.soy.types.UnionType;
import com.google.template.soy.types.VeType;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Function;

public interface TypeInterner {
    public <T extends SoyType> T intern(T var1);

    default public ListType getOrCreateListType(SoyType elementType) {
        return this.intern(ListType.of(elementType));
    }

    default public LegacyObjectMapType getOrCreateLegacyObjectMapType(SoyType keyType, SoyType valueType) {
        return this.intern(LegacyObjectMapType.of(keyType, valueType));
    }

    default public MapType getOrCreateMapType(SoyType keyType, SoyType valueType) {
        return this.intern(MapType.of(keyType, valueType));
    }

    default public SoyType getOrCreateUnionType(Collection<SoyType> members) {
        SoyType type = UnionType.of(members);
        if (type.getKind() == SoyType.Kind.UNION) {
            type = this.intern(type);
        }
        return type;
    }

    default public SoyType getOrCreateUnionType(SoyType ... members) {
        return this.getOrCreateUnionType(Arrays.asList(members));
    }

    default public RecordType getOrCreateRecordType(Iterable<RecordType.Member> members) {
        return this.intern(RecordType.of(members));
    }

    default public TemplateType internTemplateType(TemplateType typeToIntern) {
        return this.intern(typeToIntern);
    }

    default public VeType getOrCreateVeType(String dataType) {
        return this.intern(VeType.of(dataType));
    }

    public SoyProtoType getOrComputeProtoType(Descriptors.Descriptor var1, Function<? super String, ? extends SoyProtoType> var2);

    default public SoyProtoEnumType getOrCreateProtoEnumType(Descriptors.EnumDescriptor descriptor) {
        return this.intern(new SoyProtoEnumType(descriptor));
    }

    default public SoyType getOrCreateElementType(String tagName) {
        return this.intern(SanitizedType.ElementType.getInstance(tagName));
    }

    public ImportType getProtoImportType(Descriptors.GenericDescriptor var1);

    public SoyType getProtoImportType(Descriptors.FileDescriptor var1, String var2);

    public SoyType getProtoImportType(Descriptors.Descriptor var1, String var2);
}

