/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.types;

import com.google.protobuf.Descriptors;
import com.google.template.soy.base.SoyBackendKind;
import com.google.template.soy.internal.proto.ProtoUtils;
import com.google.template.soy.soytree.SoyTypeP;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypeVisitor;
import java.util.Objects;

public final class SoyProtoEnumType
extends SoyType {
    private final Descriptors.EnumDescriptor descriptor;

    public SoyProtoEnumType(Descriptors.EnumDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    @Override
    public SoyType.Kind getKind() {
        return SoyType.Kind.PROTO_ENUM;
    }

    @Override
    boolean doIsAssignableFromNonUnionType(SoyType fromType) {
        return fromType == this || fromType.getClass() == this.getClass() && ((SoyProtoEnumType)fromType).descriptor == this.descriptor;
    }

    public String getName() {
        return this.descriptor.getFullName();
    }

    public String getNameForBackend(SoyBackendKind backend) {
        switch (backend) {
            case JS_SRC: {
                return ProtoUtils.calculateJsEnumName(this.descriptor);
            }
            case TOFU: {
                return ProtoUtils.getQualifiedOuterClassname((Descriptors.GenericDescriptor)this.descriptor);
            }
            case PYTHON_SRC: 
            case JBC_SRC: {
                throw new UnsupportedOperationException();
            }
        }
        throw new AssertionError((Object)backend);
    }

    public Integer getValue(String memberName) {
        Descriptors.EnumValueDescriptor value = this.descriptor.findValueByName(memberName);
        if (value != null) {
            return value.getNumber();
        }
        return null;
    }

    public Descriptors.EnumDescriptor getDescriptor() {
        return this.descriptor;
    }

    public String getDescriptorExpression() {
        return this.getNameForBackend(SoyBackendKind.TOFU);
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    void doToProto(SoyTypeP.Builder builder) {
        builder.setProtoEnum(this.getName());
    }

    @Override
    public <T> T accept(SoyTypeVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SoyProtoEnumType that = (SoyProtoEnumType)o;
        return com.google.common.base.Objects.equal((Object)this.descriptor.getFullName(), (Object)that.descriptor.getFullName());
    }

    public int hashCode() {
        return Objects.hashCode(this.descriptor.getFullName());
    }
}

