/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.tofu.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.template.soy.base.SourceFilePath;
import com.google.template.soy.base.internal.SanitizedContentKind;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SoyRecord;
import com.google.template.soy.data.SoyTemplate;
import com.google.template.soy.data.SoyValueConverter;
import com.google.template.soy.data.SoyValueProvider;
import com.google.template.soy.data.UnsafeSanitizedContentOrdainer;
import com.google.template.soy.data.internal.ParamStore;
import com.google.template.soy.exprtree.TemplateLiteralNode;
import com.google.template.soy.msgs.SoyMsgBundle;
import com.google.template.soy.parseinfo.SoyTemplateInfo;
import com.google.template.soy.plugin.java.PluginInstances;
import com.google.template.soy.shared.SoyCssRenamingMap;
import com.google.template.soy.shared.SoyIdRenamingMap;
import com.google.template.soy.shared.internal.DelTemplateSelector;
import com.google.template.soy.shared.internal.SoyScopedData;
import com.google.template.soy.sharedpasses.render.EvalVisitorFactoryImpl;
import com.google.template.soy.sharedpasses.render.RenderException;
import com.google.template.soy.sharedpasses.render.RenderVisitor;
import com.google.template.soy.soytree.CallDelegateNode;
import com.google.template.soy.soytree.ConstNode;
import com.google.template.soy.soytree.ExternNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.TemplateDelegateNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.Visibility;
import com.google.template.soy.soytree.defn.TemplateParam;
import com.google.template.soy.tofu.SoyTofu;
import com.google.template.soy.tofu.SoyTofuException;
import com.google.template.soy.tofu.internal.NamespacedTofu;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;

public final class BaseTofu
implements SoyTofu {
    private final SoyScopedData.Enterable apiCallScope;
    private final ImmutableMap<String, TemplateNode> basicTemplates;
    private final DelTemplateSelector<TemplateDelegateNode> delTemplates;
    private final ImmutableTable<SourceFilePath, String, ConstNode> constants;
    private final ImmutableTable<SourceFilePath, String, ImmutableList<ExternNode>> externs;
    private final ImmutableMap<String, ImmutableSortedSet<String>> templateToIjParamsInfoMap;
    private final PluginInstances pluginInstances;

    public BaseTofu(SoyScopedData.Enterable apiCallScope, SoyFileSetNode fileSet, PluginInstances pluginInstances) {
        this.apiCallScope = apiCallScope;
        ImmutableMap.Builder basicTemplates = ImmutableMap.builder();
        DelTemplateSelector.Builder<TemplateDelegateNode> delTemplates = new DelTemplateSelector.Builder<TemplateDelegateNode>();
        ImmutableTable.Builder constants = ImmutableTable.builder();
        ImmutableTable.Builder externs = ImmutableTable.builder();
        for (SoyFileNode fileNode : fileSet.getChildren()) {
            for (ConstNode constNode : fileNode.getConstants()) {
                constants.put((Object)fileNode.getFilePath(), (Object)constNode.getVar().name(), (Object)constNode);
            }
            ArrayListMultimap externMap = ArrayListMultimap.create();
            for (ExternNode externNode : fileNode.getExterns()) {
                externMap.put((Object)externNode.getIdentifier().identifier(), (Object)externNode);
            }
            for (String externName : externMap.keySet()) {
                externs.put((Object)fileNode.getFilePath(), (Object)externName, (Object)ImmutableList.copyOf((Collection)externMap.get((Object)externName)));
            }
            for (TemplateNode template : fileNode.getTemplates()) {
                if (template instanceof TemplateDelegateNode) {
                    TemplateDelegateNode delegateNode = (TemplateDelegateNode)template;
                    String delTemplateName = delegateNode.getDelTemplateName();
                    String delPackageName = delegateNode.getDelPackageName();
                    String variant = delegateNode.getDelTemplateVariant();
                    if (delPackageName == null) {
                        delTemplates.addDefault(delTemplateName, variant, delegateNode);
                        continue;
                    }
                    delTemplates.add(delTemplateName, delPackageName, variant, delegateNode);
                    continue;
                }
                basicTemplates.put((Object)template.getTemplateName(), (Object)template);
            }
        }
        this.basicTemplates = basicTemplates.build();
        this.delTemplates = delTemplates.build();
        this.constants = constants.buildOrThrow();
        this.externs = externs.buildOrThrow();
        this.templateToIjParamsInfoMap = BaseTofu.buildTemplateToIjParamsInfoMap(this.basicTemplates, this.delTemplates);
        this.pluginInstances = pluginInstances;
    }

    private static ImmutableMap<String, ImmutableSortedSet<String>> buildTemplateToIjParamsInfoMap(ImmutableMap<String, TemplateNode> basicTemplates, DelTemplateSelector<TemplateDelegateNode> delTemplates) {
        LinkedHashMap<String, ImmutableSortedSet> templateNameToIjs = new LinkedHashMap<String, ImmutableSortedSet>();
        Set soFar = Sets.newIdentityHashSet();
        ArrayDeque<TemplateNode> toVisit = new ArrayDeque<TemplateNode>();
        HashSet<String> ijsForTemplate = new HashSet<String>();
        for (TemplateNode initialTemplate : Iterables.concat((Iterable)basicTemplates.values(), (Iterable)delTemplates.delTemplateNameToValues().values())) {
            TemplateNode currentTemplate;
            toVisit.add(initialTemplate);
            while ((currentTemplate = (TemplateNode)toVisit.poll()) != null) {
                if (!soFar.add(currentTemplate)) continue;
                ImmutableSortedSet alreadyCalculated = (ImmutableSortedSet)templateNameToIjs.get(currentTemplate.getTemplateName());
                if (alreadyCalculated != null) {
                    ijsForTemplate.addAll((Collection<String>)alreadyCalculated);
                    continue;
                }
                BaseTofu.collectIjParams(currentTemplate, ijsForTemplate);
                for (TemplateLiteralNode templateLiteralNode : SoyTreeUtils.getAllNodesOfType(currentTemplate, TemplateLiteralNode.class)) {
                    TemplateNode callee = (TemplateNode)basicTemplates.get((Object)templateLiteralNode.getResolvedName());
                    if (callee == null) continue;
                    toVisit.add(callee);
                }
                for (CallDelegateNode callDelegateNode : SoyTreeUtils.getAllNodesOfType(currentTemplate, CallDelegateNode.class)) {
                    toVisit.addAll((Collection<TemplateNode>)delTemplates.delTemplateNameToValues().get((Object)callDelegateNode.getDelCalleeName()));
                }
            }
            templateNameToIjs.put(initialTemplate.getTemplateName(), ImmutableSortedSet.copyOf(ijsForTemplate));
            ijsForTemplate.clear();
            toVisit.clear();
            soFar.clear();
        }
        return ImmutableMap.copyOf(templateNameToIjs);
    }

    private static void collectIjParams(TemplateNode template, Set<String> into) {
        for (TemplateParam param : template.getInjectedParams()) {
            into.add(param.name());
        }
    }

    @Override
    public Boolean hasTemplate(String namespace) {
        return this.basicTemplates.containsKey((Object)namespace);
    }

    @Override
    public SoyTofu forNamespace(@Nullable String namespace) {
        return namespace == null ? this : new NamespacedTofu(this, namespace);
    }

    @Override
    public RendererImpl newRenderer(SoyTemplateInfo templateInfo) {
        return new RendererImpl(this, templateInfo.getName(), null);
    }

    @Override
    public RendererImpl newRenderer(String templateName) {
        return new RendererImpl(this, templateName, null);
    }

    @Override
    public RendererImpl newRenderer(SoyTemplate params) {
        return new RendererImpl(this, params.getTemplateName(), params.getParamsAsMap());
    }

    @Override
    public ImmutableSortedSet<String> getUsedIjParamsForTemplate(SoyTemplateInfo templateInfo) {
        return this.getUsedIjParamsForTemplate(templateInfo.getName());
    }

    @Override
    public ImmutableSortedSet<String> getUsedIjParamsForTemplate(String templateName) {
        ImmutableSortedSet ijParams = (ImmutableSortedSet)this.templateToIjParamsInfoMap.get((Object)templateName);
        if (ijParams == null) {
            throw new SoyTofuException("Template '" + templateName + "' not found.");
        }
        return ijParams;
    }

    private TemplateNode renderMain(Appendable outputBuf, String templateName, @Nullable SoyRecord data, @Nullable SoyRecord ijData, @Nullable Predicate<String> activeDelPackageNames, @Nullable SoyMsgBundle msgBundle, @Nullable SoyIdRenamingMap idRenamingMap, @Nullable SoyCssRenamingMap cssRenamingMap, boolean debugSoyTemplateInfo, PluginInstances pluginInstances) {
        if (activeDelPackageNames == null) {
            activeDelPackageNames = arg -> false;
        }
        try (SoyScopedData.InScope inScope = this.apiCallScope.enter(msgBundle);){
            TemplateNode templateNode = this.renderMainHelper(outputBuf, templateName, data, ijData, activeDelPackageNames, msgBundle, idRenamingMap, cssRenamingMap, debugSoyTemplateInfo, pluginInstances);
            return templateNode;
        }
    }

    private TemplateNode renderMainHelper(Appendable outputBuf, String templateName, @Nullable SoyRecord data, @Nullable SoyRecord ijData, Predicate<String> activeDelPackageNames, @Nullable SoyMsgBundle msgBundle, @Nullable SoyIdRenamingMap idRenamingMap, @Nullable SoyCssRenamingMap cssRenamingMap, boolean debugSoyTemplateInfo, PluginInstances pluginInstances) {
        TemplateNode template = (TemplateNode)this.basicTemplates.get((Object)templateName);
        if (template == null) {
            throw new SoyTofuException("Attempting to render undefined template '" + templateName + "'.");
        }
        if (template.getVisibility() == Visibility.PRIVATE) {
            throw new SoyTofuException("Attempting to render private template '" + templateName + "'.");
        }
        if (data == null) {
            data = ParamStore.EMPTY_INSTANCE;
        }
        if (ijData == null) {
            ijData = ParamStore.EMPTY_INSTANCE;
        }
        try {
            RenderVisitor rv = new RenderVisitor(new EvalVisitorFactoryImpl(), outputBuf, this.basicTemplates, this.delTemplates, this.constants, this.externs, data, ijData, activeDelPackageNames, msgBundle, idRenamingMap, cssRenamingMap, debugSoyTemplateInfo, pluginInstances);
            rv.exec(template);
        }
        catch (RenderException re) {
            throw new SoyTofuException(re);
        }
        return template;
    }

    static class RendererImpl
    implements SoyTofu.Renderer {
        private final BaseTofu baseTofu;
        private final String templateName;
        private SoyRecord data;
        private SoyRecord ijData;
        private SoyMsgBundle msgBundle;
        private SoyIdRenamingMap idRenamingMap;
        private SoyCssRenamingMap cssRenamingMap;
        private Predicate<String> activeDelPackageNames;
        private SanitizedContent.ContentKind expectedContentKind;
        private boolean debugSoyTemplateInfo;
        private Map<String, Supplier<Object>> perRenderPluginInstances;
        private boolean dataSetInConstructor;

        RendererImpl(BaseTofu baseTofu, String templateName, Map<String, ?> data) {
            this.baseTofu = baseTofu;
            this.templateName = templateName;
            this.expectedContentKind = SanitizedContent.ContentKind.HTML;
            if (data != null) {
                this.setData((Map)data);
                this.dataSetInConstructor = true;
            }
        }

        private static ParamStore mapAsParamStore(Map<String, ?> source) {
            ParamStore dest = new ParamStore(source.size());
            for (Map.Entry<String, ?> entry : source.entrySet()) {
                SoyValueProvider value;
                String key = entry.getKey();
                try {
                    value = SoyValueConverter.INSTANCE.convert(entry.getValue());
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Unable to convert param " + key + " to a SoyValue", e);
                }
                dest.setField(key, value);
            }
            return dest;
        }

        @Override
        public RendererImpl setData(Map<String, ?> data) {
            Preconditions.checkState((!this.dataSetInConstructor ? 1 : 0) != 0, (Object)"May not call setData on a Renderer created from a TemplateParams");
            this.data = data != null ? RendererImpl.mapAsParamStore(data) : null;
            return this;
        }

        @Override
        public RendererImpl setData(SoyRecord data) {
            Preconditions.checkState((!this.dataSetInConstructor ? 1 : 0) != 0, (Object)"May not call setData on a Renderer created from a TemplateParams");
            this.data = data;
            return this;
        }

        @Override
        public RendererImpl setIjData(Map<String, ?> ijData) {
            this.ijData = ijData == null ? null : RendererImpl.mapAsParamStore(ijData);
            return this;
        }

        @Override
        public RendererImpl setIjData(SoyRecord ijData) {
            this.ijData = ijData;
            return this;
        }

        @Override
        public RendererImpl setPluginInstances(Map<String, Supplier<Object>> pluginInstances) {
            this.perRenderPluginInstances = (Map)Preconditions.checkNotNull(pluginInstances);
            return this;
        }

        @Override
        public RendererImpl setActiveDelegatePackageSelector(Predicate<String> activeDelegatePackageNames) {
            this.activeDelPackageNames = activeDelegatePackageNames;
            return this;
        }

        @Override
        public RendererImpl setMsgBundle(SoyMsgBundle msgBundle) {
            this.msgBundle = msgBundle;
            return this;
        }

        @Override
        public RendererImpl setIdRenamingMap(SoyIdRenamingMap idRenamingMap) {
            this.idRenamingMap = idRenamingMap;
            return this;
        }

        @Override
        public RendererImpl setCssRenamingMap(SoyCssRenamingMap cssRenamingMap) {
            this.cssRenamingMap = cssRenamingMap;
            return this;
        }

        @Override
        public RendererImpl setDebugSoyTemplateInfo(boolean debugSoyTemplateInfo) {
            this.debugSoyTemplateInfo = debugSoyTemplateInfo;
            return this;
        }

        @Override
        @Deprecated
        public String render() {
            StringBuilder sb = new StringBuilder();
            this.render(sb);
            return sb.toString();
        }

        @Override
        @Deprecated
        public SanitizedContent.ContentKind render(Appendable out) {
            TemplateNode template = this.baseTofu.renderMain(out, this.templateName, this.data, this.ijData, this.activeDelPackageNames, this.msgBundle, this.idRenamingMap, this.cssRenamingMap, this.debugSoyTemplateInfo, this.getPluginInstances());
            this.enforceContentKind(template);
            return SanitizedContent.ContentKind.valueOf(template.getContentKind().name());
        }

        private PluginInstances getPluginInstances() {
            if (this.perRenderPluginInstances != null) {
                return this.baseTofu.pluginInstances.combine(this.perRenderPluginInstances);
            }
            return this.baseTofu.pluginInstances;
        }

        @Override
        public void renderHtml(Appendable out) {
            this.renderSanitizedContent(SanitizedContent.ContentKind.HTML, out);
        }

        @Override
        public SanitizedContent renderHtml() {
            return this.renderSanitizedContent(SanitizedContent.ContentKind.HTML);
        }

        @Override
        public void renderJs(Appendable out) {
            this.renderSanitizedContent(SanitizedContent.ContentKind.JS, out);
        }

        @Override
        public SanitizedContent renderJs() {
            return this.renderSanitizedContent(SanitizedContent.ContentKind.JS);
        }

        @Override
        public void renderUri(Appendable out) {
            this.renderSanitizedContent(SanitizedContent.ContentKind.URI, out);
        }

        @Override
        public SanitizedContent renderUri() {
            return this.renderSanitizedContent(SanitizedContent.ContentKind.URI);
        }

        @Override
        public void renderTrustedResourceUri(Appendable out) {
            this.renderSanitizedContent(SanitizedContent.ContentKind.TRUSTED_RESOURCE_URI, out);
        }

        @Override
        public SanitizedContent renderTrustedResourceUri() {
            return this.renderSanitizedContent(SanitizedContent.ContentKind.TRUSTED_RESOURCE_URI);
        }

        @Override
        public void renderAttributes(Appendable out) {
            this.renderSanitizedContent(SanitizedContent.ContentKind.ATTRIBUTES, out);
        }

        @Override
        public SanitizedContent renderAttributes() {
            return this.renderSanitizedContent(SanitizedContent.ContentKind.ATTRIBUTES);
        }

        @Override
        public void renderCss(Appendable out) {
            this.renderSanitizedContent(SanitizedContent.ContentKind.CSS, out);
        }

        @Override
        public SanitizedContent renderCss() {
            return this.renderSanitizedContent(SanitizedContent.ContentKind.CSS);
        }

        @Override
        public void renderText(Appendable out) {
            this.renderMain(out);
        }

        @Override
        public String renderText() {
            StringBuilder sb = new StringBuilder();
            this.renderMain(sb);
            return sb.toString();
        }

        @Override
        @Deprecated
        public SanitizedContent renderStrict() {
            StringBuilder sb = new StringBuilder();
            TemplateNode template = this.baseTofu.renderMain(sb, this.templateName, this.data, this.ijData, this.activeDelPackageNames, this.msgBundle, this.idRenamingMap, this.cssRenamingMap, this.debugSoyTemplateInfo, this.getPluginInstances());
            this.enforceContentKind(template);
            return UnsafeSanitizedContentOrdainer.ordainAsSafe(sb.toString(), this.expectedContentKind);
        }

        private void renderSanitizedContent(SanitizedContent.ContentKind contentKind, Appendable out) {
            TemplateNode template = this.renderMain(out);
            RendererImpl.enforceContentKind(template, contentKind);
        }

        private SanitizedContent renderSanitizedContent(SanitizedContent.ContentKind contentKind) {
            StringBuilder sb = new StringBuilder();
            TemplateNode template = this.renderMain(sb);
            RendererImpl.enforceContentKind(template, contentKind);
            return UnsafeSanitizedContentOrdainer.ordainAsSafe(sb.toString(), contentKind);
        }

        private TemplateNode renderMain(Appendable out) {
            return this.baseTofu.renderMain(out, this.templateName, this.data, this.ijData, this.activeDelPackageNames, this.msgBundle, this.idRenamingMap, this.cssRenamingMap, this.debugSoyTemplateInfo, this.getPluginInstances());
        }

        private static void enforceContentKind(TemplateNode template, SanitizedContent.ContentKind expectedContentKind) {
            if (expectedContentKind == SanitizedContent.ContentKind.TEXT) {
                return;
            }
            Preconditions.checkNotNull((Object)((Object)template.getContentKind()));
            SanitizedContentKind expectedAsSanitizedContentKind = SanitizedContentKind.valueOf(expectedContentKind.name());
            if (expectedAsSanitizedContentKind != template.getContentKind()) {
                throw new SoyTofuException("Expected template '" + template.getTemplateName() + "' to be kind=\"" + expectedAsSanitizedContentKind.asAttributeValue() + "\" but was kind=\"" + template.getContentKind().asAttributeValue() + "\"");
            }
        }

        private void enforceContentKind(TemplateNode template) {
            RendererImpl.enforceContentKind(template, this.expectedContentKind);
        }
    }
}

