/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree.defn;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.exprtree.AbstractVarDefn;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.VarDefn;
import com.google.template.soy.soytree.defn.TemplateHeaderVarDefn;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.ast.NamedTypeNode;
import com.google.template.soy.types.ast.TypeNode;
import com.google.template.soy.types.ast.UnionTypeNode;
import javax.annotation.Nullable;

public class TemplateParam
extends AbstractVarDefn
implements TemplateHeaderVarDefn {
    private final TypeNode typeNode;
    private final TypeNode originalTypeNode;
    private String desc;
    private final SourceLocation sourceLocation;
    private final boolean isRequired;
    private final boolean isInjected;
    private final boolean isImplicit;
    private final boolean isExplicitlyOptional;
    @Nullable
    private final ExprRootNode defaultValue;

    public TemplateParam(String name, SourceLocation nameLocation, SourceLocation sourceLocation, @Nullable TypeNode typeNode, boolean isInjected, boolean isImplicit, boolean optional, @Nullable String desc, @Nullable ExprNode defaultValue) {
        super(name, nameLocation, null);
        this.originalTypeNode = typeNode;
        this.isInjected = isInjected;
        this.isImplicit = isImplicit;
        this.desc = desc;
        this.defaultValue = defaultValue == null ? null : new ExprRootNode(defaultValue);
        this.sourceLocation = sourceLocation;
        this.isExplicitlyOptional = optional;
        boolean isNullable = false;
        if (typeNode instanceof UnionTypeNode) {
            UnionTypeNode utn = (UnionTypeNode)typeNode;
            for (TypeNode tn : utn.candidates()) {
                if (!(tn instanceof NamedTypeNode) || !((NamedTypeNode)tn).name().identifier().equals("null")) continue;
                isNullable = true;
                break;
            }
        } else if (typeNode instanceof NamedTypeNode && ((NamedTypeNode)typeNode).name().identifier().equals("null")) {
            isNullable = true;
        }
        if (optional && !isNullable && typeNode != null) {
            NamedTypeNode nullType = NamedTypeNode.create(typeNode.sourceLocation(), "null");
            typeNode = typeNode instanceof UnionTypeNode ? UnionTypeNode.create((Iterable<TypeNode>)ImmutableList.builder().addAll(((UnionTypeNode)typeNode).candidates()).add((Object)nullType).build()) : UnionTypeNode.create((Iterable<TypeNode>)ImmutableList.of((Object)typeNode, (Object)nullType));
        }
        this.typeNode = typeNode;
        this.isRequired = defaultValue == null && !optional && !isNullable;
    }

    protected TemplateParam(TemplateParam param, CopyState copyState) {
        super(param);
        this.typeNode = param.typeNode == null ? null : param.typeNode.copy();
        this.isRequired = param.isRequired;
        this.isInjected = param.isInjected;
        this.isImplicit = param.isImplicit;
        this.sourceLocation = param.sourceLocation;
        this.desc = param.desc;
        this.isExplicitlyOptional = param.isExplicitlyOptional;
        this.defaultValue = param.defaultValue == null ? null : param.defaultValue.copy(copyState);
        this.originalTypeNode = param.originalTypeNode == null ? null : param.originalTypeNode.copy();
    }

    @Override
    public String refName() {
        return "$" + this.name();
    }

    @Override
    public SourceLocation getSourceLocation() {
        return this.sourceLocation;
    }

    @Override
    public void setType(SoyType type) {
        Preconditions.checkState((this.type == null ? 1 : 0) != 0, (Object)"type has already been assigned");
        this.type = (SoyType)Preconditions.checkNotNull((Object)type);
    }

    @Override
    public VarDefn.Kind kind() {
        return VarDefn.Kind.PARAM;
    }

    @Override
    public TypeNode getTypeNode() {
        return this.typeNode;
    }

    @Override
    public TypeNode getOriginalTypeNode() {
        return this.originalTypeNode;
    }

    @Override
    public boolean isInjected() {
        return this.isInjected;
    }

    public boolean isImplicit() {
        return this.isImplicit;
    }

    @Override
    public boolean isRequired() {
        return this.isRequired;
    }

    @Override
    public boolean isExplicitlyOptional() {
        return this.isExplicitlyOptional;
    }

    @Override
    @Nullable
    public String desc() {
        return this.desc;
    }

    @Override
    public void setDesc(String desc) {
        this.desc = desc;
    }

    @Override
    @Nullable
    public ExprRootNode defaultValue() {
        return this.defaultValue;
    }

    public boolean hasDefault() {
        return this.defaultValue != null;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "{name = " + this.name() + ", desc = " + this.desc + "}";
    }

    @Override
    public TemplateParam copy(CopyState copyState) {
        return new TemplateParam(this, copyState);
    }
}

