/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.template.soy.base.SourceFilePath;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.soytree.AbstractSoyNode;
import com.google.template.soy.soytree.CommandChar;
import com.google.template.soy.soytree.HtmlContext;
import com.google.template.soy.soytree.SoyNode;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public final class RawTextNode
extends AbstractSoyNode
implements HtmlContext.HtmlContextHolder,
SoyNode.StandaloneNode {
    private static final Pattern SPECIAL_CHARS_TO_ESCAPE = Pattern.compile("[\n\r\t{}\u00a0]");
    private static final ImmutableMap<String, String> SPECIAL_CHAR_TO_TAG = ImmutableMap.builder().put((Object)"\n", (Object)"{\\n}").put((Object)"\r", (Object)"{\\r}").put((Object)"\t", (Object)"{\\t}").put((Object)"{", (Object)"{lb}").put((Object)"}", (Object)"{rb}").put((Object)"\u00a0", (Object)"{nbsp}").buildOrThrow();
    private final String rawText;
    private final Optional<CommandChar> commandChar;
    private final Provenance provenance;
    @Nullable
    private final SourceOffsets offsets;
    @Nullable
    private HtmlContext htmlContext;

    public RawTextNode(int id, String rawText, SourceLocation sourceLocation) {
        this(id, rawText, Optional.empty(), sourceLocation, SourceOffsets.fromLocation(sourceLocation, rawText.length()), Provenance.NORMAL);
    }

    public RawTextNode(int id, String rawText, SourceLocation sourceLocation, SourceOffsets offsets) {
        this(id, rawText, Optional.empty(), sourceLocation, offsets, Provenance.NORMAL);
    }

    private RawTextNode(int id, String rawText, SourceLocation sourceLocation, SourceOffsets offsets, Provenance provenance) {
        this(id, rawText, Optional.empty(), sourceLocation, offsets, provenance);
    }

    private RawTextNode(int id, String rawText, Optional<CommandChar> commandChar, SourceLocation sourceLocation, @Nullable SourceOffsets offsets, Provenance provenance) {
        super(id, sourceLocation);
        this.rawText = rawText;
        this.commandChar = commandChar;
        this.provenance = provenance;
        this.offsets = offsets;
    }

    private RawTextNode(RawTextNode orig, CopyState copyState) {
        super(orig, copyState);
        this.rawText = orig.rawText;
        this.commandChar = orig.commandChar;
        this.provenance = orig.provenance;
        this.htmlContext = orig.htmlContext;
        this.offsets = orig.offsets;
    }

    public static RawTextNode newLiteral(int id, String rawText, SourceLocation loc) {
        SourceOffsets.Builder builder = new SourceOffsets.Builder();
        if (rawText.length() > 0) {
            builder.add(0, loc.getBeginLine(), loc.getBeginColumn(), SourceOffsets.Reason.NONE);
        }
        SourceOffsets offsets = builder.setEndLocation(loc.getEndLine(), loc.getEndColumn()).build(rawText.length(), SourceOffsets.Reason.LITERAL);
        return new RawTextNode(id, rawText, loc, offsets, Provenance.LITERAL);
    }

    public static RawTextNode newCommandCharNode(int id, CommandChar commandChar, SourceLocation loc) {
        SourceOffsets.Builder offsetsBuilder = new SourceOffsets.Builder();
        if (!commandChar.equals((Object)CommandChar.NIL)) {
            offsetsBuilder.add(0, loc.getBeginLine(), loc.getBeginColumn(), SourceOffsets.Reason.NONE);
        }
        SourceOffsets offsets = offsetsBuilder.setEndLocation(loc.getEndLine(), loc.getEndColumn()).build(commandChar.processedString().length(), SourceOffsets.Reason.COMMAND);
        return new RawTextNode(id, commandChar.processedString(), Optional.of(commandChar), loc, offsets, Provenance.COMMAND_CHARACTER);
    }

    @Override
    public HtmlContext getHtmlContext() {
        return (HtmlContext)((Object)Preconditions.checkNotNull((Object)((Object)this.htmlContext), (Object)"Cannot access HtmlContext before HtmlContextVisitor"));
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.RAW_TEXT_NODE;
    }

    public void setHtmlContext(HtmlContext value) {
        this.htmlContext = value;
    }

    public String getRawText() {
        return this.rawText;
    }

    public boolean isEmpty() {
        return this.rawText.isEmpty();
    }

    public Provenance getProvenance() {
        return this.provenance;
    }

    public boolean isCommandCharacter() {
        return this.provenance.equals((Object)Provenance.COMMAND_CHARACTER);
    }

    public boolean isNilCommandChar() {
        return this.commandChar.isPresent() && this.commandChar.get().equals((Object)CommandChar.NIL);
    }

    public CommandChar getCommandChar() {
        return this.commandChar.get();
    }

    public boolean missingWhitespaceAt(int index) {
        return this.offsets == null ? false : this.offsets.getReasonAt(index) == SourceOffsets.Reason.WHITESPACE;
    }

    public boolean commandAt(int index) {
        return this.offsets == null ? false : this.offsets.getReasonAt(index) == SourceOffsets.Reason.COMMAND;
    }

    @Nullable
    public SourceOffsets.Reason getReasonAt(int index) {
        return this.offsets == null ? null : this.offsets.getReasonAt(index);
    }

    public SourceLocation.Point locationOf(int i) {
        Preconditions.checkElementIndex((int)i, (int)this.rawText.length(), (String)"index");
        if (this.offsets == null) {
            return SourceLocation.Point.UNKNOWN_POINT;
        }
        return this.offsets.getPoint(this.rawText, i);
    }

    public SourceLocation substringLocation(int start, int end) {
        Preconditions.checkElementIndex((int)start, (int)this.rawText.length(), (String)"start");
        Preconditions.checkArgument((start < end ? 1 : 0) != 0);
        Preconditions.checkArgument((end <= this.rawText.length() ? 1 : 0) != 0);
        if (this.offsets == null) {
            return this.getSourceLocation();
        }
        return new SourceLocation(this.getSourceLocation().getFilePath(), this.offsets.getPoint(this.rawText, start), this.offsets.getPoint(this.rawText, end - 1));
    }

    public RawTextNode substring(int newId, int start) {
        return this.substring(newId, start, this.rawText.length());
    }

    public RawTextNode substring(int newId, int start, int end) {
        Preconditions.checkArgument((start >= 0 ? 1 : 0) != 0, (String)"start (%s) should be greater than or equal to 0", (int)start);
        Preconditions.checkArgument((start < end ? 1 : 0) != 0, (String)"start (%s) should be less that end (%s)", (int)start, (int)end);
        Preconditions.checkArgument((end <= this.rawText.length() ? 1 : 0) != 0, (String)"end (%s) should be less than or equal to the length (%s)", (int)end, (int)this.rawText.length());
        if (start == 0 && end == this.rawText.length()) {
            return this;
        }
        String newText = this.rawText.substring(start, end);
        SourceOffsets newOffsets = null;
        SourceLocation newLocation = this.getSourceLocation();
        if (this.offsets != null) {
            newOffsets = this.offsets.substring(start, end, this.rawText);
            newLocation = newOffsets.getSourceLocation(this.getSourceLocation().getFilePath());
        }
        return new RawTextNode(newId, newText, newLocation, newOffsets, this.provenance == Provenance.LITERAL ? Provenance.LITERAL_SUBSTRING : Provenance.NORMAL);
    }

    public static RawTextNode concat(List<RawTextNode> nodes) {
        Preconditions.checkArgument((!nodes.isEmpty() ? 1 : 0) != 0);
        if (nodes.size() == 1) {
            return nodes.get(0);
        }
        int id = nodes.get(0).getId();
        int numChars = 0;
        int numOffsets = 0;
        for (RawTextNode node : nodes) {
            numChars += node.getRawText().length();
            if (numOffsets != -1 && node.offsets != null) {
                numOffsets += node.isEmpty() ? 0 : node.offsets.indexes.length - 1;
                continue;
            }
            numOffsets = -1;
        }
        char[] chars = new char[numChars];
        int charsIndex = 0;
        int[] indexes = null;
        int[] lines = null;
        int[] columns = null;
        SourceOffsets.Reason[] reasons = null;
        int offsetsIndex = 0;
        if (numOffsets > 0) {
            indexes = new int[numOffsets + 1];
            lines = new int[numOffsets + 1];
            columns = new int[numOffsets + 1];
            reasons = new SourceOffsets.Reason[numOffsets + 1];
        }
        for (int i = 0; i < nodes.size(); ++i) {
            RawTextNode node = nodes.get(i);
            String text = node.getRawText();
            text.getChars(0, text.length(), chars, charsIndex);
            if (indexes != null && !text.isEmpty()) {
                SourceOffsets offsets = node.offsets;
                int amountToCopy = offsets.indexes.length;
                if (i < nodes.size() - 1) {
                    --amountToCopy;
                }
                System.arraycopy(offsets.lines, 0, lines, offsetsIndex, amountToCopy);
                System.arraycopy(offsets.columns, 0, columns, offsetsIndex, amountToCopy);
                System.arraycopy(offsets.reasons, 0, reasons, offsetsIndex, amountToCopy);
                if (offsets.reasons[0] == SourceOffsets.Reason.NONE && i > 0) {
                    SourceOffsets.Reason[] prevReasons = nodes.get((int)(i - 1)).offsets.reasons;
                    reasons[offsetsIndex] = prevReasons[prevReasons.length - 1];
                }
                for (int indexIndex = 0; indexIndex < amountToCopy; ++indexIndex) {
                    indexes[indexIndex + offsetsIndex] = offsets.indexes[indexIndex] + charsIndex;
                }
                offsetsIndex += amountToCopy;
            }
            charsIndex += text.length();
        }
        String text = new String(chars);
        SourceLocation location = nodes.get(0).getSourceLocation().extend(((RawTextNode)Iterables.getLast(nodes)).getSourceLocation());
        return new RawTextNode(id, text, location, indexes == null ? null : new SourceOffsets(indexes, lines, columns, reasons), Provenance.CONCATENATED);
    }

    @Override
    public String toSourceString() {
        if (this.provenance.equals((Object)Provenance.COMMAND_CHARACTER)) {
            return this.commandChar.get().sourceString();
        }
        StringBuffer sb = new StringBuffer();
        if (this.provenance == Provenance.LITERAL) {
            sb.append("{literal}").append(this.rawText).append("{/literal}");
        } else {
            Matcher matcher = SPECIAL_CHARS_TO_ESCAPE.matcher(this.rawText);
            while (matcher.find()) {
                String specialCharTag = (String)SPECIAL_CHAR_TO_TAG.get((Object)matcher.group());
                matcher.appendReplacement(sb, Matcher.quoteReplacement(specialCharTag));
            }
            matcher.appendTail(sb);
        }
        return sb.toString();
    }

    @Override
    public SoyNode.ParentSoyNode<SoyNode.StandaloneNode> getParent() {
        return super.getParent();
    }

    @Override
    public RawTextNode copy(CopyState copyState) {
        return new RawTextNode(this, copyState);
    }

    public static final class SourceOffsets {
        private final int[] indexes;
        private final int[] columns;
        private final int[] lines;
        private final Reason[] reasons;

        @Nullable
        static SourceOffsets fromLocation(SourceLocation location, int length) {
            if (!location.isKnown()) {
                return null;
            }
            Builder builder = new Builder();
            if (length > 0) {
                builder.add(0, location.getBeginLine(), location.getBeginColumn(), Reason.NONE);
            }
            return builder.setEndLocation(location.getEndLine(), location.getEndColumn()).build(length, Reason.NONE);
        }

        private SourceOffsets(int[] indexes, int[] lines, int[] columns, Reason[] reasons) {
            this.indexes = (int[])Preconditions.checkNotNull((Object)indexes);
            int prev = -1;
            for (int index : indexes) {
                if (index <= prev) {
                    throw new IllegalArgumentException("expected indexes to be monotonically increasing, got: " + Arrays.toString(indexes));
                }
                prev = index;
            }
            this.lines = (int[])Preconditions.checkNotNull((Object)lines);
            this.columns = (int[])Preconditions.checkNotNull((Object)columns);
            this.reasons = (Reason[])Preconditions.checkNotNull((Object)reasons);
        }

        SourceLocation.Point getPoint(String text, int textIndex) {
            int location = Arrays.binarySearch(this.indexes, textIndex);
            if (location < 0) {
                location = -(location + 1);
            }
            if (this.indexes[location] == textIndex) {
                return SourceLocation.Point.create(this.lines[location], this.columns[location]);
            }
            return this.getLocationOf(text, location - 1, textIndex);
        }

        Reason getReasonAt(int index) {
            Preconditions.checkElementIndex((int)index, (int)(this.indexes[this.indexes.length - 1] + 1));
            int location = Arrays.binarySearch(this.indexes, index);
            if (location < 0) {
                return Reason.NONE;
            }
            return this.reasons[location];
        }

        private SourceLocation.Point getLocationOf(String text, int startLocation, int textIndex) {
            int start;
            int line = this.lines[startLocation];
            int column = this.columns[startLocation];
            for (int i = start = this.indexes[startLocation]; i < textIndex; ++i) {
                char c = text.charAt(i);
                if (c == '\n') {
                    ++line;
                    column = 1;
                    continue;
                }
                if (c == '\r') {
                    if (i + 1 < text.length() && text.charAt(i + 1) == '\n') {
                        ++i;
                    }
                    ++line;
                    column = 1;
                    continue;
                }
                ++column;
            }
            return SourceLocation.Point.create(line, column);
        }

        SourceOffsets substring(int startTextIndex, int endTextIndex, String text) {
            Reason startReason;
            int startColumn;
            int startLine;
            Preconditions.checkArgument((startTextIndex >= 0 ? 1 : 0) != 0);
            Preconditions.checkArgument((startTextIndex < endTextIndex ? 1 : 0) != 0);
            Preconditions.checkArgument((endTextIndex <= text.length() ? 1 : 0) != 0);
            int substringLength = endTextIndex - startTextIndex;
            --endTextIndex;
            int startLocation = Arrays.binarySearch(this.indexes, startTextIndex);
            if (startLocation < 0) {
                startLocation = -(startLocation + 1);
            }
            Builder builder = new Builder();
            if (this.indexes[startLocation] == startTextIndex) {
                startLine = this.lines[startLocation];
                startColumn = this.columns[startLocation];
                startReason = this.reasons[startLocation];
            } else {
                SourceLocation.Point startPoint = this.getLocationOf(text, --startLocation, startTextIndex);
                startLine = startPoint.line();
                startColumn = startPoint.column();
                startReason = Reason.NONE;
            }
            builder.doAdd(0, startLine, startColumn, startReason);
            if (startTextIndex == endTextIndex) {
                builder.setEndLocation(startLine, startColumn);
                Reason afterLastCharacter = endTextIndex + 1 == text.length() ? this.getReasonAt(text.length()) : startReason;
                return builder.build(substringLength, afterLastCharacter);
            }
            int i = startLocation + 1;
            Reason endReason = Reason.NONE;
            while (true) {
                int index;
                if ((index = this.indexes[i]) < endTextIndex) {
                    builder.doAdd(index - startTextIndex, this.lines[i], this.columns[i], this.reasons[i]);
                } else {
                    if (index == endTextIndex) {
                        builder.setEndLocation(this.lines[i], this.columns[i]);
                        endReason = this.reasons[i];
                        break;
                    }
                    if (index > endTextIndex) {
                        SourceLocation.Point endPoint = this.getLocationOf(text, i - 1, endTextIndex);
                        builder.setEndLocation(endPoint.line(), endPoint.column());
                        break;
                    }
                }
                ++i;
            }
            if (endTextIndex + 1 == text.length()) {
                endReason = this.getReasonAt(text.length());
            }
            return builder.build(substringLength, endReason);
        }

        public SourceLocation getSourceLocation(SourceFilePath filePath) {
            return new SourceLocation(filePath, this.lines[0], this.columns[0], this.lines[this.lines.length - 1], this.columns[this.columns.length - 1]);
        }

        public String toString() {
            return String.format("SourceOffsets{\n  index:\t%s\n  lines:\t%s\n   cols:\t%s\n}", Arrays.toString(this.indexes), Arrays.toString(this.lines), Arrays.toString(this.columns));
        }

        public static final class Builder {
            private int size;
            private int[] indexes = new int[16];
            private int[] lines = new int[16];
            private int[] columns = new int[16];
            private Reason[] reasons = new Reason[16];
            private int endLine = -1;
            private int endCol = -1;

            public Builder add(int index, int startLine, int startCol, Reason reason) {
                Preconditions.checkArgument((index >= 0 ? 1 : 0) != 0, (String)"expected index to be non-negative: %s", (int)index);
                Preconditions.checkArgument((startLine > 0 ? 1 : 0) != 0, (String)"expected startLine to be positive: %s", (int)startLine);
                Preconditions.checkArgument((startCol > 0 ? 1 : 0) != 0, (String)"expected startCol to be positive: %s", (int)startCol);
                if (this.size != 0 && index <= this.indexes[this.size - 1]) {
                    throw new IllegalArgumentException(String.format("expected indexes to be added in increasing order: %d vs %d at %d:%d - %d:%d", index, this.indexes[this.size - 1], startLine, startCol, this.endLine, this.endCol));
                }
                this.doAdd(index, startLine, startCol, reason);
                return this;
            }

            public Builder setEndLocation(int endLine, int endCol) {
                Preconditions.checkArgument((endLine > 0 ? 1 : 0) != 0, (String)"expected endLine to be positive: %s", (int)endLine);
                Preconditions.checkArgument((endCol > 0 ? 1 : 0) != 0, (String)"expected endCol to be positive: %s", (int)endCol);
                this.endLine = endLine;
                this.endCol = endCol;
                return this;
            }

            public Builder delete(int from) {
                int location = Arrays.binarySearch(this.indexes, 0, this.size, from);
                if (location < 0) {
                    location = -(location + 1);
                }
                this.size = location;
                return this;
            }

            public boolean isEmpty() {
                return this.size == 0;
            }

            public int endLine() {
                return this.endLine;
            }

            public int endColumn() {
                return this.endCol;
            }

            private void doAdd(int index, int line, int col, Reason reason) {
                if (this.size == this.indexes.length) {
                    int newCapacity = this.size + (this.size >> 1);
                    this.indexes = Arrays.copyOf(this.indexes, newCapacity);
                    this.lines = Arrays.copyOf(this.lines, newCapacity);
                    this.columns = Arrays.copyOf(this.columns, newCapacity);
                    this.reasons = Arrays.copyOf(this.reasons, newCapacity);
                }
                this.indexes[this.size] = index;
                this.lines[this.size] = line;
                this.columns[this.size] = col;
                this.reasons[this.size] = reason;
                ++this.size;
            }

            public SourceOffsets build(int length, Reason reason) {
                this.doAdd(length, this.endLine, this.endCol, reason);
                Preconditions.checkArgument((this.size > 0 ? 1 : 0) != 0, (Object)"The builder should be non-empty");
                Preconditions.checkArgument((this.indexes[0] == 0 ? 1 : 0) != 0, (String)"expected first index to be zero, got: %s", (int)this.indexes[0]);
                SourceOffsets built = new SourceOffsets(Arrays.copyOf(this.indexes, this.size), Arrays.copyOf(this.lines, this.size), Arrays.copyOf(this.columns, this.size), Arrays.copyOf(this.reasons, this.size));
                --this.size;
                return built;
            }
        }

        public static enum Reason {
            COMMAND,
            LITERAL,
            COMMENT,
            WHITESPACE,
            NONE;

        }
    }

    public static enum Provenance {
        NORMAL,
        COMMAND_CHARACTER,
        LITERAL,
        LITERAL_SUBSTRING,
        CONCATENATED;

    }
}

