/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Streams;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.types.DelegatingSoyTypeRegistry;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypeRegistry;
import com.google.template.soy.types.SoyTypes;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public final class ImportsContext {
    private SoyTypeRegistry typeRegistry = null;
    private final Set<String> allImportedSymbols = new LinkedHashSet<String>();

    public boolean addImportedSymbol(String symbol) {
        return this.allImportedSymbols.add(symbol);
    }

    public void setTypeRegistry(SoyTypeRegistry typeRegistry) {
        Preconditions.checkState((this.typeRegistry == null ? 1 : 0) != 0, (Object)"Type registry is already set; cannot be overwritten.");
        this.typeRegistry = typeRegistry;
    }

    public SoyTypeRegistry getTypeRegistry() {
        return (SoyTypeRegistry)Preconditions.checkNotNull((Object)this.typeRegistry, (Object)"Type registry has not been set yet.");
    }

    public static final class ImportsTypeRegistry
    extends DelegatingSoyTypeRegistry {
        private final ImmutableMap<String, String> msgAndEnumLocalToFqn;
        private final ImmutableMap<String, String> allLocalToFqn;

        public ImportsTypeRegistry(SoyTypeRegistry delegate, ImmutableMap<String, String> msgAndEnumLocalToFqn, ImmutableMap<String, String> allLocalToFqn) {
            super(delegate);
            this.msgAndEnumLocalToFqn = msgAndEnumLocalToFqn;
            this.allLocalToFqn = allLocalToFqn;
        }

        @Override
        @Nullable
        public SoyType getType(String typeName) {
            String fullType = SoyTypes.localToFqn(typeName, this.msgAndEnumLocalToFqn);
            return fullType != null ? this.getProtoRegistry().getProtoType(fullType) : super.getType(typeName);
        }

        @Override
        public Identifier resolve(Identifier id) {
            String resolved = SoyTypes.localToFqn(id.identifier(), this.allLocalToFqn);
            if (resolved != null) {
                return Identifier.create(resolved, id.originalName(), id.location());
            }
            return super.resolve(id);
        }

        @Override
        public Iterable<String> getAllSortedTypeNames() {
            return () -> Streams.concat((Stream[])new Stream[]{this.msgAndEnumLocalToFqn.keySet().stream(), Streams.stream(super.getAllSortedTypeNames())}).sorted().iterator();
        }
    }
}

