/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceFilePath;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.soytree.AbstractSoyNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.defn.ImportedVar;
import com.google.template.soy.types.SoyType;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;

public final class ImportNode
extends AbstractSoyNode {
    private final ImmutableList<ImportedVar> identifiers;
    private final StringNode path;
    private ImportType importType;
    private SoyType moduleType;

    public ImportNode(int id, SourceLocation location, StringNode path, List<ImportedVar> defns) {
        super(id, location);
        this.identifiers = ImmutableList.copyOf(defns);
        this.path = path;
        this.importType = ImportType.UNKNOWN;
        for (ImportedVar defn : this.identifiers) {
            defn.onParentInit(this.getSourceFilePath());
        }
    }

    private ImportNode(ImportNode orig, CopyState copyState) {
        super(orig, copyState);
        this.identifiers = (ImmutableList)orig.identifiers.stream().map(prev -> {
            ImportedVar next = prev.copy(copyState);
            copyState.updateRefs(prev, next);
            return next;
        }).collect(ImmutableList.toImmutableList());
        this.path = orig.path.copy(copyState);
        this.importType = orig.importType;
        this.moduleType = orig.moduleType;
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.IMPORT_NODE;
    }

    @Override
    public ImportNode copy(CopyState copyState) {
        return new ImportNode(this, copyState);
    }

    public void setImportType(ImportType importType) {
        this.importType = importType;
    }

    public ImportType getImportType() {
        return this.importType;
    }

    public String getPath() {
        return this.path.getValue();
    }

    public SourceFilePath getSourceFilePath() {
        return SourceFilePath.create(this.path.getValue());
    }

    public boolean isModuleImport() {
        return this.identifiers.size() == 1 && ((ImportedVar)this.identifiers.get(0)).isModuleImport();
    }

    public String getModuleAlias() {
        Preconditions.checkState((boolean)this.isModuleImport(), (Object)"Module alias can only be retrieved for module imports (e.g. \"import * as fooTemplates from 'my_foo.soy';\")");
        return ((ImportedVar)this.identifiers.get(0)).name();
    }

    public SoyType getModuleType() {
        return this.moduleType;
    }

    public void setModuleType(SoyType moduleType) {
        Preconditions.checkState((!this.isModuleImport() ? 1 : 0) != 0);
        this.moduleType = moduleType;
    }

    public SourceLocation getPathSourceLocation() {
        return this.path.getSourceLocation();
    }

    public ImmutableList<ImportedVar> getIdentifiers() {
        return this.identifiers;
    }

    @Override
    public String toSourceString() {
        String exprs = "";
        if (!this.identifiers.isEmpty()) {
            exprs = String.format("{%s} from ", this.identifiers.stream().map(i -> i.isAliased() ? i.getSymbol() + " as " + i.name() : i.name()).collect(Collectors.joining(",")));
        }
        return String.format("import %s'%s'", exprs, this.path.getValue());
    }

    public void visitVars(BiConsumer<ImportedVar, SoyType> visitor) {
        this.getIdentifiers().forEach(id -> ImportNode.visitVars(id, this.getModuleType(), visitor));
    }

    private static void visitVars(ImportedVar id, SoyType parentType, BiConsumer<ImportedVar, SoyType> visitor) {
        visitor.accept(id, parentType);
        id.getNestedTypes().forEach(nestedType -> ImportNode.visitVars(id.nested((String)nestedType), id.typeOrDefault(null), visitor));
    }

    public static enum ImportType {
        PROTO,
        TEMPLATE,
        UNKNOWN;

    }
}

