/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Preconditions;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.soytree.AbstractParentSoyNode;
import com.google.template.soy.soytree.HtmlContext;
import com.google.template.soy.soytree.IfElseNode;
import com.google.template.soy.soytree.SoyNode;
import javax.annotation.Nullable;

public final class IfNode
extends AbstractParentSoyNode<SoyNode.BlockNode>
implements HtmlContext.HtmlContextHolder,
SoyNode.StandaloneNode,
SoyNode.SplitLevelTopNode<SoyNode.BlockNode>,
SoyNode.StatementNode {
    @Nullable
    private HtmlContext htmlContext;
    private final SourceLocation closeTagLocation;

    public IfNode(int id, SourceLocation closeTagLocation, SourceLocation sourceLocation) {
        super(id, sourceLocation);
        this.closeTagLocation = closeTagLocation;
    }

    public IfNode(int id, SourceLocation sourceLocation) {
        super(id, sourceLocation);
        this.closeTagLocation = SourceLocation.UNKNOWN;
    }

    private IfNode(IfNode orig, CopyState copyState) {
        super(orig, copyState);
        this.htmlContext = orig.htmlContext;
        this.closeTagLocation = orig.closeTagLocation;
    }

    @Override
    public HtmlContext getHtmlContext() {
        return (HtmlContext)((Object)Preconditions.checkNotNull((Object)((Object)this.htmlContext), (Object)"Cannot access HtmlContext before HtmlContextVisitor or InferenceEngine."));
    }

    public void setHtmlContext(HtmlContext value) {
        this.htmlContext = value;
    }

    public SourceLocation getCloseTagLocation() {
        return this.closeTagLocation;
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.IF_NODE;
    }

    public boolean hasElse() {
        return this.getChild(this.numChildren() - 1) instanceof IfElseNode;
    }

    @Override
    public String toSourceString() {
        StringBuilder sb = new StringBuilder();
        this.appendSourceStringForChildren(sb);
        sb.append("{/if}");
        return sb.toString();
    }

    @Override
    public SoyNode.ParentSoyNode<SoyNode.StandaloneNode> getParent() {
        return super.getParent();
    }

    @Override
    public IfNode copy(CopyState copyState) {
        return new IfNode(this, copyState);
    }
}

