/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soyparse;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.template.soy.base.SourceFilePath;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.BaseUtils;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.base.internal.QuoteStyle;
import com.google.template.soy.basetree.Node;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.AbstractPrimitiveNode;
import com.google.template.soy.exprtree.BooleanNode;
import com.google.template.soy.exprtree.CallableExprBuilder;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.FieldAccessNode;
import com.google.template.soy.exprtree.FloatNode;
import com.google.template.soy.exprtree.GroupNode;
import com.google.template.soy.exprtree.IntegerNode;
import com.google.template.soy.exprtree.ItemAccessNode;
import com.google.template.soy.exprtree.ListComprehensionNode;
import com.google.template.soy.exprtree.ListLiteralNode;
import com.google.template.soy.exprtree.MapLiteralFromListNode;
import com.google.template.soy.exprtree.MapLiteralNode;
import com.google.template.soy.exprtree.NullNode;
import com.google.template.soy.exprtree.Operator;
import com.google.template.soy.exprtree.RecordLiteralNode;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.exprtree.TemplateLiteralNode;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.exprtree.VeLiteralNode;
import com.google.template.soy.soyparse.CallArgs;
import com.google.template.soy.soyparse.HtmlRewriter;
import com.google.template.soy.soyparse.ParseErrors;
import com.google.template.soy.soyparse.ParseException;
import com.google.template.soy.soyparse.RawTextBuilder;
import com.google.template.soy.soyparse.SimpleCharStream;
import com.google.template.soy.soyparse.SoyFileParserConstants;
import com.google.template.soy.soyparse.SoyFileParserTokenManager;
import com.google.template.soy.soyparse.SoyParseUtils;
import com.google.template.soy.soyparse.SoySimpleCharStream;
import com.google.template.soy.soyparse.Token;
import com.google.template.soy.soyparse.TokenMgrError;
import com.google.template.soy.soyparse.Tokens;
import com.google.template.soy.soytree.AbstractBlockCommandNode;
import com.google.template.soy.soytree.AbstractCommandNode;
import com.google.template.soy.soytree.AbstractParentCommandNode;
import com.google.template.soy.soytree.AbstractSoyNode;
import com.google.template.soy.soytree.AliasDeclaration;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.CallDelegateNode;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.CallParamNode;
import com.google.template.soy.soytree.CallParamValueNode;
import com.google.template.soy.soytree.CaseOrDefaultNode;
import com.google.template.soy.soytree.CommandTagAttribute;
import com.google.template.soy.soytree.Comment;
import com.google.template.soy.soytree.ConstNode;
import com.google.template.soy.soytree.DebuggerNode;
import com.google.template.soy.soytree.DelPackageDeclaration;
import com.google.template.soy.soytree.ExternImplNode;
import com.google.template.soy.soytree.ExternNode;
import com.google.template.soy.soytree.ForIfemptyNode;
import com.google.template.soy.soytree.ForNode;
import com.google.template.soy.soytree.ForNonemptyNode;
import com.google.template.soy.soytree.IfCondNode;
import com.google.template.soy.soytree.IfElseNode;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.ImportNode;
import com.google.template.soy.soytree.JavaImplNode;
import com.google.template.soy.soytree.JsImplNode;
import com.google.template.soy.soytree.KeyNode;
import com.google.template.soy.soytree.LetContentNode;
import com.google.template.soy.soytree.LetNode;
import com.google.template.soy.soytree.LetValueNode;
import com.google.template.soy.soytree.LogNode;
import com.google.template.soy.soytree.MsgFallbackGroupNode;
import com.google.template.soy.soytree.MsgNode;
import com.google.template.soy.soytree.MsgPluralCaseNode;
import com.google.template.soy.soytree.MsgPluralDefaultNode;
import com.google.template.soy.soytree.MsgPluralNode;
import com.google.template.soy.soytree.MsgSelectCaseNode;
import com.google.template.soy.soytree.MsgSelectDefaultNode;
import com.google.template.soy.soytree.MsgSelectNode;
import com.google.template.soy.soytree.NamespaceDeclaration;
import com.google.template.soy.soytree.PrintDirectiveNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SkipNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SwitchCaseNode;
import com.google.template.soy.soytree.SwitchDefaultNode;
import com.google.template.soy.soytree.SwitchNode;
import com.google.template.soy.soytree.TemplateBasicNodeBuilder;
import com.google.template.soy.soytree.TemplateDelegateNodeBuilder;
import com.google.template.soy.soytree.TemplateElementNodeBuilder;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.TemplateNodeBuilder;
import com.google.template.soy.soytree.VeLogNode;
import com.google.template.soy.soytree.WhitespaceMode;
import com.google.template.soy.soytree.defn.AttrParam;
import com.google.template.soy.soytree.defn.ImportedVar;
import com.google.template.soy.soytree.defn.TemplateHeaderVarDefn;
import com.google.template.soy.soytree.defn.TemplateParam;
import com.google.template.soy.soytree.defn.TemplateStateVar;
import com.google.template.soy.types.TemplateType;
import com.google.template.soy.types.ast.FunctionTypeNode;
import com.google.template.soy.types.ast.GenericTypeNode;
import com.google.template.soy.types.ast.NamedTypeNode;
import com.google.template.soy.types.ast.RecordTypeNode;
import com.google.template.soy.types.ast.TemplateTypeNode;
import com.google.template.soy.types.ast.TypeNode;
import com.google.template.soy.types.ast.UnionTypeNode;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;

public class SoyFileParser
implements SoyFileParserConstants {
    private static final SoyErrorKind INVALID_ALIAS_NAME = SoyErrorKind.of("An alias must be a single identifier. Found ''{0}''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind INVALID_CALLEE_NAME = SoyErrorKind.of("Invalid callee name ''{0}''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind INVALID_TEMPLATE_NAME = SoyErrorKind.of("Template name ''{0}'' must be relative to the file namespace, i.e. a dot followed by an identifier.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind PLURAL_AND_SELECT_NOT_ALLOWED_INSIDE_PLURAL_BLOCK = SoyErrorKind.of("Tags ''plural'' and ''select'' are not allowed inside ''plural'' blocks.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind PLURAL_CASE_OUT_OF_BOUNDS = SoyErrorKind.of("Plural case ''{0}'' must be a nonnegative integer.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind PLURAL_CASE_MALFORMED = SoyErrorKind.of("Invalid number in ''plural case'' command text.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind UNEXPECTED_CONTENT_AFTER = SoyErrorKind.of("Unexpected content after ''{0}'', expected only comments or whitespace.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind UNEXPECTED_CONTENT_BEFORE = SoyErrorKind.of("Unexpected content before ''{0}'', expected only comments or whitespace.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind INJECT_DEFAULT_PARAM = SoyErrorKind.of("Default parameters are not supported on injected parameters.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind OPTIONAL_DEFAULT_PARAM = SoyErrorKind.of("Default parameters are not supported on optional parameters. Did you mean '''{@param ...}'''?", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind STATE_IN_TEMPLATE = SoyErrorKind.of("@state declarations are only allowed in elements.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind STATE_REQUIRES_VALUE = SoyErrorKind.of("@state declarations require an initial value.", new SoyErrorKind.StyleAllowance[0]);
    static final SoyErrorKind DUPLICATE_KEY_NAME = SoyErrorKind.of("Duplicate argument ''{0}''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind INVALID_RECORD_KEY = SoyErrorKind.of("Invalid record key ''{0}''. A record key must be a valid Soy identifier. Did you mean to use a map?", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind INTEGER_OUT_OF_RANGE = SoyErrorKind.of("Soy integers are constrained to the range of JavaScript integers: https://www.ecma-international.org/ecma-262/5.1/#sec-8.5", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind INVALID_PARAM_NAME = SoyErrorKind.of("Invalid param name ''{0}''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind UNEXPECTED_PIPE = SoyErrorKind.of("Unexpected ''|''. Print directives should not have whitespace after ''|''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind EMPTY_RECORD_LITERAL = SoyErrorKind.of("Empty record literal.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind RECORD_NAMED_PARAMS = SoyErrorKind.of("Record literals require named parameters.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind EMPTY_RECORD_TYPE = SoyErrorKind.of("Empty record type.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind LEGACY_NOT_ERROR = SoyErrorKind.of("Found use of ''!'' instead of the ''not'' operator.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind MULTIPLE_IMPLS = SoyErrorKind.of("An extern can only have one implementation per language.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind PARSER_ERROR = SoyErrorKind.of("parse error at ''{0}'': expected {1}", SoyErrorKind.StyleAllowance.NO_CAPS, SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final ImmutableSet<String> EXPR_ATTR_NAMES = ImmutableSet.of((Object)"data", (Object)"genders", (Object)"key", (Object)"logonly", (Object)"variant");
    private IdGenerator nodeIdGen;
    public SourceFilePath filePath;
    private WhitespaceMode whitespaceMode = WhitespaceMode.JOIN;
    private ErrorReporter errorReporter;
    private TemplateNode.SoyFileHeaderInfo headerInfo;
    public List<String> importSymbols = new ArrayList<String>();
    public SoyFileParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[123];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private static int[] jj_la1_3;
    private static int[] jj_la1_4;
    private static int[] jj_la1_5;
    private final JJCalls[] jj_2_rtns = new JJCalls[1];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    private static List<CommandTagAttribute> validateAttributes(SourceLocation currentLocation, List<CommandTagAttribute> attributes, ErrorReporter errorReporter) {
        for (CommandTagAttribute attribute : attributes) {
            if (currentLocation != null && currentLocation.isJustBefore(attribute.getName().location())) {
                errorReporter.report(attribute.getName().location(), PARSER_ERROR, attribute.getName().identifier(), "whitespace");
            }
            currentLocation = attribute.getSourceLocation();
        }
        return attributes;
    }

    public static ExprNode parseExprOrDie(String exprText) {
        return SoyFileParser.parseExpression(exprText, ErrorReporter.exploding());
    }

    @Nullable
    public static ExprNode parseExpression(String exprText, ErrorReporter errorReporter) {
        SourceFilePath filePath = SourceFilePath.create("expression parser");
        SoyFileParser parser = new SoyFileParser(exprText, filePath, errorReporter);
        try {
            return parser.ExprInput();
        }
        catch (ParseException e) {
            ParseErrors.reportSoyFileParseException(errorReporter, filePath, e, parser.token_source.curLexState);
            return null;
        }
    }

    @Nullable
    public static TypeNode parseType(String typeText, SourceFilePath filePath, ErrorReporter errorReporter) {
        SoyFileParser parser = new SoyFileParser(typeText, filePath, errorReporter);
        try {
            return parser.TypeExprInput();
        }
        catch (ParseException e) {
            ParseErrors.reportSoyFileParseException(errorReporter, filePath, e, parser.token_source.curLexState);
            return null;
        }
    }

    public SoyFileParser(IdGenerator nodeIdGen, Reader input, SourceFilePath filePath, ErrorReporter errorReporter) {
        this(new SoyFileParserTokenManager(new SoySimpleCharStream(input)));
        this.nodeIdGen = (IdGenerator)Preconditions.checkNotNull((Object)nodeIdGen);
        this.filePath = (SourceFilePath)Preconditions.checkNotNull((Object)filePath);
        this.errorReporter = (ErrorReporter)Preconditions.checkNotNull((Object)errorReporter);
        this.initTokenSource();
    }

    private SoyFileParser(String input, SourceFilePath filePath, ErrorReporter errorReporter) {
        this(new SoyFileParserTokenManager(new SoySimpleCharStream(new StringReader(input), 1, 1), 2));
        this.filePath = filePath;
        this.errorReporter = (ErrorReporter)Preconditions.checkNotNull((Object)errorReporter);
        this.headerInfo = TemplateNode.SoyFileHeaderInfo.EMPTY;
        this.initTokenSource();
    }

    private void initTokenSource() {
        this.token_source.setParser(this);
    }

    @Nullable
    public SoyFileNode parseSoyFile() {
        Preconditions.checkNotNull((Object)this.nodeIdGen);
        ErrorReporter.Checkpoint checkpoint = this.errorReporter.checkpoint();
        SoyFileNode soyFileNode = null;
        try {
            soyFileNode = this.SoyFile();
        }
        catch (ParseException e) {
            ParseErrors.reportSoyFileParseException(this.errorReporter, this.filePath, e, this.token_source.curLexState);
        }
        catch (TokenMgrError e) {
            ParseErrors.reportTokenMgrError(this.errorReporter, this.filePath, e);
        }
        if (this.errorReporter.errorsSince(checkpoint)) {
            return null;
        }
        HtmlRewriter.rewrite(soyFileNode, this.nodeIdGen, this.errorReporter);
        return soyFileNode;
    }

    private void reportFileErrorAndSkipTo(ParseException error, int skipTo) {
        Token t;
        ParseErrors.reportSoyFileParseException(this.errorReporter, this.filePath, error, this.token_source.curLexState);
        do {
            t = this.getNextToken();
        } while (t.kind != skipTo && t.kind != 0);
    }

    @CheckReturnValue
    private Token reportTemplateBodyErrorAndSkipTo(ParseException error, int ... kinds) {
        ParseErrors.reportSoyFileParseException(this.errorReporter, this.filePath, error, this.token_source.curLexState);
        return this.skipToTemplateToken(kinds);
    }

    @CheckReturnValue
    private Token reportTemplateBodyErrorAndSkipTo(ParseException error, String adviceToUser, int ... kinds) {
        ParseErrors.reportSoyFileParseException(this.errorReporter, this.filePath, error, this.token_source.curLexState, adviceToUser);
        return this.skipToTemplateToken(kinds);
    }

    @CheckReturnValue
    private Token skipToTemplateToken(int ... kinds) {
        Token t;
        ImmutableSet skipTo = ImmutableSet.copyOf((Collection)Ints.asList((int[])kinds));
        do {
            t = this.getNextToken();
            if (!skipTo.contains((Object)t.kind)) continue;
            return t;
        } while (t.kind != 38 && t.kind != 39 && t.kind != 0);
        throw new AbortParsingError();
    }

    @CheckReturnValue
    SourceLocation.Point getPointJustBeforeNextToken() {
        return ((SoySimpleCharStream)this.token_source.input_stream).getPointJustBeforeNextToken();
    }

    private SourceLocation createSrcLoc(Token t, SourceLocation.Point p) {
        return this.createSrcLoc(t, new Token[0]).extend(p);
    }

    SourceLocation createSrcLoc(Token tok1, Token ... rest) {
        return Tokens.createSrcLoc(this.filePath, tok1, rest);
    }

    private SourceLocation createSrcLoc(Token tok1, Node lastNode) {
        return this.createSrcLoc(tok1, new Token[0]).extend(lastNode.getSourceLocation());
    }

    private SourceLocation createSrcLoc(Node firstNode, Node lastNode) {
        return firstNode.getSourceLocation().extend(lastNode.getSourceLocation());
    }

    private SourceLocation createSrcLoc(Token tok1, List<? extends Node> nodes) {
        if (nodes.isEmpty()) {
            return this.createSrcLoc(tok1, new Token[0]);
        }
        return this.createSrcLoc(tok1, nodes.get(nodes.size() - 1));
    }

    private SourceLocation createSrcLoc(List<? extends Node> nodes) {
        if (nodes.isEmpty()) {
            return new SourceLocation(this.filePath);
        }
        return this.createSrcLoc(nodes.get(0), nodes.get(nodes.size() - 1));
    }

    private VarRefNode errorExpr(Token tok1, Token ... rest) {
        return VarRefNode.error(this.createSrcLoc(tok1, rest));
    }

    private ImmutableList<Comment> buildComments(SoyFileParserTokenManager manager) {
        ImmutableList.Builder comments = ImmutableList.builder();
        for (Comment comment : manager.comments) {
            comments.add((Object)comment);
        }
        return comments.build();
    }

    private CommandTagAttribute newTag(Identifier id, QuoteStyle quoteStyle, ImmutableList<ExprNode> exprList, SourceLocation loc) {
        if (id.identifier().equals("data") && exprList.size() == 1 && ((ExprNode)exprList.get(0)).toSourceString().equals("all")) {
            SourceLocation valueLoc = ((ExprNode)exprList.get(0)).getSourceLocation();
            SourceLocation withQuotes = new SourceLocation(valueLoc.getFilePath(), valueLoc.getBeginPoint().offset(0, -1), valueLoc.getEndPoint().offset(0, 1));
            return new CommandTagAttribute(id, quoteStyle, "all", withQuotes, loc);
        }
        return new CommandTagAttribute(id, quoteStyle, exprList, loc);
    }

    private final SoyFileNode SoyFile() throws ParseException {
        SoyFileNode file;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 0: {
                file = this.EmptySoyFile();
                break;
            }
            case 11: 
            case 12: {
                file = this.NonEmptySoyFile();
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return file;
    }

    private final SoyFileNode EmptySoyFile() throws ParseException {
        Token eof = this.jj_consume_token(0);
        return new SoyFileNode(this.nodeIdGen.genId(), new SourceLocation(this.filePath, SourceLocation.Point.create(1, 1), SourceLocation.Point.create(Math.max(1, eof.beginLine), Math.max(1, eof.beginColumn))), NamespaceDeclaration.EMPTY, TemplateNode.SoyFileHeaderInfo.EMPTY, this.buildComments(this.token_source));
    }

    private final SoyFileNode NonEmptySoyFile() throws ParseException {
        NamespaceDeclaration namespace;
        ImmutableList.Builder externs;
        ImmutableList.Builder constants;
        ImmutableList.Builder imports;
        ImmutableList.Builder aliases;
        DelPackageDeclaration delpackageDecl;
        block23: {
            delpackageDecl = null;
            aliases = new ImmutableList.Builder();
            imports = new ImmutableList.Builder();
            constants = new ImmutableList.Builder();
            externs = new ImmutableList.Builder();
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 12: {
                    delpackageDecl = this.DelPackage();
                    break;
                }
                default: {
                    this.jj_la1[1] = this.jj_gen;
                }
            }
            namespace = this.Namespace();
            block19: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 10: 
                    case 13: {
                        break;
                    }
                    default: {
                        this.jj_la1[2] = this.jj_gen;
                        break block23;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 10: {
                        AliasDeclaration alias = this.Alias();
                        if (alias == null) continue block19;
                        aliases.add((Object)alias);
                        continue block19;
                    }
                    case 13: {
                        ImportNode importNode = this.Import();
                        if (importNode == null) continue block19;
                        imports.add((Object)importNode);
                        continue block19;
                    }
                }
                break;
            }
            this.jj_la1[3] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        block20: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 14: {
                    break;
                }
                default: {
                    this.jj_la1[4] = this.jj_gen;
                    break block20;
                }
            }
            ConstNode constant = this.ConstStmt();
            if (constant == null) continue;
            constants.add((Object)constant);
        }
        block21: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 34: {
                    break;
                }
                default: {
                    this.jj_la1[5] = this.jj_gen;
                    break block21;
                }
            }
            ExternNode extern = this.ExternStmt();
            if (extern == null) continue;
            externs.add((Object)extern);
        }
        this.headerInfo = new TemplateNode.SoyFileHeaderInfo(this.errorReporter, delpackageDecl, namespace, (Collection<AliasDeclaration>)aliases.build(), this.importSymbols);
        ArrayList<TemplateNode> templates = new ArrayList<TemplateNode>();
        block22: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 31: 
                case 32: 
                case 33: {
                    break;
                }
                default: {
                    this.jj_la1[6] = this.jj_gen;
                    break block22;
                }
            }
            TemplateNode template = this.Template(this.headerInfo);
            if (template == null) continue;
            templates.add(template);
        }
        Token eof = this.jj_consume_token(0);
        SoyFileNode sfn = new SoyFileNode(this.nodeIdGen.genId(), new SourceLocation(this.filePath, SourceLocation.Point.create(1, 1), SourceLocation.Point.create(eof.beginLine, eof.beginColumn)), namespace, this.headerInfo, this.buildComments(this.token_source));
        sfn.addChildren(imports.build());
        sfn.addChildren(constants.build());
        sfn.addChildren(externs.build());
        sfn.addChildren(templates);
        return sfn;
    }

    private final ExternNode ExternStmt() throws ParseException {
        ArrayList<JsImplNode> impls = new ArrayList<JsImplNode>();
        Token open = this.jj_consume_token(34);
        Token name = this.jj_consume_token(96);
        this.jj_consume_token(98);
        FunctionTypeNode type = this.FunctionType();
        Token openClose = this.jj_consume_token(94);
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 36: {
                    ExternImplNode impl = this.JsImplStmt();
                    impls.add((JsImplNode)impl);
                    break;
                }
                case 37: {
                    ExternImplNode impl = this.JavaImplStmt();
                    impls.add((JsImplNode)impl);
                    break;
                }
                default: {
                    this.jj_la1[7] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 36: 
                case 37: {
                    continue block7;
                }
            }
            break;
        }
        this.jj_la1[8] = this.jj_gen;
        Token close = this.jj_consume_token(35);
        boolean hasJsImpl = false;
        boolean hasJavaImpl = false;
        for (ExternImplNode externImplNode : impls) {
            if (externImplNode instanceof JsImplNode) {
                if (hasJsImpl) {
                    this.errorReporter.report(externImplNode.getSourceLocation(), MULTIPLE_IMPLS, new Object[0]);
                }
                hasJsImpl = true;
            }
            if (!(externImplNode instanceof JavaImplNode)) continue;
            if (hasJavaImpl) {
                this.errorReporter.report(externImplNode.getSourceLocation(), MULTIPLE_IMPLS, new Object[0]);
            }
            hasJavaImpl = true;
        }
        boolean exported = open.image.startsWith("{export ");
        ExternNode externNode = new ExternNode(this.nodeIdGen.genId(), this.createSrcLoc(open, close), Identifier.create(name.image, this.createSrcLoc(name, new Token[0])), type, this.createSrcLoc(open, openClose), exported);
        externNode.addChildren(impls);
        return externNode;
    }

    private final JsImplNode JsImplStmt() throws ParseException {
        Token open = this.jj_consume_token(36);
        List<CommandTagAttribute> attributes = this.Attributes();
        Token close = this.jj_consume_token(95);
        SourceLocation srcLoc = this.createSrcLoc(open, close);
        SoyFileParser.validateAttributes(null, attributes, this.errorReporter);
        return new JsImplNode(this.nodeIdGen.genId(), srcLoc, attributes, this.errorReporter);
    }

    private final JavaImplNode JavaImplStmt() throws ParseException {
        Token open = this.jj_consume_token(37);
        List<CommandTagAttribute> attributes = this.Attributes();
        Token close = this.jj_consume_token(95);
        SourceLocation srcLoc = this.createSrcLoc(open, close);
        SoyFileParser.validateAttributes(null, attributes, this.errorReporter);
        return new JavaImplNode(this.nodeIdGen.genId(), srcLoc, attributes, this.errorReporter);
    }

    private final AliasDeclaration Alias() throws ParseException {
        Identifier alias = null;
        Token open = this.jj_consume_token(10);
        Identifier namespace = this.Identifier();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 154: {
                this.Keyword("as");
                alias = this.Identifier();
                break;
            }
            default: {
                this.jj_la1[9] = this.jj_gen;
            }
        }
        Token close = this.jj_consume_token(94);
        SourceLocation srcLoc = this.createSrcLoc(open, close);
        if (alias != null && !BaseUtils.isIdentifier(alias.identifier())) {
            this.errorReporter.report(srcLoc, INVALID_ALIAS_NAME, alias.identifier());
            return null;
        }
        if (alias == null) {
            return AliasDeclaration.create(srcLoc, namespace);
        }
        return AliasDeclaration.create(srcLoc, namespace, alias);
    }

    private final ImportedVar ModuleImportVar() throws ParseException {
        Token star = null;
        Object identifier = null;
        Token alias = null;
        star = this.jj_consume_token(20);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 154: {
                this.Keyword("as");
                alias = this.jj_consume_token(154);
                break;
            }
            default: {
                this.jj_la1[10] = this.jj_gen;
            }
        }
        if (alias == null) {
            this.errorReporter.report(this.createSrcLoc(star, new Token[0]), PARSER_ERROR, star.image, "'import * as Foo'");
            return new ImportedVar("*", "ERROR", this.createSrcLoc(star, new Token[0]));
        }
        this.importSymbols.add(alias.image);
        return new ImportedVar("*", alias.image, this.createSrcLoc(star, alias));
    }

    private final ImmutableList<ImportedVar> SymbolImportVarList() throws ParseException {
        Object star = null;
        Token identifier = null;
        Token alias = null;
        ImmutableList.Builder importedVars = new ImmutableList.Builder();
        identifier = this.jj_consume_token(154);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 154: {
                this.Keyword("as");
                alias = this.jj_consume_token(154);
                break;
            }
            default: {
                this.jj_la1[11] = this.jj_gen;
            }
        }
        String a1 = null;
        SourceLocation loc = this.createSrcLoc(identifier, new Token[0]);
        if (alias != null) {
            a1 = alias.image;
            loc = loc.extend(this.createSrcLoc(alias, new Token[0]));
            this.importSymbols.add(alias.image);
        } else {
            this.importSymbols.add(identifier.image);
        }
        importedVars.add((Object)new ImportedVar(identifier.image, a1, loc));
        alias = null;
        block9: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 16: {
                    break;
                }
                default: {
                    this.jj_la1[12] = this.jj_gen;
                    break block9;
                }
            }
            this.jj_consume_token(16);
            identifier = this.jj_consume_token(154);
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 154: {
                    this.Keyword("as");
                    alias = this.jj_consume_token(154);
                    break;
                }
                default: {
                    this.jj_la1[13] = this.jj_gen;
                }
            }
            String a2 = null;
            loc = this.createSrcLoc(identifier, new Token[0]);
            if (alias != null) {
                a2 = alias.image;
                loc = loc.extend(this.createSrcLoc(alias, new Token[0]));
                this.importSymbols.add(alias.image);
            } else {
                this.importSymbols.add(identifier.image);
            }
            importedVars.add((Object)new ImportedVar(identifier.image, a2, loc));
            alias = null;
        }
        return importedVars.build();
    }

    private final ImportNode Import() throws ParseException {
        StringNode path = null;
        ImmutableList<ImportedVar> identifiers = ImmutableList.of();
        Token open = this.jj_consume_token(13);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 17: 
            case 20: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 20: {
                        ImportedVar moduleImportVar = this.ModuleImportVar();
                        identifiers = ImmutableList.of((Object)moduleImportVar);
                        break;
                    }
                    case 17: {
                        this.jj_consume_token(17);
                        identifiers = this.SymbolImportVarList();
                        this.jj_consume_token(18);
                        break;
                    }
                    default: {
                        this.jj_la1[14] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.jj_consume_token(19);
                break;
            }
            default: {
                this.jj_la1[15] = this.jj_gen;
            }
        }
        path = this.StringLiteral();
        Token close = this.jj_consume_token(15);
        return new ImportNode(this.nodeIdGen.genId(), this.createSrcLoc(open, close), path, (List<ImportedVar>)identifiers);
    }

    private final NamespaceDeclaration Namespace() throws ParseException {
        Token open = this.jj_consume_token(11);
        Identifier name = this.DottedIdent();
        List<CommandTagAttribute> attributes = this.Attributes();
        Token close = this.jj_consume_token(94);
        SoyFileParser.validateAttributes(this.createSrcLoc(open, new Token[0]), attributes, this.errorReporter);
        return new NamespaceDeclaration(name, attributes, this.errorReporter, this.createSrcLoc(open, close));
    }

    private final List<CommandTagAttribute> Attributes() throws ParseException {
        Object attributes = ImmutableList.of();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 96: 
                case 154: {
                    break;
                }
                default: {
                    this.jj_la1[16] = this.jj_gen;
                    break block3;
                }
            }
            CommandTagAttribute attr = this.Attribute();
            if (attributes.isEmpty()) {
                attributes = new ArrayList();
            }
            attributes.add(attr);
        }
        CommandTagAttribute.removeDuplicatesAndReportErrors((Iterable<CommandTagAttribute>)attributes, this.errorReporter);
        return attributes;
    }

    private final CommandTagAttribute Attribute() throws ParseException {
        Token nameToken;
        ImmutableList exprList = ImmutableList.of();
        Preconditions.checkState((this.token_source.curLexState == 1 || this.token_source.curLexState == 2 ? 1 : 0) != 0);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 96: {
                nameToken = this.jj_consume_token(96);
                break;
            }
            case 154: {
                nameToken = this.jj_consume_token(154);
                break;
            }
            default: {
                this.jj_la1[17] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        Identifier name = Identifier.create(nameToken.image, this.createSrcLoc(nameToken, new Token[0]));
        this.token_source.SwitchTo(1);
        this.jj_consume_token(100);
        if (EXPR_ATTR_NAMES.contains((Object)name.identifier())) {
            Token qToken;
            QuoteStyle quoteStyle;
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 21: {
                    this.jj_consume_token(21);
                    quoteStyle = QuoteStyle.DOUBLE;
                    this.token_source.SwitchTo(3);
                    try {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 107: 
                            case 108: 
                            case 109: 
                            case 110: 
                            case 111: 
                            case 112: 
                            case 113: 
                            case 114: 
                            case 134: 
                            case 138: 
                            case 141: 
                            case 148: 
                            case 153: 
                            case 154: {
                                exprList = this.ExprList();
                                break;
                            }
                            default: {
                                this.jj_la1[18] = this.jj_gen;
                            }
                        }
                        qToken = this.jj_consume_token(23);
                    }
                    catch (ParseException e) {
                        this.token_source.SwitchTo(1);
                        exprList = ImmutableList.of((Object)this.errorExpr(e.currentToken, new Token[0]));
                        qToken = this.reportTemplateBodyErrorAndSkipTo(e, 21, 23);
                    }
                    break;
                }
                case 22: {
                    this.jj_consume_token(22);
                    quoteStyle = QuoteStyle.SINGLE;
                    this.token_source.SwitchTo(4);
                    try {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 107: 
                            case 108: 
                            case 109: 
                            case 110: 
                            case 111: 
                            case 112: 
                            case 113: 
                            case 114: 
                            case 134: 
                            case 138: 
                            case 141: 
                            case 148: 
                            case 153: 
                            case 154: {
                                exprList = this.ExprList();
                                break;
                            }
                            default: {
                                this.jj_la1[19] = this.jj_gen;
                            }
                        }
                        qToken = this.jj_consume_token(24);
                    }
                    catch (ParseException e) {
                        this.token_source.SwitchTo(1);
                        exprList = ImmutableList.of((Object)this.errorExpr(e.currentToken, new Token[0]));
                        qToken = this.reportTemplateBodyErrorAndSkipTo(e, 22, 24);
                    }
                    break;
                }
                default: {
                    this.jj_la1[20] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            if (exprList.isEmpty()) {
                this.errorReporter.report(this.createSrcLoc(qToken, new Token[0]), PARSER_ERROR, qToken.image, "an expression");
                exprList = ImmutableList.of((Object)this.errorExpr(qToken, new Token[0]));
            }
            return this.newTag(name, quoteStyle, (ImmutableList<ExprNode>)exprList, this.createSrcLoc(nameToken, qToken));
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 21: 
            case 22: {
                QuoteStyle quoteStyle;
                Token value;
                Token startValue;
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 21: {
                        startValue = this.jj_consume_token(21);
                        this.token_source.pushState(8);
                        value = this.jj_consume_token(25);
                        quoteStyle = QuoteStyle.DOUBLE;
                        break;
                    }
                    case 22: {
                        startValue = this.jj_consume_token(22);
                        this.token_source.pushState(9);
                        value = this.jj_consume_token(26);
                        quoteStyle = QuoteStyle.SINGLE;
                        break;
                    }
                    default: {
                        this.jj_la1[21] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                return new CommandTagAttribute(name, quoteStyle, value.image, this.createSrcLoc(startValue, value), this.createSrcLoc(nameToken, value));
            }
        }
        this.jj_la1[22] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    private final DelPackageDeclaration DelPackage() throws ParseException {
        Token open = this.jj_consume_token(12);
        Identifier name = this.DottedIdent();
        Token close = this.jj_consume_token(94);
        return DelPackageDeclaration.create(this.createSrcLoc(open, close), name);
    }

    private final TemplateNode Template(TemplateNode.SoyFileHeaderInfo soyFileHeaderInfo) throws ParseException {
        Token close = null;
        TemplateNode templateNode = null;
        RawTextNode initialWhitespace = null;
        List<SoyNode.StandaloneNode> templateBodyNodes = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 32: {
                Token open = this.jj_consume_token(32);
                TemplateBasicNodeBuilder builder = new TemplateBasicNodeBuilder(soyFileHeaderInfo, this.errorReporter);
                try {
                    this.TemplateOpenTagHelper(builder, open, false);
                    this.whitespaceMode = builder.getWhitespaceMode();
                    initialWhitespace = this.TemplateHeader(builder, false);
                    templateBodyNodes = this.TemplateBlock();
                    close = this.jj_consume_token(38);
                    builder.setSourceLocation(this.createSrcLoc(open, close));
                    templateNode = builder.build();
                    break;
                }
                catch (ParseException e) {
                    this.reportFileErrorAndSkipTo(e, 38);
                    return null;
                }
                catch (AbortParsingError e) {
                    return null;
                }
            }
            case 31: {
                Token open = this.jj_consume_token(31);
                TemplateDelegateNodeBuilder builder = new TemplateDelegateNodeBuilder(soyFileHeaderInfo, this.errorReporter);
                try {
                    this.TemplateOpenTagHelper(builder, open, true);
                    this.whitespaceMode = builder.getWhitespaceMode();
                    initialWhitespace = this.TemplateHeader(builder, false);
                    templateBodyNodes = this.TemplateBlock();
                    close = this.jj_consume_token(39);
                    builder.setSourceLocation(this.createSrcLoc(open, close));
                    templateNode = builder.build();
                    break;
                }
                catch (ParseException e) {
                    this.reportFileErrorAndSkipTo(e, 39);
                    return null;
                }
                catch (AbortParsingError e) {
                    return null;
                }
            }
            case 33: {
                Token open = this.jj_consume_token(33);
                TemplateElementNodeBuilder builder = new TemplateElementNodeBuilder(soyFileHeaderInfo, this.errorReporter);
                try {
                    this.TemplateOpenTagHelper(builder, open, false);
                    initialWhitespace = this.TemplateHeader(builder, true);
                    templateBodyNodes = this.TemplateBlock();
                    close = this.jj_consume_token(40);
                    builder.setSourceLocation(this.createSrcLoc(open, close));
                    templateNode = builder.build();
                    break;
                }
                catch (ParseException e) {
                    this.reportFileErrorAndSkipTo(e, 40);
                    return null;
                }
                catch (AbortParsingError e) {
                    return null;
                }
            }
            default: {
                this.jj_la1[23] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (initialWhitespace != null) {
            templateNode.addChild(initialWhitespace);
        }
        if (templateBodyNodes != null) {
            templateNode.addChildren(templateBodyNodes);
        }
        return templateNode;
    }

    private final void TemplateOpenTagHelper(TemplateNodeBuilder<?> builder, Token open, boolean isDeltemplate) throws ParseException {
        builder.setId(this.nodeIdGen.genId());
        Identifier templateName = this.TemplateNameInDef(isDeltemplate);
        List<CommandTagAttribute> attributes = this.Attributes();
        SoyFileParser.validateAttributes(templateName.location(), attributes, this.errorReporter);
        builder.setCommandValues(templateName, attributes);
        Token soyDoc = open.specialToken;
        if (soyDoc != null && soyDoc.kind == 9) {
            builder.setSoyDoc(soyDoc.image, this.createSrcLoc(soyDoc, new Token[0]));
        }
        Token close = this.jj_consume_token(94);
        builder.setOpenTagLocation(this.createSrcLoc(open, close));
    }

    private final Identifier TemplateNameInDef(boolean isDeltemplate) throws ParseException {
        Identifier templateName = this.TemplateName();
        if (!isDeltemplate && templateName.type() != Identifier.Type.SINGLE_IDENT) {
            this.errorReporter.report(templateName.location(), INVALID_TEMPLATE_NAME, templateName.identifier());
        }
        return templateName;
    }

    private final Identifier TemplateName() throws ParseException {
        Identifier ident = this.DottedIdent();
        return ident;
    }

    private final Identifier DottedIdent() throws ParseException {
        StringBuilder sb = null;
        Token next = null;
        Token name = this.jj_consume_token(96);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 102: {
                    break;
                }
                default: {
                    this.jj_la1[24] = this.jj_gen;
                    break block3;
                }
            }
            Token dot = this.jj_consume_token(102);
            next = this.jj_consume_token(96);
            if (sb == null) {
                sb = new StringBuilder();
                sb.append(name.image);
            }
            sb.append('.').append(next.image);
        }
        return sb == null ? Identifier.create(name.image, this.createSrcLoc(name, new Token[0])) : Identifier.create(sb.toString(), this.createSrcLoc(name, next));
    }

    private final void SkipWhitespace() throws ParseException {
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 105: {
                    break;
                }
                default: {
                    this.jj_la1[25] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(105);
        }
    }

    private final RawTextNode RawText() throws ParseException {
        RawTextBuilder builder = new RawTextBuilder(this.filePath, this.nodeIdGen, this.whitespaceMode);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                Token token;
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 50: {
                        token = this.jj_consume_token(50);
                        break;
                    }
                    case 51: {
                        token = this.jj_consume_token(51);
                        break;
                    }
                    case 53: {
                        token = this.jj_consume_token(53);
                        break;
                    }
                    case 52: {
                        token = this.jj_consume_token(52);
                        break;
                    }
                    case 54: {
                        token = this.jj_consume_token(54);
                        break;
                    }
                    case 55: {
                        token = this.jj_consume_token(55);
                        break;
                    }
                    case 56: {
                        token = this.jj_consume_token(56);
                        break;
                    }
                    case 57: {
                        token = this.jj_consume_token(57);
                        break;
                    }
                    default: {
                        this.jj_la1[26] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                return RawTextBuilder.buildCommandCharNode(token, this.filePath, this.nodeIdGen);
            }
            case 58: 
            case 105: 
            case 106: {
                block25: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 105: 
                        case 106: {
                            Token token;
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 106: {
                                    token = this.jj_consume_token(106);
                                    break;
                                }
                                case 105: {
                                    token = this.jj_consume_token(105);
                                    break;
                                }
                                default: {
                                    this.jj_la1[27] = this.jj_gen;
                                    this.jj_consume_token(-1);
                                    throw new ParseException();
                                }
                            }
                            builder.addBasic(token);
                            break;
                        }
                        case 58: {
                            Token tagBegin = this.jj_consume_token(58);
                            Token token = this.jj_consume_token(104);
                            SourceLocation loc = this.createSrcLoc(tagBegin, token);
                            token.image = token.image.substring(0, token.image.length() - "{/literal}".length());
                            token.endColumn -= "{/literal}".length();
                            return builder.buildLiteral(token, loc);
                        }
                        default: {
                            this.jj_la1[28] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    if (this.getToken((int)1).kind == 58) {
                        return builder.build();
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 58: 
                        case 105: 
                        case 106: {
                            continue block25;
                        }
                    }
                    break;
                }
                this.jj_la1[29] = this.jj_gen;
                return builder.build();
            }
        }
        this.jj_la1[30] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    private final RawTextNode TemplateHeader(TemplateNodeBuilder<?> templateBuilder, boolean allowState) throws ParseException {
        RawTextNode whitespace;
        Object params;
        block32: {
            TemplateHeaderVarDefn docSinkParam = null;
            params = ImmutableList.of();
            whitespace = null;
            String soyDoc = null;
            block22: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 41: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 47: 
                    case 48: 
                    case 105: {
                        break;
                    }
                    default: {
                        this.jj_la1[31] = this.jj_gen;
                        break block32;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 105: {
                        Token tok;
                        RawTextBuilder builder = new RawTextBuilder(this.filePath, this.nodeIdGen, this.whitespaceMode);
                        block23: while (true) {
                            tok = this.jj_consume_token(105);
                            if (tok.specialToken != null && tok.specialToken.kind == 9) {
                                if (docSinkParam != null) {
                                    String desc = tok.specialToken.image;
                                    desc = desc.substring(3, desc.length() - 2).trim();
                                    docSinkParam.setDesc(desc);
                                    docSinkParam = null;
                                } else {
                                    soyDoc = tok.specialToken.image;
                                }
                            } else if (tok.image.contains("\n") || tok.image.contains("\r")) {
                                docSinkParam = null;
                            }
                            builder.addBasic(tok);
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 105: {
                                    continue block23;
                                }
                            }
                            break;
                        }
                        this.jj_la1[32] = this.jj_gen;
                        whitespace = builder.build();
                        continue block22;
                    }
                    case 41: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 47: 
                    case 48: {
                        Token tok;
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 42: {
                                tok = this.jj_consume_token(42);
                                templateBuilder.setAllowExtraAttributes(this.createSrcLoc(tok, new Token[0]));
                                continue block22;
                            }
                            case 41: 
                            case 43: 
                            case 44: 
                            case 45: 
                            case 46: 
                            case 47: 
                            case 48: {
                                TemplateHeaderVarDefn param;
                                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                    case 41: 
                                    case 45: 
                                    case 46: 
                                    case 47: 
                                    case 48: {
                                        param = this.ParamDecl(soyDoc);
                                        break;
                                    }
                                    case 43: 
                                    case 44: {
                                        param = this.AttrDecl(soyDoc);
                                        break;
                                    }
                                    default: {
                                        this.jj_la1[33] = this.jj_gen;
                                        this.jj_consume_token(-1);
                                        throw new ParseException();
                                    }
                                }
                                docSinkParam = param;
                                switch (param.kind()) {
                                    case PARAM: {
                                        whitespace = null;
                                        soyDoc = null;
                                        if (params.isEmpty()) {
                                            params = new ArrayList();
                                        }
                                        params.add(param);
                                        continue block22;
                                    }
                                    case STATE: {
                                        if (params.isEmpty()) {
                                            params = new ArrayList();
                                        }
                                        if (allowState) {
                                            params.add(param);
                                            continue block22;
                                        }
                                        this.errorReporter.report(param.nameLocation(), STATE_IN_TEMPLATE, new Object[0]);
                                        continue block22;
                                    }
                                }
                                throw new AssertionError((Object)("unexpected var kind: " + (Object)((Object)param.kind())));
                            }
                        }
                        this.jj_la1[34] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                break;
            }
            this.jj_la1[35] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        templateBuilder.addVarDefns((Iterable<TemplateHeaderVarDefn>)params);
        return whitespace;
    }

    private final TemplateHeaderVarDefn ParamDecl(@Nullable String desc) throws ParseException {
        Token tagBegin;
        Token tagEnd = null;
        TypeNode paramTypeNode = null;
        ExprNode value = null;
        boolean optional = false;
        boolean inject = false;
        boolean stateVar = false;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 41: {
                tagBegin = this.jj_consume_token(41);
                break;
            }
            case 45: {
                tagBegin = this.jj_consume_token(45);
                optional = true;
                break;
            }
            case 46: {
                tagBegin = this.jj_consume_token(46);
                inject = true;
                break;
            }
            case 47: {
                tagBegin = this.jj_consume_token(47);
                inject = true;
                optional = true;
                break;
            }
            case 48: {
                tagBegin = this.jj_consume_token(48);
                stateVar = true;
                break;
            }
            default: {
                this.jj_la1[36] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (tagBegin.specialToken != null && tagBegin.specialToken.kind == 9) {
            desc = tagBegin.specialToken.image;
        }
        Token name = this.jj_consume_token(96);
        try {
            block8 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 98: {
                    this.jj_consume_token(98);
                    paramTypeNode = this.TypeExpr();
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 151: {
                            this.jj_consume_token(151);
                            value = this.Expr();
                            break block8;
                        }
                    }
                    this.jj_la1[37] = this.jj_gen;
                    break;
                }
                case 99: {
                    this.jj_consume_token(99);
                    value = this.Expr();
                    break;
                }
                default: {
                    this.jj_la1[38] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            tagEnd = this.jj_consume_token(94);
        }
        catch (ParseException parseException) {
            tagEnd = this.reportTemplateBodyErrorAndSkipTo(parseException, 94);
        }
        if (desc != null) {
            desc = desc.substring(3, desc.length() - 2).trim();
        }
        if (stateVar) {
            if (value == null) {
                this.errorReporter.report(this.createSrcLoc(tagBegin, new Token[0]), STATE_REQUIRES_VALUE, new Object[0]);
                value = this.errorExpr(name, new Token[0]);
            }
            return new TemplateStateVar(name.image, paramTypeNode, value, desc, this.createSrcLoc(name, new Token[0]), tagEnd == null ? this.createSrcLoc(tagBegin, new Token[0]) : this.createSrcLoc(tagBegin, tagEnd));
        }
        if (value != null) {
            if (inject) {
                this.errorReporter.report(this.createSrcLoc(tagBegin, new Token[0]), INJECT_DEFAULT_PARAM, new Object[0]);
            } else if (optional) {
                this.errorReporter.report(this.createSrcLoc(tagBegin, new Token[0]), OPTIONAL_DEFAULT_PARAM, new Object[0]);
            }
        }
        return new TemplateParam(name.image, this.createSrcLoc(name, new Token[0]), tagEnd == null ? this.createSrcLoc(tagBegin, new Token[0]) : this.createSrcLoc(tagBegin, tagEnd), paramTypeNode, inject, false, optional, desc, value);
    }

    private final TemplateHeaderVarDefn AttrDecl(@Nullable String desc) throws ParseException {
        Token name;
        Token tagBegin;
        Object lastName = null;
        Token tagEnd = null;
        TypeNode paramTypeNode = null;
        boolean optional = false;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 43: {
                tagBegin = this.jj_consume_token(43);
                break;
            }
            case 44: {
                tagBegin = this.jj_consume_token(44);
                optional = true;
                break;
            }
            default: {
                this.jj_la1[39] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (tagBegin.specialToken != null && tagBegin.specialToken.kind == 9) {
            desc = tagBegin.specialToken.image;
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 97: {
                name = this.jj_consume_token(97);
                break;
            }
            case 96: {
                name = this.jj_consume_token(96);
                break;
            }
            default: {
                this.jj_la1[40] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        try {
            this.jj_consume_token(98);
            paramTypeNode = this.TypeExpr();
            tagEnd = this.jj_consume_token(94);
        }
        catch (ParseException parseException) {
            tagEnd = this.reportTemplateBodyErrorAndSkipTo(parseException, 94);
        }
        if (desc != null) {
            desc = desc.substring(3, desc.length() - 2).trim();
        }
        return new AttrParam(name.image, optional, paramTypeNode, desc, lastName == null ? this.createSrcLoc(name, new Token[0]) : this.createSrcLoc(name, new Token[]{lastName}), tagEnd == null ? this.createSrcLoc(tagBegin, new Token[0]) : this.createSrcLoc(tagBegin, tagEnd));
    }

    private final List<SoyNode.StandaloneNode> TemplateBlock() throws ParseException {
        Object templateBlock = ImmutableList.of();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 65: 
                case 68: 
                case 72: 
                case 74: 
                case 80: 
                case 85: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 93: 
                case 105: 
                case 106: {
                    break;
                }
                default: {
                    this.jj_la1[41] = this.jj_gen;
                    break block3;
                }
            }
            SoyNode.StandaloneNode node = this.TemplateBlockItem();
            if (templateBlock.isEmpty()) {
                templateBlock = new ArrayList();
            }
            templateBlock.add(node);
        }
        return templateBlock;
    }

    private final SoyNode.StandaloneNode TemplateBlockItem() throws ParseException {
        SoyNode.StandaloneNode node;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 105: 
            case 106: {
                node = this.RawText();
                break;
            }
            case 59: 
            case 60: 
            case 65: 
            case 68: 
            case 72: 
            case 74: 
            case 80: 
            case 85: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 93: {
                node = this.Stmt();
                break;
            }
            default: {
                this.jj_la1[42] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return node;
    }

    private final SoyNode.StatementNode Stmt() throws ParseException {
        SoyNode.StatementNode stmt;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 72: 
            case 85: 
            case 87: 
            case 90: 
            case 91: 
            case 93: {
                stmt = this.NonPrintableStmt();
                break;
            }
            case 59: 
            case 60: 
            case 65: 
            case 88: 
            case 89: {
                stmt = this.PrintableStmt();
                break;
            }
            case 68: 
            case 74: 
            case 80: {
                stmt = this.ControlFlowStmt();
                break;
            }
            default: {
                this.jj_la1[43] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return stmt;
    }

    private final SoyNode.StatementNode NonPrintableStmt() throws ParseException {
        AbstractCommandNode stmt;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 72: {
                stmt = this.LetStmt();
                break;
            }
            case 85: {
                stmt = this.LogStmt();
                break;
            }
            case 87: {
                stmt = this.DebuggerStmt();
                break;
            }
            case 91: {
                stmt = this.VeLogStmt();
                break;
            }
            case 90: {
                stmt = this.KeyStmt();
                break;
            }
            case 93: {
                stmt = this.SkipStmt();
                break;
            }
            default: {
                this.jj_la1[44] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return stmt;
    }

    private final SoyNode.StatementNode PrintableStmt() throws ParseException {
        AbstractSoyNode stmt;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 65: {
                stmt = this.MsgStmt();
                break;
            }
            case 59: 
            case 60: {
                stmt = this.CallStmt();
                break;
            }
            case 88: 
            case 89: {
                stmt = this.PrintStmt();
                break;
            }
            default: {
                this.jj_la1[45] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return stmt;
    }

    private final SoyNode.StatementNode ControlFlowStmt() throws ParseException {
        AbstractSoyNode stmt;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 68: {
                stmt = this.IfStmt();
                break;
            }
            case 80: {
                stmt = this.SwitchStmt();
                break;
            }
            case 74: {
                stmt = this.ForStmt();
                break;
            }
            default: {
                this.jj_la1[46] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return stmt;
    }

    private final MsgFallbackGroupNode MsgStmt() throws ParseException {
        SourceLocation msgLocation;
        Token tagEnd;
        Object attributes = ImmutableList.of();
        MsgNode fallback = null;
        Token tagBegin = this.jj_consume_token(65);
        try {
            attributes = this.Attributes();
            tagEnd = this.jj_consume_token(94);
        }
        catch (ParseException e) {
            tagEnd = this.reportTemplateBodyErrorAndSkipTo(e, 94);
        }
        List<SoyNode.StandaloneNode> templateBlock = this.TemplateBlockForMsg();
        SoyFileParser.validateAttributes(this.createSrcLoc(tagEnd, new Token[0]), (List<CommandTagAttribute>)attributes, this.errorReporter);
        SourceLocation srcLocation = msgLocation = this.createSrcLoc(tagBegin, tagEnd);
        SourceLocation blockLocation = this.createSrcLoc(templateBlock);
        if (blockLocation.isKnown()) {
            srcLocation = msgLocation.extend(blockLocation);
        }
        MsgNode msg = new MsgNode(this.nodeIdGen.genId(), srcLocation, msgLocation, "msg", (List<CommandTagAttribute>)attributes, this.errorReporter);
        msg.addChildren(templateBlock);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 66: {
                Token fallbackTagBegin = this.jj_consume_token(66);
                try {
                    attributes = this.Attributes();
                    tagEnd = this.jj_consume_token(94);
                }
                catch (ParseException e) {
                    tagEnd = this.reportTemplateBodyErrorAndSkipTo(e, 94);
                }
                List<SoyNode.StandaloneNode> fallbackTemplateBlock = this.TemplateBlockForMsg();
                SoyFileParser.validateAttributes(this.createSrcLoc(tagEnd, new Token[0]), (List<CommandTagAttribute>)attributes, this.errorReporter);
                SourceLocation openTag = msgLocation = this.createSrcLoc(fallbackTagBegin, tagEnd);
                blockLocation = this.createSrcLoc(fallbackTemplateBlock);
                if (blockLocation.isKnown()) {
                    msgLocation = msgLocation.extend(blockLocation);
                }
                fallback = new MsgNode(this.nodeIdGen.genId(), msgLocation, openTag, "fallbackmsg", (List<CommandTagAttribute>)attributes, this.errorReporter);
                fallback.addChildren(fallbackTemplateBlock);
                break;
            }
            default: {
                this.jj_la1[47] = this.jj_gen;
            }
        }
        Token tagClose = this.jj_consume_token(67);
        MsgFallbackGroupNode msgGroup = new MsgFallbackGroupNode(this.nodeIdGen.genId(), this.createSrcLoc(tagBegin, tagClose));
        msgGroup.addChild(msg);
        if (fallback != null) {
            msgGroup.addChild(fallback);
        }
        return msgGroup;
    }

    private final List<SoyNode.StandaloneNode> TemplateBlockForMsg() throws ParseException {
        ArrayList<SoyNode.StandaloneNode> templateBlock;
        int pluralOrSelectIndex;
        block23: {
            pluralOrSelectIndex = -1;
            boolean firstNodeIsWhitespace = false;
            templateBlock = new ArrayList<SoyNode.StandaloneNode>();
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 105: {
                    RawTextBuilder builder = new RawTextBuilder(this.filePath, this.nodeIdGen, this.whitespaceMode);
                    block17: while (true) {
                        Token tok = this.jj_consume_token(105);
                        builder.addBasic(tok);
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 105: {
                                continue block17;
                            }
                        }
                        break;
                    }
                    this.jj_la1[48] = this.jj_gen;
                    RawTextNode rawText = builder.build();
                    if (rawText == null) break;
                    firstNodeIsWhitespace = true;
                    templateBlock.add(rawText);
                    break;
                }
                default: {
                    this.jj_la1[49] = this.jj_gen;
                }
            }
            block18: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: 
                    case 58: 
                    case 59: 
                    case 60: 
                    case 65: 
                    case 68: 
                    case 72: 
                    case 74: 
                    case 76: 
                    case 78: 
                    case 80: 
                    case 85: 
                    case 87: 
                    case 88: 
                    case 89: 
                    case 90: 
                    case 91: 
                    case 93: 
                    case 105: 
                    case 106: {
                        break;
                    }
                    default: {
                        this.jj_la1[50] = this.jj_gen;
                        break block23;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 76: 
                    case 78: {
                        AbstractParentCommandNode msgPluralOrSelectNode;
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 76: {
                                msgPluralOrSelectNode = this.MsgPlural();
                                break;
                            }
                            case 78: {
                                msgPluralOrSelectNode = this.MsgSelect();
                                break;
                            }
                            default: {
                                this.jj_la1[51] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        this.SkipWhitespace();
                        if (firstNodeIsWhitespace) {
                            templateBlock.remove(0);
                            firstNodeIsWhitespace = false;
                        }
                        if (pluralOrSelectIndex == -1) {
                            pluralOrSelectIndex = templateBlock.size();
                        }
                        templateBlock.add((SoyNode.StandaloneNode)((Object)msgPluralOrSelectNode));
                        continue block18;
                    }
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: 
                    case 58: 
                    case 59: 
                    case 60: 
                    case 65: 
                    case 68: 
                    case 72: 
                    case 74: 
                    case 80: 
                    case 85: 
                    case 87: 
                    case 88: 
                    case 89: 
                    case 90: 
                    case 91: 
                    case 93: 
                    case 105: 
                    case 106: {
                        SoyNode.StandaloneNode stmt = this.TemplateBlockItem();
                        if (stmt == null) continue block18;
                        templateBlock.add(stmt);
                        continue block18;
                    }
                }
                break;
            }
            this.jj_la1[52] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        if (pluralOrSelectIndex != -1) {
            SoyNode.StandaloneNode pluralOrSelect = (SoyNode.StandaloneNode)templateBlock.get(pluralOrSelectIndex);
            for (int i = 0; i < templateBlock.size(); ++i) {
                if (i == pluralOrSelectIndex) continue;
                this.errorReporter.report(((SoyNode.StandaloneNode)templateBlock.get(i)).getSourceLocation(), i < pluralOrSelectIndex ? UNEXPECTED_CONTENT_BEFORE : UNEXPECTED_CONTENT_AFTER, pluralOrSelect instanceof MsgPluralNode ? "{plural" : "{select");
            }
            return ImmutableList.of((Object)pluralOrSelect);
        }
        return templateBlock;
    }

    private final MsgPluralNode MsgPlural() throws ParseException {
        Token tagClose;
        Token tagEnd;
        ImmutableList attributes;
        ExprNode pluralExpr;
        Token tagBegin = this.jj_consume_token(76);
        try {
            pluralExpr = this.Expr();
            attributes = this.Attributes();
            tagEnd = this.jj_consume_token(94);
        }
        catch (ParseException e) {
            pluralExpr = this.errorExpr(tagBegin, new Token[0]);
            attributes = ImmutableList.of();
            tagEnd = this.reportTemplateBodyErrorAndSkipTo(e, 94);
        }
        SoyFileParser.validateAttributes(pluralExpr.getSourceLocation(), (List<CommandTagAttribute>)attributes, this.errorReporter);
        ArrayList<CaseOrDefaultNode> caseNodes = new ArrayList<CaseOrDefaultNode>();
        this.SkipWhitespace();
        try {
            List<SoyNode.StandaloneNode> templateBlock;
            Token caseBeginTag;
            block7: while (true) {
                int value;
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 82: {
                        break;
                    }
                    default: {
                        this.jj_la1[53] = this.jj_gen;
                        break block7;
                    }
                }
                caseBeginTag = this.jj_consume_token(82);
                ExprNode caseExpr = this.Expr();
                Token caseBeginEnd = this.jj_consume_token(94);
                if (!(caseExpr instanceof IntegerNode)) {
                    this.errorReporter.report(caseExpr.getSourceLocation(), PLURAL_CASE_MALFORMED, new Object[0]);
                    value = 0;
                } else {
                    value = (int)((IntegerNode)caseExpr).getValue();
                    if (value < 0) {
                        this.errorReporter.report(caseExpr.getSourceLocation(), PLURAL_CASE_OUT_OF_BOUNDS, value);
                        value = 0;
                    }
                }
                templateBlock = this.TemplateBlockForMsg();
                if (templateBlock.size() == 1 && (templateBlock.get(0) instanceof MsgPluralNode || templateBlock.get(0) instanceof MsgSelectNode)) {
                    this.errorReporter.report(templateBlock.get(0).getSourceLocation(), PLURAL_AND_SELECT_NOT_ALLOWED_INSIDE_PLURAL_BLOCK, new Object[0]);
                }
                MsgPluralCaseNode caseNode = new MsgPluralCaseNode(this.nodeIdGen.genId(), this.createSrcLoc(caseBeginTag, templateBlock), this.createSrcLoc(caseBeginTag, caseBeginEnd), value);
                caseNode.addChildren(templateBlock);
                caseNodes.add(caseNode);
            }
            caseBeginTag = this.jj_consume_token(83);
            templateBlock = this.TemplateBlockForMsg();
            if (templateBlock.size() == 1 && (templateBlock.get(0) instanceof MsgPluralNode || templateBlock.get(0) instanceof MsgSelectNode)) {
                this.errorReporter.report(templateBlock.get(0).getSourceLocation(), PLURAL_AND_SELECT_NOT_ALLOWED_INSIDE_PLURAL_BLOCK, new Object[0]);
            }
            MsgPluralDefaultNode defaultNode = new MsgPluralDefaultNode(this.nodeIdGen.genId(), this.createSrcLoc(caseBeginTag, templateBlock), this.createSrcLoc(caseBeginTag, new Token[0]));
            defaultNode.addChildren(templateBlock);
            caseNodes.add(defaultNode);
            tagClose = this.jj_consume_token(77);
        }
        catch (ParseException e) {
            tagClose = this.reportTemplateBodyErrorAndSkipTo(e, 77);
        }
        MsgPluralNode pluralNode = MsgPluralNode.fromPluralExpr(this.nodeIdGen.genId(), this.createSrcLoc(tagBegin, tagClose), this.createSrcLoc(tagBegin, tagEnd), pluralExpr, (List<CommandTagAttribute>)attributes, this.errorReporter);
        pluralNode.addChildren(caseNodes);
        return pluralNode;
    }

    private final MsgSelectNode MsgSelect() throws ParseException {
        Token tagClose;
        ImmutableList attributes;
        ExprNode selectExpr;
        Token tagBeginEnd = null;
        Token tagBegin = this.jj_consume_token(78);
        try {
            selectExpr = this.Expr();
            attributes = this.Attributes();
            tagBeginEnd = this.jj_consume_token(94);
        }
        catch (ParseException e) {
            selectExpr = this.errorExpr(tagBegin, new Token[0]);
            attributes = ImmutableList.of();
            tagBeginEnd = this.reportTemplateBodyErrorAndSkipTo(e, 94);
        }
        SoyFileParser.validateAttributes(selectExpr.getSourceLocation(), (List<CommandTagAttribute>)attributes, this.errorReporter);
        ArrayList<CaseOrDefaultNode> caseNodes = new ArrayList<CaseOrDefaultNode>();
        this.SkipWhitespace();
        try {
            List<SoyNode.StandaloneNode> templateBlock;
            Token caseTagBegin;
            block7: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 82: {
                        break;
                    }
                    default: {
                        this.jj_la1[54] = this.jj_gen;
                        break block7;
                    }
                }
                caseTagBegin = this.jj_consume_token(82);
                ExprNode caseExpr = this.Expr();
                Token caseTagEnd = this.jj_consume_token(94);
                templateBlock = this.TemplateBlockForMsg();
                String value = ParseErrors.validateSelectCaseLabel(caseExpr, this.errorReporter);
                MsgSelectCaseNode caseNode = new MsgSelectCaseNode(this.nodeIdGen.genId(), this.createSrcLoc(caseTagBegin, templateBlock), this.createSrcLoc(caseTagBegin, caseTagEnd), value);
                caseNodes.add(caseNode);
                caseNode.addChildren(templateBlock);
            }
            caseTagBegin = this.jj_consume_token(83);
            templateBlock = this.TemplateBlockForMsg();
            MsgSelectDefaultNode defaultNode = new MsgSelectDefaultNode(this.nodeIdGen.genId(), this.createSrcLoc(caseTagBegin, templateBlock), this.createSrcLoc(caseTagBegin, new Token[0]));
            caseNodes.add(defaultNode);
            defaultNode.addChildren(templateBlock);
            tagClose = this.jj_consume_token(79);
        }
        catch (ParseException e) {
            tagClose = this.reportTemplateBodyErrorAndSkipTo(e, 79);
        }
        MsgSelectNode selectNode = MsgSelectNode.fromSelectExpr(this.nodeIdGen.genId(), this.createSrcLoc(tagBegin, tagClose), tagBeginEnd == null ? this.createSrcLoc(tagBegin, new Token[0]) : this.createSrcLoc(tagBegin, tagBeginEnd), new ExprRootNode(selectExpr), (List<CommandTagAttribute>)attributes, this.errorReporter);
        selectNode.addChildren(caseNodes);
        return selectNode;
    }

    private final PrintNode PrintStmt() throws ParseException {
        Token tagEnd;
        boolean isImplicit;
        Token tagBegin;
        ExprNode expr = null;
        Object directives = ImmutableList.of();
        Object attributes = ImmutableList.of();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 88: {
                tagBegin = this.jj_consume_token(88);
                isImplicit = false;
                break;
            }
            case 89: {
                tagBegin = this.jj_consume_token(89);
                isImplicit = true;
                break;
            }
            default: {
                this.jj_la1[55] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        try {
            expr = this.Expr();
            directives = this.PrintDirectives();
            attributes = this.Attributes();
            tagEnd = this.jj_consume_token(94);
        }
        catch (ParseException e) {
            if (expr == null) {
                expr = this.errorExpr(tagBegin, new Token[0]);
            }
            tagEnd = this.reportTemplateBodyErrorAndSkipTo(e, 94);
        }
        SoyFileParser.validateAttributes(expr.getSourceLocation(), (List<CommandTagAttribute>)attributes, this.errorReporter);
        PrintNode node = new PrintNode(this.nodeIdGen.genId(), this.createSrcLoc(tagBegin, tagEnd), isImplicit, expr, (Iterable<CommandTagAttribute>)attributes, this.errorReporter);
        node.addChildren((List)directives);
        return node;
    }

    private final List<PrintDirectiveNode> PrintDirectives() throws ParseException {
        Object directives = ImmutableList.of();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 150: {
                    break;
                }
                default: {
                    this.jj_la1[56] = this.jj_gen;
                    break block3;
                }
            }
            PrintDirectiveNode node = this.PrintDirective();
            if (directives.isEmpty()) {
                directives = new ArrayList();
            }
            directives.add(node);
        }
        return directives;
    }

    private final PrintDirectiveNode PrintDirective() throws ParseException {
        ImmutableList<ExprNode> args = ImmutableList.of();
        Token vbar = this.jj_consume_token(150);
        Token directive = this.jj_consume_token(154);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 123: {
                this.jj_consume_token(123);
                args = this.ExprList();
                break;
            }
            default: {
                this.jj_la1[57] = this.jj_gen;
            }
        }
        if (!Tokens.areAdjacent(vbar, directive)) {
            this.errorReporter.report(this.createSrcLoc(vbar, new Token[0]), UNEXPECTED_PIPE, new Object[0]);
        }
        SourceLocation loc = this.createSrcLoc(vbar, directive);
        Identifier ident = Identifier.create("|" + directive.image, loc);
        if (!args.isEmpty()) {
            loc = loc.extend(((ExprNode)args.get(args.size() - 1)).getSourceLocation());
        }
        return new PrintDirectiveNode(this.nodeIdGen.genId(), ident, loc, args);
    }

    private final KeyNode KeyStmt() throws ParseException {
        Token tagEnd;
        ExprNode expr = null;
        Token tagBegin = this.jj_consume_token(90);
        try {
            expr = this.Expr();
            tagEnd = this.jj_consume_token(94);
        }
        catch (ParseException e) {
            if (expr == null) {
                expr = this.errorExpr(tagBegin, new Token[0]);
            }
            tagEnd = this.reportTemplateBodyErrorAndSkipTo(e, 94);
        }
        KeyNode node = new KeyNode(this.nodeIdGen.genId(), this.createSrcLoc(tagBegin, tagEnd), expr);
        return node;
    }

    private final SkipNode SkipStmt() throws ParseException {
        Token tagBegin = this.jj_consume_token(93);
        SkipNode node = new SkipNode(this.nodeIdGen.genId(), this.createSrcLoc(tagBegin, new Token[0]));
        return node;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final LetNode LetStmt() throws ParseException {
        Token nameTok = null;
        Token tagBeginEnd = null;
        ExprNode valueExpr = null;
        CommandTagAttribute attr = null;
        ImmutableList immutableList = ImmutableList.of();
        Token tagBegin = this.jj_consume_token(72);
        try {
            nameTok = this.jj_consume_token(154);
        }
        catch (ParseException e) {
            Token tagClose = this.reportTemplateBodyErrorAndSkipTo(e, 95, 94);
            SourceLocation loc = this.createSrcLoc(tagBegin, tagClose);
            return new LetValueNode(-1, loc, "$error", loc, this.errorExpr(tagBegin, new Token[0]));
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 123: {
                Token tagClose;
                try {
                    this.jj_consume_token(123);
                    valueExpr = this.Expr();
                    tagClose = this.jj_consume_token(95);
                    return new LetValueNode(this.nodeIdGen.genId(), this.createSrcLoc(tagBegin, tagClose), nameTok.image, this.createSrcLoc(nameTok, new Token[0]), valueExpr);
                }
                catch (ParseException e) {
                    tagClose = this.reportTemplateBodyErrorAndSkipTo(e, 95, 94);
                    if (valueExpr != null) return new LetValueNode(this.nodeIdGen.genId(), this.createSrcLoc(tagBegin, tagClose), nameTok.image, this.createSrcLoc(nameTok, new Token[0]), valueExpr);
                    valueExpr = this.errorExpr(tagClose, new Token[0]);
                }
                return new LetValueNode(this.nodeIdGen.genId(), this.createSrcLoc(tagBegin, tagClose), nameTok.image, this.createSrcLoc(nameTok, new Token[0]), valueExpr);
            }
            case 96: 
            case 154: {
                try {
                    attr = this.Attribute();
                    tagBeginEnd = this.jj_consume_token(94);
                }
                catch (ParseException e) {
                    tagBeginEnd = this.reportTemplateBodyErrorAndSkipTo(e, 94, 95);
                }
                List<SoyNode.StandaloneNode> list = this.TemplateBlock();
                Token tagClose = this.jj_consume_token(73);
                if (attr == null) {
                    SourceLocation loc = this.createSrcLoc(tagBegin, tagClose);
                    return new LetValueNode(-1, loc, "$error", loc, this.errorExpr(tagBegin, new Token[0]));
                }
                LetContentNode node = new LetContentNode(this.nodeIdGen.genId(), this.createSrcLoc(tagBegin, tagClose), tagBeginEnd == null ? this.createSrcLoc(tagBegin, new Token[0]) : this.createSrcLoc(tagBegin, tagBeginEnd), nameTok.image, this.createSrcLoc(nameTok, new Token[0]), attr, this.errorReporter);
                node.addChildren((List<? extends SoyNode.StandaloneNode>)list);
                return node;
            }
        }
        this.jj_la1[58] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    private final ConstNode ConstStmt() throws ParseException {
        Token tagClose;
        boolean exported;
        Token tagBegin;
        ExprNode valueExpr;
        Token nameTok;
        block4: {
            nameTok = null;
            Object tagBeginEnd = null;
            valueExpr = null;
            Object attr = null;
            ImmutableList templateBlock = ImmutableList.of();
            tagBegin = this.jj_consume_token(14);
            exported = tagBegin.image.startsWith("{export ");
            try {
                nameTok = this.jj_consume_token(154);
            }
            catch (ParseException e) {
                Token tagClose2 = this.reportTemplateBodyErrorAndSkipTo(e, 95, 94);
                SourceLocation loc = this.createSrcLoc(tagBegin, tagClose2);
                return new ConstNode(-1, loc, "$error", loc, this.errorExpr(tagBegin, new Token[0]), exported);
            }
            try {
                this.jj_consume_token(151);
                valueExpr = this.Expr();
                tagClose = this.jj_consume_token(95);
            }
            catch (ParseException e) {
                tagClose = this.reportTemplateBodyErrorAndSkipTo(e, 95, 94);
                if (valueExpr != null) break block4;
                valueExpr = this.errorExpr(tagClose, new Token[0]);
            }
        }
        return new ConstNode(this.nodeIdGen.genId(), this.createSrcLoc(tagBegin, tagClose), nameTok.image, this.createSrcLoc(nameTok, new Token[0]), valueExpr, exported);
    }

    private final IfNode IfStmt() throws ParseException {
        ExprNode ifExpr;
        Token tagBeginEnd = null;
        Token tagBegin = this.jj_consume_token(68);
        try {
            ifExpr = this.Expr();
            tagBeginEnd = this.jj_consume_token(94);
        }
        catch (ParseException e) {
            ifExpr = this.errorExpr(tagBegin, new Token[0]);
            tagBeginEnd = this.reportTemplateBodyErrorAndSkipTo(e, 94);
        }
        List<SoyNode.StandaloneNode> templateBlock = this.TemplateBlock();
        ArrayList<AbstractBlockCommandNode> condNodes = new ArrayList<AbstractBlockCommandNode>();
        IfCondNode ifCondNode = new IfCondNode(this.nodeIdGen.genId(), this.createSrcLoc(tagBegin, this.getPointJustBeforeNextToken()), tagBeginEnd == null ? this.createSrcLoc(tagBegin, new Token[0]) : this.createSrcLoc(tagBegin, tagBeginEnd), "if", ifExpr);
        condNodes.add(ifCondNode);
        ifCondNode.addChildren(templateBlock);
        block10: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 69: {
                    break;
                }
                default: {
                    this.jj_la1[59] = this.jj_gen;
                    break block10;
                }
            }
            Token condTagBegin = this.jj_consume_token(69);
            try {
                ifExpr = this.Expr();
                tagBeginEnd = this.jj_consume_token(94);
            }
            catch (ParseException e) {
                ifExpr = this.errorExpr(condTagBegin, new Token[0]);
                tagBeginEnd = this.reportTemplateBodyErrorAndSkipTo(e, 94);
            }
            templateBlock = this.TemplateBlock();
            ifCondNode = new IfCondNode(this.nodeIdGen.genId(), this.createSrcLoc(condTagBegin, this.getPointJustBeforeNextToken()), tagBeginEnd == null ? this.createSrcLoc(condTagBegin, new Token[0]) : this.createSrcLoc(condTagBegin, tagBeginEnd), "elseif", ifExpr);
            condNodes.add(ifCondNode);
            ifCondNode.addChildren(templateBlock);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 70: {
                Token elseTag = this.jj_consume_token(70);
                templateBlock = this.TemplateBlock();
                IfElseNode ifElseNode = new IfElseNode(this.nodeIdGen.genId(), this.createSrcLoc(elseTag, this.getPointJustBeforeNextToken()), this.createSrcLoc(elseTag, new Token[0]));
                condNodes.add(ifElseNode);
                ifElseNode.addChildren(templateBlock);
                break;
            }
            default: {
                this.jj_la1[60] = this.jj_gen;
            }
        }
        Token tagClose = this.jj_consume_token(71);
        IfNode ifNode = new IfNode(this.nodeIdGen.genId(), this.createSrcLoc(tagClose, new Token[0]), this.createSrcLoc(tagBegin, tagClose));
        ifNode.addChildren(condNodes);
        return ifNode;
    }

    private final VeLogNode VeLogStmt() throws ParseException {
        Token tagBeginEnd;
        ExprNode veDataExpr = null;
        Object attributes = ImmutableList.of();
        Token tagBegin = this.jj_consume_token(91);
        try {
            veDataExpr = this.Expr();
            attributes = this.Attributes();
            tagBeginEnd = this.jj_consume_token(94);
        }
        catch (ParseException e) {
            if (veDataExpr == null) {
                veDataExpr = this.errorExpr(tagBegin, new Token[0]);
            }
            tagBeginEnd = this.reportTemplateBodyErrorAndSkipTo(e, 94);
        }
        List<SoyNode.StandaloneNode> templateBlock = this.TemplateBlock();
        Token tagClose = this.jj_consume_token(92);
        SoyFileParser.validateAttributes(veDataExpr.getSourceLocation(), (List<CommandTagAttribute>)attributes, this.errorReporter);
        VeLogNode node = new VeLogNode(this.nodeIdGen.genId(), this.createSrcLoc(tagBegin, tagClose), this.createSrcLoc(tagBegin, tagBeginEnd), veDataExpr, (List<CommandTagAttribute>)attributes, this.errorReporter);
        node.addChildren(templateBlock);
        return node;
    }

    private final SwitchNode SwitchStmt() throws ParseException {
        Token tagClose;
        ExprNode switchExpr;
        Token tagBeginEnd = null;
        SwitchDefaultNode defaultNode = null;
        Token tagBegin = this.jj_consume_token(80);
        try {
            switchExpr = this.Expr();
            tagBeginEnd = this.jj_consume_token(94);
        }
        catch (ParseException e) {
            switchExpr = this.errorExpr(tagBegin, new Token[0]);
            tagBeginEnd = this.reportTemplateBodyErrorAndSkipTo(e, 94);
        }
        ArrayList<CaseOrDefaultNode> cases = new ArrayList<CaseOrDefaultNode>();
        this.SkipWhitespace();
        try {
            List<SoyNode.StandaloneNode> templateBlock;
            block10: while (true) {
                Token caseTag = this.jj_consume_token(82);
                ImmutableList<ExprNode> caseExprs = this.ExprList();
                Token caseTagEnd = this.jj_consume_token(94);
                templateBlock = this.TemplateBlock();
                SwitchCaseNode caseNode = new SwitchCaseNode(this.nodeIdGen.genId(), this.createSrcLoc(caseTag, this.getPointJustBeforeNextToken()), this.createSrcLoc(caseTag, caseTagEnd), caseExprs);
                caseNode.addChildren(templateBlock);
                cases.add(caseNode);
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 82: {
                        continue block10;
                    }
                }
                break;
            }
            this.jj_la1[61] = this.jj_gen;
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 83: {
                    Token defaultTag = this.jj_consume_token(83);
                    templateBlock = this.TemplateBlock();
                    defaultNode = new SwitchDefaultNode(this.nodeIdGen.genId(), this.createSrcLoc(defaultTag, this.getPointJustBeforeNextToken()), this.createSrcLoc(defaultTag, new Token[0]));
                    defaultNode.addChildren(templateBlock);
                    cases.add(defaultNode);
                    break;
                }
                default: {
                    this.jj_la1[62] = this.jj_gen;
                }
            }
            tagClose = this.jj_consume_token(81);
        }
        catch (ParseException e) {
            tagClose = this.reportTemplateBodyErrorAndSkipTo(e, 81);
        }
        SwitchNode switchNode = new SwitchNode(this.nodeIdGen.genId(), this.createSrcLoc(tagBegin, tagClose), tagBeginEnd == null ? this.createSrcLoc(tagBegin, new Token[0]) : this.createSrcLoc(tagBegin, tagBeginEnd), switchExpr);
        switchNode.addChildren(cases);
        return switchNode;
    }

    private final ForNode ForStmt() throws ParseException {
        Token tagBegin;
        ForIfemptyNode ifempty;
        ExprNode expr;
        Identifier indexId;
        Identifier nameId;
        Token tagBeginEnd;
        block10: {
            tagBeginEnd = null;
            Token indexTok = null;
            nameId = null;
            indexId = null;
            expr = null;
            Object name = null;
            ifempty = null;
            tagBegin = this.jj_consume_token(74);
            try {
                Token nameTok = this.jj_consume_token(154);
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 144: {
                        this.jj_consume_token(144);
                        indexTok = this.jj_consume_token(154);
                        break;
                    }
                    default: {
                        this.jj_la1[63] = this.jj_gen;
                    }
                }
                nameId = Identifier.create(nameTok.image, this.createSrcLoc(nameTok, new Token[0]));
                indexId = indexTok == null ? null : Identifier.create(indexTok.image, this.createSrcLoc(indexTok, new Token[0]));
                this.jj_consume_token(146);
                expr = this.Expr();
                tagBeginEnd = this.jj_consume_token(94);
            }
            catch (ParseException e) {
                tagBeginEnd = this.reportTemplateBodyErrorAndSkipTo(e, "\nFor-loops should be formatted as: \"{for $foo in <listExpression>}\" or \"{for $foo, $i in <listExpression>}\".", 94);
                if (nameId == null) {
                    nameId = Identifier.create("$error", this.createSrcLoc(tagBegin, new Token[0]));
                }
                if (expr != null) break block10;
                expr = this.errorExpr(tagBegin, new Token[0]);
            }
        }
        List<SoyNode.StandaloneNode> templateBlock = this.TemplateBlock();
        ForNonemptyNode nonEmpty = new ForNonemptyNode(this.nodeIdGen.genId(), nameId, indexId, this.createSrcLoc(tagBegin, templateBlock));
        nonEmpty.addChildren(templateBlock);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 84: {
                Token ifemptyTag = this.jj_consume_token(84);
                templateBlock = this.TemplateBlock();
                ifempty = new ForIfemptyNode(this.nodeIdGen.genId(), this.createSrcLoc(ifemptyTag, templateBlock), this.createSrcLoc(ifemptyTag, new Token[0]));
                ifempty.addChildren(templateBlock);
                break;
            }
            default: {
                this.jj_la1[64] = this.jj_gen;
            }
        }
        Token tagClose = this.jj_consume_token(75);
        ForNode forNode = new ForNode(this.nodeIdGen.genId(), this.createSrcLoc(tagBegin, tagClose), tagBeginEnd == null ? this.createSrcLoc(tagBegin, new Token[0]) : this.createSrcLoc(tagBegin, tagBeginEnd), expr);
        forNode.addChild(nonEmpty);
        if (ifempty != null) {
            forNode.addChild(ifempty);
        }
        return forNode;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final CallNode CallStmt() throws ParseException {
        tagBeginEnd = null;
        calleeName = null;
        calleeExpr = null;
        selfClosing = false;
        attributes /* !! */  = ImmutableList.of();
        params /* !! */  = ImmutableList.of();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 59: {
                tagBegin = this.jj_consume_token(59);
                try {
                    calleeExpr = this.Expr();
                    attributes /* !! */  = this.Attributes();
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 95: {
                            tagClose = this.jj_consume_token(95);
                            selfClosing = true;
                            break;
                        }
                        case 94: {
                            tagBeginEnd = this.jj_consume_token(94);
                            params /* !! */  = this.CallParams();
                            tagClose = this.jj_consume_token(61);
                            break;
                        }
                        default: {
                            this.jj_la1[65] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                }
                catch (ParseException e) {
                    tagClose = this.reportTemplateBodyErrorAndSkipTo(e, new int[]{95, 61});
                    if (calleeExpr != null || calleeName != null) ** GOTO lbl34
                    loc = this.createSrcLoc(tagBegin, new Token[0]);
                    calleeExpr = TemplateLiteralNode.forVarRef(new VarRefNode("$error", loc, null));
                }
lbl34:
                // 3 sources

                loc = this.createSrcLoc(tagBegin, new Token[]{tagClose});
                if (calleeExpr == null) {
                    calleeExpr = TemplateLiteralNode.forVarRef(new VarRefNode(calleeName.identifier(), calleeName.location(), null));
                    SoyFileParser.validateAttributes(calleeName.location(), (List<CommandTagAttribute>)attributes /* !! */ , this.errorReporter);
                } else {
                    SoyFileParser.validateAttributes(calleeExpr.getSourceLocation(), (List<CommandTagAttribute>)attributes /* !! */ , this.errorReporter);
                }
                node = new CallBasicNode(this.nodeIdGen.genId(), this.createSrcLoc(tagBegin, new Token[]{tagClose}), tagBeginEnd != null ? this.createSrcLoc(tagBegin, new Token[]{tagBeginEnd}) : loc, calleeExpr, (List<CommandTagAttribute>)attributes /* !! */ , selfClosing, this.errorReporter);
                node.addChildren((List)params /* !! */ );
                return node;
            }
            case 60: {
                tagBegin = this.jj_consume_token(60);
                try {
                    calleeName = this.TemplateName();
                    attributes /* !! */  = this.Attributes();
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 95: {
                            tagClose = this.jj_consume_token(95);
                            selfClosing = true;
                            break;
                        }
                        case 94: {
                            tagBeginEnd = this.jj_consume_token(94);
                            params /* !! */  = this.CallParams();
                            tagClose = this.jj_consume_token(62);
                            break;
                        }
                        default: {
                            this.jj_la1[66] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                }
                catch (ParseException e) {
                    tagClose = this.reportTemplateBodyErrorAndSkipTo(e, new int[]{95, 62});
                    if (calleeName != null) ** GOTO lbl70
                    calleeName = Identifier.create("error", this.createSrcLoc(tagBegin, new Token[0]));
                }
lbl70:
                // 3 sources

                SoyFileParser.validateAttributes(calleeName.location(), (List<CommandTagAttribute>)attributes /* !! */ , this.errorReporter);
                tag = this.createSrcLoc(tagBegin, new Token[]{tagClose});
                node = new CallDelegateNode(this.nodeIdGen.genId(), tag, tagBeginEnd != null ? this.createSrcLoc(tagBegin, new Token[]{tagBeginEnd}) : tag, calleeName, (List<CommandTagAttribute>)attributes /* !! */ , selfClosing, this.errorReporter);
                node.addChildren((List)params /* !! */ );
                return node;
            }
        }
        this.jj_la1[67] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    private final List<CallParamNode> CallParams() throws ParseException {
        Object params = ImmutableList.of();
        this.SkipWhitespace();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 63: {
                    break;
                }
                default: {
                    this.jj_la1[68] = this.jj_gen;
                    break block3;
                }
            }
            CallParamNode paramNode = this.CallParam();
            if (params.isEmpty()) {
                params = new ArrayList();
            }
            params.add(paramNode);
            this.SkipWhitespace();
        }
        return params;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final CallParamNode CallParam() throws ParseException {
        Identifier key;
        Token tagBeginEnd = null;
        ExprNode valueExpr = null;
        CommandTagAttribute attr = null;
        ImmutableList immutableList = ImmutableList.of();
        Token tagBegin = this.jj_consume_token(63);
        try {
            key = this.Identifier();
        }
        catch (ParseException e) {
            Identifier key2 = Identifier.create("error", this.createSrcLoc(tagBegin, new Token[0]));
            Token tagClose = this.reportTemplateBodyErrorAndSkipTo(e, 95, 94);
            return new CallParamValueNode(-1, this.createSrcLoc(tagBegin, tagClose), key2, this.errorExpr(tagBegin, new Token[0]));
        }
        if (key.type() != Identifier.Type.SINGLE_IDENT) {
            this.errorReporter.report(key.location(), INVALID_PARAM_NAME, key.identifier());
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 123: {
                Token tagClose;
                try {
                    this.jj_consume_token(123);
                    valueExpr = this.Expr();
                    tagClose = this.jj_consume_token(95);
                    return new CallParamValueNode(this.nodeIdGen.genId(), this.createSrcLoc(tagBegin, tagClose), key, valueExpr);
                }
                catch (ParseException e) {
                    tagClose = this.reportTemplateBodyErrorAndSkipTo(e, 95, 94);
                    if (valueExpr != null) return new CallParamValueNode(this.nodeIdGen.genId(), this.createSrcLoc(tagBegin, tagClose), key, valueExpr);
                    valueExpr = this.errorExpr(tagClose, new Token[0]);
                }
                return new CallParamValueNode(this.nodeIdGen.genId(), this.createSrcLoc(tagBegin, tagClose), key, valueExpr);
            }
            case 96: 
            case 154: {
                try {
                    attr = this.Attribute();
                    tagBeginEnd = this.jj_consume_token(94);
                }
                catch (ParseException e) {
                    tagBeginEnd = this.reportTemplateBodyErrorAndSkipTo(e, 94, 95);
                }
                List<SoyNode.StandaloneNode> list = this.TemplateBlock();
                Token tagClose = this.jj_consume_token(64);
                if (attr == null) {
                    return new CallParamValueNode(-1, this.createSrcLoc(tagBegin, tagClose), key, this.errorExpr(tagBegin, new Token[0]));
                }
                CallParamContentNode node = new CallParamContentNode(this.nodeIdGen.genId(), this.createSrcLoc(tagBegin, tagClose), this.createSrcLoc(tagBegin, tagBeginEnd), key, attr, this.errorReporter);
                node.addChildren((List<? extends SoyNode.StandaloneNode>)list);
                return node;
            }
        }
        this.jj_la1[69] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    private final LogNode LogStmt() throws ParseException {
        Token open = this.jj_consume_token(85);
        List<SoyNode.StandaloneNode> templateBlock = this.TemplateBlock();
        Token close = this.jj_consume_token(86);
        LogNode logNode = new LogNode(this.nodeIdGen.genId(), this.createSrcLoc(open, close));
        logNode.addChildren(templateBlock);
        return logNode;
    }

    private final DebuggerNode DebuggerStmt() throws ParseException {
        Token token = this.jj_consume_token(87);
        return new DebuggerNode(this.nodeIdGen.genId(), this.createSrcLoc(token, new Token[0]));
    }

    private final ExprNode ExprInput() throws ParseException {
        ExprNode expr = this.Expr();
        this.jj_consume_token(0);
        return expr;
    }

    private final ImmutableList<ExprNode> ExprList() throws ParseException {
        ImmutableList.Builder exprList = ImmutableList.builder();
        ExprNode expr = this.Expr();
        exprList.add((Object)expr);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 144: {
                    break;
                }
                default: {
                    this.jj_la1[70] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(144);
            expr = this.Expr();
            exprList.add((Object)expr);
        }
        return exprList.build();
    }

    private final CallArgs CallArgs() throws ParseException {
        ArrayList<ExprNode> params = new ArrayList<ExprNode>();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 134: 
            case 138: 
            case 141: 
            case 148: 
            case 153: 
            case 154: {
                ExprNode val = this.Expr();
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 123: {
                        Identifier paramName;
                        this.jj_consume_token(123);
                        ArrayList<Identifier> paramIds = new ArrayList<Identifier>();
                        String firstId = val.toSourceString();
                        if (BaseUtils.isDottedIdentifier(firstId)) {
                            paramName = Identifier.create(firstId, val.getSourceLocation());
                        } else {
                            this.errorReporter.report(val.getSourceLocation(), INVALID_PARAM_NAME, firstId);
                            paramName = Identifier.create("error" + paramIds.size(), val.getSourceLocation());
                        }
                        paramIds.add(paramName);
                        val = this.Expr();
                        params.add(val);
                        while (this.getToken((int)1).kind == 144 && this.getToken((int)2).kind != 149) {
                            this.jj_consume_token(144);
                            paramName = this.Identifier();
                            this.jj_consume_token(123);
                            val = this.Expr();
                            paramIds.add(paramName);
                            params.add(val);
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 144: {
                                this.jj_consume_token(144);
                                break;
                            }
                            default: {
                                this.jj_la1[71] = this.jj_gen;
                            }
                        }
                        Token close = this.jj_consume_token(149);
                        return CallArgs.named(this.errorReporter, (ImmutableList<Identifier>)ImmutableList.copyOf(paramIds), (ImmutableList<ExprNode>)ImmutableList.copyOf(params), close);
                    }
                    case 144: {
                        Token comma = this.jj_consume_token(144);
                        ArrayList<SourceLocation.Point> commaLocations = new ArrayList<SourceLocation.Point>();
                        params.add(val);
                        commaLocations.add(this.createSrcLoc(comma, new Token[0]).getBeginPoint());
                        val = this.Expr();
                        params.add(val);
                        block16: while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 144: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[72] = this.jj_gen;
                                    break block16;
                                }
                            }
                            comma = this.jj_consume_token(144);
                            val = this.Expr();
                            params.add(val);
                            commaLocations.add(this.createSrcLoc(comma, new Token[0]).getBeginPoint());
                        }
                        Token close = this.jj_consume_token(149);
                        return CallArgs.positional((ImmutableList<ExprNode>)ImmutableList.copyOf(params), (ImmutableList<SourceLocation.Point>)ImmutableList.copyOf(commaLocations), close);
                    }
                    case 149: {
                        Token close = this.jj_consume_token(149);
                        return CallArgs.positional((ImmutableList<ExprNode>)ImmutableList.of((Object)val), (ImmutableList<SourceLocation.Point>)ImmutableList.of(), close);
                    }
                }
                this.jj_la1[73] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            case 149: {
                Token close = this.jj_consume_token(149);
                return CallArgs.empty(close);
            }
        }
        this.jj_la1[74] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    private final ExprNode Expr() throws ParseException {
        ExprNode expr = this.PrecExpr1();
        return expr;
    }

    private final ExprNode PrecExpr1() throws ParseException {
        ExprNode expr = this.PrecExpr2();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 122: 
            case 124: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 124: {
                        Token op = this.jj_consume_token(124);
                        ExprNode expr1 = this.PrecExpr1();
                        expr = Operator.NULL_COALESCING.createNode(this.createSrcLoc(expr, (Node)expr1), this.createSrcLoc(op, new Token[0]), expr, expr1);
                        break block0;
                    }
                    case 122: {
                        Token op = this.jj_consume_token(122);
                        ExprNode expr1 = this.PrecExpr1();
                        Token op2 = this.jj_consume_token(123);
                        ExprNode expr2 = this.PrecExpr1();
                        expr = Operator.CONDITIONAL.createNode(expr.getSourceLocation().extend(expr2.getSourceLocation()), this.createSrcLoc(op, op2), expr, expr1, expr2);
                        break block0;
                    }
                }
                this.jj_la1[75] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[76] = this.jj_gen;
            }
        }
        return expr;
    }

    private final ExprNode PrecExpr2() throws ParseException {
        ExprNode expr = this.PrecExpr3();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 125: {
                    break;
                }
                default: {
                    this.jj_la1[77] = this.jj_gen;
                    break block3;
                }
            }
            Token op = this.jj_consume_token(125);
            ExprNode rightHand = this.PrecExpr3();
            expr = Operator.createOperatorNode(this.createSrcLoc(expr, (Node)rightHand), op.image, this.createSrcLoc(op, new Token[0]), 2, expr, rightHand);
        }
        return expr;
    }

    private final ExprNode PrecExpr3() throws ParseException {
        ExprNode expr = this.PrecExpr4();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 126: {
                    break;
                }
                default: {
                    this.jj_la1[78] = this.jj_gen;
                    break block3;
                }
            }
            Token op = this.jj_consume_token(126);
            ExprNode rightHand = this.PrecExpr4();
            expr = Operator.createOperatorNode(this.createSrcLoc(expr, (Node)rightHand), op.image, this.createSrcLoc(op, new Token[0]), 3, expr, rightHand);
        }
        return expr;
    }

    private final ExprNode PrecExpr4() throws ParseException {
        ExprNode expr = this.PrecExpr5();
        block7: while (true) {
            Token op;
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 127: 
                case 128: {
                    break;
                }
                default: {
                    this.jj_la1[79] = this.jj_gen;
                    break block7;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 127: {
                    op = this.jj_consume_token(127);
                    break;
                }
                case 128: {
                    op = this.jj_consume_token(128);
                    break;
                }
                default: {
                    this.jj_la1[80] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            ExprNode rightHand = this.PrecExpr5();
            expr = Operator.createOperatorNode(this.createSrcLoc(expr, (Node)rightHand), op.image, this.createSrcLoc(op, new Token[0]), 4, expr, rightHand);
        }
        return expr;
    }

    private final ExprNode PrecExpr5() throws ParseException {
        ExprNode expr = this.PrecExpr6();
        block9: while (true) {
            Token op;
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 129: 
                case 130: 
                case 131: 
                case 132: {
                    break;
                }
                default: {
                    this.jj_la1[81] = this.jj_gen;
                    break block9;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 129: {
                    op = this.jj_consume_token(129);
                    break;
                }
                case 130: {
                    op = this.jj_consume_token(130);
                    break;
                }
                case 131: {
                    op = this.jj_consume_token(131);
                    break;
                }
                case 132: {
                    op = this.jj_consume_token(132);
                    break;
                }
                default: {
                    this.jj_la1[82] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            ExprNode rightHand = this.PrecExpr6();
            expr = Operator.createOperatorNode(this.createSrcLoc(expr, (Node)rightHand), op.image, this.createSrcLoc(op, new Token[0]), 5, expr, rightHand);
        }
        return expr;
    }

    private final ExprNode PrecExpr6() throws ParseException {
        ExprNode expr = this.PrecExpr7();
        block7: while (true) {
            Token op;
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 133: 
                case 134: {
                    break;
                }
                default: {
                    this.jj_la1[83] = this.jj_gen;
                    break block7;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 133: {
                    op = this.jj_consume_token(133);
                    break;
                }
                case 134: {
                    op = this.jj_consume_token(134);
                    break;
                }
                default: {
                    this.jj_la1[84] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            ExprNode rightHand = this.PrecExpr7();
            expr = Operator.createOperatorNode(this.createSrcLoc(expr, (Node)rightHand), op.image, this.createSrcLoc(op, new Token[0]), 6, expr, rightHand);
        }
        return expr;
    }

    private final ExprNode PrecExpr7() throws ParseException {
        ExprNode expr = this.PrecExpr8();
        block8: while (true) {
            Token op;
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 135: 
                case 136: 
                case 137: {
                    break;
                }
                default: {
                    this.jj_la1[85] = this.jj_gen;
                    break block8;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 135: {
                    op = this.jj_consume_token(135);
                    break;
                }
                case 136: {
                    op = this.jj_consume_token(136);
                    break;
                }
                case 137: {
                    op = this.jj_consume_token(137);
                    break;
                }
                default: {
                    this.jj_la1[86] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            ExprNode rightHand = this.PrecExpr8();
            expr = Operator.createOperatorNode(this.createSrcLoc(expr, (Node)rightHand), op.image, this.createSrcLoc(op, new Token[0]), 7, expr, rightHand);
        }
        return expr;
    }

    private final ExprNode PrecExpr8() throws ParseException {
        ExprNode expr;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 141: 
            case 148: 
            case 154: {
                expr = this.PrecExpr9();
                break;
            }
            case 134: 
            case 138: 
            case 153: {
                Token op;
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 138: {
                        op = this.jj_consume_token(138);
                        break;
                    }
                    case 134: {
                        op = this.jj_consume_token(134);
                        break;
                    }
                    case 153: {
                        op = this.jj_consume_token(153);
                        this.errorReporter.report(this.createSrcLoc(op, new Token[0]), LEGACY_NOT_ERROR, new Object[0]);
                        op.image = "not";
                        break;
                    }
                    default: {
                        this.jj_la1[87] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                expr = this.PrecExpr8();
                SourceLocation opLocation = this.createSrcLoc(op, new Token[0]);
                SourceLocation location = opLocation.extend(expr.getSourceLocation());
                if (op.kind == 134 && expr instanceof IntegerNode) {
                    long value = -1L * ((IntegerNode)expr).getValue();
                    expr = new IntegerNode(value, location);
                    break;
                }
                if (op.kind == 134 && expr instanceof FloatNode) {
                    double value = -1.0 * ((FloatNode)expr).getValue();
                    expr = new FloatNode(value, location);
                    break;
                }
                expr = Operator.createOperatorNode(location, op.image, opLocation, 8, expr);
                break;
            }
            default: {
                this.jj_la1[88] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return expr;
    }

    private final ExprNode PrecExpr9() throws ParseException {
        ExprNode expr;
        block23: {
            expr = this.Primary();
            block22: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 139: 
                    case 140: 
                    case 141: 
                    case 143: 
                    case 153: {
                        break;
                    }
                    default: {
                        this.jj_la1[89] = this.jj_gen;
                        break block23;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 139: 
                    case 140: 
                    case 141: 
                    case 143: {
                        Token op;
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 139: 
                            case 140: {
                                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                    case 139: {
                                        op = this.jj_consume_token(139);
                                        break;
                                    }
                                    case 140: {
                                        op = this.jj_consume_token(140);
                                        break;
                                    }
                                    default: {
                                        this.jj_la1[90] = this.jj_gen;
                                        this.jj_consume_token(-1);
                                        throw new ParseException();
                                    }
                                }
                                Token ident = this.jj_consume_token(154);
                                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                    case 148: {
                                        this.jj_consume_token(148);
                                        CallArgs callArgs = this.CallArgs();
                                        expr = callArgs.toBuilder().setTarget(expr).setIdentifier(Identifier.create(ident.image, this.createSrcLoc(ident, new Token[0]))).setSourceLocation(this.createSrcLoc(op, callArgs.close)).setNullSafe(op.kind == 140).buildMethod();
                                        continue block22;
                                    }
                                }
                                this.jj_la1[91] = this.jj_gen;
                                expr = new FieldAccessNode(expr, ident.image, this.createSrcLoc(op, ident), op.kind == 140);
                                continue block22;
                            }
                            case 141: 
                            case 143: {
                                Token open;
                                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                    case 141: {
                                        open = this.jj_consume_token(141);
                                        break;
                                    }
                                    case 143: {
                                        open = this.jj_consume_token(143);
                                        break;
                                    }
                                    default: {
                                        this.jj_la1[92] = this.jj_gen;
                                        this.jj_consume_token(-1);
                                        throw new ParseException();
                                    }
                                }
                                ExprNode keyExpr = this.Expr();
                                Token close = this.jj_consume_token(142);
                                expr = new ItemAccessNode(expr, keyExpr, this.createSrcLoc(open, close), open.kind == 143);
                                continue block22;
                            }
                        }
                        this.jj_la1[93] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    case 153: {
                        Token op = this.jj_consume_token(153);
                        SourceLocation opLocation = this.createSrcLoc(op, new Token[0]);
                        expr = Operator.createOperatorNode(expr.getSourceLocation().extend(opLocation), op.image, opLocation, 10, expr);
                        continue block22;
                    }
                }
                break;
            }
            this.jj_la1[94] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return expr;
    }

    private final ExprNode Primary() throws ParseException {
        ExprNode primary;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 148: {
                primary = this.GroupNode();
                break;
            }
            case 154: {
                primary = this.VarRefOrFunctionCallLike();
                break;
            }
            case 141: {
                primary = this.List();
                break;
            }
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: {
                primary = this.Primitive();
                break;
            }
            default: {
                this.jj_la1[95] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return primary;
    }

    private final GroupNode GroupNode() throws ParseException {
        Token lParen = this.jj_consume_token(148);
        ExprNode primary = this.Expr();
        Token rParen = this.jj_consume_token(149);
        return new GroupNode(primary, this.createSrcLoc(lParen, rParen));
    }

    private final ExprNode VarRefOrFunctionCallLike() throws ParseException {
        Token openParen = null;
        Object closeParen = null;
        Token identToken = this.jj_consume_token(154);
        Identifier ident = Identifier.create(identToken.image, this.createSrcLoc(identToken, new Token[0]));
        boolean isRecord = "record".equals(identToken.image);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 148: {
                openParen = this.jj_consume_token(148);
                if (identToken.image.equals("map")) {
                    return this.MapLiteral(ident);
                }
                if (identToken.image.equals("ve")) {
                    return this.VeLiteral(ident);
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 107: 
                    case 108: 
                    case 109: 
                    case 110: 
                    case 111: 
                    case 112: 
                    case 113: 
                    case 114: 
                    case 134: 
                    case 138: 
                    case 141: 
                    case 148: 
                    case 149: 
                    case 153: 
                    case 154: {
                        CallArgs callArgs = this.CallArgs();
                        SourceLocation loc = ident.location().extend(this.createSrcLoc(callArgs.close, new Token[0]));
                        CallableExprBuilder callBuilder = CallableExprBuilder.builder();
                        if (isRecord) {
                            RecordLiteralNode node;
                            if (callArgs.values.isEmpty()) {
                                this.errorReporter.report(ident.location(), EMPTY_RECORD_LITERAL, new Object[0]);
                                node = new RecordLiteralNode(ident, (Iterable<Identifier>)ImmutableList.of(), loc);
                            } else if (callArgs.isNamed()) {
                                for (Identifier name : callArgs.names) {
                                    if (name.type() == Identifier.Type.SINGLE_IDENT) continue;
                                    this.errorReporter.report(name.location(), INVALID_RECORD_KEY, name.identifier());
                                }
                                node = new RecordLiteralNode(ident, (Iterable<Identifier>)callArgs.names, loc);
                            } else {
                                this.errorReporter.report(ident.location(), RECORD_NAMED_PARAMS, new Object[0]);
                                node = new RecordLiteralNode(ident, (Iterable<Identifier>)ImmutableList.of(), loc);
                            }
                            node.addChildren((List<? extends ExprNode>)callArgs.values);
                            return node;
                        }
                        return callArgs.toBuilder().setIdentifier(ident).setSourceLocation(loc).buildFunction();
                    }
                }
                this.jj_la1[96] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_la1[97] = this.jj_gen;
        return new VarRefNode(identToken.image, this.createSrcLoc(identToken, new Token[0]), null);
    }

    private final ExprNode MapLiteral(Identifier ident) throws ParseException {
        ExprNode key = null;
        ImmutableMap.Builder kvPairs = ImmutableMap.builder();
        boolean fromList = false;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 134: 
            case 138: 
            case 141: 
            case 148: 
            case 153: 
            case 154: {
                key = this.Expr();
                fromList = true;
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 123: {
                        this.jj_consume_token(123);
                        ExprNode val = this.Expr();
                        kvPairs.put((Object)key, (Object)val);
                        fromList = false;
                        while (this.getToken((int)1).kind == 144 && this.getToken((int)2).kind != 149) {
                            this.jj_consume_token(144);
                            key = this.Expr();
                            this.jj_consume_token(123);
                            val = this.Expr();
                            kvPairs.put((Object)key, (Object)val);
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 144: {
                                this.jj_consume_token(144);
                                break block0;
                            }
                        }
                        this.jj_la1[98] = this.jj_gen;
                        break block0;
                    }
                }
                this.jj_la1[99] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[100] = this.jj_gen;
            }
        }
        Token closeParen = this.jj_consume_token(149);
        SourceLocation srcLoc = ident.location().extend(this.createSrcLoc(closeParen, new Token[0]));
        return fromList ? new MapLiteralFromListNode(ident, key, srcLoc, this.nodeIdGen.genId()) : new MapLiteralNode(ident, (ImmutableMap<ExprNode, ExprNode>)kvPairs.build(), srcLoc);
    }

    private final ExprNode VeLiteral(Identifier ident) throws ParseException {
        Identifier name = this.Identifier();
        Token closeParen = this.jj_consume_token(149);
        SourceLocation srcLoc = ident.location().extend(this.createSrcLoc(closeParen, new Token[0]));
        return new VeLiteralNode(ident, name, srcLoc);
    }

    private final ExprNode List() throws ParseException {
        Token begin = this.jj_consume_token(141);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 142: {
                Token end = this.jj_consume_token(142);
                return new ListLiteralNode(new ArrayList<ExprNode>(), this.createSrcLoc(begin, end), (List<SourceLocation.Point>)ImmutableList.of());
            }
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 134: 
            case 138: 
            case 141: 
            case 148: 
            case 153: 
            case 154: {
                ExprNode listNode;
                ExprNode firstExpr = this.Expr();
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 145: {
                        listNode = this.ListComprehension(begin, firstExpr);
                        break;
                    }
                    default: {
                        this.jj_la1[101] = this.jj_gen;
                        if (this.jj_2_1(1)) {
                            listNode = this.ListLiteral(begin, firstExpr);
                            break;
                        }
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                return listNode;
            }
        }
        this.jj_la1[102] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    private final ExprNode ListComprehension(Token begin, ExprNode itemExpr) throws ParseException {
        Token end;
        Token listIterVar = null;
        Token indexVar = null;
        ExprNode listExpr = null;
        ExprNode filterExpr = null;
        Object listIterVarIdentLocation = null;
        this.jj_consume_token(145);
        try {
            listIterVar = this.jj_consume_token(154);
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 144: {
                    this.jj_consume_token(144);
                    indexVar = this.jj_consume_token(154);
                    break;
                }
                default: {
                    this.jj_la1[103] = this.jj_gen;
                }
            }
            this.jj_consume_token(146);
            listExpr = this.Expr();
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 147: {
                    this.jj_consume_token(147);
                    filterExpr = this.Expr();
                    break;
                }
                default: {
                    this.jj_la1[104] = this.jj_gen;
                }
            }
            end = this.jj_consume_token(142);
        }
        catch (ParseException e) {
            Token end2 = this.reportTemplateBodyErrorAndSkipTo(e, "\nList comprehensions should be formatted as: \"[$foo.bar for $foo in <listExpression>]\" or \"[$foo.bar for $foo, $i in <listExpression>]\".", 142);
            return new ListComprehensionNode(this.errorExpr(begin, new Token[0]), "$error", this.createSrcLoc(begin, new Token[0]), "$error", this.createSrcLoc(begin, new Token[0]), this.errorExpr(begin, new Token[0]), this.errorExpr(begin, new Token[0]), this.createSrcLoc(begin, end2), this.nodeIdGen.genId());
        }
        String indexVarName = indexVar == null ? null : indexVar.image;
        SourceLocation indexVarNameLocation = indexVar == null ? null : this.createSrcLoc(indexVar, new Token[0]);
        return new ListComprehensionNode(listExpr, listIterVar.image, this.createSrcLoc(listIterVar, new Token[0]), indexVarName, indexVarNameLocation, itemExpr, filterExpr, this.createSrcLoc(begin, end), this.nodeIdGen.genId());
    }

    private final ExprNode ListLiteral(Token begin, ExprNode firstItem) throws ParseException {
        Token comma;
        Object items = ImmutableList.of();
        ArrayList<SourceLocation.Point> commaLocations = new ArrayList<SourceLocation.Point>();
        items = new ArrayList();
        items.add(firstItem);
        while (this.getToken((int)1).kind == 144 && this.getToken((int)2).kind != 142) {
            comma = this.jj_consume_token(144);
            ExprNode itemExpr = this.Expr();
            items.add(itemExpr);
            commaLocations.add(this.createSrcLoc(comma, new Token[0]).getBeginPoint());
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 144: {
                comma = this.jj_consume_token(144);
                commaLocations.add(this.createSrcLoc(comma, new Token[0]).getBeginPoint());
                break;
            }
            default: {
                this.jj_la1[105] = this.jj_gen;
            }
        }
        Token end = this.jj_consume_token(142);
        return new ListLiteralNode((List<ExprNode>)items, this.createSrcLoc(begin, end), commaLocations);
    }

    private final ExprNode.PrimitiveNode Primitive() throws ParseException {
        AbstractPrimitiveNode primitive;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 107: {
                Token tok = this.jj_consume_token(107);
                primitive = new NullNode(this.createSrcLoc(tok, new Token[0]));
                break;
            }
            case 108: {
                Token tok = this.jj_consume_token(108);
                primitive = new BooleanNode(true, this.createSrcLoc(tok, new Token[0]));
                break;
            }
            case 109: {
                Token tok = this.jj_consume_token(109);
                primitive = new BooleanNode(false, this.createSrcLoc(tok, new Token[0]));
                break;
            }
            case 110: {
                Token tok = this.jj_consume_token(110);
                SourceLocation loc = this.createSrcLoc(tok, new Token[0]);
                Long parsed = Longs.tryParse((String)tok.image, (int)10);
                if (parsed == null || !IntegerNode.isInRange(parsed)) {
                    this.errorReporter.report(loc, INTEGER_OUT_OF_RANGE, new Object[0]);
                    parsed = 0L;
                }
                primitive = new IntegerNode(parsed, loc);
                break;
            }
            case 111: {
                Token tok = this.jj_consume_token(111);
                SourceLocation loc = this.createSrcLoc(tok, new Token[0]);
                Long parsed = Longs.tryParse((String)tok.image.substring(2), (int)16);
                if (parsed == null || !IntegerNode.isInRange(parsed)) {
                    this.errorReporter.report(loc, INTEGER_OUT_OF_RANGE, new Object[0]);
                    parsed = 0L;
                }
                primitive = new IntegerNode(parsed, loc);
                break;
            }
            case 112: {
                Token tok = this.jj_consume_token(112);
                primitive = new FloatNode(Double.parseDouble(tok.image), this.createSrcLoc(tok, new Token[0]));
                break;
            }
            case 113: 
            case 114: {
                primitive = this.StringLiteral();
                break;
            }
            default: {
                this.jj_la1[106] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return primitive;
    }

    private final StringNode StringLiteral() throws ParseException {
        QuoteStyle quoteStyle;
        Token value;
        Token quote;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 113: {
                quote = this.jj_consume_token(113);
                this.token_source.pushState(11);
                value = this.jj_consume_token(115);
                quoteStyle = QuoteStyle.SINGLE;
                break;
            }
            case 114: {
                quote = this.jj_consume_token(114);
                this.token_source.pushState(12);
                value = this.jj_consume_token(116);
                quoteStyle = QuoteStyle.DOUBLE;
                break;
            }
            default: {
                this.jj_la1[107] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        SourceLocation loc = this.createSrcLoc(quote, value);
        String rawString = value.image.substring(0, value.image.length() - 1);
        String unescaped = SoyParseUtils.unescapeString(rawString, this.errorReporter, loc);
        return new StringNode(unescaped, quoteStyle, loc);
    }

    private final Identifier Identifier() throws ParseException {
        Token next = null;
        StringBuilder sb = null;
        Token first = this.jj_consume_token(154);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 139: {
                    break;
                }
                default: {
                    this.jj_la1[108] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(139);
            next = this.jj_consume_token(154);
            if (sb == null) {
                sb = new StringBuilder();
                sb.append(first.image);
            }
            sb.append('.').append(next.image);
        }
        return sb == null ? Identifier.create(first.image, this.createSrcLoc(first, new Token[0])) : Identifier.create(sb.toString(), this.createSrcLoc(first, next));
    }

    private final Identifier DottedOrDashedIdent() throws ParseException {
        Token next = null;
        Token delim = null;
        Token prevDelim = null;
        StringBuilder sb = null;
        Token first = this.jj_consume_token(154);
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 134: 
                case 139: {
                    break;
                }
                default: {
                    this.jj_la1[109] = this.jj_gen;
                    break block7;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 134: {
                    delim = this.jj_consume_token(134);
                    break;
                }
                case 139: {
                    delim = this.jj_consume_token(139);
                    break;
                }
                default: {
                    this.jj_la1[110] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            next = this.jj_consume_token(154);
            if (prevDelim != null && !prevDelim.image.equals(delim.image)) {
                this.errorReporter.report(this.createSrcLoc(delim, new Token[0]), PARSER_ERROR, delim.image, "'" + prevDelim.image + "'");
            }
            if (sb == null) {
                sb = new StringBuilder();
                sb.append(first.image);
            }
            sb.append(delim.image).append(next.image);
            prevDelim = delim;
        }
        return sb == null ? Identifier.create(first.image, this.createSrcLoc(first, new Token[0])) : Identifier.create(sb.toString(), this.createSrcLoc(first, next));
    }

    private final Token Keyword(String keyword) throws ParseException {
        Token ident = this.jj_consume_token(154);
        if (!ident.image.equals(keyword)) {
            throw this.generateParseException();
        }
        return ident;
    }

    private final TypeNode TypeExprInput() throws ParseException {
        TypeNode type = this.TypeExpr();
        this.jj_consume_token(0);
        return type;
    }

    private final TypeNode TypeExpr() throws ParseException {
        ArrayList<TypeNode> members = null;
        TypeNode first = this.PrimaryType();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 150: {
                    break;
                }
                default: {
                    this.jj_la1[111] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(150);
            TypeNode next = this.PrimaryType();
            if (members == null) {
                members = new ArrayList<TypeNode>();
                members.add(first);
            }
            members.add(next);
        }
        return members == null ? first : UnionTypeNode.create(members);
    }

    private final TypeNode PrimaryType() throws ParseException {
        TypeNode type;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 154: {
                type = this.NamedType();
                break;
            }
            case 107: {
                type = this.NullType();
                break;
            }
            case 122: {
                type = this.UnknownType();
                break;
            }
            case 141: {
                type = this.RecordType();
                break;
            }
            case 148: {
                type = this.TemplateType();
                break;
            }
            default: {
                this.jj_la1[112] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return type;
    }

    private final TypeNode TemplateType() throws ParseException {
        Object parameters = ImmutableList.of();
        Token open = this.jj_consume_token(148);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 154: 
            case 155: {
                TemplateTypeNode.Parameter parameter = this.TemplateParameter();
                parameters = new ArrayList();
                parameters.add(parameter);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 144: {
                            break;
                        }
                        default: {
                            this.jj_la1[113] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(144);
                    parameter = this.TemplateParameter();
                    parameters.add(parameter);
                }
            }
            default: {
                this.jj_la1[114] = this.jj_gen;
            }
        }
        Token close = this.jj_consume_token(149);
        Token arrow = this.jj_consume_token(152);
        TypeNode returnType = this.NamedType();
        SourceLocation srcLoc = this.createSrcLoc(open, returnType.sourceLocation().getEndPoint());
        return TemplateTypeNode.create(srcLoc, (Iterable<TemplateTypeNode.Parameter>)parameters, returnType);
    }

    private final TemplateTypeNode.Parameter TemplateParameter() throws ParseException {
        Token parameterName;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 154: {
                parameterName = this.jj_consume_token(154);
                break;
            }
            case 155: {
                parameterName = this.jj_consume_token(155);
                break;
            }
            default: {
                this.jj_la1[115] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_consume_token(123);
        TypeNode parameterType = this.TypeExpr();
        TemplateType.ParameterKind kind = TemplateType.ParameterKind.PARAM;
        String paramName = parameterName.image;
        if (paramName.startsWith("@")) {
            kind = TemplateType.ParameterKind.ATTRIBUTE;
            paramName = TemplateType.Parameter.attrToParamName(paramName.substring(1));
        }
        return TemplateTypeNode.Parameter.create(this.createSrcLoc(parameterName, new Token[0]), paramName, parameterName.image, kind, parameterType);
    }

    private final FunctionTypeNode FunctionType() throws ParseException {
        Object parameters = ImmutableList.of();
        Token open = this.jj_consume_token(148);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 154: {
                FunctionTypeNode.Parameter parameter = this.FunctionParameter();
                parameters = new ArrayList();
                parameters.add(parameter);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 144: {
                            break;
                        }
                        default: {
                            this.jj_la1[116] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(144);
                    parameter = this.FunctionParameter();
                    parameters.add(parameter);
                }
            }
            default: {
                this.jj_la1[117] = this.jj_gen;
            }
        }
        Token close = this.jj_consume_token(149);
        Token arrow = this.jj_consume_token(152);
        TypeNode returnType = this.TypeExpr();
        SourceLocation srcLoc = this.createSrcLoc(open, returnType.sourceLocation().getEndPoint());
        return FunctionTypeNode.create(srcLoc, (Iterable<FunctionTypeNode.Parameter>)parameters, returnType);
    }

    private final FunctionTypeNode.Parameter FunctionParameter() throws ParseException {
        Token parameterName = this.jj_consume_token(154);
        this.jj_consume_token(123);
        TypeNode parameterType = this.TypeExpr();
        String paramName = parameterName.image;
        return FunctionTypeNode.Parameter.create(this.createSrcLoc(parameterName, new Token[0]), paramName, parameterName.image, parameterType);
    }

    private final TypeNode RecordType() throws ParseException {
        Object properties = ImmutableList.of();
        Token open = this.jj_consume_token(141);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 154: {
                RecordTypeNode.Property prop = this.RecordField();
                properties = new ArrayList();
                properties.add(prop);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 144: {
                            break;
                        }
                        default: {
                            this.jj_la1[118] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(144);
                    prop = this.RecordField();
                    properties.add(prop);
                }
            }
            default: {
                this.jj_la1[119] = this.jj_gen;
            }
        }
        Token close = this.jj_consume_token(142);
        SourceLocation srcLoc = this.createSrcLoc(open, close);
        if (properties.isEmpty()) {
            this.errorReporter.report(srcLoc, EMPTY_RECORD_TYPE, new Object[0]);
        }
        return RecordTypeNode.create(srcLoc, (Iterable<RecordTypeNode.Property>)properties);
    }

    private final RecordTypeNode.Property RecordField() throws ParseException {
        Token fieldName = this.jj_consume_token(154);
        this.jj_consume_token(123);
        TypeNode fieldType = this.TypeExpr();
        return RecordTypeNode.Property.create(this.createSrcLoc(fieldName, new Token[0]), fieldName.image, fieldType);
    }

    private final TypeNode NullType() throws ParseException {
        Token tok = this.jj_consume_token(107);
        return NamedTypeNode.create(this.createSrcLoc(tok, new Token[0]), tok.image);
    }

    private final TypeNode NamedType() throws ParseException {
        Object genericArgs = ImmutableList.of();
        Identifier identifier = this.DottedOrDashedIdent();
        SourceLocation fullLocation = identifier.location();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 129: {
                Token open = this.jj_consume_token(129);
                block3 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 107: 
                    case 122: 
                    case 141: 
                    case 148: 
                    case 154: {
                        TypeNode arg = this.TypeExpr();
                        genericArgs = new ArrayList();
                        genericArgs.add(arg);
                        while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 144: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[120] = this.jj_gen;
                                    break block3;
                                }
                            }
                            this.jj_consume_token(144);
                            arg = this.TypeExpr();
                            genericArgs.add(arg);
                        }
                    }
                    default: {
                        this.jj_la1[121] = this.jj_gen;
                    }
                }
                Token close = this.jj_consume_token(130);
                return GenericTypeNode.create(fullLocation.extend(this.createSrcLoc(close, new Token[0])), identifier, (Iterable<? extends TypeNode>)genericArgs);
            }
        }
        this.jj_la1[122] = this.jj_gen;
        return NamedTypeNode.create(identifier);
    }

    private final TypeNode UnknownType() throws ParseException {
        Token tok = this.jj_consume_token(122);
        return NamedTypeNode.create(this.createSrcLoc(tok, new Token[0]), "?");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    private boolean jj_3R_42() {
        return this.jj_scan_token(144);
    }

    private boolean jj_3R_43() {
        return this.jj_scan_token(144);
    }

    private boolean jj_3R_41() {
        Token xsp;
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_42());
        xsp = this.jj_scanpos = xsp;
        if (this.jj_3R_43()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(142);
    }

    private boolean jj_3_1() {
        return this.jj_3R_41();
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{6145, 4096, 9216, 9216, 16384, 0, Integer.MIN_VALUE, 0, 0, 0, 0, 0, 65536, 0, 0x120000, 0x120000, 0, 0, 0, 0, 0x600000, 0x600000, 0x600000, Integer.MIN_VALUE, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{0, 0, 0, 0, 0, 4, 3, 48, 48, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 66846720, 0, 0x4000000, 0x4000000, 133955584, 130560, 0, 129536, 130560, 130560, 123392, 0, 0, 6144, 0, 536608768, 536608768, 0x18000000, 0, 0x18000000, 0, 0, 0, 0, 536608768, 0, 536608768, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x18000000, Integer.MIN_VALUE, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    private static void jj_la1_init_2() {
        jj_la1_2 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 799081746, 799081746, 799081746, 748683520, 0x3000002, 66576, 4, 0, 0, 799102226, 20480, 799102226, 262144, 262144, 0x3000000, 0, 0, 0, 32, 64, 262144, 524288, 0, 0x100000, -1073741824, -1073741824, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    private static void jj_la1_init_3() {
        jj_la1_3 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 522240, 522240, 0, 0, 0, 0, 64, 512, 0, 1536, 1536, 1536, 1536, 512, 512, 0, 0, 512, 0, 0, 12, 0, 3, 1536, 1536, 0, 0, 0, 0, 0, 512, 512, 1536, 0, 1536, 0, 0, 0, 0, 0x8000000, 0x8000001, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x8000001, 0, 0, 0, 0x8000000, 522240, 0x14000000, 0x14000000, 0x20000000, 0x40000000, Integer.MIN_VALUE, Integer.MIN_VALUE, 0, 0, 0, 0, 0, 0, 0, 522240, 0, 0, 0, 0, 0, 0, 522240, 522240, 0, 0, 0x8000000, 522240, 0, 522240, 0, 0, 0, 522240, 393216, 0, 0, 0, 0, 0x4000800, 0, 0, 0, 0, 0, 0, 0, 0, 0x4000800, 0};
    }

    private static void jj_la1_init_4() {
        jj_la1_4 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0x4000000, 0x4000000, 0x4000000, 0, 0x4000000, 0, 0, 0x4000000, 0x4000000, 101721152, 101721152, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x800000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x400000, 0, 0x4000000, 0, 0, 0, 0, 65536, 0, 0, 0, 0, 0, 0x4000000, 65536, 65536, 65536, 0x210000, 103818304, 0, 0, 0, 0, 1, 1, 30, 30, 96, 96, 896, 896, 0x2000440, 101721152, 33601536, 6144, 0x100000, 40960, 47104, 33601536, 68165632, 103818304, 0x100000, 65536, 0, 101721152, 131072, 101737536, 65536, 524288, 65536, 0, 0, 2048, 2112, 2112, 0x400000, 68165632, 65536, 0xC000000, 0xC000000, 65536, 0x4000000, 65536, 0x4000000, 65536, 68165632, 2};
    }

    private static void jj_la1_init_5() {
        jj_la1_5 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    public SoyFileParser(InputStream stream) {
        this(stream, null);
    }

    public SoyFileParser(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new SoyFileParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 123; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 123; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public SoyFileParser(Reader stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new SoyFileParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 123; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        if (this.jj_input_stream == null) {
            this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        } else {
            this.jj_input_stream.ReInit(stream, 1, 1);
        }
        if (this.token_source == null) {
            this.token_source = new SoyFileParserTokenManager(this.jj_input_stream);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 123; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public SoyFileParser(SoyFileParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 123; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(SoyFileParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 123; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk_f() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                boolean isMatched = true;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] == this.jj_expentry[i]) continue;
                    isMatched = false;
                    break;
                }
                if (!isMatched) continue;
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[167];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 123; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) != 0) {
                    la1tokens[32 + j] = true;
                }
                if ((jj_la1_2[i] & 1 << j) != 0) {
                    la1tokens[64 + j] = true;
                }
                if ((jj_la1_3[i] & 1 << j) != 0) {
                    la1tokens[96 + j] = true;
                }
                if ((jj_la1_4[i] & 1 << j) != 0) {
                    la1tokens[128 + j] = true;
                }
                if ((jj_la1_5[i] & 1 << j) == 0) continue;
                la1tokens[160 + j] = true;
            }
        }
        for (i = 0; i < 167; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 1; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        SoyFileParser.jj_la1_init_0();
        SoyFileParser.jj_la1_init_1();
        SoyFileParser.jj_la1_init_2();
        SoyFileParser.jj_la1_init_3();
        SoyFileParser.jj_la1_init_4();
        SoyFileParser.jj_la1_init_5();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }

    private static final class AbortParsingError
    extends Error {
        private AbortParsingError() {
        }
    }
}

