/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.sharedpasses.render;

import com.google.errorprone.annotations.FormatMethod;
import com.google.errorprone.annotations.FormatString;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateNode;
import java.util.ArrayDeque;
import java.util.Deque;
import javax.annotation.Nullable;

public final class RenderException
extends RuntimeException {
    private final Deque<StackTraceElement> soyStackTrace = new ArrayDeque<StackTraceElement>();

    public static RenderException create(String message) {
        return RenderException.create(message, null);
    }

    public static RenderException create(String message, Throwable cause) {
        return new RenderException(message, cause);
    }

    @FormatMethod
    public static RenderException createF(@FormatString String format, Object ... args) {
        return RenderException.create(String.format(format, args), null);
    }

    @FormatMethod
    public static RenderException createF(@FormatString String format, Throwable cause, Object ... args) {
        return RenderException.create(String.format(format, args), cause);
    }

    public static RenderException createWithSource(String message, SoyNode source) {
        return RenderException.createWithSource(message, null, source);
    }

    public static RenderException createWithSource(String message, @Nullable Throwable cause, SoyNode source) {
        return new RenderException(message, cause).addStackTraceElement(source);
    }

    public static RenderException createFromRenderException(String message, RenderException cause, SoyNode node) {
        RenderException renderException = new RenderException(message, cause.getCause());
        renderException.soyStackTrace.addAll(cause.soyStackTrace);
        renderException.addStackTraceElement(node);
        return renderException;
    }

    private RenderException(String message, Throwable cause) {
        super(message, cause);
    }

    @Override
    public synchronized Throwable fillInStackTrace() {
        return this;
    }

    RenderException addStackTraceElement(SoyNode node) {
        TemplateNode template = node.getNearestAncestor(TemplateNode.class);
        return this.addStackTraceElement(template, node.getSourceLocation());
    }

    RenderException addStackTraceElement(TemplateNode template, SourceLocation location) {
        this.soyStackTrace.add(template.createStackTraceElement(location));
        return this;
    }

    public void finalizeStackTrace(Throwable t) {
        t.setStackTrace(this.concatWithJavaStackTrace(t.getStackTrace()));
    }

    private StackTraceElement[] concatWithJavaStackTrace(StackTraceElement[] javaStackTrace) {
        if (this.soyStackTrace.isEmpty()) {
            return javaStackTrace;
        }
        StackTraceElement[] finalStackTrace = new StackTraceElement[this.soyStackTrace.size() + javaStackTrace.length];
        this.soyStackTrace.toArray(finalStackTrace);
        System.arraycopy(javaStackTrace, 0, finalStackTrace, this.soyStackTrace.size(), javaStackTrace.length);
        return finalStackTrace;
    }
}

