/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.sharedpasses.render;

import com.google.common.base.Preconditions;
import com.google.template.soy.data.SoyRecord;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.SoyValueProvider;
import com.google.template.soy.data.restricted.NullData;
import com.google.template.soy.data.restricted.UndefinedData;
import com.google.template.soy.exprtree.VarDefn;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.defn.TemplateParam;
import java.util.IdentityHashMap;

public abstract class Environment {
    Environment() {
    }

    static Environment create(TemplateNode template, SoyRecord data, SoyRecord ijData) {
        return new Impl(template, data, ijData);
    }

    public static Environment prerenderingEnvironment() {
        return new EmptyImpl();
    }

    abstract void bind(VarDefn var1, SoyValueProvider var2);

    abstract void bindLoopPosition(VarDefn var1, SoyValueProvider var2);

    abstract SoyValue getVar(VarDefn var1);

    abstract boolean hasVar(VarDefn var1);

    abstract SoyValueProvider getVarProvider(VarDefn var1);

    private static final class EmptyImpl
    extends Environment {
        private EmptyImpl() {
        }

        @Override
        void bind(VarDefn var, SoyValueProvider value) {
            throw new UnsupportedOperationException();
        }

        @Override
        void bindLoopPosition(VarDefn loopVar, SoyValueProvider value) {
            throw new UnsupportedOperationException();
        }

        @Override
        SoyValueProvider getVarProvider(VarDefn var) {
            return UndefinedData.INSTANCE;
        }

        @Override
        SoyValue getVar(VarDefn var) {
            return UndefinedData.INSTANCE;
        }

        @Override
        boolean hasVar(VarDefn var) {
            return false;
        }
    }

    private static final class Impl
    extends Environment {
        final IdentityHashMap<VarDefn, Object> localVariables = new IdentityHashMap();
        final SoyRecord data;

        Impl(TemplateNode template, SoyRecord data, SoyRecord ijData) {
            this.data = data;
            for (TemplateParam param : template.getAllParams()) {
                SoyValueProvider provider = (param.isInjected() ? ijData : data).getFieldProvider(param.name());
                if (provider == null) {
                    provider = param.isRequired() || param.hasDefault() ? UndefinedData.INSTANCE : NullData.INSTANCE;
                }
                this.bind(param, provider);
            }
        }

        @Override
        void bind(VarDefn var, SoyValueProvider value) {
            this.localVariables.put(var, value);
        }

        @Override
        void bindLoopPosition(VarDefn loopVar, SoyValueProvider value) {
            LoopPosition position = (LoopPosition)this.localVariables.computeIfAbsent(loopVar, ignored -> new LoopPosition());
            position.item = value;
        }

        @Override
        SoyValueProvider getVarProvider(VarDefn var) {
            if (var.kind() == VarDefn.Kind.UNDECLARED) {
                SoyValueProvider provider = this.data.getFieldProvider(var.name());
                return provider != null ? provider : UndefinedData.INSTANCE;
            }
            Object o = this.localVariables.get(var);
            if (o instanceof LoopPosition) {
                return ((LoopPosition)o).item;
            }
            return (SoyValueProvider)o;
        }

        @Override
        SoyValue getVar(VarDefn var) {
            return ((SoyValueProvider)Preconditions.checkNotNull((Object)this.getVarProvider(var), (String)"No value for %s at %s. All: %s", (Object)var.name(), (Object)var.nameLocation().toLineColumnString(), this.localVariables.keySet())).resolve();
        }

        @Override
        boolean hasVar(VarDefn var) {
            return this.data.hasField(var.name());
        }

        private static final class LoopPosition {
            SoyValueProvider item;

            private LoopPosition() {
            }
        }
    }
}

