/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.shared;

import com.google.template.soy.base.SourceFilePath;
import com.google.template.soy.base.internal.SoyFileSupplier;
import com.google.template.soy.soytree.SoyFileNode;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.concurrent.GuardedBy;
import javax.inject.Inject;

public final class SoyAstCache {
    @GuardedBy(value="this")
    private final Map<SourceFilePath, VersionedFile> cache = new HashMap<SourceFilePath, VersionedFile>();

    @Inject
    public SoyAstCache() {
    }

    public synchronized void put(SourceFilePath fileName, SoyFileSupplier.Version version, SoyFileNode file) {
        this.cache.put(fileName, new VersionedFile(file, version));
    }

    public synchronized SoyFileNode get(SourceFilePath fileName, SoyFileSupplier.Version version) {
        VersionedFile entry = this.cache.get(fileName);
        if (entry != null) {
            if (entry.version.equals(version)) {
                return entry.file;
            }
            this.cache.remove(fileName);
        }
        return null;
    }

    public synchronized boolean evict(SourceFilePath fileName) {
        VersionedFile entry = this.cache.remove(fileName);
        return entry != null;
    }

    private static final class VersionedFile {
        final SoyFileNode file;
        final SoyFileSupplier.Version version;

        VersionedFile(SoyFileNode file, SoyFileSupplier.Version version) {
            this.file = file;
            this.version = version;
        }
    }
}

