/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.plugin.java.internal;

import com.google.auto.value.AutoOneOf;
import com.google.template.soy.plugin.java.internal.AutoOneOf_ValidatorValue_ValueType;
import com.google.template.soy.plugin.java.internal.ValidatorErrorReporter;
import com.google.template.soy.plugin.java.restricted.JavaValue;
import com.google.template.soy.plugin.java.restricted.MethodSignature;
import com.google.template.soy.types.BoolType;
import com.google.template.soy.types.FloatType;
import com.google.template.soy.types.IntType;
import com.google.template.soy.types.PrimitiveType;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.StringType;
import javax.annotation.Nullable;

final class ValidatorValue
implements JavaValue {
    private final boolean error;
    private final ValueType valueType;
    private final ValidatorErrorReporter reporter;
    private final MethodSignature methodSignature;

    static ValidatorValue forConstantNull(ValidatorErrorReporter reporter) {
        return new ValidatorValue(AutoOneOf_ValidatorValue_ValueType.constantNull(true), false, null, reporter);
    }

    static ValidatorValue forSoyType(SoyType type, ValidatorErrorReporter reporter) {
        return new ValidatorValue(AutoOneOf_ValidatorValue_ValueType.soyType(type), false, null, reporter);
    }

    static ValidatorValue forClazz(Class<?> clazz, ValidatorErrorReporter reporter) {
        return new ValidatorValue(AutoOneOf_ValidatorValue_ValueType.clazz(clazz), false, null, reporter);
    }

    static ValidatorValue forError(Class<?> clazz, ValidatorErrorReporter reporter) {
        return new ValidatorValue(AutoOneOf_ValidatorValue_ValueType.clazz(clazz), true, null, reporter);
    }

    static ValidatorValue forError(SoyType type, ValidatorErrorReporter reporter) {
        return new ValidatorValue(AutoOneOf_ValidatorValue_ValueType.soyType(type), true, null, reporter);
    }

    static ValidatorValue forMethodReturnType(MethodSignature method, ValidatorErrorReporter reporter) {
        PrimitiveType type = null;
        if (method.returnType() == Boolean.TYPE) {
            type = BoolType.getInstance();
        }
        if (method.returnType() == Integer.TYPE || method.returnType() == Long.TYPE) {
            type = IntType.getInstance();
        }
        if (method.returnType() == Integer.TYPE) {
            type = IntType.getInstance();
        }
        if (method.returnType() == Double.TYPE) {
            type = FloatType.getInstance();
        }
        if (method.returnType() == String.class) {
            type = StringType.getInstance();
        }
        if (type != null) {
            return new ValidatorValue(AutoOneOf_ValidatorValue_ValueType.soyType(type), false, method, reporter);
        }
        return new ValidatorValue(AutoOneOf_ValidatorValue_ValueType.clazz(method.returnType()), false, method, reporter);
    }

    private ValidatorValue(ValueType valueType, boolean error, MethodSignature method, ValidatorErrorReporter reporter) {
        this.valueType = valueType;
        this.reporter = reporter;
        this.error = error;
        this.methodSignature = method;
    }

    @Override
    public ValidatorValue isNonNull() {
        return ValidatorValue.forSoyType(BoolType.getInstance(), this.reporter);
    }

    @Override
    public ValidatorValue isNull() {
        return ValidatorValue.forSoyType(BoolType.getInstance(), this.reporter);
    }

    @Override
    public ValidatorValue asSoyBoolean() {
        return this.asValue(BoolType.getInstance(), "asSoyBoolean");
    }

    @Override
    public ValidatorValue asSoyString() {
        return this.asValue(StringType.getInstance(), "asSoyString");
    }

    @Override
    public ValidatorValue asSoyInt() {
        return this.asValue(IntType.getInstance(), "asSoyInt");
    }

    @Override
    public ValidatorValue asSoyFloat() {
        return this.asValue(FloatType.getInstance(), "asSoyFloat");
    }

    private ValidatorValue asValue(SoyType newType, String methodName) {
        if (this.valueType.type() != ValueType.Type.SOY_TYPE) {
            this.reporter.nonSoyExpressionNotConvertible(this.isConstantNull() ? Object.class : this.valueType.clazz(), newType, methodName);
            return ValidatorValue.forError(newType, this.reporter);
        }
        if (!this.valueType.soyType().isAssignableFromStrict(newType)) {
            this.reporter.incompatibleSoyType(this.valueType.soyType(), newType, methodName);
            return ValidatorValue.forError(newType, this.reporter);
        }
        return ValidatorValue.forSoyType(newType, this.reporter);
    }

    @Override
    public ValidatorValue coerceToSoyBoolean() {
        if (this.valueType.type() != ValueType.Type.SOY_TYPE) {
            this.reporter.nonSoyExpressionNotCoercible(this.isConstantNull() ? Object.class : this.valueType.clazz(), BoolType.getInstance(), "coerceToSoyBoolean");
            return ValidatorValue.forError(BoolType.getInstance(), this.reporter);
        }
        return ValidatorValue.forSoyType(BoolType.getInstance(), this.reporter);
    }

    @Override
    public ValidatorValue coerceToSoyString() {
        if (this.valueType.type() != ValueType.Type.SOY_TYPE) {
            this.reporter.nonSoyExpressionNotCoercible(this.isConstantNull() ? Object.class : this.valueType.clazz(), StringType.getInstance(), "coerceToSoyString");
            return ValidatorValue.forError(StringType.getInstance(), this.reporter);
        }
        return ValidatorValue.forSoyType(StringType.getInstance(), this.reporter);
    }

    @Nullable
    MethodSignature methodInfo() {
        return this.methodSignature;
    }

    boolean isError() {
        return this.error;
    }

    ValueType valueType() {
        return this.valueType;
    }

    boolean hasSoyType() {
        return this.valueType.type() == ValueType.Type.SOY_TYPE;
    }

    boolean isConstantNull() {
        return this.valueType.type() == ValueType.Type.CONSTANT_NULL;
    }

    boolean hasClazz() {
        return this.valueType.type() == ValueType.Type.CLAZZ;
    }

    @AutoOneOf(value=Type.class)
    static abstract class ValueType {
        ValueType() {
        }

        abstract Type type();

        abstract boolean constantNull();

        abstract SoyType soyType();

        abstract Class<?> clazz();

        static enum Type {
            CONSTANT_NULL,
            SOY_TYPE,
            CLAZZ;

        }
    }
}

