/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.plugin.java.internal;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.plugin.java.MethodChecker;
import com.google.template.soy.plugin.java.ReadMethodData;
import com.google.template.soy.plugin.java.internal.CompiledJarsPluginSignatureReader;
import java.util.List;

public abstract class AbstractMethodChecker
implements MethodChecker {
    @Override
    public final MethodChecker.Response findMethod(String className, String methodName, String returnType, List<String> arguments) {
        CompiledJarsPluginSignatureReader.ClassSignatures signatures = this.getSignatures(className);
        if (signatures.equals(CompiledJarsPluginSignatureReader.ClassSignatures.EMPTY)) {
            return MethodChecker.Response.error(MethodChecker.Code.NO_SUCH_CLASS);
        }
        CompiledJarsPluginSignatureReader.MethodSignatures methodsForSig = signatures.forPartial(CompiledJarsPluginSignatureReader.PartialSignature.create(methodName, (ImmutableList<String>)ImmutableList.copyOf(arguments)));
        if (methodsForSig.equals(CompiledJarsPluginSignatureReader.MethodSignatures.EMPTY)) {
            ImmutableList methodsMatchingName = (ImmutableList)signatures.allPartials().stream().filter(p -> p.methodName().equals(methodName)).collect(ImmutableList.toImmutableList());
            if (methodsMatchingName.isEmpty()) {
                return MethodChecker.Response.error(MethodChecker.Code.NO_SUCH_METHOD_NAME, (ImmutableCollection<String>)((ImmutableCollection)signatures.allPartials().stream().map(CompiledJarsPluginSignatureReader.PartialSignature::methodName).collect(ImmutableList.toImmutableList())));
            }
            ImmutableList suggestedSigs = (ImmutableList)methodsMatchingName.stream().map(CompiledJarsPluginSignatureReader.PartialSignature::toString).collect(ImmutableList.toImmutableList());
            return MethodChecker.Response.error(MethodChecker.Code.NO_SUCH_METHOD_SIG, (ImmutableCollection<String>)suggestedSigs);
        }
        ReadMethodData method = methodsForSig.forReturnType(returnType);
        if (method != null) {
            if (!method.isPublic()) {
                return MethodChecker.Response.error(MethodChecker.Code.NOT_PUBLIC);
            }
            return MethodChecker.Response.success(method);
        }
        return MethodChecker.Response.error(MethodChecker.Code.NO_SUCH_RETURN_TYPE, methodsForSig.returnTypes());
    }

    protected abstract CompiledJarsPluginSignatureReader.ClassSignatures getSignatures(String var1);
}

