/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.TemplateLiteralNode;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.passes.CompilerFileSetPass;
import com.google.template.soy.passes.FinalizeTemplateRegistryPass;
import com.google.template.soy.passes.PassManager;
import com.google.template.soy.passes.ResolveExpressionTypesPass;
import com.google.template.soy.passes.RunAfter;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.CallParamValueNode;
import com.google.template.soy.soytree.CommandTagAttribute;
import com.google.template.soy.soytree.HtmlOpenTagNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.TemplateImportType;
import com.google.template.soy.types.TemplateType;
import java.util.List;

@RunAfter(value={ResolveExpressionTypesPass.class, FinalizeTemplateRegistryPass.class})
final class ShortFormCallPass
implements CompilerFileSetPass {
    private final ErrorReporter errorReporter;
    private final PassManager.AstRewrites astRewrites;

    ShortFormCallPass(PassManager.AstRewrites astRewrites, ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        this.astRewrites = astRewrites;
    }

    @Override
    public CompilerFileSetPass.Result run(ImmutableList<SoyFileNode> sourceFiles, IdGenerator idGenerator) {
        if (this.errorReporter.hasErrors()) {
            return CompilerFileSetPass.Result.CONTINUE;
        }
        for (SoyFileNode file : sourceFiles) {
            this.run(file, idGenerator);
        }
        return CompilerFileSetPass.Result.CONTINUE;
    }

    public void run(SoyFileNode file, IdGenerator nodeIdGen) {
        for (TemplateNode template : file.getTemplates()) {
            if (this.astRewrites == PassManager.AstRewrites.TRICORDER || this.astRewrites == PassManager.AstRewrites.NONE) continue;
            for (PrintNode printNode : SoyTreeUtils.getAllNodesOfType(template, PrintNode.class)) {
                if (printNode.getParent() instanceof HtmlOpenTagNode) continue;
                this.process(printNode, nodeIdGen);
            }
        }
    }

    private void process(PrintNode printNode, IdGenerator nodeIdGen) {
        if (printNode.getExpr().getRoot() instanceof FunctionNode && !((FunctionNode)printNode.getExpr().getRoot()).hasStaticName() && ((FunctionNode)printNode.getExpr().getRoot()).getNameExpr() != null) {
            SoyType type;
            ExprNode callee;
            FunctionNode fnNode = (FunctionNode)printNode.getExpr().getRoot();
            if (fnNode.getNameExpr() instanceof VarRefNode && fnNode.getNameExpr().getType() instanceof TemplateImportType) {
                TemplateLiteralNode templateLiteralNode = TemplateLiteralNode.forVarRef((VarRefNode)fnNode.getNameExpr());
                templateLiteralNode.setStaticCall(true);
                callee = templateLiteralNode;
                type = ((TemplateImportType)fnNode.getNameExpr().getType()).getBasicTemplateType();
                templateLiteralNode.setType(type);
            } else if (fnNode.getNameExpr().getType() instanceof TemplateType) {
                callee = fnNode.getNameExpr().copy(new CopyState());
                type = callee.getType();
            } else {
                return;
            }
            CallBasicNode call = new CallBasicNode(nodeIdGen.genId(), printNode.getSourceLocation(), printNode.getExpr().getSourceLocation(), callee, (List<CommandTagAttribute>)ImmutableList.of(), false, this.errorReporter);
            call.getCalleeExpr().setType(type);
            for (int i = 0; i < fnNode.getParamNames().size(); ++i) {
                Identifier identifier = (Identifier)fnNode.getParamNames().get(i);
                CallParamValueNode valueNode = new CallParamValueNode(nodeIdGen.genId(), identifier.location(), identifier, fnNode.getParams().get(i).copy(new CopyState()));
                valueNode.getExpr().setType(fnNode.getParams().get(i).getType());
                call.addChild(valueNode);
            }
            printNode.getParent().replaceChild(printNode, call);
        }
    }
}

