/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.base.internal.TemplateContentKind;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.error.SoyErrors;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.MethodCallNode;
import com.google.template.soy.exprtree.TemplateLiteralNode;
import com.google.template.soy.passes.CompilerFileSetPass;
import com.google.template.soy.passes.ResolveExpressionTypesPass;
import com.google.template.soy.passes.RunAfter;
import com.google.template.soy.shared.internal.BuiltinFunction;
import com.google.template.soy.shared.internal.BuiltinMethod;
import com.google.template.soy.soytree.HtmlAttributeNode;
import com.google.template.soy.soytree.HtmlOpenTagNode;
import com.google.template.soy.soytree.HtmlTagNode;
import com.google.template.soy.soytree.IfCondNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.TagName;
import com.google.template.soy.types.SanitizedType;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypes;
import com.google.template.soy.types.StringType;
import com.google.template.soy.types.TemplateType;
import com.google.template.soy.types.UnknownType;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

@RunAfter(value={ResolveExpressionTypesPass.class})
final class ResolveExpressionTypesCrossTemplatePass
implements CompilerFileSetPass {
    private static final SoyErrorKind ELEMENT_CALL_TO_HTML_TEMPLATE = SoyErrorKind.of("Expected a template with kind 'html<?>' that is completely bound or only has html parameters, but found `{0}`.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind ONLY_STRICT_HTML_TEMPLATES_ALLOWED = SoyErrorKind.of("Only strict HTML templates are allowed in expressions, but template `{0}` was not strict HTML.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind ILLEGAL_USE = SoyErrorKind.of("''legacyDynamicTag'' may only be used to name an HTML tag.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind NEED_WRAP = SoyErrorKind.of("A dynamic tag name should be wrapped in the ''legacyDynamicTag'' function.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind ONLY_ONE_CLOSE_TAG = SoyErrorKind.of("Element calls require exactly one close tag.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind NON_STATIC_ATTRIBUTE_NAME = SoyErrorKind.of("Element call attribute names must be static.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind NEGATIVE_ATTRIBUTE = SoyErrorKind.of("Callee template does not allow attribute ''{0}''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind PARAM_AS_ATTRIBUTE = SoyErrorKind.of("Param ''{0}'' may not be set as an attribute.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind NO_SUCH_ATTRIBUTE = SoyErrorKind.of("Unrecognized attribute.{0}", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind MISUSED_AT_ATTRIBUTE = SoyErrorKind.of("Attributes with a leading @ should not have values.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind BAD_ATTRIBUTE_NAME = SoyErrorKind.of("Element attribute names must be lower hyphen case.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind NO_ATTRIBUTE_VALUE = SoyErrorKind.of("Element call attributes must have values.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind NO_ATTRIBUTES_ON_SLOT = SoyErrorKind.of("<parameter> elements cannot have attributes except slot, which must have a static value.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind SLOTS_ONLY_ONE_CLOSE_TAG = SoyErrorKind.of("<parameter> elements cannot have more than one close tag.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind SLOTS_ONLY_DIRECT_DESCENDENTS_OF_TEMPLATE_CALL = SoyErrorKind.of("<parameter> elements can only be direct descendents of template calls.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind DUPLICATE_PARAM = SoyErrorKind.of("Duplicate param ''{0}''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind PASSES_UNUSED_PARAM = SoyErrorKind.of("''{0}'' is not a declared parameter of {1} or any indirect callee.{2}", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind MISSING_PARAM = SoyErrorKind.of("Call missing required param ''{0}''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind MISSING_ATTRIBUTE = SoyErrorKind.of("Call missing required attribute ''{0}''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind ONLY_SLOTS_ALLOWED = SoyErrorKind.of("Element calls require all children to be <parameter> elements.", new SoyErrorKind.StyleAllowance[0]);
    private final ErrorReporter errorReporter;
    private final boolean astRewrites;

    ResolveExpressionTypesCrossTemplatePass(ErrorReporter errorReporter, boolean astRewrites) {
        this.errorReporter = errorReporter;
        this.astRewrites = astRewrites;
    }

    @Override
    public CompilerFileSetPass.Result run(ImmutableList<SoyFileNode> sourceFiles, IdGenerator idGenerator) {
        for (SoyFileNode file : sourceFiles) {
            this.checkTemplateLiteralsUsedInExpr(file);
            if (!this.astRewrites) continue;
            this.handleDynamicTagAndCheckForLegacyDynamicTags(file);
        }
        return CompilerFileSetPass.Result.CONTINUE;
    }

    private void checkTemplateLiteralsUsedInExpr(SoyFileNode file) {
        SoyTreeUtils.allNodesOfType(file, ExprNode.class).filter(exprNode -> exprNode.getKind() == ExprNode.Kind.TEMPLATE_LITERAL_NODE && !((TemplateLiteralNode)exprNode).isStaticCall()).map(TemplateLiteralNode.class::cast).forEach(templateNode -> Streams.stream(SoyTypes.getTypeTraverser(templateNode.getType(), null)).filter(t -> t.getKind() == SoyType.Kind.TEMPLATE).map(TemplateType.class::cast).filter(templateType -> templateType.getContentKind().getSanitizedContentKind().isHtml() && !templateType.isStrictHtml()).forEach(templateType -> this.errorReporter.report(templateNode.getSourceLocation(), ONLY_STRICT_HTML_TEMPLATES_ALLOWED, templateNode.getResolvedName())));
    }

    private void handleDynamicTagAndCheckForLegacyDynamicTags(SoyFileNode file) {
        HashSet correctlyPlaced = new HashSet();
        HashSet allowedSlots = new HashSet();
        SoyTreeUtils.allNodesOfType(file, HtmlTagNode.class).filter(tag -> !tag.getTagName().isStatic()).forEach(tagNode -> {
            SoyType type = tagNode.getTagName().getDynamicTagName().getExpr().getType();
            if (type.isAssignableFromStrict(StringType.getInstance())) {
                this.handleDynamicTag((HtmlTagNode)tagNode, correctlyPlaced);
            } else if (!(type instanceof TemplateType) || !(((TemplateType)type).getContentKind() instanceof TemplateContentKind.ElementContentKind)) {
                this.errorReporter.report(tagNode.getSourceLocation(), ELEMENT_CALL_TO_HTML_TEMPLATE, tagNode.getTagName().getDynamicTagName().getExpr().getType());
            } else {
                this.validateTemplateCall((HtmlOpenTagNode)tagNode, allowedSlots::add);
            }
        });
        SoyTreeUtils.allFunctionInvocations(file, BuiltinFunction.LEGACY_DYNAMIC_TAG).filter(fn -> !correctlyPlaced.contains(fn)).forEach(fn -> this.errorReporter.report(fn.getSourceLocation(), ILLEGAL_USE, new Object[0]));
        SoyTreeUtils.allNodesOfType(file, HtmlOpenTagNode.class).filter(tag -> tag.isSlot() && !allowedSlots.contains(tag)).forEach(tagNode -> this.errorReporter.report(tagNode.getSourceLocation(), SLOTS_ONLY_DIRECT_DESCENDENTS_OF_TEMPLATE_CALL, new Object[0]));
    }

    private void validateTemplateCall(HtmlOpenTagNode openTagNode, Consumer<HtmlTagNode> consumer) {
        boolean defaultSlotFulfilled;
        if (openTagNode.getTaggedPairs().size() > 1) {
            this.errorReporter.report(openTagNode.getSourceLocation(), ONLY_ONE_CLOSE_TAG, new Object[0]);
        }
        HashSet seenSlots = new HashSet();
        HashSet seenAttributes = new HashSet();
        TemplateType templateType = (TemplateType)openTagNode.getTagName().getDynamicTagName().getExpr().getType();
        boolean hasAllAttributes = templateType.getAllowExtraAttributes();
        ImmutableSet<String> reservedAttributes = templateType.getReservedAttributes();
        ImmutableMap allParamsByAttrName = (ImmutableMap)templateType.getParameters().stream().collect(ImmutableMap.toImmutableMap(p -> TemplateType.Parameter.paramToAttrName(p.getName()), p -> p));
        SoyTreeUtils.getAllNodesOfType(openTagNode, HtmlAttributeNode.class).forEach(a -> this.validateAttribute((HtmlAttributeNode)a, seenAttributes::add, (ImmutableMap<String, TemplateType.Parameter>)allParamsByAttrName, hasAllAttributes, reservedAttributes));
        HtmlTagNode closeTag = (HtmlTagNode)Iterables.getFirst(openTagNode.getTaggedPairs(), (Object)openTagNode);
        SoyNode next = SoyTreeUtils.nextSibling(openTagNode);
        boolean bl = defaultSlotFulfilled = !openTagNode.isSelfClosing() && templateType.getParameters().stream().filter(p -> SoyTypes.makeNullable(SanitizedType.HtmlType.getInstance()).isAssignableFromStrict(p.getType())).count() == 1L && (!(next instanceof HtmlOpenTagNode) || !((HtmlOpenTagNode)next).isSlot());
        while (!defaultSlotFulfilled && next != closeTag && !openTagNode.isSelfClosing() && next != null) {
            next = this.consumeSlot(next, openTagNode.getTagName().getDynamicTagName().getExpr(), openTagNode.getSourceLocation(), seenSlots::add, consumer);
        }
        templateType.getParameters().stream().filter(TemplateType.Parameter::isRequired).forEach(p -> {
            if (p.getKind() == TemplateType.ParameterKind.ATTRIBUTE) {
                if (!seenAttributes.contains(p.getName())) {
                    this.errorReporter.report(openTagNode.getSourceLocation(), MISSING_ATTRIBUTE, TemplateType.Parameter.paramToAttrName(p.getName()));
                }
            } else if (!seenSlots.contains(p.getName()) && !defaultSlotFulfilled) {
                this.errorReporter.report(openTagNode.getSourceLocation(), MISSING_PARAM, p.getName());
            }
        });
    }

    private void validateAttribute(HtmlAttributeNode attr, Function<String, Boolean> addAttr, ImmutableMap<String, TemplateType.Parameter> allParamsByAttrName, boolean hasAllAttributes, ImmutableSet<String> reservedAttributes) {
        String name = attr.getStaticKey();
        SourceLocation loc = ((SoyNode.StandaloneNode)attr.getChild(0)).getSourceLocation();
        if (name == null) {
            if (attr.numChildren() != 1) {
                this.errorReporter.report(loc, NON_STATIC_ATTRIBUTE_NAME, new Object[0]);
            }
            return;
        }
        boolean isSoyAttr = name.startsWith("@");
        if (isSoyAttr) {
            name = name.substring(1);
        }
        if (TemplateType.Parameter.isValidAttrName(name)) {
            String paramName = TemplateType.Parameter.attrToParamName(name);
            if ((attr.getParent() instanceof IfCondNode && !attr.getParent().getSourceLocation().isKnown() || attr.getParent() instanceof HtmlOpenTagNode) && !addAttr.apply(paramName).booleanValue()) {
                this.errorReporter.report(loc, DUPLICATE_PARAM, name);
                return;
            }
            if (!hasAllAttributes) {
                TemplateType.Parameter param = (TemplateType.Parameter)allParamsByAttrName.get((Object)name);
                if (param == null) {
                    String didYouMeanMessage = SoyErrors.getDidYouMeanMessage(allParamsByAttrName.entrySet().stream().filter(e -> ((TemplateType.Parameter)e.getValue()).getKind() == TemplateType.ParameterKind.ATTRIBUTE).map(Map.Entry::getKey).collect(Collectors.toList()), name);
                    this.errorReporter.report(loc, NO_SUCH_ATTRIBUTE, didYouMeanMessage);
                    return;
                }
                if (param.getKind() != TemplateType.ParameterKind.ATTRIBUTE) {
                    this.errorReporter.report(loc, PARAM_AS_ATTRIBUTE, param.getName());
                    return;
                }
            } else if (reservedAttributes.contains((Object)name)) {
                this.errorReporter.report(loc, NEGATIVE_ATTRIBUTE, name);
                return;
            }
        } else {
            this.errorReporter.report(loc, BAD_ATTRIBUTE_NAME, new Object[0]);
            return;
        }
        if (!attr.hasValue() && !isSoyAttr && allParamsByAttrName.containsKey((Object)name)) {
            this.errorReporter.report(attr.getSourceLocation(), NO_ATTRIBUTE_VALUE, new Object[0]);
        }
        if (attr.hasValue() && isSoyAttr) {
            this.errorReporter.report(attr.getSourceLocation(), MISUSED_AT_ATTRIBUTE, new Object[0]);
        }
    }

    private SoyNode consumeSlot(SoyNode startNode, ExprNode template, SourceLocation templateLocation, Function<String, Boolean> addParam, Consumer<HtmlTagNode> consumer) {
        if (!(startNode instanceof HtmlOpenTagNode) || !((HtmlOpenTagNode)startNode).isSlot()) {
            this.errorReporter.report(startNode.getSourceLocation(), ONLY_SLOTS_ALLOWED, new Object[0]);
            return null;
        }
        HtmlOpenTagNode nextOpenTag = (HtmlOpenTagNode)startNode;
        if (nextOpenTag.numChildren() != 2) {
            this.errorReporter.report(nextOpenTag.getSourceLocation(), NO_ATTRIBUTES_ON_SLOT, new Object[0]);
            return null;
        }
        if (nextOpenTag.getTaggedPairs().size() > 1) {
            this.errorReporter.report(nextOpenTag.getSourceLocation(), SLOTS_ONLY_ONE_CLOSE_TAG, new Object[0]);
            return null;
        }
        HtmlAttributeNode attributeNode = (HtmlAttributeNode)nextOpenTag.getChild(1);
        if (!attributeNode.hasValue() || attributeNode.getStaticKey() == null || !attributeNode.getStaticKey().equals("slot") || attributeNode.getStaticContent() == null) {
            this.errorReporter.report(attributeNode.getSourceLocation(), NO_ATTRIBUTES_ON_SLOT, new Object[0]);
            return null;
        }
        TemplateType templateType = (TemplateType)template.getType();
        boolean containsParam = templateType.getParameters().stream().anyMatch(p -> p.getName().equals(attributeNode.getStaticContent()));
        if (!containsParam) {
            this.errorReporter.report(templateLocation, PASSES_UNUSED_PARAM, attributeNode.getStaticContent(), template.toSourceString(), SoyErrors.getDidYouMeanMessage((Iterable)templateType.getParameters().stream().map(TemplateType.Parameter::getName).collect(ImmutableList.toImmutableList()), attributeNode.getStaticContent()));
        }
        if (!addParam.apply(attributeNode.getStaticContent()).booleanValue()) {
            this.errorReporter.report(templateLocation, DUPLICATE_PARAM, attributeNode.getStaticContent());
        }
        HtmlTagNode closeTag = nextOpenTag.getTaggedPairs().get(0);
        consumer.accept(nextOpenTag);
        return SoyTreeUtils.nextSibling(closeTag);
    }

    private void handleDynamicTag(HtmlTagNode tagNode, Set<FunctionNode> correctlyPlaced) {
        TagName name = tagNode.getTagName();
        PrintNode printNode = name.getDynamicTagName();
        ExprNode exprNode = printNode.getExpr().getRoot();
        if (exprNode.getKind() == ExprNode.Kind.FUNCTION_NODE) {
            if (((FunctionNode)exprNode).isResolved() && ((FunctionNode)exprNode).getSoyFunction() == BuiltinFunction.LEGACY_DYNAMIC_TAG) {
                FunctionNode functionNode = (FunctionNode)exprNode;
                if (functionNode.numChildren() == 1) {
                    printNode.getExpr().clearChildren();
                    printNode.getExpr().addChild(functionNode.getChild(0));
                }
                correctlyPlaced.add(functionNode);
            }
        } else if (!tagNode.getTagName().isTemplateCall()) {
            if (printNode.getExpr().getType() == UnknownType.getInstance()) {
                if (exprNode instanceof MethodCallNode && ((MethodCallNode)exprNode).isMethodResolved() && ((MethodCallNode)exprNode).getSoyMethod() == BuiltinMethod.BIND) {
                    return;
                }
                if (exprNode instanceof TemplateLiteralNode) {
                    return;
                }
            }
            this.errorReporter.report(printNode.getExpr().getSourceLocation(), NEED_WRAP, new Object[0]);
        }
    }
}

