/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.template.soy.soytree.FileSetMetadata;
import com.google.template.soy.soytree.TemplateMetadata;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.TemplateType;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class IndirectParamsCalculator {
    private final FileSetMetadata fileSetMetadata;
    private Set<TransitiveCallSituation> visitedCallSituations;
    private Map<String, TemplateType.Parameter> indirectParams;
    private SetMultimap<String, TemplateMetadata> paramKeyToCalleesMultimap;
    private SetMultimap<String, SoyType> indirectParamTypes;
    private boolean mayHaveIndirectParamsInExternalCalls;
    private boolean mayHaveIndirectParamsInExternalDelCalls;

    public IndirectParamsCalculator(FileSetMetadata fileSetMetadata) {
        this.fileSetMetadata = (FileSetMetadata)Preconditions.checkNotNull((Object)fileSetMetadata);
    }

    public IndirectParamsInfo calculateIndirectParams(TemplateNode node) {
        return this.calculateIndirectParams(this.fileSetMetadata.getTemplate(node).getTemplateType());
    }

    public IndirectParamsInfo calculateIndirectParams(TemplateType template) {
        this.visitedCallSituations = Sets.newHashSet();
        this.indirectParams = Maps.newHashMap();
        this.paramKeyToCalleesMultimap = HashMultimap.create();
        this.indirectParamTypes = LinkedHashMultimap.create();
        this.mayHaveIndirectParamsInExternalCalls = false;
        this.mayHaveIndirectParamsInExternalDelCalls = false;
        this.visit(template, new HashSet<String>(), new HashSet<TemplateType>());
        return new IndirectParamsInfo((ImmutableSortedMap<String, TemplateType.Parameter>)ImmutableSortedMap.copyOf(this.indirectParams), (ImmutableSetMultimap<String, TemplateMetadata>)ImmutableSetMultimap.copyOf(this.paramKeyToCalleesMultimap), (ImmutableSetMultimap<String, SoyType>)ImmutableSetMultimap.copyOf(this.indirectParamTypes), this.mayHaveIndirectParamsInExternalCalls, this.mayHaveIndirectParamsInExternalDelCalls);
    }

    private void visit(TemplateType template, Set<String> allCallParamKeys, Set<TemplateType> allCallers) {
        if (!allCallers.add(template)) {
            return;
        }
        for (TemplateType.DataAllCallSituation call : template.getDataAllCallSituations()) {
            Set<String> newAllCallParamKeys = allCallParamKeys;
            if (!allCallParamKeys.containsAll((Collection<?>)call.getExplicitlyPassedParameters())) {
                newAllCallParamKeys = new HashSet<String>();
                newAllCallParamKeys.addAll(allCallParamKeys);
                newAllCallParamKeys.addAll((Collection<String>)call.getExplicitlyPassedParameters());
            }
            if (call.isDelCall()) {
                this.mayHaveIndirectParamsInExternalDelCalls = true;
                for (TemplateMetadata delCallee : this.fileSetMetadata.getDelTemplateSelector().delTemplateNameToValues().get((Object)call.getTemplateName())) {
                    this.processCall(template, delCallee, newAllCallParamKeys, allCallers);
                }
                continue;
            }
            TemplateMetadata basicCallee = this.fileSetMetadata.getBasicTemplateOrElement(call.getTemplateName());
            if (basicCallee == null) {
                this.mayHaveIndirectParamsInExternalCalls = true;
                continue;
            }
            this.processCall(template, basicCallee, newAllCallParamKeys, allCallers);
        }
        allCallers.remove(template);
    }

    private void processCall(TemplateType caller, TemplateMetadata callee, Set<String> allCallParamKeys, Set<TemplateType> allCallers) {
        TemplateType calleeSignature = callee.getTemplateType();
        if (caller.equals(calleeSignature) || allCallers.contains(calleeSignature)) {
            return;
        }
        for (TemplateType.Parameter p : callee.getTemplateType().getParameters()) {
            if (allCallParamKeys.contains(p.getName())) continue;
            this.indirectParams.putIfAbsent(p.getName(), p);
            this.indirectParamTypes.put((Object)p.getName(), (Object)p.getType());
            this.paramKeyToCalleesMultimap.put((Object)p.getName(), (Object)callee);
        }
        TransitiveCallSituation transitiveCallSituation = new TransitiveCallSituation(callee, allCallParamKeys);
        if (!this.visitedCallSituations.add(transitiveCallSituation)) {
            return;
        }
        this.visit(calleeSignature, allCallParamKeys, allCallers);
    }

    private static final class TransitiveCallSituation {
        private final TemplateMetadata callee;
        private final Set<String> allCallParamKeys;

        public TransitiveCallSituation(TemplateMetadata callee, Set<String> allCallParamKeys) {
            this.callee = callee;
            this.allCallParamKeys = allCallParamKeys;
        }

        public boolean equals(Object other) {
            if (!(other instanceof TransitiveCallSituation)) {
                return false;
            }
            TransitiveCallSituation otherCallSit = (TransitiveCallSituation)other;
            return Objects.equals(otherCallSit.callee, this.callee) && otherCallSit.allCallParamKeys.equals(this.allCallParamKeys);
        }

        public int hashCode() {
            return this.callee.hashCode() * 31 + this.allCallParamKeys.hashCode();
        }
    }

    public static class IndirectParamsInfo {
        public final ImmutableSortedMap<String, TemplateType.Parameter> indirectParams;
        public final ImmutableSetMultimap<String, TemplateMetadata> paramKeyToCalleesMultimap;
        public final ImmutableSetMultimap<String, SoyType> indirectParamTypes;
        public final boolean mayHaveIndirectParamsInExternalCalls;
        public final boolean mayHaveIndirectParamsInExternalDelCalls;

        public IndirectParamsInfo(ImmutableSortedMap<String, TemplateType.Parameter> indirectParams, ImmutableSetMultimap<String, TemplateMetadata> paramKeyToCalleesMultimap, ImmutableSetMultimap<String, SoyType> indirectParamTypes, boolean mayHaveIndirectParamsInExternalCalls, boolean mayHaveIndirectParamsInExternalDelCalls) {
            this.indirectParams = indirectParams;
            this.paramKeyToCalleesMultimap = paramKeyToCalleesMultimap;
            this.indirectParamTypes = indirectParamTypes;
            this.mayHaveIndirectParamsInExternalCalls = mayHaveIndirectParamsInExternalCalls;
            this.mayHaveIndirectParamsInExternalDelCalls = mayHaveIndirectParamsInExternalDelCalls;
        }
    }
}

