/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.error.SoyErrors;
import com.google.template.soy.passes.CompilerFileSetPass;
import com.google.template.soy.passes.ResolveExpressionTypesPass;
import com.google.template.soy.passes.ResolvePluginsPass;
import com.google.template.soy.passes.ResolveTemplateNamesPass;
import com.google.template.soy.passes.ResolveTemplateParamTypesPass;
import com.google.template.soy.passes.RewriteGlobalsPass;
import com.google.template.soy.passes.RunBefore;
import com.google.template.soy.soytree.ImportNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.defn.ImportedVar;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.TypeRegistries;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;

@RunBefore(value={ResolveExpressionTypesPass.class, ResolvePluginsPass.class, ResolveTemplateParamTypesPass.class, ResolveExpressionTypesPass.class, RewriteGlobalsPass.class, ResolveTemplateNamesPass.class})
public final class ImportsPass
implements CompilerFileSetPass {
    private static final SoyErrorKind IMPORT_NOT_IN_DEPS = SoyErrorKind.of("Unknown import dep {0}.{1}", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind UNKNOWN_SYMBOL = SoyErrorKind.of("Unknown symbol {0} in {1}.{2}", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind SYMBOLS_REQUIRED = SoyErrorKind.of("One or more imported symbols are required for import.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind IMPORT_CONFLICTS_WITH_TYPE_NAME = SoyErrorKind.of("Import ''{0}'' conflicts with a builtin type of the same name.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind IMPORT_SAME_FILE = SoyErrorKind.of("Importing from the same file is not allowed.", new SoyErrorKind.StyleAllowance[0]);
    private final ErrorReporter errorReporter;
    private final boolean disableAllTypeChecking;
    private final ImmutableList<ImportProcessor> processors;

    public ImportsPass(ErrorReporter errorReporter, boolean disableAllTypeChecking, ImportProcessor ... processors) {
        this.errorReporter = errorReporter;
        this.disableAllTypeChecking = disableAllTypeChecking;
        this.processors = ImmutableList.copyOf((Object[])processors);
    }

    @Override
    public CompilerFileSetPass.Result run(ImmutableList<SoyFileNode> sourceFiles, IdGenerator idGenerator) {
        for (ImportProcessor processor : this.processors) {
            processor.init(sourceFiles);
        }
        for (SoyFileNode sourceFile : sourceFiles) {
            this.run(sourceFile);
        }
        return CompilerFileSetPass.Result.CONTINUE;
    }

    private void run(SoyFileNode file) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        block0: for (ImportNode importNode : file.getImports()) {
            String path = importNode.getPath();
            if (path.equals(file.getFilePath().path())) {
                this.errorReporter.report(importNode.getPathSourceLocation(), IMPORT_SAME_FILE, new Object[0]);
                continue;
            }
            if (importNode.getIdentifiers().isEmpty()) {
                this.errorReporter.report(importNode.getSourceLocation(), SYMBOLS_REQUIRED, new Object[0]);
                continue;
            }
            boolean foundSymbolErrors = false;
            for (ImportedVar symbol : importNode.getIdentifiers()) {
                if (!this.reportErrorIfSymbolInvalid(file, symbol.name(), symbol.nameLocation())) continue;
                foundSymbolErrors = true;
            }
            if (foundSymbolErrors) continue;
            for (ImportProcessor processor : this.processors) {
                if (!processor.handlesPath(importNode.getPath())) continue;
                builder.put((Object)processor, (Object)importNode);
                continue block0;
            }
            this.reportUnknownImport(file, importNode);
        }
        ImmutableMultimap nodesByProc = builder.build();
        for (ImportProcessor processor : this.processors) {
            ImmutableCollection nodes = nodesByProc.get((Object)processor);
            processor.handle(file, (ImmutableCollection<ImportNode>)nodes);
        }
    }

    static void reportUnknownSymbolError(ErrorReporter errorReporter, SourceLocation symbolLocation, String incorrectName, String importPath, Iterable<String> validSymbols) {
        errorReporter.report(symbolLocation, UNKNOWN_SYMBOL, incorrectName, importPath, SoyErrors.getDidYouMeanMessage(validSymbols, incorrectName));
    }

    boolean reportErrorIfSymbolInvalid(SoyFileNode file, String importSymbolName, SourceLocation nameLocation) {
        SoyType type;
        boolean foundErrors = false;
        if (!file.getImportsContext().addImportedSymbol(importSymbolName)) {
            foundErrors = true;
        }
        if ((type = TypeRegistries.builtinTypeRegistry().getType(importSymbolName)) != null) {
            foundErrors = true;
            this.errorReporter.report(nameLocation, IMPORT_CONFLICTS_WITH_TYPE_NAME, importSymbolName);
        }
        return foundErrors;
    }

    private void reportUnknownImport(SoyFileNode file, ImportNode node) {
        if (this.disableAllTypeChecking) {
            return;
        }
        String nodePath = node.getPath();
        Set allPaths = this.processors.stream().flatMap(p -> p.getAllPaths().stream()).collect(Collectors.toCollection(TreeSet::new));
        allPaths.remove(file.getFilePath().path());
        this.errorReporter.report(node.getPathSourceLocation(), IMPORT_NOT_IN_DEPS, nodePath, SoyErrors.getDidYouMeanMessage(allPaths, nodePath));
    }

    static interface ImportProcessor {
        public boolean handlesPath(String var1);

        public void handle(SoyFileNode var1, ImmutableCollection<ImportNode> var2);

        public ImmutableCollection<String> getAllPaths();

        public void init(ImmutableList<SoyFileNode> var1);
    }
}

