/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.base.internal.QuoteStyle;
import com.google.template.soy.base.internal.SanitizedContentKind;
import com.google.template.soy.base.internal.TemplateContentKind;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.basetree.Node;
import com.google.template.soy.basicfunctions.ConcatAttributeValuesFunction;
import com.google.template.soy.basicfunctions.ConcatCssValuesFunction;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.error.SoyErrors;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.NullNode;
import com.google.template.soy.exprtree.OperatorNodes;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.passes.AutoescaperPass;
import com.google.template.soy.passes.CompilerFileSetPass;
import com.google.template.soy.passes.FinalizeTemplateRegistryPass;
import com.google.template.soy.passes.ResolveNamesPass;
import com.google.template.soy.passes.ResolveTemplateParamTypesPass;
import com.google.template.soy.passes.RunAfter;
import com.google.template.soy.passes.RunBefore;
import com.google.template.soy.passes.SoyElementCompositionPass;
import com.google.template.soy.passes.SoyElementPass;
import com.google.template.soy.plugin.restricted.SoySourceFunction;
import com.google.template.soy.shared.internal.BuiltinFunction;
import com.google.template.soy.soytree.AbstractParentSoyNode;
import com.google.template.soy.soytree.CommandTagAttribute;
import com.google.template.soy.soytree.FileSetMetadata;
import com.google.template.soy.soytree.HtmlAttributeNode;
import com.google.template.soy.soytree.HtmlAttributeValueNode;
import com.google.template.soy.soytree.HtmlOpenTagNode;
import com.google.template.soy.soytree.IfCondNode;
import com.google.template.soy.soytree.IfElseNode;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.LetContentNode;
import com.google.template.soy.soytree.LetValueNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.TagName;
import com.google.template.soy.soytree.TemplateDelegateNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.defn.AttrParam;
import com.google.template.soy.soytree.defn.TemplateParam;
import com.google.template.soy.treebuilder.ExprNodes;
import com.google.template.soy.types.BoolType;
import com.google.template.soy.types.SanitizedType;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypes;
import com.google.template.soy.types.StringType;
import com.google.template.soy.types.ast.NamedTypeNode;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

@RunAfter(value={ResolveNamesPass.class, ResolveTemplateParamTypesPass.class, SoyElementPass.class})
@RunBefore(value={FinalizeTemplateRegistryPass.class, SoyElementCompositionPass.class, AutoescaperPass.class})
final class ElementAttributePass
implements CompilerFileSetPass {
    private static final SoyErrorKind DELTEMPLATE_USING_ELEMENT_CONTENT_KIND = SoyErrorKind.of("Deltemplates cannot set kind=\"html<...>\".", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind UNUSED_ATTRIBUTE = SoyErrorKind.of("Declared @attribute unused in template element.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind ATTRIBUTE_USED_OUTSIDE_OF_TAG = SoyErrorKind.of("Attributes may not be referenced explicitly.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind UNRECOGNIZED_ATTRIBUTE = SoyErrorKind.of("''{0}'' is not a declared @attribute of the template.{1}", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind PLAIN_ATTRIBUTE = SoyErrorKind.of("HTML attribute masks Soy attribute. Did you mean ''{0}''?", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind ATTRIBUTE_NOT_REQUIRED = SoyErrorKind.of("@attribute ''{0}'' must be set as optional to be used here.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind ATTRIBUTE_PARAM_NOT_ALLOWED = SoyErrorKind.of("Attribute ''{0}'' can only be present on root elements of html<?> templates.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind BAD_ATTRIBUTE_TYPE = SoyErrorKind.of("Attributes must be of type string or a sanitized type.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind ROOT_TAG_KIND_MISMATCH = SoyErrorKind.of("Expected root tag to be {0}.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind DELEGATE_KIND_MISMATCH = SoyErrorKind.of("Expected the called template to have root tag {0}, found {1}.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoySourceFunction concatCssFunction = new ConcatCssValuesFunction();
    private static final SoySourceFunction concatAttributesFunction = new ConcatAttributeValuesFunction();
    private final ErrorReporter errorReporter;
    private final Supplier<FileSetMetadata> templateRegistryFromDeps;
    private final boolean desugarIdomPasses;

    ElementAttributePass(ErrorReporter errorReporter, Supplier<FileSetMetadata> templateRegistryFromDeps, boolean desugarIdomPasses) {
        this.errorReporter = errorReporter;
        this.templateRegistryFromDeps = templateRegistryFromDeps;
        this.desugarIdomPasses = desugarIdomPasses;
    }

    private static ExprNode buildNotNull(ExprNode node) {
        SourceLocation unknown = node.getSourceLocation().clearRange();
        OperatorNodes.NotEqualOpNode ne = new OperatorNodes.NotEqualOpNode(unknown, unknown);
        ne.addChild(node.copy(new CopyState()));
        ne.addChild(new NullNode(unknown));
        ne.setType(BoolType.getInstance());
        return ne;
    }

    private static IfNode buildPrintIfNotNull(ExprNode node, Supplier<Integer> id) {
        SourceLocation unknown = node.getSourceLocation().clearRange();
        IfNode ifNode = new IfNode(id.get(), unknown);
        IfCondNode ifCondNode = new IfCondNode(id.get(), unknown, unknown, "if", ElementAttributePass.buildNotNull(node));
        ifCondNode.getExpr().setType(BoolType.getInstance());
        ifNode.addChild(ifCondNode);
        PrintNode printNode = new PrintNode(id.get(), unknown, true, node, (Iterable<CommandTagAttribute>)ImmutableList.of(), ErrorReporter.exploding());
        printNode.getExpr().setType(node.getType());
        ifCondNode.addChild(printNode);
        return ifNode;
    }

    @Override
    public CompilerFileSetPass.Result run(ImmutableList<SoyFileNode> sourceFiles, IdGenerator idGenerator) {
        ImmutableMap allAstElements = (ImmutableMap)sourceFiles.stream().flatMap(fn -> fn.getTemplates().stream()).filter(t -> !(t instanceof TemplateDelegateNode) && t.getTemplateContentKind() instanceof TemplateContentKind.ElementContentKind && t.getHtmlElementMetadata() != null).collect(ImmutableMap.toImmutableMap(TemplateNode::getTemplateName, t -> t));
        for (SoyFileNode file : sourceFiles) {
            this.run(file, (ImmutableMap<String, TemplateNode>)allAstElements, idGenerator);
        }
        this.checkRootElementTagNames((ImmutableCollection<TemplateNode>)allAstElements.values());
        return CompilerFileSetPass.Result.CONTINUE;
    }

    private void run(SoyFileNode file, ImmutableMap<String, TemplateNode> allAstElements, IdGenerator nodeIdGen) {
        this.checkAttributeTypes(file);
        ImmutableList.Builder delegatingElementsWithAllAttrs = ImmutableList.builder();
        file.getTemplates().stream().filter(t -> t.getTemplateContentKind() instanceof TemplateContentKind.ElementContentKind && t.getHtmlElementMetadata() != null).forEach(t -> {
            if (t instanceof TemplateDelegateNode) {
                this.errorReporter.report(t.getOpenTagLocation(), DELTEMPLATE_USING_ELEMENT_CONTENT_KIND, new Object[0]);
                return;
            }
            this.processTemplate((TemplateNode)t, nodeIdGen::genId, arg_0 -> ((ImmutableList.Builder)delegatingElementsWithAllAttrs).add(arg_0));
        });
        file.getTemplates().stream().filter(t -> t.getHtmlElementMetadata() != null && ElementAttributePass.getDelegateCall(t).isEmpty()).forEach(t -> SoyTreeUtils.allNodesOfType(t, HtmlAttributeNode.class).filter(HtmlAttributeNode::isSoyAttr).forEach(attr -> this.errorReporter.report(attr.getSourceLocation(), ATTRIBUTE_PARAM_NOT_ALLOWED, attr.getStaticKey())));
        this.updateReservedAttributesForDelegateCalls((ImmutableList<TemplateNode>)delegatingElementsWithAllAttrs.build(), allAstElements);
    }

    private <T extends Node> void checkAttributeTypes(SoyFileNode file) {
        file.getTemplates().stream().flatMap(t -> t.getHeaderParams().stream()).filter(AttrParam.class::isInstance).map(AttrParam.class::cast).forEach(attr -> {
            SoyType type = SoyTypes.removeNull(attr.type());
            if (!(type instanceof SanitizedType) && !(type instanceof StringType) || SanitizedType.HtmlType.getInstance().isAssignableFromStrict(type)) {
                this.errorReporter.report(attr.getSourceLocation(), BAD_ATTRIBUTE_TYPE, new Object[0]);
            }
        });
    }

    private void processTemplate(TemplateNode templateNode, Supplier<Integer> id, Consumer<TemplateNode> delegatingElementsWithAllAttrs) {
        ImmutableMap attrs = (ImmutableMap)templateNode.getAllParams().stream().filter(AttrParam.class::isInstance).map(AttrParam.class::cast).collect(ImmutableMap.toImmutableMap(AttrParam::getAttrName, Function.identity()));
        HashSet<AttrParam> unseenParams = new HashSet<AttrParam>((Collection<AttrParam>)attrs.values());
        this.checkAttributeRefs(templateNode, unseenParams);
        Optional<HtmlOpenTagNode> elmOpen = ElementAttributePass.getElementOpen(templateNode);
        if (!elmOpen.isPresent()) {
            return;
        }
        SourceLocation unknown = templateNode.getSourceLocation().clearRange();
        HtmlOpenTagNode openTagNode = elmOpen.get();
        String delegateTemplateName = ElementAttributePass.getDelegateCall(templateNode);
        boolean iAmAnElementCallingAnElement = !delegateTemplateName.isEmpty();
        ImmutableSet.Builder foundNormalAttr = ImmutableSet.builder();
        SoyTreeUtils.allNodesOfType(openTagNode, HtmlAttributeNode.class).filter(attr -> attr.getStaticKey() != null).forEach(attrNode -> {
            AbstractParentSoyNode replacementNode;
            String attrName;
            String attrKey = attrNode.getStaticKey();
            if (attrKey.equals("data-debug-soy")) {
                return;
            }
            boolean isSoyAttr = attrNode.isSoyAttr();
            String string = attrName = isSoyAttr ? attrKey.substring(1) : attrKey;
            if (!isSoyAttr) {
                foundNormalAttr.add((Object)attrName);
                if (attrs.containsKey((Object)attrName)) {
                    this.errorReporter.report(attrNode.getSourceLocation(), PLAIN_ATTRIBUTE, "@" + attrName);
                }
                return;
            }
            if (!attrs.containsKey((Object)attrName)) {
                String didYouMeanMessage = SoyErrors.getDidYouMeanMessage((Iterable<String>)attrs.keySet(), attrName);
                this.errorReporter.report(attrNode.getSourceLocation(), UNRECOGNIZED_ATTRIBUTE, attrName, didYouMeanMessage);
                return;
            }
            AttrParam attr = (AttrParam)attrs.get((Object)attrName);
            unseenParams.remove(attr);
            VarRefNode attrExpr = new VarRefNode("$" + attr.name(), unknown, attr);
            if (attrNode.hasValue() && attr.isRequired()) {
                this.errorReporter.report(attrNode.getSourceLocation(), ATTRIBUTE_NOT_REQUIRED, attr.getAttrName());
            }
            if (!attrNode.hasValue() && iAmAnElementCallingAnElement && !isSoyAttr) {
                return;
            }
            HtmlAttributeNode newAttrNode = new HtmlAttributeNode((Integer)id.get(), unknown, SourceLocation.Point.UNKNOWN_POINT);
            newAttrNode.addChild(((RawTextNode)attrNode.getChild(0)).substring((Integer)id.get(), 1));
            HtmlAttributeValueNode valueNode = new HtmlAttributeValueNode((Integer)id.get(), unknown, HtmlAttributeValueNode.Quotes.DOUBLE);
            newAttrNode.addChild(valueNode);
            if (attrNode.getConcatenationDelimiter() == null && attr.isRequired()) {
                PrintNode printNode = new PrintNode((Integer)id.get(), unknown, true, attrExpr, (Iterable<CommandTagAttribute>)ImmutableList.of(), this.errorReporter);
                printNode.getExpr().setType(attrExpr.getType());
                valueNode.addChild(printNode);
                replacementNode = newAttrNode;
            } else if (attrNode.getConcatenationDelimiter() == null && attrNode.hasValue()) {
                IfNode ifNode = ElementAttributePass.buildPrintIfNotNull(attrExpr, id);
                valueNode.addChild(ifNode);
                IfElseNode ifElseNode = new IfElseNode((int)((Integer)id.get()), unknown, unknown);
                ifNode.addChild(ifElseNode);
                ElementAttributePass.copyChildren(attrNode, ifElseNode);
                replacementNode = newAttrNode;
            } else {
                VarRefNode outputValueExpr = attrNode.getConcatenationDelimiter() != null && attrNode.hasValue() ? ElementAttributePass.concatAttributeValues(openTagNode, attrNode, attrExpr, SanitizedType.StyleType.getInstance().isAssignableFromStrict(SoyTypes.removeNull(attr.type())), id, unknown) : attrExpr;
                PrintNode printNode = new PrintNode((Integer)id.get(), unknown, true, outputValueExpr, (Iterable<CommandTagAttribute>)ImmutableList.of(), this.errorReporter);
                printNode.getExpr().setType(outputValueExpr.getType());
                valueNode.addChild(printNode);
                IfNode ifNode = new IfNode((Integer)id.get(), unknown);
                IfCondNode ifCondNode = new IfCondNode((Integer)id.get(), unknown, unknown, "if", attrNode.getConcatenationDelimiter() == null ? ElementAttributePass.buildNotNull(outputValueExpr) : outputValueExpr.copy(new CopyState()));
                ifCondNode.getExpr().setType(BoolType.getInstance());
                ifCondNode.addChild(newAttrNode);
                ifNode.addChild(ifCondNode);
                replacementNode = ifNode;
            }
            attrNode.getParent().replaceChild(attrNode, replacementNode);
        });
        TemplateParam keyParam = new TemplateParam("ssk", SourceLocation.UNKNOWN, SourceLocation.UNKNOWN, NamedTypeNode.create(SourceLocation.UNKNOWN, "ssk"), false, true, true, "Created by ElementAttributePass.", null);
        keyParam.setType(SoyTypes.makeNullable(StringType.getInstance()));
        templateNode.addParam(keyParam);
        if (this.desugarIdomPasses && openTagNode.getTagName().isStatic()) {
            ExprNode.ParentExprNode result;
            VarRefNode keyParamRef = new VarRefNode("$" + keyParam.name(), SourceLocation.UNKNOWN, keyParam);
            IfNode ifNode = new IfNode(id.get(), unknown);
            IfCondNode ifCondNode = new IfCondNode(id.get(), unknown, unknown, "if", ElementAttributePass.buildNotNull(keyParamRef));
            ifCondNode.getExpr().setType(BoolType.getInstance());
            ifNode.addChild(ifCondNode);
            HtmlAttributeNode htmlAttributeNode = new HtmlAttributeNode(id.get(), SourceLocation.UNKNOWN, SourceLocation.Point.UNKNOWN_POINT);
            htmlAttributeNode.addChild(new RawTextNode(id.get(), "ssk", SourceLocation.UNKNOWN));
            HtmlAttributeValueNode valueNode = new HtmlAttributeValueNode(id.get(), SourceLocation.UNKNOWN, HtmlAttributeValueNode.Quotes.SINGLE);
            String tplName = templateNode.getHtmlElementMetadata().getFinalCallee().isEmpty() ? templateNode.getTemplateName() : templateNode.getHtmlElementMetadata().getFinalCallee();
            FunctionNode wrappedFn = FunctionNode.newPositional(Identifier.create(BuiltinFunction.SOY_SERVER_KEY.getName(), SourceLocation.UNKNOWN), BuiltinFunction.SOY_SERVER_KEY, SourceLocation.UNKNOWN);
            wrappedFn.setType(StringType.getInstance());
            if (openTagNode.getKeyNode() == null) {
                FunctionNode funcNode = FunctionNode.newPositional(Identifier.create(BuiltinFunction.XID.getName(), SourceLocation.UNKNOWN), BuiltinFunction.XID, SourceLocation.UNKNOWN);
                funcNode.addChild(new StringNode(tplName + "-root", QuoteStyle.SINGLE, SourceLocation.UNKNOWN));
                funcNode.setType(StringType.getInstance());
                wrappedFn.addChild(funcNode);
                result = ExprNodes.plus(wrappedFn, keyParamRef);
            } else {
                wrappedFn.addChild(openTagNode.getKeyNode().getExpr().getRoot().copy(new CopyState()));
                result = wrappedFn;
            }
            PrintNode printNode = new PrintNode(id.get(), unknown, true, result, (Iterable<CommandTagAttribute>)ImmutableList.of(), ErrorReporter.exploding());
            printNode.getExpr().setType(wrappedFn.getType());
            valueNode.addChild(printNode);
            htmlAttributeNode.addChild(valueNode);
            ifCondNode.addChild(htmlAttributeNode);
            openTagNode.addChild(ifNode);
            if (openTagNode.getKeyNode() != null) {
                openTagNode.removeChild(openTagNode.getKeyNode());
            }
        }
        if (templateNode.getAllowExtraAttributes()) {
            TemplateParam attrsParam = new TemplateParam("__soyInternalAttributes", SourceLocation.UNKNOWN, SourceLocation.UNKNOWN, NamedTypeNode.create(SourceLocation.UNKNOWN, "__soyInternalAttributes"), false, true, true, "Created by ElementAttributePass.", null);
            VarRefNode extraAttributesRef = new VarRefNode("$" + attrsParam.name(), SourceLocation.UNKNOWN, attrsParam);
            templateNode.addParam(attrsParam);
            attrsParam.setType(SoyTypes.makeNullable(SanitizedType.AttributesType.getInstance()));
            IfNode ifNode = new IfNode(id.get(), unknown);
            IfCondNode ifCondNode = new IfCondNode(id.get(), unknown, unknown, "if", ElementAttributePass.buildNotNull(extraAttributesRef));
            ifCondNode.getExpr().setType(BoolType.getInstance());
            ifNode.addChild(ifCondNode);
            HtmlAttributeNode htmlAttributeNode = new HtmlAttributeNode(id.get(), unknown, null);
            PrintNode printNode = new PrintNode(id.get(), unknown, true, extraAttributesRef, (Iterable<CommandTagAttribute>)ImmutableList.of(), ErrorReporter.exploding());
            printNode.getExpr().setType(extraAttributesRef.getType());
            htmlAttributeNode.addChild(printNode);
            ifCondNode.addChild(htmlAttributeNode);
            openTagNode.addChild(ifNode);
            templateNode.setReservedAttributes((ImmutableSet<String>)foundNormalAttr.build());
            if (iAmAnElementCallingAnElement) {
                delegatingElementsWithAllAttrs.accept(templateNode);
            }
        }
        this.warnUnusedAttributes(unseenParams);
    }

    private static VarRefNode concatAttributeValues(HtmlOpenTagNode openTagNode, HtmlAttributeNode attrNode, VarRefNode attrExpr, boolean isCss, Supplier<Integer> id, SourceLocation location) {
        LetContentNode letContentNode = LetContentNode.forVariable(id.get(), location, "$__internal_soy_letContent_" + id.get(), location, isCss ? SanitizedContentKind.CSS : SanitizedContentKind.TEXT);
        openTagNode.getParent().addChild(openTagNode.getParent().getChildIndex(openTagNode), letContentNode);
        ElementAttributePass.copyChildren(attrNode, letContentNode);
        VarRefNode letRef = new VarRefNode(letContentNode.getVarRefName(), SourceLocation.UNKNOWN, letContentNode.getVar());
        SoySourceFunction soyFn = isCss ? concatCssFunction : concatAttributesFunction;
        FunctionNode fn = FunctionNode.newPositional(Identifier.create("$$concatAttributeValues", location), soyFn, location);
        fn.setType(isCss ? SanitizedType.StyleType.getInstance() : StringType.getInstance());
        fn.addChild(attrExpr);
        fn.addChild(letRef);
        if (!isCss) {
            fn.addChild(new StringNode(attrNode.getConcatenationDelimiter(), QuoteStyle.SINGLE, location));
        }
        if (isCss) {
            fn.setAllowedParamTypes((List<SoyType>)ImmutableList.of((Object)SoyTypes.makeNullable(SanitizedType.StyleType.getInstance()), (Object)SoyTypes.makeNullable(SanitizedType.StyleType.getInstance())));
        } else {
            fn.setAllowedParamTypes((List<SoyType>)ImmutableList.of((Object)SoyTypes.makeNullable(StringType.getInstance()), (Object)SoyTypes.makeNullable(StringType.getInstance()), (Object)StringType.getInstance()));
        }
        LetValueNode letValueNode = new LetValueNode(id.get(), location, "$__internal_soy_letValue_" + id.get(), location, fn);
        letValueNode.getVar().setType(fn.getType());
        letValueNode.getExpr().setType(fn.getType());
        letContentNode.getParent().addChild(letContentNode.getParent().getChildIndex(letContentNode) + 1, letValueNode);
        return new VarRefNode(letValueNode.getVarRefName(), SourceLocation.UNKNOWN, letValueNode.getVar());
    }

    private void updateReservedAttributesForDelegateCalls(ImmutableList<TemplateNode> templates, ImmutableMap<String, TemplateNode> allAstElements) {
        Map<String, String> templateFqnCall = templates.stream().collect(Collectors.toMap(TemplateNode::getTemplateName, ElementAttributePass::getDelegateCall));
        while (!templateFqnCall.isEmpty()) {
            List leaves = templateFqnCall.entrySet().stream().filter(e -> !templateFqnCall.containsKey(e.getValue())).collect(Collectors.toList());
            if (leaves.isEmpty()) {
                throw new IllegalArgumentException("Cyclical graph: " + templateFqnCall);
            }
            for (Map.Entry leaf : leaves) {
                TemplateNode callee = (TemplateNode)allAstElements.get(leaf.getValue());
                ImmutableSet<String> reservedAttr = callee != null ? callee.getReservedAttributes() : this.templateRegistryFromDeps.get().getBasicTemplateOrElement((String)leaf.getValue()).getTemplateType().getReservedAttributes();
                TemplateNode caller = (TemplateNode)allAstElements.get(leaf.getKey());
                caller.setReservedAttributes((ImmutableSet<String>)ImmutableSet.builder().addAll(caller.getReservedAttributes()).addAll(reservedAttr).build());
                templateFqnCall.remove(leaf.getKey());
            }
        }
    }

    private void checkRootElementTagNames(ImmutableCollection<TemplateNode> elements) {
        for (TemplateNode node : elements) {
            Optional<HtmlOpenTagNode> maybeTagNode;
            String tag;
            TemplateContentKind.ElementContentKind contentKind = (TemplateContentKind.ElementContentKind)node.getTemplateContentKind();
            String expectedTagName = contentKind.getTagName();
            if (expectedTagName.isEmpty() || "?".equals(tag = node.getHtmlElementMetadata().getTag()) || expectedTagName.equals(tag) || !(maybeTagNode = ElementAttributePass.getElementOpen(node)).isPresent()) continue;
            TagName tagName = ElementAttributePass.getElementOpen(node).get().getTagName();
            if (tagName.isStatic()) {
                this.errorReporter.report(tagName.getTagLocation(), ROOT_TAG_KIND_MISMATCH, expectedTagName);
                continue;
            }
            this.errorReporter.report(tagName.getTagLocation(), DELEGATE_KIND_MISMATCH, expectedTagName, tag);
        }
    }

    private static String getDelegateCall(TemplateNode templateNode) {
        return templateNode.getHtmlElementMetadata().getDelegateElement();
    }

    private static void copyChildren(HtmlAttributeNode from, SoyNode.ParentSoyNode<SoyNode.StandaloneNode> to) {
        Iterator i = from.getChildren().iterator();
        i.next();
        while (i.hasNext()) {
            SoyNode.StandaloneNode child = (SoyNode.StandaloneNode)i.next();
            if (child instanceof HtmlAttributeValueNode) {
                for (SoyNode.StandaloneNode node : ((HtmlAttributeValueNode)child).getChildren()) {
                    to.addChild(node.copy(new CopyState()));
                }
                continue;
            }
            to.addChild(child.copy(new CopyState()));
        }
    }

    private void checkAttributeRefs(TemplateNode templateNode, Set<AttrParam> attrs) {
        SoyTreeUtils.allNodesOfType(templateNode, VarRefNode.class).filter(ref -> attrs.contains(ref.getDefnDecl())).forEach(attrRef -> this.errorReporter.report(attrRef.getSourceLocation(), ATTRIBUTE_USED_OUTSIDE_OF_TAG, new Object[0]));
    }

    private void warnUnusedAttributes(Iterable<AttrParam> unseenParams) {
        unseenParams.forEach(attrParam -> this.errorReporter.warn(attrParam.getSourceLocation(), UNUSED_ATTRIBUTE, new Object[0]));
    }

    static Optional<HtmlOpenTagNode> getElementOpen(TemplateNode node) {
        return SoyTreeUtils.allNodesOfType(node, HtmlOpenTagNode.class).filter(HtmlOpenTagNode::isElementRoot).findFirst();
    }
}

