/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.collect.ImmutableSet;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.VarDefn;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.passes.CompilerFilePass;
import com.google.template.soy.passes.ResolveExpressionTypesCrossTemplatePass;
import com.google.template.soy.passes.ResolveExpressionTypesPass;
import com.google.template.soy.passes.RunAfter;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.types.SoyType;

@RunAfter(value={ResolveExpressionTypesPass.class, ResolveExpressionTypesCrossTemplatePass.class})
final class CheckValidVarrefsPass
implements CompilerFilePass {
    private static final ImmutableSet<SoyType.Kind> BAD_SOY_TYPE_KINDS = ImmutableSet.of((Object)((Object)SoyType.Kind.FUNCTION), (Object)((Object)SoyType.Kind.TEMPLATE_MODULE), (Object)((Object)SoyType.Kind.PROTO_ENUM_TYPE), (Object)((Object)SoyType.Kind.PROTO_MODULE));
    private static final ImmutableSet<VarDefn.Kind> BAD_VAR_DEFN_KINDS = ImmutableSet.of((Object)((Object)VarDefn.Kind.UNDECLARED));
    private static final SoyErrorKind ILLEGAL_TYPE_OF_VARIABLE = SoyErrorKind.of("Illegal use of symbol ''{0}''.", new SoyErrorKind.StyleAllowance[0]);
    private final ErrorReporter errorReporter;

    CheckValidVarrefsPass(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }

    @Override
    public void run(SoyFileNode file, IdGenerator idGenerator) {
        SoyTreeUtils.allNodesOfType(file, VarRefNode.class).forEach(this::checkVarRef);
    }

    private void checkVarRef(VarRefNode varRef) {
        VarDefn defn = varRef.getDefnDecl();
        if (defn != null && defn.hasType() && (BAD_SOY_TYPE_KINDS.contains((Object)defn.type().getKind()) || BAD_VAR_DEFN_KINDS.contains((Object)defn.kind()))) {
            this.errorReporter.report(varRef.getSourceLocation(), ILLEGAL_TYPE_OF_VARIABLE, varRef.toSourceString());
        }
    }
}

