/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.internal.exemptions.NamespaceExemptions;
import com.google.template.soy.passes.CompilerFileSetPass;
import com.google.template.soy.passes.FinalizeTemplateRegistryPass;
import com.google.template.soy.passes.RunAfter;
import com.google.template.soy.soytree.FileSetMetadata;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.TemplateMetadata;
import java.util.function.Supplier;
import java.util.stream.Collectors;

@RunAfter(value={FinalizeTemplateRegistryPass.class})
final class BanDuplicateNamespacesPass
implements CompilerFileSetPass {
    private static final SoyErrorKind DUPLICATE_NAMESPACE = SoyErrorKind.of("Found another file ''{0}'' with the same namespace.  All files must have unique namespaces.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind DUPLICATE_NAMESPACE_WARNING = SoyErrorKind.of("Found another file ''{0}'' with the same namespace.  All files should have unique namespaces. This will soon become an error.", new SoyErrorKind.StyleAllowance[0]);
    private final ErrorReporter errorReporter;
    private final Supplier<FileSetMetadata> fileSetTemplateRegistry;

    BanDuplicateNamespacesPass(ErrorReporter errorReporter, Supplier<FileSetMetadata> fileSetTemplateRegistry) {
        this.errorReporter = errorReporter;
        this.fileSetTemplateRegistry = fileSetTemplateRegistry;
    }

    @Override
    public CompilerFileSetPass.Result run(ImmutableList<SoyFileNode> sourceFiles, IdGenerator nodeIdGen) {
        ImmutableSetMultimap namespaceToFiles = (ImmutableSetMultimap)this.fileSetTemplateRegistry.get().getAllTemplates().stream().collect(ImmutableSetMultimap.toImmutableSetMultimap(BanDuplicateNamespacesPass::namespace, t -> t.getSourceLocation().getFilePath().path()));
        for (SoyFileNode sourceFile : sourceFiles) {
            ImmutableSet filePaths = namespaceToFiles.get((Object)sourceFile.getNamespace());
            if (filePaths.size() <= 1) continue;
            String filePath = sourceFile.getFilePath().path();
            String otherFiles = filePaths.stream().filter(path -> !path.equals(filePath)).collect(Collectors.joining(", "));
            if (NamespaceExemptions.isKnownDuplicateNamespace(sourceFile.getNamespace())) {
                this.errorReporter.warn(sourceFile.getNamespaceDeclaration().getSourceLocation(), DUPLICATE_NAMESPACE_WARNING, otherFiles);
                continue;
            }
            this.errorReporter.report(sourceFile.getNamespaceDeclaration().getSourceLocation(), DUPLICATE_NAMESPACE, otherFiles);
        }
        return CompilerFileSetPass.Result.CONTINUE;
    }

    private static String namespace(TemplateMetadata meta) {
        return meta.getTemplateName().substring(0, meta.getTemplateName().lastIndexOf(46));
    }
}

